/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class BrokerMetadataPublisher$
implements Logging {
    public static BrokerMetadataPublisher$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new BrokerMetadataPublisher$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return Option$.MODULE$.apply((Object)newImage.topics().getTopic(topicName)).flatMap((Function1 & Serializable & scala.Serializable)topicImage -> Option$.MODULE$.apply((Object)delta.topicsDelta()).flatMap((Function1 & Serializable & scala.Serializable)topicDelta -> Option$.MODULE$.apply((Object)topicDelta.changedTopic(topicImage.id()))));
    }

    public Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return (Iterable)logs.flatMap((Function1 & Serializable & scala.Serializable)log -> {
            Iterable iterable;
            int partitionId;
            Uuid topicId = (Uuid)log.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException(new StringBuilder(87).append("The log dir ").append(log).append(" does not have a topic ID, ").append("which is not allowed when running in KRaft mode.").toString());
            });
            Option option = Option$.MODULE$.apply((Object)newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition()));
            if (option instanceof Some) {
                Iterable iterable2;
                PartitionRegistration partition = (PartitionRegistration)((Some)option).value();
                if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
                    BrokerMetadataPublisher$ brokerMetadataPublisher$ = MODULE$;
                    if (brokerMetadataPublisher$ == null) {
                        throw null;
                    }
                    BrokerMetadataPublisher$ info_this = brokerMetadataPublisher$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent(BrokerMetadataPublisher$.$anonfun$findStrayPartitions$3(log, partition, brokerId)));
                    }
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)log.topicPartition()));
                } else {
                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                iterable = iterable2;
            } else if (None$.MODULE$.equals(option)) {
                BrokerMetadataPublisher$ brokerMetadataPublisher$ = MODULE$;
                if (brokerMetadataPublisher$ == null) {
                    throw null;
                }
                BrokerMetadataPublisher$ info_this = brokerMetadataPublisher$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(BrokerMetadataPublisher$.$anonfun$findStrayPartitions$4(log, topicId)));
                }
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)log.topicPartition()));
            } else {
                throw new MatchError((Object)option);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$findStrayPartitions$3(UnifiedLog log$1, PartitionRegistration partition$1, int brokerId$1) {
        return new StringBuilder(91).append("Found stray log dir ").append(log$1).append(": the current replica assignment ").append(partition$1.replicas).append(" ").append("does not contain the local brokerId ").append(brokerId$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$findStrayPartitions$4(UnifiedLog log$1, Uuid topicId$1) {
        return new StringBuilder(71).append("Found stray log dir ").append(log$1).append(": the topicId ").append(topicId$1).append(" does not exist in the metadata image").toString();
    }

    private BrokerMetadataPublisher$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

