/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.mirror.DefaultGroupFilter;
import org.apache.kafka.connect.mirror.GroupFilter;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.TopicFilter;

public class MirrorCheckpointConfig
extends MirrorConnectorConfig {
    protected static final String REFRESH_GROUPS = "refresh.groups";
    protected static final String EMIT_CHECKPOINTS = "emit.checkpoints";
    protected static final String SYNC_GROUP_OFFSETS = "sync.group.offsets";
    public static final String GROUPS = "groups";
    public static final String GROUPS_DEFAULT = ".*";
    private static final String GROUPS_DOC = "Consumer groups to replicate. Supports comma-separated group IDs and regexes.";
    public static final String GROUPS_EXCLUDE = "groups.exclude";
    public static final String GROUPS_EXCLUDE_ALIAS = "groups.blacklist";
    public static final String GROUPS_EXCLUDE_DEFAULT = "console-consumer-.*, connect-.*, __.*";
    private static final String GROUPS_EXCLUDE_DOC = "Exclude groups. Supports comma-separated group IDs and regexes. Excludes take precedence over includes.";
    public static final String CHECKPOINTS_TOPIC_REPLICATION_FACTOR = "checkpoints.topic.replication.factor";
    public static final String CHECKPOINTS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for checkpoints topic.";
    public static final short CHECKPOINTS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    protected static final String TASK_CONSUMER_GROUPS = "task.assigned.groups";
    public static final String CONSUMER_POLL_TIMEOUT_MILLIS = "consumer.poll.timeout.ms";
    private static final String CONSUMER_POLL_TIMEOUT_MILLIS_DOC = "Timeout when polling source cluster.";
    public static final long CONSUMER_POLL_TIMEOUT_MILLIS_DEFAULT = 1000L;
    public static final String REFRESH_GROUPS_ENABLED = "refresh.groups.enabled";
    private static final String REFRESH_GROUPS_ENABLED_DOC = "Whether to periodically check for new consumer groups.";
    public static final boolean REFRESH_GROUPS_ENABLED_DEFAULT = true;
    public static final String REFRESH_GROUPS_INTERVAL_SECONDS = "refresh.groups.interval.seconds";
    private static final String REFRESH_GROUPS_INTERVAL_SECONDS_DOC = "Frequency of group refresh.";
    public static final long REFRESH_GROUPS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String EMIT_CHECKPOINTS_ENABLED = "emit.checkpoints.enabled";
    private static final String EMIT_CHECKPOINTS_ENABLED_DOC = "Whether to replicate consumer offsets to target cluster.";
    public static final boolean EMIT_CHECKPOINTS_ENABLED_DEFAULT = true;
    public static final String EMIT_CHECKPOINTS_INTERVAL_SECONDS = "emit.checkpoints.interval.seconds";
    private static final String EMIT_CHECKPOINTS_INTERVAL_SECONDS_DOC = "Frequency of checkpoints.";
    public static final long EMIT_CHECKPOINTS_INTERVAL_SECONDS_DEFAULT = 60L;
    public static final String SYNC_GROUP_OFFSETS_ENABLED = "sync.group.offsets.enabled";
    private static final String SYNC_GROUP_OFFSETS_ENABLED_DOC = "Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster, as long as no active consumers in that group are connected to the target cluster";
    public static final boolean SYNC_GROUP_OFFSETS_ENABLED_DEFAULT = false;
    public static final String SYNC_GROUP_OFFSETS_INTERVAL_SECONDS = "sync.group.offsets.interval.seconds";
    private static final String SYNC_GROUP_OFFSETS_INTERVAL_SECONDS_DOC = "Frequency of consumer group offset sync.";
    public static final long SYNC_GROUP_OFFSETS_INTERVAL_SECONDS_DEFAULT = 60L;
    public static final String GROUP_FILTER_CLASS = "group.filter.class";
    private static final String GROUP_FILTER_CLASS_DOC = "GroupFilter to use. Selects consumer groups to replicate.";
    public static final Class<?> GROUP_FILTER_CLASS_DEFAULT = DefaultGroupFilter.class;
    protected static final ConfigDef CONNECTOR_CONFIG_DEF = new ConfigDef(BASE_CONNECTOR_CONFIG_DEF).define("consumer.poll.timeout.ms", ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Importance.LOW, "Timeout when polling source cluster.").define("groups", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "Consumer groups to replicate. Supports comma-separated group IDs and regexes.").define("groups.exclude", ConfigDef.Type.LIST, (Object)"console-consumer-.*, connect-.*, __.*", ConfigDef.Importance.HIGH, "Exclude groups. Supports comma-separated group IDs and regexes. Excludes take precedence over includes.").define("groups.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use groups.exclude instead.").define("group.filter.class", ConfigDef.Type.CLASS, GROUP_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "GroupFilter to use. Selects consumer groups to replicate.").define("refresh.groups.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to periodically check for new consumer groups.").define("refresh.groups.interval.seconds", ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, "Frequency of group refresh.").define("emit.checkpoints.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to replicate consumer offsets to target cluster.").define("emit.checkpoints.interval.seconds", ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, "Frequency of checkpoints.").define("sync.group.offsets.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster, as long as no active consumers in that group are connected to the target cluster").define("sync.group.offsets.interval.seconds", ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, "Frequency of consumer group offset sync.").define("checkpoints.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, "Replication factor for checkpoints topic.").define("offset-syncs.topic.location", ConfigDef.Type.STRING, (Object)"source", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"source", "target"}), ConfigDef.Importance.LOW, "The location (source/target) of the offset-syncs topic.").define("topic.filter.class", ConfigDef.Type.CLASS, (Object)TOPIC_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "TopicFilter to use. Selects topics to replicate.");

    public MirrorCheckpointConfig(Map<String, String> props) {
        super(CONNECTOR_CONFIG_DEF, ConfigUtils.translateDeprecatedConfigs(props, (String[][])new String[][]{{GROUPS_EXCLUDE, GROUPS_EXCLUDE_ALIAS}}));
    }

    public MirrorCheckpointConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
    }

    Duration emitCheckpointsInterval() {
        if (this.getBoolean(EMIT_CHECKPOINTS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(EMIT_CHECKPOINTS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration refreshGroupsInterval() {
        if (this.getBoolean(REFRESH_GROUPS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(REFRESH_GROUPS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    short checkpointsTopicReplicationFactor() {
        return this.getShort(CHECKPOINTS_TOPIC_REPLICATION_FACTOR);
    }

    GroupFilter groupFilter() {
        return (GroupFilter)this.getConfiguredInstance(GROUP_FILTER_CLASS, GroupFilter.class);
    }

    TopicFilter topicFilter() {
        return (TopicFilter)this.getConfiguredInstance("topic.filter.class", TopicFilter.class);
    }

    Duration syncGroupOffsetsInterval() {
        if (this.getBoolean(SYNC_GROUP_OFFSETS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_GROUP_OFFSETS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Map<String, String> taskConfigForConsumerGroups(List<String> groups) {
        Map props = this.originalsStrings();
        props.put(TASK_CONSUMER_GROUPS, String.join((CharSequence)",", groups));
        return props;
    }

    String offsetSyncsTopic() {
        String otherClusterAlias = "source".equals(this.offsetSyncsTopicLocation()) ? this.targetClusterAlias() : this.sourceClusterAlias();
        return this.replicationPolicy().offsetSyncsTopic(otherClusterAlias);
    }

    String offsetSyncsTopicLocation() {
        return this.getString("offset-syncs.topic.location");
    }

    String checkpointsTopic() {
        return this.replicationPolicy().checkpointsTopic(this.sourceClusterAlias());
    }

    Map<String, Object> offsetSyncsTopicConsumerConfig() {
        return "source".equals(this.offsetSyncsTopicLocation()) ? this.sourceConsumerConfig() : this.targetConsumerConfig();
    }

    Map<String, Object> offsetSyncsTopicAdminConfig() {
        return "source".equals(this.offsetSyncsTopicLocation()) ? this.sourceAdminConfig() : this.targetAdminConfig();
    }

    Duration consumerPollTimeout() {
        return Duration.ofMillis(this.getLong(CONSUMER_POLL_TIMEOUT_MILLIS));
    }

    public static void main(String[] args) {
        System.out.println(CONNECTOR_CONFIG_DEF.toHtml(4, config -> "mirror_checkpoint_" + config));
    }
}

