/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.BrokerBlockingSender;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\t\u0012\u0001YA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tE\u0001\u0011)\u0019!C\tG!Aq\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00069\u0002!\t!\u0018\u0005\u0006M\u0002!\te\u001a\u0005\u0006k\u0002!\tA^\u0004\buF\t\t\u0011#\u0001|\r\u001d\u0001\u0012#!A\t\u0002qDa\u0001X\u0007\u0005\u0002\u0005\u0005\u0001\"CA\u0002\u001bE\u0005I\u0011AA\u0003\u0005U\u0011V\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u00012\u0001G\r\u001c\u001b\u0005\t\u0012B\u0001\u000e\u0012\u0005Y\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bC\u0001\r\u001d\u0013\ti\u0012C\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u00031\u0001J!!I\t\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005!\u0003C\u0001\r&\u0013\t1\u0013C\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nq!\\3ue&\u001c7\u000f\u0005\u0002+g5\t1F\u0003\u0002)Y)\u0011QFL\u0001\u0007G>lWn\u001c8\u000b\u0005Qy#B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001eL!\u0001N\u0016\u0003\u000f5+GO]5dg\u0006!A/[7f!\t9$(D\u00019\u0015\tID&A\u0003vi&d7/\u0003\u0002<q\t!A+[7f\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002?\u0003\u000ek\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011[eBA#J!\t1u(D\u0001H\u0015\tAU#\u0001\u0004=e>|GOP\u0005\u0003\u0015~\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!jP\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u00031AK!!U\t\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018aF7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8TkB\u0004H.[3s!\rqDKV\u0005\u0003+~\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005]SV\"\u0001-\u000b\u00055J&B\u0001\n/\u0013\tY\u0006LA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0019a\u0014N\\5u}QAal\u00181bE\u000e$W\r\u0005\u0002\u0019\u0001!)a$\u0003a\u0001?!)!%\u0003a\u0001I!)\u0001&\u0003a\u0001S!)Q'\u0003a\u0001m!9A(\u0003I\u0001\u0002\u0004i\u0004\"\u0002(\n\u0001\u0004y\u0005\"\u0002*\n\u0001\u0004\u0019\u0016aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$GcA\u000ei[\")\u0011N\u0003a\u0001U\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\t\u0003}-L!\u0001\\ \u0003\u0007%sG\u000fC\u0003o\u0015\u0001\u0007q.\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s'\u000591\r\\;ti\u0016\u0014\u0018B\u0001;r\u00059\u0011%o\\6fe\u0016sG\rU8j]R\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002oB\u0011a\b_\u0005\u0003s~\u0012A!\u00168ji\u0006)\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bC\u0001\r\u000e'\tiQ\u0010\u0005\u0002?}&\u0011qp\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0003m\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA\u0004U\ri\u0014\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QC \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;
    private final Function0<MetadataVersion> metadataVersionSupplier;

    public static Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String prefix = (String)this.threadNamePrefix.map((Function1 & Serializable)tp -> new StringBuilder(1).append((String)tp).append(":").toString()).getOrElse((Function0 & Serializable)() -> "");
        String threadName = new StringBuilder(22).append(prefix).append("ReplicaFetcherThread-").append(fetcherId).append("-").append(sourceBroker.id()).toString();
        LogContext logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.brokerConfig.brokerId()).append(", leaderId=").append(sourceBroker.id()).append(", ").append("fetcherId=").append(fetcherId).append("] ").toString());
        BrokerBlockingSender endpoint = new BrokerBlockingSender(sourceBroker, this.brokerConfig, this.metrics, this.time, fetcherId, new StringBuilder(16).append("broker-").append(this.brokerConfig.brokerId()).append("-fetcher-").append(fetcherId).toString(), logContext);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, sourceBroker.id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), endpoint, fetchSessionHandler, this.brokerConfig, this.replicaManager(), this.quotaManager, this.metadataVersionSupplier);
        return new ReplicaFetcherThread(threadName, leader, this.brokerConfig, this.failedPartitions(), this.replicaManager(), this.quotaManager, logContext.logPrefix(), this.metadataVersionSupplier);
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager, Function0<MetadataVersion> metadataVersionSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(new StringBuilder(32).append("ReplicaFetcherManager on broker ").append(brokerConfig.brokerId()).toString(), "Replica", Predef$.MODULE$.Integer2int(brokerConfig.numReplicaFetchers()));
    }
}

