/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUd\u0001\u0002\u001f>\u0001\tC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t/\u0002\u0011\t\u0011)A\u00051\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0006z\u0001A\u0005\t1!Q\u0001\niD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u000f\u0005\u0005\u0002\u0001)A\u0005{\"I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00024!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002D!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002\u0006\"I\u0011Q\u0012\u0001C\u0002\u0013%\u0011q\u0012\u0005\t\u00033\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u00111\u0014\u0001C\u0002\u0013%\u0011Q\u0014\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002 \"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAZ\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003k\u0003A\u0011IAV\u000f\u001d\t9,\u0010E\u0001\u0003s3a\u0001P\u001f\t\u0002\u0005m\u0006BB:\u001b\t\u0003\ti\fC\u0005\u0002@j\u0011\r\u0011\"\u0001\u0002B\"A\u0011q\u0019\u000e!\u0002\u0013\t\u0019\rC\u0005\u0002Jj\u0011\r\u0011\"\u0001\u0002L\"A\u0011Q\u001b\u000e!\u0002\u0013\ti\rC\u0005\u0002Xj\u0011\r\u0011\"\u0001\u0002Z\"A\u0011\u0011\u001d\u000e!\u0002\u0013\tYNB\u0005\u0002dj\u0001\n1%\t\u0002f\u001e9!Q\f\u000e\t\u0002\n-aaBAu5!\u0005\u00151\u001e\u0005\u0007g\u0012\"\tA!\u0003\t\u000f\t5A\u0005\"\u0011\u0003\u0010!I!\u0011\u0003\u0013\u0002\u0002\u0013\u0005\u0013\u0011\u0019\u0005\n\u0005'!\u0013\u0011!C\u0001\u0005+A\u0011B!\b%\u0003\u0003%\tAa\b\t\u0013\t%B%!A\u0005B\t-\u0002\"\u0003B\u001aI\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011y\u0004JA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003D\u0011\n\t\u0011\"\u0003\u0003F\u001d9!q\f\u000e\t\u0002\nMca\u0002B'5!\u0005%q\n\u0005\u0007g>\"\tA!\u0015\t\u000f\t5q\u0006\"\u0011\u0003\u0010!I!\u0011C\u0018\u0002\u0002\u0013\u0005\u0013\u0011\u0019\u0005\n\u0005'y\u0013\u0011!C\u0001\u0005+A\u0011B!\b0\u0003\u0003%\tA!\u0016\t\u0013\t%r&!A\u0005B\t-\u0002\"\u0003B\u001a_\u0005\u0005I\u0011\u0001B-\u0011%\u0011ydLA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003D=\n\t\u0011\"\u0003\u0003F!9!\u0011\r\u000e\u0005\u0002\t\r\u0004\"\u0003B45\t\u0007I\u0011\u0001B5\u0011!\u0011\u0019H\u0007Q\u0001\n\t-$aD&bM.\f'+\u00194u'\u0016\u0014h/\u001a:\u000b\u0005yz\u0014AB:feZ,'OC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\"J\u001bB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"AS&\u000e\u0003uJ!\u0001T\u001f\u0003\rM+'O^3s!\tq\u0015+D\u0001P\u0015\t\u0001v(A\u0003vi&d7/\u0003\u0002S\u001f\n9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002K+&\u0011a+\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0003uS6,\u0007CA-c\u001b\u0005Q&B\u0001)\\\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003\u0001zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111M\u0017\u0002\u0005)&lW-\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB\u0019AI\u001a5\n\u0005\u001d,%AB(qi&|g\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003W\u0016k\u0011\u0001\u001c\u0006\u0003[\u0006\u000ba\u0001\u0010:p_Rt\u0014BA8F\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=,\u0015A\u0002\u001fj]&$h\b\u0006\u0003vm^D\bC\u0001&\u0001\u0011\u0015\u0019F\u00011\u0001U\u0011\u00159F\u00011\u0001Y\u0011\u0015!G\u00011\u0001f\u0003\rAH%\r\t\b\tnl\u0018\u0011AA\t\u0013\taXI\u0001\u0004UkBdWm\r\t\u0003\u0015zL!a`\u001f\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!\u00032p_R\u001cHO]1q\u0015\r\tY!X\u0001\t[\u0016$\u0018\rZ1uC&!\u0011qBA\u0003\u0005E\u0011un\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\t\u0006\u0003'\tI\u0002[\u0007\u0003\u0003+Q1!a\u0006F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)BA\u0002TKF\f\u0011\"\\3uCB\u0013x\u000e]:\u0016\u0003u\f!\"\\3uCB\u0013x\u000e]:!\u0003E\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/Y\u000b\u0003\u0003\u0003\t!CY8piN$(/\u00199NKR\fG-\u0019;bA\u0005YqN\u001a4mS:,G)\u001b:t+\t\t\t\"\u0001\u0007pM\u001ad\u0017N\\3ESJ\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003si!!a\u000e\u000b\u0007\u0005=2,\u0003\u0003\u0002<\u0005]\"aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAA\"!\u0019\t)%a\u0015\u0002X5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0014\u0002P\u0005!Q\u000f^5m\u0015\t\t\t&\u0001\u0003kCZ\f\u0017\u0002BA+\u0003\u000f\u0012\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\tI&a\u0017\u0002`\u0005-TBAA&\u0013\u0011\ti&a\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0014\u0002\t1\fgnZ\u0005\u0005\u0003S\n\u0019GA\u0004J]R,w-\u001a:\u0011\t\u00055\u0014\u0011\u0010\b\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O/\u0002\tI\fg\r^\u0005\u0005\u0003o\n\t(\u0001\u0006SC\u001a$8i\u001c8gS\u001eLA!a\u001f\u0002~\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\u0011\t9(!\u001d\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\nAb\u001d5be\u0016$7+\u001a:wKJ,\"!!\"\u0011\u0007)\u000b9)C\u0002\u0002\nv\u0012Ab\u00155be\u0016$7+\u001a:wKJ\fQb\u001d5be\u0016$7+\u001a:wKJ\u0004\u0013A\u00022s_.,'/\u0006\u0002\u0002\u0012B!AIZAJ!\rQ\u0015QS\u0005\u0004\u0003/k$\u0001\u0004\"s_.,'oU3sm\u0016\u0014\u0018a\u00022s_.,'\u000fI\u0001\u000bG>tGO]8mY\u0016\u0014XCAAP!\u0011!e-!)\u0011\u0007)\u000b\u0019+C\u0002\u0002&v\u0012\u0001cQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\bgR\f'\u000f^;q)\t\ti\u000bE\u0002E\u0003_K1!!-F\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0017aD&bM.\f'+\u00194u'\u0016\u0014h/\u001a:\u0011\u0005)S2C\u0001\u000eD)\t\tI,A\u0007NKR\fG-\u0019;b)>\u0004\u0018nY\u000b\u0003\u0003\u0007\u0004B!!\u0019\u0002F&\u0019\u0011/a\u0019\u0002\u001d5+G/\u00193bi\u0006$v\u000e]5dA\u0005\tR*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8\u0016\u0005\u00055\u0007\u0003BAh\u0003#l\u0011aW\u0005\u0004\u0003'\\&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0013\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t\u0007%A\bNKR\fG-\u0019;b)>\u0004\u0018nY%e+\t\tY\u000e\u0005\u0003\u0002P\u0006u\u0017bAAp7\n!Q+^5e\u0003AiU\r^1eCR\fGk\u001c9jG&#\u0007EA\u0006Qe>\u001cWm]:S_2,7C\u0001\u0012DS\r\u0011Ce\f\u0002\u000b\u0005J|7.\u001a:S_2,7\u0003\u0003\u0013D\u0003[\f\t0a>\u0011\u0007\u0005=(%D\u0001\u001b!\r!\u00151_\u0005\u0004\u0003k,%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003s\u0014\u0019A\u0004\u0003\u0002|\u0006}hbA6\u0002~&\ta)C\u0002\u0003\u0002\u0015\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0006\t\u001d!\u0001D*fe&\fG.\u001b>bE2,'b\u0001B\u0001\u000bR\u0011!1\u0002\t\u0004\u0003_$\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003!\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\f!\r!%\u0011D\u0005\u0004\u00057)%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0011\u0005O\u00012\u0001\u0012B\u0012\u0013\r\u0011)#\u0012\u0002\u0004\u0003:L\b\u0002C=*\u0003\u0003\u0005\rAa\u0006\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\f\u0011\r\u0005M!q\u0006B\u0011\u0013\u0011\u0011\t$!\u0006\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005o\u0011i\u0004E\u0002E\u0005sI1Aa\u000fF\u0005\u001d\u0011un\u001c7fC:D\u0001\"_\u0016\u0002\u0002\u0003\u0007!\u0011E\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qC\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u000f\u0002B!!\u0019\u0003J%!!1JA2\u0005\u0019y%M[3di\nq1i\u001c8ue>dG.\u001a:S_2,7\u0003C\u0018D\u0003[\f\t0a>\u0015\u0005\tM\u0003cAAx_Q!!\u0011\u0005B,\u0011!IH'!AA\u0002\t]A\u0003\u0002B\u001c\u00057B\u0001\"\u001f\u001c\u0002\u0002\u0003\u0007!\u0011E\u0001\u000b\u0005J|7.\u001a:S_2,\u0017AD\"p]R\u0014x\u000e\u001c7feJ{G.Z\u0001\u0012S:LG/[1mSj,Gj\\4ESJ\u001cHc\u0001>\u0003f!)1+\u000fa\u0001)\u0006a1m\u001c8gS\u001e\u001c6\r[3nCV\u0011!1\u000e\t\u0005\u0005[\u0012y'\u0004\u0002\u0002\n%!!\u0011OA\u0005\u0005EY\u0015MZ6b\u0007>tg-[4TG\",W.Y\u0001\u000eG>tg-[4TG\",W.\u0019\u0011")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        this.x$1 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.sharedServer = new SharedServer(config, this.metaProps(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture(), new StandardFaultHandlerFactory());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(this.sharedServer(), this.offlineDirs())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

