/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dbA\u0002.\\\u0003\u0003iv\f\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001z\u0011!q\bA!A!\u0002\u0013Q\b\"C@\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\ty\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003#\u0001!\u00111A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\t\u0005\r\u0011\"\u0001\u0002$!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006K!!\u0006\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003K\u0002!\u0011!Q\u0001\n\u0005\u001d\u0004BCA7\u0001\t\u0005\t\u0015!\u0003\u0002p!IA\u000f\u0001B\u0001B\u0003%\u0011Q\u000f\u0005\u000b\u0003\u007f\u0002!\u0011!Q\u0001\n\u0005\u0005\u0005BCAG\u0001\t\u0005\t\u0015!\u0003\u0002\u0010\"Q\u0011Q\u0013\u0001\u0003\u0002\u0003\u0006I!a&\t\u0015\u0005\r\u0006A!A!\u0002\u0013\t)\u000bC\u0004\u0002,\u0002!\t!!,\t\u0013\u0005-\u0007A1A\u0005\u0002\u00055\u0007\u0002CAr\u0001\u0001\u0006I!a4\t\u000f\u0005\u0015\bA\"\u0001\u0002h\"9\u0011q \u0001\u0007\u0002\u0005\u001d\b\"\u0003B\u0001\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011Y\u0001\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\u0007\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011y\u0001\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\t\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011\u0019\u0002\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\u000b\u0001\t\u0007I\u0011\u0002B\f\u0011!\u0011I\u0003\u0001Q\u0001\n\te\u0001B\u0003B\u0016\u0001\t\u0007I\u0011A.\u0003.!A!Q\u0007\u0001!\u0002\u0013\u0011y\u0003\u0003\u0006\u00038\u0001\u0011\r\u0011\"\u0001\\\u0005sA\u0001B!\u0015\u0001A\u0003%!1\b\u0005\n\u0005'\u0002!\u0019!C\u0005\u0005+B\u0001B!\u001c\u0001A\u0003%!q\u000b\u0005\n\u0005_\u0002!\u0019!C\u0005\u0005cB\u0001B!\u001f\u0001A\u0003%!1\u000f\u0005\n\u0005w\u0002\u0001\u0019!C\u0005\u0005{B\u0011Ba \u0001\u0001\u0004%IA!!\t\u0011\t\u0015\u0005\u0001)Q\u0005\u0003sA!Ba\"\u0001\u0005\u0004%\ta\u0017BE\u0011!\u0019)\u0005\u0001Q\u0001\n\t-\u0005\"CB$\u0001\u0001\u0007I\u0011BB%\u0011%\u0019Y\u0005\u0001a\u0001\n\u0013\u0019i\u0005\u0003\u0005\u0004R\u0001\u0001\u000b\u0015BA4\u0011)\u0019\u0019\u0006\u0001b\u0001\n\u0003Y6Q\u000b\u0005\t\u0007K\u0002\u0001\u0015!\u0003\u0004X!I1q\r\u0001C\u0002\u0013\u00051\u0011\u000e\u0005\t\u0007c\u0002\u0001\u0015!\u0003\u0004l\u00199!Q\u0013\u0001A7\n]\u0005B\u0003B_i\tU\r\u0011\"\u0001\u0003@\"Q!q\u0019\u001b\u0003\u0012\u0003\u0006IA!1\t\u0015\t%GG!f\u0001\n\u0003\u0011Y\r\u0003\u0006\u0003TR\u0012\t\u0012)A\u0005\u0005\u001bDq!a+5\t\u0003\u0011)\u000eC\u0004\u0003\\R\"\tE!8\t\u0013\t\rH'!A\u0005\u0002\t\u0015\b\"\u0003BviE\u0005I\u0011\u0001Bw\u0011%\u0019\u0019\u0001NI\u0001\n\u0003\u0019)\u0001C\u0005\u0004\nQ\n\t\u0011\"\u0011\u0004\f!I1\u0011\u0003\u001b\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0007'!\u0014\u0011!C\u0001\u0007+A\u0011ba\b5\u0003\u0003%\te!\t\t\u0013\r-B'!A\u0005\u0002\r5\u0002\"CB\u0019i\u0005\u0005I\u0011IB\u001a\u0011%\u00199\u0004NA\u0001\n\u0003\u001aI\u0004C\u0005\u0004<Q\n\t\u0011\"\u0011\u0004>!I1q\b\u001b\u0002\u0002\u0013\u00053\u0011I\u0004\u000b\u0007g\u0002\u0011\u0011!E\u00017\u000eUdA\u0003BK\u0001\u0005\u0005\t\u0012A.\u0004x!9\u00111\u0016%\u0005\u0002\r=\u0005\"CB\u001e\u0011\u0006\u0005IQIB\u001f\u0011%\u0019\t\nSA\u0001\n\u0003\u001b\u0019\nC\u0005\u0004\u001a\"\u000b\t\u0011\"!\u0004\u001c\"A1Q\u0016\u0001\u0005\u0002m\u001by\u000bC\u0004\u00046\u0002!\taa.\t\u000f\re\u0006\u0001\"\u0001\u00048\"911\u0018\u0001\u0005B\r]\u0006bBB_\u0001\u0011%1q\u0018\u0005\b\u0007\u0017\u0004A\u0011BB\\\u0011\u001d\u0019i\r\u0001C\u0005\u0007\u001fDqa!8\u0001\t#\u0019y\u000eC\u0004\u0004f\u0002!Iaa.\t\u000f\r\u001d\b\u0001\"\u0003\u0004j\"91Q\u001f\u0001\u0005\u0002\r]\u0006bBB|\u0001\u0011\u00051\u0011 \u0005\b\u0007\u007f\u0004A\u0011\u0001C\u0001\u0005!\t5mY3qi>\u0014(B\u0001/^\u0003\u001dqW\r^<pe.T\u0011AX\u0001\u0006W\u000647.Y\n\u0006\u0001\u0001D7.\u001d\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA\u0001\\1oO*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005\u0019y%M[3diB\u0011\u0011-[\u0005\u0003U\n\u0014\u0001BU;o]\u0006\u0014G.\u001a\t\u0003Y>l\u0011!\u001c\u0006\u0003]v\u000bQ!\u001e;jYNL!\u0001]7\u0003\u000f1{wmZ5oOB\u0011!/^\u0007\u0002g*\u0011A/X\u0001\b[\u0016$(/[2t\u0013\t18OA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fAb]8dW\u0016$8+\u001a:wKJ\u001c\u0001!F\u0001{!\tYH0D\u0001\\\u0013\ti8L\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001\tK:$\u0007k\\5oiV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B/\u0002\u000f\rdWo\u001d;fe&!\u0011QBA\u0004\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D/\u0002\rM,'O^3s\u0013\u0011\ty\"!\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u0013\u0003c\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0003\u0003W\tQa]2bY\u0006LA!a\f\u0002*\t!QK\\5u\u0011%\t\u0019DBA\u0001\u0002\u0004\t)\"A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0005\u0003O\tY$\u0003\u0003\u0002>\u0005%\"aA%oi\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0003\u0007\u00022a_A#\u0013\r\t9e\u0017\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\f\u0011cY8o]\u0016\u001cG/[8o#V|G/Y:!\u0003\u0011!\u0018.\\3\u0011\t\u0005=\u0013\u0011M\u0007\u0003\u0003#R1A\\A*\u0015\u0011\t)&a\u0016\u0002\r\r|W.\\8o\u0015\rq\u0016\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003?\n1a\u001c:h\u0013\u0011\t\u0019'!\u0015\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\t\u0005\u001d\u0012\u0011N\u0005\u0005\u0003W\nICA\u0004C_>dW-\u00198\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u001910!\u001d\n\u0007\u0005M4L\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\t\u0005]\u00141P\u0007\u0003\u0003sR1\u0001^A*\u0013\u0011\ti(!\u001f\u0003\u000f5+GO]5dg\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD;\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\f\u0006\u0015%AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\f!\u0002\\8h\u0007>tG/\u001a=u!\u0011\ty%!%\n\t\u0005M\u0015\u0011\u000b\u0002\u000b\u0019><7i\u001c8uKb$\u0018AC7f[>\u0014\u0018\u0010U8pYB!\u0011\u0011TAP\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006M\u0013AB7f[>\u0014\u00180\u0003\u0003\u0002\"\u0006m%AC'f[>\u0014\u0018\u0010U8pY\u0006\t\u0012\r]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0011\t\u0005]\u0011qU\u0005\u0005\u0003S\u000bIBA\tBa&4VM]:j_:l\u0015M\\1hKJ\fa\u0001P5oSRtD\u0003HAX\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011\u001a\t\u0003w\u0002AQa^\nA\u0002iDaa`\nA\u0002\u0005\r\u0001bBA\t'\u0001\u0007\u0011Q\u0003\u0005\b\u0003o\u0019\u0002\u0019AA\u001d\u0011\u001d\tyd\u0005a\u0001\u0003\u0007Bq!a\u0013\u0014\u0001\u0004\ti\u0005C\u0004\u0002fM\u0001\r!a\u001a\t\u000f\u000554\u00031\u0001\u0002p!1Ao\u0005a\u0001\u0003kBq!a \u0014\u0001\u0004\t\t\tC\u0004\u0002\u000eN\u0001\r!a$\t\u000f\u0005U5\u00031\u0001\u0002\u0018\"9\u00111U\nA\u0002\u0005\u0015\u0016!C:i_VdGMU;o+\t\ty\r\u0005\u0003\u0002R\u0006}WBAAj\u0015\u0011\t).a6\u0002\r\u0005$x.\\5d\u0015\u0011\tI.a7\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002^\u0012\fA!\u001e;jY&!\u0011\u0011]Aj\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q1\u000f[8vY\u0012\u0014VO\u001c\u0011\u0002\u00195,GO]5d!J,g-\u001b=\u0015\u0005\u0005%\b\u0003BAv\u0003stA!!<\u0002vB!\u0011q^A\u0015\u001b\t\t\tPC\u0002\u0002tb\fa\u0001\u0010:p_Rt\u0014\u0002BA|\u0003S\ta\u0001\u0015:fI\u00164\u0017\u0002BA~\u0003{\u0014aa\u0015;sS:<'\u0002BA|\u0003S\tA\u0002\u001e5sK\u0006$\u0007K]3gSb\fab]3oI\n+hMZ3s'&TX-\u0006\u0002\u0003\u0006A\u0019\u0011Ma\u0002\n\u0007\t%!MA\u0004J]R,w-\u001a:\u0002\u001fM,g\u000e\u001a\"vM\u001a,'oU5{K\u0002\naB]3dm\n+hMZ3s'&TX-A\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3!\u0003Ea\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0Z\u0001\u0013Y&\u001cH/\u001a8CC\u000e\\Gn\\4TSj,\u0007%A\u0006oS>\u001cV\r\\3di>\u0014XC\u0001B\r!\u0011\u0011YB!\n\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\t\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0005G!\u0017a\u00018j_&!!q\u0005B\u000f\u0005!\u0019V\r\\3di>\u0014\u0018\u0001\u00048j_N+G.Z2u_J\u0004\u0013!D:feZ,'o\u00115b]:,G.\u0006\u0002\u00030A!!1\u0004B\u0019\u0013\u0011\u0011\u0019D!\b\u0003'M+'O^3s'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u001dM,'O^3s\u0007\"\fgN\\3mA\u0005Q\u0001O]8dKN\u001cxN]:\u0016\u0005\tm\u0002C\u0002B\u001f\u0005\u000f\u0012Y%\u0004\u0002\u0003@)!!\u0011\tB\"\u0003\u001diW\u000f^1cY\u0016TAA!\u0012\u0002*\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%#q\b\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002|\u0005\u001bJ1Aa\u0014\\\u0005%\u0001&o\\2fgN|'/A\u0006qe>\u001cWm]:peN\u0004\u0013!\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\t]\u0003\u0003\u0002B-\u0005Sj!Aa\u0017\u000b\t\tu#qL\u0001\u0005G>\u0014XMC\u0002u\u0005CRAAa\u0019\u0003f\u00051\u00110Y7nKJT!Aa\u001a\u0002\u0007\r|W.\u0003\u0003\u0003l\tm#AC'fiJL7MT1nK\u0006q\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;fe6+GO]5d\u001d\u0006lW\rI\u0001\u0014E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]\u000b\u0003\u0005g\u0002BA!\u0017\u0003v%!!q\u000fB.\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005)2-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016DXCAA\u001d\u0003e\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb|F%Z9\u0015\t\u0005\u0015\"1\u0011\u0005\n\u0003gI\u0013\u0011!a\u0001\u0003s\tacY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u0007\u0010I\u0001\u0011i\"\u0014x\u000e\u001e;mK\u0012\u001cvnY6fiN,\"Aa#\u0011\r\tu\"Q\u0012BI\u0013\u0011\u0011yIa\u0010\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f!\r\u0011\u0019\nN\u0007\u0002\u0001\t\u0011B)\u001a7bs\u0016$7\t\\8tKN{7m[3u'%!$\u0011\u0014BP\u0005c\u00139\f\u0005\u0003\u0002(\tm\u0015\u0002\u0002BO\u0003S\u0011a!\u00118z%\u00164\u0007C\u0002BQ\u0005W\u0013\tJ\u0004\u0003\u0003$\n\u001df\u0002BAx\u0005KK!!a\u000b\n\t\t%\u0016\u0011F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iKa,\u0003\u000f=\u0013H-\u001a:fI*!!\u0011VA\u0015!\u0011\t9Ca-\n\t\tU\u0016\u0011\u0006\u0002\b!J|G-^2u!\u0011\u0011\tK!/\n\t\tm&q\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007g>\u001c7.\u001a;\u0016\u0005\t\u0005\u0007\u0003\u0002B\u000e\u0005\u0007LAA!2\u0003\u001e\ti1k\\2lKR\u001c\u0005.\u00198oK2\fqa]8dW\u0016$\b%A\tf]\u0012$\u0006N]8ui2,G+[7f\u001bN,\"A!4\u0011\t\u0005\u001d\"qZ\u0005\u0005\u0005#\fIC\u0001\u0003M_:<\u0017AE3oIRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\"bA!%\u0003X\ne\u0007b\u0002B_s\u0001\u0007!\u0011\u0019\u0005\b\u0005\u0013L\u0004\u0019\u0001Bg\u0003\u001d\u0019w.\u001c9be\u0016$B!!\u000f\u0003`\"9!\u0011\u001d\u001eA\u0002\tE\u0015\u0001\u0002;iCR\fAaY8qsR1!\u0011\u0013Bt\u0005SD\u0011B!0<!\u0003\u0005\rA!1\t\u0013\t%7\b%AA\u0002\t5\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005_TCA!1\u0003r.\u0012!1\u001f\t\u0005\u0005k\u0014y0\u0004\u0002\u0003x*!!\u0011 B~\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003~\u0006%\u0012AC1o]>$\u0018\r^5p]&!1\u0011\u0001B|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199A\u000b\u0003\u0003N\nE\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004\u000eA\u0019\u0011ma\u0004\n\u0007\u0005m(-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r]1Q\u0004\t\u0005\u0003O\u0019I\"\u0003\u0003\u0004\u001c\u0005%\"aA!os\"I\u00111\u0007!\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u0005\t\u0007\u0007K\u00199ca\u0006\u000e\u0005\t\r\u0013\u0002BB\u0015\u0005\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qMB\u0018\u0011%\t\u0019DQA\u0001\u0002\u0004\u00199\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BB\u0007\u0007kA\u0011\"a\rD\u0003\u0003\u0005\r!!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"a!\u0004\u0002\r\u0015\fX/\u00197t)\u0011\t9ga\u0011\t\u0013\u0005Mb)!AA\u0002\r]\u0011!\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;tA\u000591\u000f^1si\u0016$WCAA4\u0003-\u0019H/\u0019:uK\u0012|F%Z9\u0015\t\u0005\u00152q\n\u0005\n\u0003gq\u0013\u0011!a\u0001\u0003O\n\u0001b\u001d;beR,G\rI\u0001\fgR\f'\u000f\u001e$viV\u0014X-\u0006\u0002\u0004XA11\u0011LB.\u0007?j!!a6\n\t\ru\u0013q\u001b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA1\u0004b%\u001911\r2\u0003\tY{\u0017\u000eZ\u0001\rgR\f'\u000f\u001e$viV\u0014X\rI\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\r-\u0004\u0003BA(\u0007[JAaa\u001c\u0002R\tY1*\u00194lCRC'/Z1e\u0003\u001d!\bN]3bI\u0002\n!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiB\u0019!1\u0013%\u0014\u000b!\u001bIh!\"\u0011\u0015\rm4\u0011\u0011Ba\u0005\u001b\u0014\t*\u0004\u0002\u0004~)!1qPA\u0015\u0003\u001d\u0011XO\u001c;j[\u0016LAaa!\u0004~\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\r\u001d5QR\u0007\u0003\u0007\u0013S1aa#e\u0003\tIw.\u0003\u0003\u0003<\u000e%ECAB;\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011\tj!&\u0004\u0018\"9!QX&A\u0002\t\u0005\u0007b\u0002Be\u0017\u0002\u0007!QZ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ij!+\u0011\r\u0005\u001d2qTBR\u0013\u0011\u0019\t+!\u000b\u0003\r=\u0003H/[8o!!\t9c!*\u0003B\n5\u0017\u0002BBT\u0003S\u0011a\u0001V;qY\u0016\u0014\u0004\"CBV\u0019\u0006\u0005\t\u0019\u0001BI\u0003\rAH\u0005M\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$B!!\n\u00042\"911W'A\u0002\u0005e\u0012a\u0003:f[>4XmQ8v]R\fQBY3hS:\u001c\u0006.\u001e;e_^tGCAA\u0013\u0003\u0015\u0019Gn\\:f\u0003\r\u0011XO\\\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$\u0002Ba\f\u0004B\u000e\u00157\u0011\u001a\u0005\b\u0007\u0007\f\u0006\u0019AAu\u0003\u0011Awn\u001d;\t\u000f\r\u001d\u0017\u000b1\u0001\u0002:\u0005!\u0001o\u001c:u\u0011\u001d\u0011\t\"\u0015a\u0001\u0003s\tA#Y2dKB$h*Z<D_:tWm\u0019;j_:\u001c\u0018AB1dG\u0016\u0004H\u000f\u0006\u0003\u0004R\u000eM\u0007CBA\u0014\u0007?\u0013\t\rC\u0004\u0004VN\u0003\raa6\u0002\u0007-,\u0017\u0010\u0005\u0003\u0003\u001c\re\u0017\u0002BBn\u0005;\u0011AbU3mK\u000e$\u0018n\u001c8LKf\fadY8oM&<WO]3BG\u000e,\u0007\u000f^3e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0015\t\u0005\u00152\u0011\u001d\u0005\b\u0007G$\u0006\u0019\u0001Ba\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\u0006I2\r\\8tKRC'o\u001c;uY\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0003M\t7o]5h]:+woQ8o]\u0016\u001cG/[8o)!\t9ga;\u0004n\u000eE\bbBBr-\u0002\u0007!\u0011\u0019\u0005\b\u0007_4\u0006\u0019\u0001B&\u0003%\u0001(o\\2fgN|'\u000fC\u0004\u0004tZ\u0003\r!a\u001a\u0002\u00115\f\u0017P\u00117pG.\faa^1lKV\u0004\u0018!D1eIB\u0013xnY3tg>\u00148\u000f\u0006\u0003\u0002&\rm\bbBB\u007f1\u0002\u0007\u0011\u0011H\u0001\ti>\u001c%/Z1uK\u0006aa.Z<Qe>\u001cWm]:peRA!1\nC\u0002\t\u000f!)\u0002C\u0004\u0005\u0006e\u0003\r!!\u000f\u0002\u0005%$\u0007b\u0002C\u00053\u0002\u0007A1B\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\t\u001b!\t\"\u0004\u0002\u0005\u0010)\u0019A,a\u0015\n\t\u0011MAq\u0002\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\t/I\u0006\u0019\u0001C\r\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0005\u001c\u0011\rRB\u0001C\u000f\u0015\u0011!y\u0002\"\t\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u000f\u000b\u0019&\u0003\u0003\u0005&\u0011u!\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0001")
public abstract class Acceptor
implements Runnable,
KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private boolean started;
    private final CompletableFuture<Void> startFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public CompletableFuture<Void> startFuture() {
        return this.startFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$13 -> {
                    x$13.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$14 -> {
                x$14.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$15)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$15) {
        return x$15.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize()));
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = this.explicitMetricName("kafka.network", "Acceptor", new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.blockedPercentMeter = this.newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = false;
        this.startFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        Object var14_14 = null;
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
        this.startFuture().thenRun(() -> {
            synchronized (this) {
                if (!this.shouldRun().get()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Ignoring start future for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
                    this.started_$eq(true);
                    this.processors().foreach((Function1 & Serializable)x$11 -> {
                        x$11.start();
                        return BoxedUnit.UNIT;
                    });
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
                    this.thread().start();
                }
                return;
            }
        });
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

