/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t]r!\u0002\u0012$\u0011\u0003Qc!\u0002\u0017$\u0011\u0003i\u0003\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"B2\u0002\t\u0003!g!\u0002\u0017$\u0001\u0005=\u0001BCA\f\u000b\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011\u0011E\u0003\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005%RA!A!\u0002\u0013\tY\u0003\u0003\u0006\u00022\u0015\u0011\t\u0011)A\u0005\u0003gA!\"!\u000f\u0006\u0005\u0003\u0005\u000b\u0011BA\u001e\u0011)\tY%\u0002B\u0001B\u0003%\u0011Q\n\u0005\u000b\u00033*!\u0011!Q\u0001\n\u0005m\u0003BCA1\u000b\t\u0005\r\u0011\"\u0001\u0002d!Q\u00111N\u0003\u0003\u0002\u0004%\t!!\u001c\t\u0015\u0005eTA!A!B\u0013\t)\u0007\u0003\u0006\u0002|\u0015\u0011)\u0019!C\u0005\u0003{B!\"a$\u0006\u0005\u0003\u0005\u000b\u0011BA@\u0011)\t\t*\u0002B\u0001B\u0003%\u00111\u0013\u0005\u000b\u0003?+!\u0011!Q\u0001\n\u0005M\u0005B\u0002\u001e\u0006\t\u0003\t\t\u000b\u0003\u0005v\u000b\t\u0007I\u0011AA^\u0011\u001d\ti,\u0002Q\u0001\nYD\u0011\"a0\u0006\u0001\u0004%\t!!1\t\u0013\u0005%W\u00011A\u0005\u0002\u0005-\u0007\u0002CAh\u000b\u0001\u0006K!a1\t\u0013\u0005EWA1A\u0005\u0002\u0005M\u0007\u0002CAw\u000b\u0001\u0006I!!6\t\u000f\u0005=X\u0001\"\u0011\u0002r\"9\u0011q_\u0003\u0005B\u0005e\bb\u0002B\u0001\u000b\u0011\u0005!1\u0001\u0005\b\u0005#)A\u0011\u0001B\n\u0011\u001d\u0011i#\u0002C\u0005\u0005_AqA!\r\u0006\t\u0013\u0011\u0019$A\fCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5fe*\u0011A%J\u0001\t[\u0016$\u0018\rZ1uC*\u0011aeJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002,\u00035\t1EA\fCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feN\u0019\u0011A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)\u0004(D\u00017\u0015\t9t%A\u0003vi&d7/\u0003\u0002:m\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001+\u000359W\r\u001e+pa&\u001cG)\u001a7uCR!a\bT-_!\rys(Q\u0005\u0003\u0001B\u0012aa\u00149uS>t\u0007C\u0001\"K\u001b\u0005\u0019%B\u0001#F\u0003\u0015IW.Y4f\u0015\tAcI\u0003\u0002H\u0011\u00061\u0011\r]1dQ\u0016T\u0011!S\u0001\u0004_J<\u0017BA&D\u0005)!v\u000e]5d\t\u0016dG/\u0019\u0005\u0006\u001b\u000e\u0001\rAT\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004\"a\u0014,\u000f\u0005A#\u0006CA)1\u001b\u0005\u0011&BA**\u0003\u0019a$o\\8u}%\u0011Q\u000bM\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002Va!)!l\u0001a\u00017\u0006Aa.Z<J[\u0006<W\r\u0005\u0002C9&\u0011Ql\u0011\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\t\u000b}\u001b\u0001\u0019\u00011\u0002\u000b\u0011,G\u000e^1\u0011\u0005\t\u000b\u0017B\u00012D\u00055iU\r^1eCR\fG)\u001a7uC\u0006\u0019b-\u001b8e'R\u0014\u0018-\u001f)beRLG/[8ogR!Q\r^=\u007f!\r17N\u001c\b\u0003O&t!!\u00155\n\u0003EJ!A\u001b\u0019\u0002\u000fA\f7m[1hK&\u0011A.\u001c\u0002\t\u0013R,'/\u00192mK*\u0011!\u000e\r\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0016\u000baaY8n[>t\u0017BA:q\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQ!\u001e\u0003A\u0002Y\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003_]L!\u0001\u001f\u0019\u0003\u0007%sG\u000fC\u0003{\t\u0001\u000710\u0001\boK^$v\u000e]5dg&k\u0017mZ3\u0011\u0005\tc\u0018BA?D\u0005-!v\u000e]5dg&k\u0017mZ3\t\r}$\u0001\u0019AA\u0001\u0003\u0011awnZ:\u0011\t\u0019\\\u00171\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0014\u0002\u00071|w-\u0003\u0003\u0002\u000e\u0005\u001d!AC+oS\u001aLW\r\u001a'pON)QALA\tiA\u00191&a\u0005\n\u0007\u0005U1EA\tNKR\fG-\u0019;b!V\u0014G.[:iKJ\fAaY8oMB!\u00111DA\u000f\u001b\u0005)\u0013bAA\u0010K\tY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u00191&!\n\n\u0007\u0005\u001d2E\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017A\u00037pO6\u000bg.Y4feB!\u0011QAA\u0017\u0013\u0011\ty#a\u0002\u0003\u00151{w-T1oC\u001e,'/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005m\u0011QG\u0005\u0004\u0003o)#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J\u0004B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0003he>,\bOC\u0002\u0002F\u001d\n1bY8pe\u0012Lg.\u0019;pe&!\u0011\u0011JA \u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/\u0001\buq:\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#RA!a\u0015\u0002D\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t9&!\u0015\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\f!d\u00197jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJ\u00042aKA/\u0013\r\tyf\t\u0002\u001b\u00072LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0017Ift\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5feV\u0011\u0011Q\r\t\u0004W\u0005\u001d\u0014bAA5G\t1B)\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'/\u0001\u000ees:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3s?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005U\u0004cA\u0018\u0002r%\u0019\u00111\u000f\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003or\u0011\u0011!a\u0001\u0003K\n1\u0001\u001f\u00132\u0003]!\u0017P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014\b%A\u0006`CV$\bn\u001c:ju\u0016\u0014XCAA@!\u0011ys(!!\u0011\t\u0005\r\u00151R\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005\u0019*\u0015\u0002BAG\u0003\u000b\u0013!\"Q;uQ>\u0014\u0018N_3s\u00031y\u0016-\u001e;i_JL'0\u001a:!\u0003E1\u0017\r^1m\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TAE\u0003\u00151\u0017-\u001e7u\u0013\u0011\ti*a&\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002=5,G/\u00193bi\u0006\u0004VO\u00197jg\"Lgn\u001a$bk2$\b*\u00198eY\u0016\u0014H\u0003GAR\u0003K\u000b9+!+\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\u0002:B\u00111&\u0002\u0005\b\u0003/!\u0002\u0019AA\r\u0011\u001d\t\t\u0003\u0006a\u0001\u0003GAq!!\u000b\u0015\u0001\u0004\tY\u0003C\u0004\u00022Q\u0001\r!a\r\t\u000f\u0005eB\u00031\u0001\u0002<!9\u00111\n\u000bA\u0002\u00055\u0003bBA-)\u0001\u0007\u00111\f\u0005\b\u0003C\"\u0002\u0019AA3\u0011\u001d\tY\b\u0006a\u0001\u0003\u007fBq!!%\u0015\u0001\u0004\t\u0019\nC\u0004\u0002 R\u0001\r!a%\u0016\u0003Y\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001b}3\u0017N]:u!V\u0014G.[:i+\t\t\u0019\rE\u00020\u0003\u000bL1!a21\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u00184jeN$\b+\u001e2mSNDw\fJ3r)\u0011\ty'!4\t\u0013\u0005]\u0004$!AA\u0002\u0005\r\u0017AD0gSJ\u001cH\u000fU;cY&\u001c\b\u000eI\u0001\u0016aV\u0014G.[:iK\u0012|eMZ:fi\u0006#x.\\5d+\t\t)\u000e\u0005\u0003\u0002X\u0006%XBAAm\u0015\u0011\tY.!8\u0002\r\u0005$x.\\5d\u0015\u0011\ty.!9\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001B;uS2T!!a:\u0002\t)\fg/Y\u0005\u0005\u0003W\fIN\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fa\u0003];cY&\u001c\b.\u001a3PM\u001a\u001cX\r^!u_6L7\rI\u0001\baV\u0014G.[:i)\u0019\ty'a=\u0002v\")q\f\ba\u0001A\")!\f\ba\u00017\u0006y\u0001/\u001e2mSNDW\rZ(gMN,G/\u0006\u0002\u0002|B\u0019q&!@\n\u0007\u0005}\bG\u0001\u0003M_:<\u0017!\n:fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0011\tyG!\u0002\t\u000f\t\u001da\u00041\u0001\u0003\n\u0005)\u0001O]8qgB!!1\u0002B\u0007\u001b\t\t\t/\u0003\u0003\u0003\u0010\u0005\u0005(A\u0003)s_B,'\u000f^5fg\u0006\tR\u000f\u001d3bi\u0016\u001cun\u001c:eS:\fGo\u001c:\u0015\u0019\u0005=$Q\u0003B\f\u00053\u0011YB!\n\t\u000b\u0011{\u0002\u0019A.\t\u000b}{\u0002\u0019\u00011\t\u000b5{\u0002\u0019\u0001(\t\u000f\tuq\u00041\u0001\u0003 \u0005AQ\r\\3di&|g\u000eE\u00040\u0005C1h/a\u001c\n\u0007\t\r\u0002GA\u0005Gk:\u001cG/[8oe!9!qE\u0010A\u0002\t%\u0012a\u0003:fg&<g.\u0019;j_:\u0004\u0002b\fB\u0011m\n-\u0012q\u000e\t\u0004_}2\u0018AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$\"!a\u001c\u0002A\u0019Lg.[:i\u0013:LG/[1mSjLgn\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0005\u0003_\u0012)\u0004C\u0003[C\u0001\u00071\f")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final Option<Authorizer> _authorizer;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final AtomicLong publishedOffsetAtomic;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public AtomicLong publishedOffsetAtomic() {
        return this.publishedOffsetAtomic;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$4(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> $this.groupCoordinator.onElection(offsetTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)offsetTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().publish(delta, newImage);
                try {
                    Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                        this.clientQuotaMetadataManager.update(clientQuotasDelta);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(32).append("Error updating client ").append("quotas in ").append(deltaName).toString(), t);
                }
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable)aclsDelta -> {
                    Authorizer authorizer;
                    Option<Authorizer> option = this._authorizer();
                    if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                        ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
                        if (aclsDelta.isSnapshotDelta()) {
                            try {
                                clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                                return BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                return $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName).toString(), t);
                            }
                        }
                        try {
                            aclsDelta.changes().entrySet().forEach(e -> {
                                if (((Optional)e.getValue()).isPresent()) {
                                    clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                                    return;
                                }
                                clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                            });
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName).toString(), t);
                        }
                    }
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
                this.publishedOffsetAtomic().set(newImage.highestOffsetAndEpoch().offset());
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    @Override
    public long publishedOffset() {
        return this.publishedOffsetAtomic().get();
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        try {
            Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
            if (strayPartitions.nonEmpty()) {
                this.replicaManager.deleteStrayReplicas(strayPartitions);
            }
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error deleting stray partitions during startup", t);
        }
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$publish$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion.featureLevel()).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, DynamicConfigPublisher dynamicConfigPublisher, Option<Authorizer> _authorizer, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this._authorizer = _authorizer;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.publishedOffsetAtomic = new AtomicLong(-1L);
    }
}

