/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.admin.BrokerMetadata;
import kafka.controller.StateChangeLogger;
import kafka.server.CachedControllerId;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rec\u0001\u0002\u00192\u0001aB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001f\")1\u000b\u0001C\u0001)\"9q\u000b\u0001a\u0001\n\u0013A\u0006b\u00023\u0001\u0001\u0004%I!\u001a\u0005\u0007W\u0002\u0001\u000b\u0015B-\t\u000fA\u0004!\u0019!C\u0005c\"1\u0001\u0010\u0001Q\u0001\nIDQ!\u001f\u0001\u0005\niDq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003{D\u0011Ba\u0005\u0001#\u0003%\t!!@\t\u000f\tU\u0001\u0001\"\u0011\u0003\u0018!9!\u0011\u0004\u0001\u0005B\tm\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011i\u0004\u0001C!\u0005\u007fAqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\t=\u0003\u0001\"\u0011\u0003R!9!q\n\u0001\u0005\n\t\u0015\u0004b\u0002B5\u0001\u0011\u0005#1\u000e\u0005\b\u0005c\u0002A\u0011\tB:\u0011\u001d\u0011I\b\u0001C!\u0005wBqAa%\u0001\t\u0003\u0012)\nC\u0004\u0003\u001c\u0002!\tE!(\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\"9!1\u0016\u0001\u0005B\t5\u0006b\u0002B[\u0001\u0011\u0005#q\u0017\u0005\b\u0005\u007f\u0003A\u0011\tBa\u0011\u001d\u0011i\r\u0001C!\u0005\u001fDqA!7\u0001\t\u0003\u0012Y\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\t\r\b\u0001\"\u0011\u0003f\"9!1\u001f\u0001\u0005\u0002\tU\bb\u0002B|\u0001\u0011\u0005!\u0011 \u0005\b\u0005\u007f\u0004A\u0011IB\u0001\u0011\u001d\u0011y\u0010\u0001C!\u0007\u000bAqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0004\u0004\u0012\u0001!\tea\u0005\t\u000f\r%\u0002\u0001\"\u0001\u0004,!91q\b\u0001\u0005B\r\u0005\u0003bBB(\u0001\u0011\u00053\u0011\u000b\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u00023g\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u00025k\u000511/\u001a:wKJT\u0011AN\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0011hP\"J!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fMB\u0011\u0001)Q\u0007\u0002g%\u0011!i\r\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019+\u0014!B;uS2\u001c\u0018B\u0001%F\u0005\u001daunZ4j]\u001e\u0004\"AS&\u000e\u0003EJ!\u0001T\u0019\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003=\u0003\"A\u000f)\n\u0005E[$aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U3\u0006C\u0001&\u0001\u0011\u0015i5\u00011\u0001P\u00035y6-\u001e:sK:$\u0018*\\1hKV\t\u0011\f\u0005\u0002[E6\t1L\u0003\u0002];\u0006)\u0011.\\1hK*\u0011aG\u0018\u0006\u0003?\u0002\fa!\u00199bG\",'\"A1\u0002\u0007=\u0014x-\u0003\u0002d7\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011cX2veJ,g\u000e^%nC\u001e,w\fJ3r)\t1\u0017\u000e\u0005\u0002;O&\u0011\u0001n\u000f\u0002\u0005+:LG\u000fC\u0004k\u000b\u0005\u0005\t\u0019A-\u0002\u0007a$\u0013'\u0001\b`GV\u0014(/\u001a8u\u00136\fw-\u001a\u0011)\u0005\u0019i\u0007C\u0001\u001eo\u0013\ty7H\u0001\u0005w_2\fG/\u001b7f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002eB\u00111O^\u0007\u0002i*\u0011Q/N\u0001\u000bG>tGO]8mY\u0016\u0014\u0018BA<u\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b%\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\u0012b_A\n\u0003+\ty\"a\r\u0011\u000bq\f\u0019!a\u0002\u000e\u0003uT!A`@\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA?\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB@\u0002\t1\fgnZ\u0005\u0005\u0003#\tYAA\u0004J]R,w-\u001a:\t\u000bqK\u0001\u0019A-\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a\u00059!M]8lKJ\u001c\b\u0003\u0002\u001e\u0002\u001c=K1!!\b<\u0005\u0015\t%O]1z\u0011\u001d\t\t#\u0003a\u0001\u0003G\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0004oKR<xN]6\u000b\u0007\u00055R,\u0001\u0004d_6lwN\\\u0005\u0005\u0003c\t9C\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u00026%\u0001\r!a\u000e\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0011\u0007i\nI$C\u0002\u0002<m\u0012qAQ8pY\u0016\fg.\u0001\u0007dkJ\u0014XM\u001c;J[\u0006<W\rF\u0001Z\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011QIAE\u0003\u0017\u000by*!)\u0002&B)!(a\u0012\u0002L%\u0019\u0011\u0011J\u001e\u0003\r=\u0003H/[8o!\u0019\ti%!\u0018\u0002d9!\u0011qJA-\u001d\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+o\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u00037Z\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003?\n\tG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tYf\u000f\t\u0005\u0003K\n\u0019I\u0004\u0003\u0002h\u0005ud\u0002BA5\u0003srA!a\u001b\u0002x9!\u0011QNA;\u001d\u0011\ty'a\u001d\u000f\t\u0005E\u0013\u0011O\u0005\u0002C&\u0011q\fY\u0005\u0003myK1!!\f^\u0013\u0011\tY(a\u000b\u0002\u000f5,7o]1hK&!\u0011qPAA\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u00111PA\u0016\u0013\u0011\t))a\"\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003\u007f\n\t\tC\u0003]\u0017\u0001\u0007\u0011\fC\u0004\u0002\u000e.\u0001\r!a$\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAI\u00033sA!a%\u0002\u0016B\u0019\u0011\u0011K\u001e\n\u0007\u0005]5(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\u000biJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/[\u0004bBA\u0011\u0017\u0001\u0007\u00111\u0005\u0005\b\u0003G[\u0001\u0019AA\u001c\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005\u001d6\u00021\u0001\u00028\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003I9W\r^(gM2Lg.\u001a*fa2L7-Y:\u0015\u000fm\fi+a,\u0002>\")A\f\u0004a\u00013\"9\u0011\u0011\u0017\u0007A\u0002\u0005M\u0016!\u00039beRLG/[8o!\u0011\t),!/\u000e\u0005\u0005]&B\u0001\u001a^\u0013\u0011\tY,a.\u0003+A\u000b'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u0011\u0011\u0005\u0007A\u0002\u0005\r\u0012\u0001E4fi\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)!\t\u0019-!4\u0002P\u0006M\u0007#\u0002\u001e\u0002H\u0005\u0015\u0007\u0003BAd\u0003\u0013l!!a\u000b\n\t\u0005-\u00171\u0006\u0002\u0005\u001d>$W\rC\u0003]\u001b\u0001\u0007\u0011\f\u0003\u0004\u0002R6\u0001\raT\u0001\u0003S\u0012Dq!!\t\u000e\u0001\u0004\t\u0019#\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRQ\u0011\u0011\\Av\u0003k\f90!?\u0011\r\u0005m\u0017\u0011]As\u001b\t\tiNC\u0002\u0002`n\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019/!8\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002f\u0005\u001d\u0018\u0002BAu\u0003\u000f\u0013Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7\rC\u0004\u0002n:\u0001\r!a<\u0002\rQ|\u0007/[2t!\u0019\tY.!=\u0002\u0010&!\u00111_Ao\u0005\r\u0019V\r\u001e\u0005\b\u0003Cq\u0001\u0019AA\u0012\u0011%\t\u0019K\u0004I\u0001\u0002\u0004\t9\u0004C\u0005\u0002(:\u0001\n\u00111\u0001\u00028\u0005Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q \u0016\u0005\u0003o\u0011\ta\u000b\u0002\u0003\u0004A!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011!C;oG\",7m[3e\u0015\r\u0011iaO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\t\u0005\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135\u000319W\r^!mYR{\u0007/[2t)\t\ty/\u0001\nhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\u000f\u0005K\u0001b!a7\u0002r\n}\u0001\u0003BAd\u0005CIAAa\t\u0002,\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAG%\u0001\u0007\u0011qR\u0001\u000bO\u0016$Hk\u001c9jG&#G\u0003\u0002B\u0016\u0005c\u0001B!a2\u0003.%!!qFA\u0016\u0005\u0011)V/\u001b3\t\u000f\u000555\u00031\u0001\u0002\u0010\u0006aq-\u001a;U_BL7MT1nKR!!q\u0007B\u001d!\u0015Q\u0014qIAH\u0011\u001d\u0011Y\u0004\u0006a\u0001\u0005W\tq\u0001^8qS\u000eLE-\u0001\biCN\fE.\u001b<f\u0005J|7.\u001a:\u0015\t\u0005]\"\u0011\t\u0005\u0006\u001bV\u0001\raT\u0001\u000fSN\u0014%o\\6fe\u001a+gnY3e)\u0011\t9Da\u0012\t\u000b53\u0002\u0019A(\u0002)%\u001c(I]8lKJ\u001c\u0006.\u001e;uS:<Gi\\<o)\u0011\t9D!\u0014\t\u000b5;\u0002\u0019A(\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN$\"Aa\u0015\u0011\r\u00055#Q\u000bB-\u0013\u0011\u00119&!\u0019\u0003\u0011%#XM]1cY\u0016\u0004BAa\u0017\u0003b5\u0011!Q\f\u0006\u0004\u0005?*\u0014!B1e[&t\u0017\u0002\u0002B2\u0005;\u0012aB\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003T\t\u001d\u0004\"\u0002/\u001a\u0001\u0004I\u0016AE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016$b!a1\u0003n\t=\u0004\"B'\u001b\u0001\u0004y\u0005bBA\u00115\u0001\u0007\u00111E\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0005k\u00129\b\u0005\u0004\u0002\\\u0006\u0005\u0018Q\u0019\u0005\b\u0003CY\u0002\u0019AA\u0012\u0003A9W\r\u001e)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u0003~\t5%q\u0012\t\u0006u\u0005\u001d#q\u0010\t\u0005\u0005\u0003\u00139I\u0004\u0003\u0002h\t\r\u0015\u0002\u0002BC\u0003\u0003\u000b\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC&!!\u0011\u0012BF\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TAA!\"\u0002\u0002\"9\u0011Q\u0012\u000fA\u0002\u0005=\u0005B\u0002BI9\u0001\u0007q*A\u0006qCJ$\u0018\u000e^5p]&#\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003\u0018\ne\u0005\u0003\u0002\u001e\u0002H=Cq!!$\u001e\u0001\u0004\ty)A\bu_BL7MT1nKN$v.\u00133t)\t\u0011y\nE\u0004}\u0005C\u000byIa\u000b\n\u0007\t\rVPA\u0002NCB\fq\u0002^8qS\u000eLEm\u001d+p\u001d\u0006lWm\u001d\u000b\u0003\u0005S\u0003r\u0001 BQ\u0005W\ty)A\u0006u_BL7-\u00133J]\u001a|GC\u0001BX!\u001dQ$\u0011\u0017BP\u0005SK1Aa-<\u0005\u0019!V\u000f\u001d7fe\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA\u00111\u0019B]\u0005w\u0013i\fC\u0004\u0002\u000e\u0006\u0002\r!a$\t\r\tE\u0015\u00051\u0001P\u0011\u001d\t\t#\ta\u0001\u0003G\tAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0003D\n\u001d'1\u001a\t\b\u0003#\u0013)mTAc\u0013\u0011\u0011\u0019+!(\t\u000f\t%'\u00051\u0001\u0003 \u0005\u0011A\u000f\u001d\u0005\b\u0003C\u0011\u0003\u0019AA\u0012\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#WC\u0001Bi!\u0015Q\u0014q\tBj!\r\u0001%Q[\u0005\u0004\u0005/\u001c$AE\"bG\",GmQ8oiJ|G\u000e\\3s\u0013\u0012\facZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0005/\u000bAcZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014H\u0003\u0002BL\u0005CDQ\u0001X\u0013A\u0002e\u000b!cZ3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uCR1!q\u001dBw\u0005c\u0004B!a2\u0003j&!!1^A\u0016\u0005\u001d\u0019E.^:uKJDqAa<'\u0001\u0004\ty)A\u0005dYV\u001cH/\u001a:JI\"9\u0011\u0011\u0005\u0014A\u0002\u0005\r\u0012aF:uCR,7\t[1oO\u0016$&/Y2f\u000b:\f'\r\\3e)\t\t9$A\nm_\u001e\u001cF/\u0019;f\u0007\"\fgnZ3Ue\u0006\u001cW\rF\u0002g\u0005wDqA!@)\u0001\u0004\ty)A\u0002tiJ\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003o\u0019\u0019\u0001C\u0004\u0002\u000e&\u0002\r!a$\u0015\t\u0005]2q\u0001\u0005\b\u0005\u0013T\u0003\u0019\u0001B\u0010\u0003!\u0019X\r^%nC\u001e,Gc\u00014\u0004\u000e!11qB\u0016A\u0002e\u000b\u0001B\\3x\u00136\fw-Z\u0001\u0007G>tg-[4\u0015\t\rU11\u0004\t\u0004y\u000e]\u0011bAB\r{\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\ruA\u00061\u0001\u0004 \u0005q1m\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007\u0003BB\u0011\u0007Ki!aa\t\u000b\t\rE\u00111F\u0005\u0005\u0007O\u0019\u0019C\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002)\u0011,7o\u0019:jE\u0016\u001cE.[3oiF+x\u000e^1t)\u0011\u0019ic!\u000e\u0011\t\r=2\u0011G\u0007\u0003\u0003\u0003KAaa\r\u0002\u0002\n\u0001C)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u00199$\fa\u0001\u0007s\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u00040\rm\u0012\u0002BB\u001f\u0003\u0003\u0013q\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z9vKN$H)\u0019;b\u0003=iW\r^1eCR\fg+\u001a:tS>tGCAB\"!\u0011\u0019)ea\u0013\u000e\u0005\r\u001d#\u0002BA\u0017\u0007\u0013R!\u0001N/\n\t\r53q\t\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006Aa-Z1ukJ,7\u000f\u0006\u0002\u0004TA\u0019\u0001i!\u0016\n\u0007\r]3GA\rGS:\fG.\u001b>fI\u001a+\u0017\r^;sKN\fe\u000eZ#q_\u000eD\u0007")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokers)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable & scala.Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            none$ = new Some((Object)((GenSetLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                MetadataResponseData.MetadataResponsePartition metadataResponsePartition;
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    metadataResponsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                } else if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.replicas)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.isr)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    metadataResponsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                } else {
                    throw new MatchError(maybeLeader);
                }
                return metadataResponsePartition;
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).iterator());
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return (Set)CollectionConverters$.MODULE$.asScalaSetConverter(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Set set;
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            set = Set$.MODULE$.empty();
        } else if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            set = (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return set;
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this._currentImage().topics().topicsByName()).asScala()).get((Object)topicName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this._currentImage().topics().topicsById()).asScala()).get((Object)topicId).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(image.cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.fenced()))).map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(b.rack()))), Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$9.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this._currentImage().cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced()))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value())))), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable & scala.Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch)));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<Map<String, Uuid>, Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        None$ none$;
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            None$ none$2;
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                none$2 = None$.MODULE$;
            } else if (option2 instanceof Some) {
                Some some;
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    some = new Some((Object)Node.noNode());
                } else if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    some = new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                } else {
                    throw new MatchError((Object)option3);
                }
                none$2 = some;
            } else {
                throw new MatchError((Object)option2);
            }
            none$ = none$2;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable & scala.Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.isr)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.getOfflineReplicas(image, partition, listenerName)).asScala()).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        boolean bl;
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            bl = ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeaturesAndEpoch features() {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.Map features = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(image.features().finalizedVersions()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Short level;
            String name;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    name = (String)x0$1._1();
                    level = (Short)x0$1._2();
                    if (name != null && level != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short(level)));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        features.put((Object)"metadata.version", (Object)BoxesRunTime.boxToShort((short)image.features().metadataVersion().featureLevel()));
        return new FinalizedFeaturesAndEpoch((scala.collection.immutable.Map<String, Object>)features.toMap(Predef$.MODULE$.$conforms()), image.highestOffsetAndEpoch().offset());
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Boolean bl;
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            bl = BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            bl = broker.fenced() || !broker.listeners().containsKey(listenerName$3.value()) ? BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId))) : BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int replicaId) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)replicaId);
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(replicaId));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
        } else {
            throw new MatchError((Object)option);
        }
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        topic.partitions().values().forEach(partition -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).map((Function1 & Serializable & scala.Serializable)replicaId -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)replicaId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

