/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001C\u0005\u0001!!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b\t\u0003A\u0011A\"\t\u000b)\u0003A\u0011A&\t\u000bq\u0003A\u0011A/\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJT!AC\u0006\u0002\u00115,G/\u00193bi\u0006T!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001b\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005}\u0001S\"A\u0006\n\u0005\u0005Z!aC&bM.\f7i\u001c8gS\u001e\fABZ1vYRD\u0015M\u001c3mKJ\u0004\"\u0001J\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000b\u0019\fW\u000f\u001c;\u000b\u00051A#B\u0001\b*\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\n\u00059*#\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014\u0018!\u00063z]\u0006l\u0017nY\"p]\u001aLw\rS1oI2,'o\u001d\t\u0005caZdH\u0004\u00023mA\u00111gE\u0007\u0002i)\u0011QgD\u0001\u0007yI|w\u000e\u001e \n\u0005]\u001a\u0012A\u0002)sK\u0012,g-\u0003\u0002:u\t\u0019Q*\u00199\u000b\u0005]\u001a\u0002CA\u0019=\u0013\ti$H\u0001\u0004TiJLgn\u001a\t\u0003?}J!\u0001Q\u0006\u0003\u001b\r{gNZ5h\u0011\u0006tG\r\\3s\u0003!qw\u000eZ3UsB,\u0017A\u0002\u001fj]&$h\bF\u0003E\r\u001eC\u0015\n\u0005\u0002F\u00015\t\u0011\u0002C\u0003\u001e\u000b\u0001\u0007a\u0004C\u0003#\u000b\u0001\u00071\u0005C\u00030\u000b\u0001\u0007\u0001\u0007C\u0003B\u000b\u0001\u00071(A\u0004qk\nd\u0017n\u001d5\u0015\u00071{u\u000b\u0005\u0002\u0013\u001b&\u0011aj\u0005\u0002\u0005+:LG\u000fC\u0003Q\r\u0001\u0007\u0011+A\u0003eK2$\u0018\r\u0005\u0002S+6\t1K\u0003\u0002UQ\u0005)\u0011.\\1hK&\u0011ak\u0015\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\t\u000ba3\u0001\u0019A-\u0002\u00119,w/S7bO\u0016\u0004\"A\u0015.\n\u0005m\u001b&!D'fi\u0006$\u0017\r^1J[\u0006<W-A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u0011AJ\u0018\u0005\u0006?\u001e\u0001\r\u0001Y\u0001\u0006aJ|\u0007o\u001d\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005)\u0001&o\u001c9feRLWm\u001d")
public class DynamicConfigPublisher
implements Logging {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void publish(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = new StringBuilder(20).append("MetadataDelta up to ").append(newImage.highestOffsetAndEpoch().offset()).toString();
        try {
            Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable & scala.Serializable)configsDelta -> {
                DynamicConfigPublisher.$anonfun$publish$1(this, newImage, deltaName, configsDelta);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.faultHandler.handleFault(new StringBuilder(71).append("Uncaught exception while ").append("publishing dynamic configuration changes from ").append(deltaName).toString(), t);
            return;
        }
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public static final /* synthetic */ void $anonfun$publish$1(DynamicConfigPublisher $this, MetadataImage newImage$1, String deltaName$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            Properties props = newImage$1.configs().configProperties(resource);
            ConfigResource.Type type = resource.type();
            if (ConfigResource.Type.TOPIC.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType$.MODULE$.Topic()).foreach((Function1 & Serializable & scala.Serializable)topicConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        topicConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault(new StringBuilder(50).append("Error updating topic ").append(resource.name()).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                    }
                });
                return;
            }
            if (ConfigResource.Type.BROKER.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)nodeConfigHandler -> {
                    if (resource.name().isEmpty()) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            nodeConfigHandler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault(new StringBuilder(51).append("Error updating ").append("cluster with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        }
                    }
                    String string = resource.name();
                    String string2 = Integer.toString($this.conf.nodeId());
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating node ").append($this.conf.nodeId()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            nodeConfigHandler.processConfigChanges(resource.name(), props);
                            $this.reloadUpdatedFilesWithoutConfigChange(props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault(new StringBuilder(48).append("Error updating ").append("node with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        }
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public DynamicConfigPublisher(KafkaConfig conf, FaultHandler faultHandler, Map<String, ConfigHandler> dynamicConfigHandlers, String nodeType) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(39).append("[DynamicConfigPublisher nodeType=").append(nodeType).append(" id=").append(conf.nodeId()).append("] ").toString());
    }
}

