/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KafkaMetadataLog$
implements Logging {
    public static KafkaMetadataLog$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new KafkaMetadataLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(config.maxBatchSizeInBytes()));
        props.setProperty(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(config.logSegmentBytes()));
        props.setProperty(LogConfig$.MODULE$.SegmentMsProp(), Long.toString(config.logSegmentMillis()));
        props.setProperty(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Integer.toString(Defaults$.MODULE$.FileDeleteDelayMs()));
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "-1");
        props.setProperty(LogConfig$.MODULE$.RetentionBytesProp(), "-1");
        LogConfig$.MODULE$.validateValues(props);
        LogConfig defaultLogConfig = new LogConfig(props, LogConfig$.MODULE$.apply$default$2());
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException(new StringBuilder(20).append("Cannot set ").append(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp()).append(" below ").append(config.logSegmentMinBytes()).append(": ").append(config.logSegmentBytes()).toString());
        }
        if (Predef$.MODULE$.Long2long(defaultLogConfig.retentionMs()) >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(23).append("Cannot set ").append(LogConfig$.MODULE$.RetentionMsProp()).append(" above -1: ").append(defaultLogConfig.retentionMs()).append(".").toString());
        }
        if (Predef$.MODULE$.Long2long(defaultLogConfig.retentionSize()) >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(23).append("Cannot set ").append(LogConfig$.MODULE$.RetentionBytesProp()).append(" above -1: ").append(defaultLogConfig.retentionSize()).append(".").toString());
        }
        UnifiedLog log = UnifiedLog$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, new BrokerTopicStats(), time, Integer.MAX_VALUE, new ProducerStateManagerConfig(Integer.MAX_VALUE), Integer.MAX_VALUE, new LogDirFailureChannel(5), false, (Option<Uuid>)new Some((Object)topicId), true, UnifiedLog$.MODULE$.apply$default$15());
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log), topicPartition, config);
        if (config.logSegmentMinBytes() != 0x800000 && metadataLog.logger().underlying().isErrorEnabled()) {
            metadataLog.logger().underlying().error(metadataLog.msgWithLogIdent(KafkaMetadataLog$.$anonfun$apply$1()));
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(UnifiedLog log) {
        void var2_2;
        TreeMap snapshotsToRetain = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        Buffer snapshotsToDelete = (Buffer)Buffer$.MODULE$.empty();
        try (DirectoryStream<Path> filesInDir = Files.newDirectoryStream(log.dir().toPath());){
            Option latestSnapshotId;
            filesInDir.forEach(path -> Snapshots.parse((Path)path).ifPresent(snapshotPath -> {
                if (snapshotPath.partial || snapshotPath.deleted || snapshotPath.snapshotId.offset() < log.logStartOffset()) {
                    snapshotsToDelete.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SnapshotPath[]{snapshotPath}));
                    return;
                }
                snapshotsToRetain.put((Object)snapshotPath.snapshotId, (Object)None$.MODULE$);
            }));
            if (log.logStartOffset() > 0L && !(latestSnapshotId = snapshotsToRetain.lastOption().map((Function1 & Serializable & scala.Serializable)x$4 -> (OffsetAndEpoch)x$4._1())).exists((Function1 & Serializable & scala.Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$recoverSnapshots$4(log, snapshotId)))) {
                throw new IllegalStateException(new StringBuilder(137).append("Inconsistent snapshot state: there must be a snapshot ").append("at an offset larger then the current log start offset ").append(log.logStartOffset()).append(", but the ").append("latest snapshot is ").append(latestSnapshotId).toString());
            }
            snapshotsToDelete.foreach((Function1 & Serializable & scala.Serializable)snapshotPath -> {
                KafkaMetadataLog$.$anonfun$recoverSnapshots$5(snapshotPath);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(KafkaMetadataLog$.$anonfun$recoverSnapshots$7(snapshotsToRetain, log)));
        }
        return var2_2;
    }

    public Function0<BoxedUnit> kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, Logging logging) {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> expiredSnapshots.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$2(logging, logDir, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$apply$1() {
        return new StringBuilder(132).append("Overriding ").append(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()).append(" is only supported for testing. Setting ").append("this value too low may lead to an inability to write batches of metadata records.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverSnapshots$4(UnifiedLog log$1, OffsetAndEpoch snapshotId) {
        return snapshotId.offset() >= log$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$6(SnapshotPath snapshotPath$1) {
        return new StringBuilder(41).append("Deleted unneeded snapshot file with path ").append(snapshotPath$1).toString();
    }

    public static final /* synthetic */ void $anonfun$recoverSnapshots$5(SnapshotPath snapshotPath) {
        Files.deleteIfExists(snapshotPath.path);
        KafkaMetadataLog$ kafkaMetadataLog$ = MODULE$;
        if (kafkaMetadataLog$ == null) {
            throw null;
        }
        KafkaMetadataLog$ info_this = kafkaMetadataLog$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent(KafkaMetadataLog$.$anonfun$recoverSnapshots$6(snapshotPath)));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$7(TreeMap snapshotsToRetain$1, UnifiedLog log$1) {
        return new StringBuilder(37).append("Initialized snapshots with IDs ").append(snapshotsToRetain$1.keys()).append(" from ").append(log$1.dir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(Logging logging$1, Path logDir$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
        ((Option)x0$1._2()).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close(), logging$1, CoreUtils$.MODULE$.swallow$default$3());
            return BoxedUnit.UNIT;
        });
        boolean bl = Snapshots.deleteIfExists((Path)logDir$1, (OffsetAndEpoch)snapshotId);
        return bl;
    }

    private KafkaMetadataLog$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

