/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.ControlPlaneAcceptor;
import kafka.network.ControlPlaneAcceptor$;
import kafka.network.DataPlaneAcceptor;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r}b\u0001B$I\u00015C\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Q\"AQ\f\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003n\u0011!Q\bA!b\u0001\n\u0003Y\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003}\u0011)\t)\u0001\u0001BC\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\f\u0001\t\u0015\r\u0011\"\u0001\u0002\u001a!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\u0007\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002:!I\u00111\n\u0001C\u0002\u0013E\u0011Q\n\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002P!I\u0011q\u000b\u0001C\u0002\u0013%\u0011\u0011\f\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002\\!I\u00111\r\u0001C\u0002\u0013%\u0011Q\r\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002h!I\u0011q\u000e\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002t!I\u0011Q\u0010\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002t!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\u0006\"Q\u00111\u0013\u0001C\u0002\u0013\u0005\u0001*!&\t\u0011\u0005e\u0006\u0001)A\u0005\u0003/C\u0011\"a/\u0001\u0005\u0004%\t!!0\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003\u007fC!\"a2\u0001\u0001\u0004%\t\u0001SAe\u0011)\t9\u000e\u0001a\u0001\n\u0003A\u0015\u0011\u001c\u0005\t\u0003K\u0004\u0001\u0015)\u0003\u0002L\"I\u0011q\u001d\u0001C\u0002\u0013\u0005\u0011\u0011\u001e\u0005\t\u0003[\u0004\u0001\u0015!\u0003\u0002l\"A\u0011q\u001e\u0001!\u0002\u0013\t\t\u0010C\u0005\u0002~\u0002\u0011\r\u0011\"\u0001\u0002\u0000\"A!q\u0001\u0001!\u0002\u0013\u0011\t\u0001C\u0005\u0003\n\u0001\u0011\r\u0011\"\u0003\u0003\f!A!\u0011\u0004\u0001!\u0002\u0013\u0011i\u0001C\u0005\u0003\u001c\u0001\u0001\r\u0011\"\u0003\u0003\u001e!I!Q\u0005\u0001A\u0002\u0013%!q\u0005\u0005\t\u0005W\u0001\u0001\u0015)\u0003\u0003 !9\u0011q\u001e\u0001\u0005\u0002\t5\u0002b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'BqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003p\u0001!\tB!\u001d\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!q\u0011\u0001\u0005\u0002\t%\u0005b\u0002BF\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011\u001d\u0011)\n\u0001C\u0001\u0005/CqAa)\u0001\t\u0003\u0011)\u000bC\u0004\u0003,\u0002!\tE!,\t\u000f\t-\u0007\u0001\"\u0011\u0003N\"9!1\u001b\u0001\u0005B\tU\u0007\u0002\u0003Bo\u0001\u0011\u0005\u0001Ja8\t\u000f\tE\b\u0001\"\u0001\u0003t\u001e9!\u0011 %\t\u0002\tmhAB$I\u0011\u0003\u0011i\u0010C\u0004\u0002$u\"\tAa@\t\u0013\r\u0005QH1A\u0005\u0002\r\r\u0001\u0002CB\u0005{\u0001\u0006Ia!\u0002\t\u0013\r-QH1A\u0005\u0002\r5\u0001\u0002CB\t{\u0001\u0006Iaa\u0004\t\u0013\rMQH1A\u0005\u0002\r5\u0001\u0002CB\u000b{\u0001\u0006Iaa\u0004\t\u000f\r]Q\b\"\u0001\u0004\u001a!911G\u001f\u0005\u0002\rU\"\u0001D*pG.,GoU3sm\u0016\u0014(BA%K\u0003\u001dqW\r^<pe.T\u0011aS\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001a\n\u0016.a!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fMB\u0011Q\u000bW\u0007\u0002-*\u0011qKS\u0001\u0006kRLGn]\u0005\u00033Z\u0013q\u0001T8hO&tw\r\u0005\u0002\\=6\tAL\u0003\u0002^\u0015\u00069Q.\u001a;sS\u000e\u001c\u0018BA0]\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G*\u000baa]3sm\u0016\u0014\u0018BA3c\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u000611m\u001c8gS\u001e,\u0012\u0001\u001b\t\u0003C&L!A\u001b2\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!+\u0005i\u0007C\u00018x\u001b\u0005y'BA/q\u0015\t\t(/\u0001\u0004d_6lwN\u001c\u0006\u0003\u0017NT!\u0001^;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0018aA8sO&\u0011\u0001p\u001c\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003/BL1!!\u0001\u007f\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002%\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fQ\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005M\u0011Q\u0002\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/A\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b%A\tba&4VM]:j_:l\u0015M\\1hKJ,\"!a\u0007\u0011\u0007\u0005\fi\"C\u0002\u0002 \t\u0014\u0011#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s\u0003I\t\u0007/\u001b,feNLwN\\'b]\u0006<WM\u001d\u0011\u0002\rqJg.\u001b;?)1\t9#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a!\r\tI\u0003A\u0007\u0002\u0011\")am\u0003a\u0001Q\")Ql\u0003a\u0001[\")!p\u0003a\u0001y\"9\u0011QA\u0006A\u0002\u0005%\u0001bBA\f\u0017\u0001\u0007\u00111D\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cXCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA\u0001\\1oO*\u0011\u00111I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005u\"aB%oi\u0016<WM]\u0001\u0013[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001c\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0003\u0003\u001f\u00022aTA)\u0013\r\t\u0019\u0006\u0015\u0002\u0004\u0013:$\u0018a\u00028pI\u0016LE\rI\u0001\u000bY><7i\u001c8uKb$XCAA.!\ri\u0018QL\u0005\u0004\u0003?r(A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003AiW-\\8ssB{w\u000e\\*f]N|'/\u0006\u0002\u0002hA\u0019a.!\u001b\n\u0007\u0005-tN\u0001\u0004TK:\u001cxN]\u0001\u0012[\u0016lwN]=Q_>d7+\u001a8t_J\u0004\u0013aI7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003g\u0002B!!\u001e\u0002x5\t\u0001/C\u0002\u0002zA\u0014!\"T3ue&\u001cg*Y7f\u0003\u0011jW-\\8ssB{w\u000e\u001c#fa2,G/\u001a3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001I7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f\u0011%\\3n_JL\bk\\8m\t\u0016\u0004H.\u001a;fIRKW.Z'fiJL7MT1nK\u0002\n!\"\\3n_JL\bk\\8m+\t\t)\t\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tY\t]\u0001\u0007[\u0016lwN]=\n\t\u0005=\u0015\u0011\u0012\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017aC7f[>\u0014\u0018\u0010U8pY\u0002\n!\u0003Z1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8sgV\u0011\u0011q\u0013\t\t\u00033\u000b\u0019+a*\u000246\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0006d_:\u001cWO\u001d:f]RTA!!)\u0002B\u0005!Q\u000f^5m\u0013\u0011\t)+a'\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\tiKS\u0001\bG2,8\u000f^3s\u0013\u0011\t\t,a+\u0003\u0011\u0015sG\rU8j]R\u0004B!!\u000b\u00026&\u0019\u0011q\u0017%\u0003#\u0011\u000bG/\u0019)mC:,\u0017iY2faR|'/A\neCR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\u001c\b%A\feCR\f\u0007\u000b\\1oKJ+\u0017/^3ti\u000eC\u0017M\u001c8fYV\u0011\u0011q\u0018\t\u0005\u0003S\t\t-C\u0002\u0002D\"\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\reCR\f\u0007\u000b\\1oKJ+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nqcY8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014x\n\u001d;\u0016\u0005\u0005-\u0007#B(\u0002N\u0006E\u0017bAAh!\n1q\n\u001d;j_:\u0004B!!\u000b\u0002T&\u0019\u0011Q\u001b%\u0003)\r{g\u000e\u001e:pYBc\u0017M\\3BG\u000e,\u0007\u000f^8s\u0003m\u0019wN\u001c;s_2\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;pe>\u0003Ho\u0018\u0013fcR!\u00111\\Aq!\ry\u0015Q\\\u0005\u0004\u0003?\u0004&\u0001B+oSRD\u0011\"a9 \u0003\u0003\u0005\r!a3\u0002\u0007a$\u0013'\u0001\rd_:$(o\u001c7QY\u0006tW-Q2dKB$xN](qi\u0002\nQdY8oiJ|G\u000e\u00157b]\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2|\u0005\u000f^\u000b\u0003\u0003W\u0004RaTAg\u0003\u007f\u000badY8oiJ|G\u000e\u00157b]\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2|\u0005\u000f\u001e\u0011\u0002\u001f9,\u0007\u0010\u001e)s_\u000e,7o]8s\u0013\u0012\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0005\u0003o\fY*\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003w\f)PA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN,\"A!\u0001\u0011\t\u0005%\"1A\u0005\u0004\u0005\u000bA%\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001dC2d\u0017)\u001e;i_JL'0\u001a:GkR,(/Z:D_6\u0004H.\u001a;f+\t\u0011i\u0001\u0005\u0004\u0002\u001a\n=!1C\u0005\u0005\u0005#\tYJA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!a\u000f\u0003\u0016%!!qCA\u001f\u0005\u00111v.\u001b3\u0002;\u0005dG.Q;uQ>\u0014\u0018N_3s\rV$XO]3t\u0007>l\u0007\u000f\\3uK\u0002\nqa\u001d;paB,G-\u0006\u0002\u0003 A\u0019qJ!\t\n\u0007\t\r\u0002KA\u0004C_>dW-\u00198\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0005\u00037\u0014I\u0003C\u0005\u0002d&\n\t\u00111\u0001\u0003 \u0005A1\u000f^8qa\u0016$\u0007\u0005\u0006\u0002\u0002P\u00059RM\\1cY\u0016\u0014V-];fgR\u0004&o\\2fgNLgn\u001a\u000b\u0005\u00037\u0014\u0019\u0004C\u0004\u000361\u0002\rAa\u000e\u0002#\u0005,H\u000f[8sSj,'OR;ukJ,7\u000f\u0005\u0005\u0003:\t}\"1\tB\u0007\u001b\t\u0011YDC\u0002\u0003>A\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tEa\u000f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002v\t\u0015\u0013b\u0001B$a\nAQI\u001c3q_&tG/\u0001\u0013de\u0016\fG/\u001a#bi\u0006\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;pe\u0006sG\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\tYN!\u0014\t\u000f\t=S\u00061\u0001\u0002(\u0006AQM\u001c3q_&tG/\u0001\u0014de\u0016\fG/Z\"p]R\u0014x\u000e\u001c)mC:,\u0017iY2faR|'/\u00118e!J|7-Z:t_J$B!a7\u0003V!9!q\n\u0018A\u0002\u0005\u001d\u0016!C3oIB|\u0017N\u001c;t+\t\u0011Y\u0006\u0005\u0005\u0003^\t\r$QMAT\u001b\t\u0011yF\u0003\u0003\u0003b\tm\u0012!C5n[V$\u0018M\u00197f\u0013\u0011\u0011\tEa\u0018\u0011\t\t\u001d$1N\u0007\u0003\u0005SR!!\u00139\n\t\t5$\u0011\u000e\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0018GJ,\u0017\r^3ECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J$\u0002\"a-\u0003t\t]$1\u0010\u0005\b\u0005k\u0002\u0004\u0019AAT\u0003!)g\u000e\u001a)pS:$\bb\u0002B=a\u0001\u0007!qD\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\t\u000f\tu\u0004\u00071\u0001\u0002@\u0006q!/Z9vKN$8\t[1o]\u0016d\u0017AG2sK\u0006$XmQ8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014HCBAi\u0005\u0007\u0013)\tC\u0004\u0003vE\u0002\r!a*\t\u000f\tu\u0014\u00071\u0001\u0002@\u000612\u000f^8q!J|7-Z:tS:<'+Z9vKN$8\u000f\u0006\u0002\u0002\\\u0006A1\u000f[;uI><h.A\u0005c_VtG\rU8siR!\u0011q\nBI\u0011\u001d\u0011\u0019\n\u000ea\u0001\u0005K\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\fA\"\u00193e\u0019&\u001cH/\u001a8feN$B!a7\u0003\u001a\"9!1T\u001bA\u0002\tu\u0015A\u00047jgR,g.\u001a:t\u0003\u0012$W\r\u001a\t\u0007\u0005s\u0011y*a*\n\t\t\u0005&1\b\u0002\u0004'\u0016\f\u0018a\u0004:f[>4X\rT5ti\u0016tWM]:\u0015\t\u0005m'q\u0015\u0005\b\u0005S3\u0004\u0019\u0001BO\u0003Aa\u0017n\u001d;f]\u0016\u00148OU3n_Z,G-A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\t=\u0006C\u0002B\u001d\u0005c\u0013),\u0003\u0003\u00034\nm\"aA*fiB!!q\u0017Bc\u001d\u0011\u0011IL!1\u0011\u0007\tm\u0006+\u0004\u0002\u0003>*\u0019!q\u0018'\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019\rU\u0001\u0007!J,G-\u001a4\n\t\t\u001d'\u0011\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\r\u0007+A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u00111\u001cBh\u0011\u0019\u0011\t\u000e\u000fa\u0001Q\u0006Ia.Z<D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\\\n]'1\u001c\u0005\u0007\u00053L\u0004\u0019\u00015\u0002\u0013=dGmQ8oM&<\u0007B\u0002Bis\u0001\u0007\u0001.A\bd_:tWm\u0019;j_:\u001cu.\u001e8u)\u0011\tyE!9\t\u000f\t\r(\b1\u0001\u0003f\u00069\u0011\r\u001a3sKN\u001c\b\u0003\u0002Bt\u0005[l!A!;\u000b\t\t-\u0018\u0011I\u0001\u0004]\u0016$\u0018\u0002\u0002Bx\u0005S\u00141\"\u00138fi\u0006#GM]3tg\u0006\tB-\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:\u0015\t\tU(q\u001f\t\u0006\u001f\u00065\u00171\u0017\u0005\b\u0005'[\u0004\u0019\u0001B[\u00031\u0019vnY6fiN+'O^3s!\r\tI#P\n\u0003{9#\"Aa?\u0002\u00195+GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\r\u0015\u0001\u0003BA\u001e\u0007\u000fIAAa2\u0002>\u0005iQ*\u001a;sS\u000e\u001cxI]8va\u0002\nQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0004\u0010A1!\u0011\bBY\u0007\u000b\taCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u001e\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0006qB*[:uK:,'OU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\fG2|7/Z*pG.,G\u000f\u0006\u0004\u0002\\\u000em1q\u0006\u0005\b\u0007;)\u0005\u0019AB\u0010\u0003\u001d\u0019\u0007.\u00198oK2\u0004Ba!\t\u0004,5\u001111\u0005\u0006\u0005\u0007K\u00199#\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\u0019I#!\u0011\u0002\u00079Lw.\u0003\u0003\u0004.\r\r\"!D*pG.,Go\u00115b]:,G\u000e\u0003\u0004\u00042\u0015\u0003\r\u0001V\u0001\bY><w-\u001b8h\u0003-\u0019\u0007.Y5o\rV$XO]3\u0015\r\u0005m7qGB\u001e\u0011\u001d\u0019ID\u0012a\u0001\u0005\u001b\tAb]8ve\u000e,g)\u001e;ve\u0016Dqa!\u0010G\u0001\u0004\u0011i!A\teKN$\u0018N\\1uS>tg)\u001e;ve\u0016\u0004")
public class SocketServer
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt;
    private final Option<RequestChannel> controlPlaneRequestChannelOpt;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private final CompletableFuture<Void> allAuthorizerFuturesComplete;
    private boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void chainFuture(CompletableFuture<Void> completableFuture, CompletableFuture<Void> completableFuture2) {
        SocketServer$.MODULE$.chainFuture(completableFuture, completableFuture2);
    }

    public static void closeSocket(SocketChannel socketChannel, Logging logging) {
        SocketServer$.MODULE$.closeSocket(socketChannel, logging);
    }

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(com.yammer.metrics.core.MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt() {
        return this.controlPlaneAcceptorOpt;
    }

    public void controlPlaneAcceptorOpt_$eq(Option<ControlPlaneAcceptor> x$1) {
        this.controlPlaneAcceptorOpt = x$1;
    }

    public Option<RequestChannel> controlPlaneRequestChannelOpt() {
        return this.controlPlaneRequestChannelOpt;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private CompletableFuture<Void> allAuthorizerFuturesComplete() {
        return this.allAuthorizerFuturesComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public synchronized void enableRequestProcessing(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        if (this.stopped()) {
            throw new RuntimeException("Can't enable request processing: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Enabling request processing.");
        this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)acceptor -> {
            this.chainAcceptorFuture$1(acceptor, authorizerFutures);
            return BoxedUnit.UNIT;
        });
        this.dataPlaneAcceptors().values().forEach(acceptor -> this.chainAcceptorFuture$1((Acceptor)acceptor, (Map)authorizerFutures));
        SocketServer$.MODULE$.chainFuture(CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), this.allAuthorizerFuturesComplete());
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void createDataPlaneAcceptorAndProcessors(EndPoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new data plane acceptor and processors: SocketServer is stopped.");
        }
        parsedConfigs = this.config().valuesFromThisConfigWithPrefixOverride(endpoint.listenerName().configPrefix());
        this.connectionQuotas().addListener(this.config(), endpoint.listenerName());
        if (!this.controlPlaneRequestChannelOpt().isEmpty()) ** GOTO lbl-1000
        v0 = this.config().interBrokerListenerName();
        var4_3 = endpoint.listenerName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isPrivilegedListener = v1;
        dataPlaneAcceptor = this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, this.dataPlaneRequestChannel());
        this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createDataPlaneAcceptorAndProcessors$1(kafka.cluster.EndPoint ), ()Ljava/lang/String;)((EndPoint)endpoint));
    }

    private synchronized void createControlPlaneAcceptorAndProcessor(EndPoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new control plane acceptor and processor: SocketServer is stopped.");
        }
        this.connectionQuotas().addListener(this.config(), endpoint.listenerName());
        ControlPlaneAcceptor controlPlaneAcceptor = this.createControlPlaneAcceptor(endpoint, (RequestChannel)this.controlPlaneRequestChannelOpt().get());
        controlPlaneAcceptor.addProcessors(1);
        this.controlPlaneAcceptorOpt_$eq((Option<ControlPlaneAcceptor>)new Some((Object)controlPlaneAcceptor));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Created control-plane acceptor and processor for endpoint : ").append(endpoint.listenerName()).toString());
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((TraversableOnce)this.config().listeners().map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(EndPoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    private ControlPlaneAcceptor createControlPlaneAcceptor(EndPoint endPoint, RequestChannel requestChannel) {
        return new ControlPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public synchronized void stopProcessingRequests() {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping socket server request processors");
            ((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.beginShutdown();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.beginShutdown();
                return BoxedUnit.UNIT;
            });
            ((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.close();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.clear();
                return BoxedUnit.UNIT;
            });
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped socket server request processors");
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down socket server");
        this.allAuthorizerFuturesComplete().completeExceptionally(new TimeoutException("The socket server was shut down before the Authorizer could be completely initialized."));
        synchronized (this) {
            this.stopProcessingRequests();
            this.dataPlaneRequestChannel().shutdown();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.shutdown();
                return BoxedUnit.UNIT;
            });
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                return BoxesRunTime.unboxToInt((Object)this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)SocketServer.$anonfun$boundPort$1(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new KafkaException(new StringBuilder(61).append("Could not find listenerName : ").append(listenerName).append(" in data-plane or control-plane").toString());
                }));
            }
            n = acceptor.serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        if (this.stopped()) {
            throw new RuntimeException("can't add new listeners: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Adding data-plane listeners for endpoints ").append(listenersAdded).toString());
        listenersAdded.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$addListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Removing data-plane listeners for endpoints ").append(listenersRemoved).toString());
        listenersRemoved.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Updating maxConnectionsPerIp: ").append(maxConnectionsPerIp).toString());
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating maxConnectionsPerIpOverrides: ").append(((TraversableOnce)maxConnectionsPerIpOverrides.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String k = (String)x0$1._1();
                int v = x0$1._2$mcI$sp();
                String string = new StringBuilder(1).append(k).append("=").append(v).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).toString());
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating broker-wide maxConnections: ").append(maxConnections).toString());
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Updating broker-wide maxConnectionCreationRate: ").append(maxConnectionRate).toString());
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
        }
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$new$6(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$4(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$6(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$new$1() {
        Iterable dataPlaneProcessors = (Iterable)((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)a -> a.processors(), Iterable$.MODULE$.canBuildFrom());
        Iterable ioWaitRatioMetricNames = (Iterable)dataPlaneProcessors.map((Function1 & Serializable & scala.Serializable)p -> this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()), Iterable$.MODULE$.canBuildFrom());
        if (dataPlaneProcessors.isEmpty()) {
            return 1.0;
        }
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ioWaitRatioMetricNames.map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$4(this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors.size();
    }

    public static final /* synthetic */ double $anonfun$new$12(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$10(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$12(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$new$7() {
        return BoxesRunTime.unboxToDouble((Object)this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)a -> (Processor)a.processors().apply(0)).map((Function1 & Serializable & scala.Serializable)p -> this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$10(this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN));
    }

    public final /* synthetic */ long kafka$network$SocketServer$$$anonfun$new$14() {
        return this.memoryPool().availableMemory();
    }

    public final /* synthetic */ long kafka$network$SocketServer$$$anonfun$new$15() {
        return this.memoryPool().size() - this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$new$21(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$19(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$21(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$new$16() {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((Iterable)((Iterable)((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)a -> a.processors(), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$19(this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$new$27(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$25(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$27(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$new$22() {
        return BoxesRunTime.unboxToDouble((Object)this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)a -> (Processor)a.processors().apply(0)).map((Function1 & Serializable & scala.Serializable)p -> this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$25(this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
    }

    public static final /* synthetic */ boolean $anonfun$enableRequestProcessing$1(Acceptor acceptor$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Endpoint endpoint = (Endpoint)x0$1._1();
        boolean bl = acceptor$1.endPoint().listenerName().value().equals(endpoint.listenerName().get());
        return bl;
    }

    private final void chainAcceptorFuture$1(Acceptor acceptor, Map authorizerFutures$1) {
        Tuple2 tuple2;
        Option option = authorizerFutures$1.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$enableRequestProcessing$1(acceptor, x0$1)));
        if (None$.MODULE$.equals(option)) {
            SocketServer$.MODULE$.chainFuture(this.allAuthorizerFuturesComplete(), acceptor.startFuture());
            return;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            CompletableFuture future = (CompletableFuture)tuple2._2();
            SocketServer$.MODULE$.chainFuture(future, acceptor.startFuture());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$createDataPlaneAcceptorAndProcessors$1(EndPoint endpoint$1) {
        return new StringBuilder(58).append("Created data-plane acceptor and processors for endpoint : ").append(endpoint$1.listenerName()).toString();
    }

    public static final /* synthetic */ int $anonfun$boundPort$1(ControlPlaneAcceptor x$8) {
        return x$8.serverChannel().socket().getLocalPort();
    }

    public static final /* synthetic */ void $anonfun$addListeners$2(SocketServer $this, EndPoint endpoint) {
        $this.createDataPlaneAcceptorAndProcessors(endpoint);
        DataPlaneAcceptor acceptor = $this.dataPlaneAcceptors().get(endpoint);
        SocketServer$.MODULE$.chainFuture($this.allAuthorizerFuturesComplete(), acceptor.startFuture());
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(DataPlaneAcceptor acceptor) {
        acceptor.beginShutdown();
        acceptor.close();
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), endpoint.listenerName());
        ((scala.collection.mutable.MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.dataPlaneAcceptors()).asScala()).remove((Object)endpoint).foreach((Function1 & Serializable & scala.Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3(acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$2, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block7: {
            block4: {
                DataPlaneAcceptor acceptor;
                block6: {
                    String string;
                    block5: {
                        if (x0$1 == null) break block4;
                        EndPoint endPoint = (EndPoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listenerName().value();
                        if (string != null) break block5;
                        if (listenerName$2 != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!string.equals(listenerName$2)) break block7;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            throw new MatchError(null);
        }
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext(new StringBuilder(38).append("[SocketServer listenerType=").append(apiVersionManager.listenerType()).append(", nodeId=").append(this.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolSensor().add((CompoundStat)new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), DataPlaneAcceptor$.MODULE$.MetricPrefix(), time, apiVersionManager.newRequestMetrics());
        this.controlPlaneAcceptorOpt = None$.MODULE$;
        this.controlPlaneRequestChannelOpt = config.controlPlaneListenerName().map((Function1 & Serializable & scala.Serializable)x$1 -> new RequestChannel(20, ControlPlaneAcceptor$.MODULE$.MetricPrefix(), this.time(), this.apiVersionManager().newRequestMetrics()));
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.allAuthorizerFuturesComplete = new CompletableFuture();
        this.stopped = false;
        this.newGauge(new StringBuilder(30).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        if (config.requiresZookeeper()) {
            this.newGauge(new StringBuilder(30).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), new Gauge<Object>(this){
                private final /* synthetic */ SocketServer $outer;

                public final double value() {
                    return this.$outer.kafka$network$SocketServer$$$anonfun$new$7();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
        }
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final long value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$new$14();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final long value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$new$15();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(new StringBuilder(29).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$new$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        if (config.requiresZookeeper()) {
            this.newGauge(new StringBuilder(29).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), new Gauge<Object>(this){
                private final /* synthetic */ SocketServer $outer;

                public final double value() {
                    return this.$outer.kafka$network$SocketServer$$$anonfun$new$22();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
        }
        if (apiVersionManager.listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER)) {
            config.controllerListeners().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
                this.createDataPlaneAcceptorAndProcessors(endpoint);
                return BoxedUnit.UNIT;
            });
            return;
        }
        config.controlPlaneListener().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            this.createControlPlaneAcceptorAndProcessor(endpoint);
            return BoxedUnit.UNIT;
        });
        config.dataPlaneListeners().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors(endpoint);
            return BoxedUnit.UNIT;
        });
    }
}

