/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rmw!\u00027n\u0011\u0003\u0011h!\u0002;n\u0011\u0003)\b\"\u0002?\u0002\t\u0003i\bb\u0002@\u0002\u0005\u0004%\ta \u0005\t\u0003\u000f\t\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011B\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003'\t\u0001\u0015!\u0003\u0002\u000e!I\u0011QC\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003S\t\u0001\u0015!\u0003\u0002\u001a!I\u00111F\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003[\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qF\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003c\t\u0001\u0015!\u0003\u0002\u001a!I\u00111G\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003k\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qG\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003s\t\u0001\u0015!\u0003\u0002\u001a!I\u00111H\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003{\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qH\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u0003\n\u0001\u0015!\u0003\u0002\u001a!I\u00111I\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u000b\n\u0001\u0015!\u0003\u0002\u001a!I\u0011qI\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u0013\n\u0001\u0015!\u0003\u0002\u001a!I\u00111J\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u001b\n\u0001\u0015!\u0003\u0002\u001a!I\u0011qJ\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003#\n\u0001\u0015!\u0003\u0002\u001a!A\u00111K\u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002V\u0005\u0001\u000b\u0011BA\u0001\u0011!\t9&\u0001b\u0001\n\u0013y\b\u0002CA-\u0003\u0001\u0006I!!\u0001\t\u0011\u0005m\u0013A1A\u0005\n}D\u0001\"!\u0018\u0002A\u0003%\u0011\u0011\u0001\u0005\n\u0003?\n!\u0019!C\u0001\u0003CB\u0001\"!!\u0002A\u0003%\u00111\r\u0005\n\u0003\u0007\u000b!\u0019!C\u0001\u0003CB\u0001\"!\"\u0002A\u0003%\u00111\r\u0005\b\u0003\u000f\u000bA\u0011AAE\u0011\u001d\tI,\u0001C\u0005\u0003wCq!a8\u0002\t\u0013\t\t\u000f\u0003\u0005\u0002l\u0006!\t!\\Aw\r\u0015!X\u000eAA\u0000\u0011)\u0011ia\u000bBC\u0002\u0013\u0005!q\u0002\u0005\u000b\u00053Y#\u0011!Q\u0001\n\tE\u0001B\u0003B\u000eW\t\u0005\r\u0011\"\u0001\u0003\u001e!Q!qD\u0016\u0003\u0002\u0004%\tA!\t\t\u0015\t\u001d2F!A!B\u0013\ti\u000bC\u0005\u00032-\u0012)\u0019!C\u0001\u007f\"Q!1G\u0016\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\tU2F!b\u0001\n\u0003\u00119\u0004\u0003\u0006\u0003@-\u0012\t\u0011)A\u0005\u0005sA!B!\u0011,\u0005\u000b\u0007I\u0011\u0001B\"\u0011)\u0011ye\u000bB\u0001B\u0003%!Q\t\u0005\u0007y.\"\tA!\u0015\t\u0013\t}3\u00061A\u0005\n\t\u0005\u0004\"\u0003B<W\u0001\u0007I\u0011\u0002B=\u0011!\u0011ih\u000bQ!\n\t\r\u0004\"\u0003B@W\t\u0007I\u0011\u0002BA\u0011!\u0011\u0019i\u000bQ\u0001\n\u0005%\u0007\"\u0003BCW\u0001\u0007I\u0011\u0002BD\u0011%\u0011Ii\u000ba\u0001\n\u0013\u0011Y\t\u0003\u0005\u0003\u0010.\u0002\u000b\u0015BAm\u0011%\u0011\tj\u000ba\u0001\n\u0013\u00119\tC\u0005\u0003\u0014.\u0002\r\u0011\"\u0003\u0003\u0016\"A!\u0011T\u0016!B\u0013\tI\u000eC\u0005\u0003\u001c.\u0002\r\u0011\"\u0003\u0003\b\"I!QT\u0016A\u0002\u0013%!q\u0014\u0005\t\u0005G[\u0003\u0015)\u0003\u0002Z\"I!qU\u0016C\u0002\u0013%!\u0011\u0016\u0005\t\u0005s[\u0003\u0015!\u0003\u0003,\"I!1X\u0016C\u0002\u0013%!\u0011\u0016\u0005\t\u0005{[\u0003\u0015!\u0003\u0003,\"9!qX\u0016\u0005\u0002\t\u0005\u0007b\u0002BhW\u0011%!\u0011\u001b\u0005\t\u0005'\\C\u0011A7\u0003V\"9!Q\\\u0016\u0005\u0002\t}\u0007b\u0002BzW\u0011\u0005!Q\u001f\u0005\t\u0005w\\C\u0011A7\u0003~\"91\u0011A\u0016\u0005\u0002\t\u001d\u0005bBB\u0002W\u0011\u00051Q\u0001\u0005\b\u0007#YC\u0011AB\n\u0011\u001d\u0019)b\u000bC\u0005\u0007/A\u0001b!\t,\t\u0003i71\u0005\u0005\b\u0007SYC\u0011BB\u0016\u0011\u001d\u0019\u0019d\u000bC\u0001\u0007kAqa!\u000f,\t\u0003\u0019Y\u0004C\u0004\u0004F-\"\taa\u0012\t\u000f\ru3\u0006\"\u0001\u0004`!91QM\u0016\u0005\n\r\u001d\u0004bBB5W\u0011\u000511\u000e\u0005\b\u0007cZC\u0011AB:\u0011\u001d\u0019Ih\u000bC\u0001\u0007OBqaa\u001f,\t\u0003\u0019i\bC\u0004\u0004\u0004.\"\tA!@\t\u000f\r\u00155\u0006\"\u0001\u0003~\"A1qQ\u0016\u0005\u00025\u001cI\tC\u0004\u0004\u0012.\"\taa%\t\u000f\r]5\u0006\"\u0003\u0004\u001a\"91QT\u0016\u0005\u0002\r}\u0005bBBRW\u0011\u00051Q\u0015\u0005\b\u0007c[C\u0011ABZ\u0011\u001d\u00199l\u000bC\u0001\u0007sCqaa0,\t\u0013\u0019\t\rC\u0004\u0004D.\"Ia!1\t\u000f\r\u00157\u0006\"\u0003\u0004H\"A1QZ\u0016\u0005\u00025\u001cy-\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\u0006\u0003]>\f1\u0001\\8h\u0015\u0005\u0001\u0018!B6bM.\f7\u0001\u0001\t\u0003g\u0006i\u0011!\u001c\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0014\u0005\u00051\bCA<{\u001b\u0005A(\"A=\u0002\u000bM\u001c\u0017\r\\1\n\u0005mD(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002e\u00069B*\u0019;f)J\fgn]1di&|gNQ;gM\u0016\u0014Xj]\u000b\u0003\u0003\u0003\u00012a^A\u0002\u0013\r\t)\u0001\u001f\u0002\u0004\u0013:$\u0018\u0001\u0007'bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8Ck\u001a4WM]'tA\u00059\u0002K]8ek\u000e,'o\u00158baNDw\u000e\u001e,feNLwN\\\u000b\u0003\u0003\u001b\u00012a^A\b\u0013\r\t\t\u0002\u001f\u0002\u0006'\"|'\u000f^\u0001\u0019!J|G-^2feNs\u0017\r]:i_R4VM]:j_:\u0004\u0013\u0001\u0004,feNLwN\u001c$jK2$WCAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA\u0001\\1oO*\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005u!AB*ue&tw-A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\rI\u0001\t\u0007J\u001cg)[3mI\u0006I1I]2GS\u0016dG\rI\u0001\u0010!J|G-^2fe&#g)[3mI\u0006\u0001\u0002K]8ek\u000e,'/\u00133GS\u0016dG\rI\u0001\u0012\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0017A\u0005'bgR\u001cV-];f]\u000e,g)[3mI\u0002\n!\u0003\u0015:pIV\u001cWM]#q_\u000eDg)[3mI\u0006\u0019\u0002K]8ek\u000e,'/\u00129pG\"4\u0015.\u001a7eA\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG-\u0001\tMCN$xJ\u001a4tKR4\u0015.\u001a7eA\u0005\u0001rJ\u001a4tKR$U\r\u001c;b\r&,G\u000eZ\u0001\u0012\u001f\u001a47/\u001a;EK2$\u0018MR5fY\u0012\u0004\u0013A\u0004+j[\u0016\u001cH/Y7q\r&,G\u000eZ\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA\u0005!\u0002K]8ek\u000e,'/\u00128ue&,7OR5fY\u0012\fQ\u0003\u0015:pIV\u001cWM]#oiJLWm\u001d$jK2$\u0007%A\u000bD_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u001aKW\r\u001c3\u0002-\r{wN\u001d3j]\u0006$xN]#q_\u000eDg)[3mI\u0002\n!dQ;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,GOR5fY\u0012\f1dQ;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,GOR5fY\u0012\u0004\u0013!\u0004,feNLwN\\(gMN,G/\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\u0002\u0013\r\u00138m\u00144gg\u0016$\u0018AC\"sG>3gm]3uA\u0005)\u0002K]8ek\u000e,'/\u00128ue&,7o\u00144gg\u0016$\u0018A\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:PM\u001a\u001cX\r\u001e\u0011\u00027A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$XI\u001c;ssN\u001b\u0007.Z7b+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005uTBAA4\u0015\u0011\tI'a\u001b\u0002\u000bQL\b/Z:\u000b\t\u00055\u0014qN\u0001\taJ|Go\\2pY*!\u0011\u0011OA:\u0003\u0019\u0019w.\\7p]*\u0019\u0001/!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0014aA8sO&!\u0011qPA4\u0005\u0019\u00196\r[3nC\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0013\u0001\u0006)jINs\u0017\r]:i_Rl\u0015\r]*dQ\u0016l\u0017-A\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.\u0019\u0011\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\u0005-\u0015\u0011\u0016\t\u0007\u0003\u001b\u000bi*a)\u000f\t\u0005=\u0015\u0011\u0014\b\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS9\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0018bAANq\u00069\u0001/Y2lC\u001e,\u0017\u0002BAP\u0003C\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u00037C\bcA:\u0002&&\u0019\u0011qU7\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u0003W;\u0003\u0019AAW\u0003\u00111\u0017\u000e\\3\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cSA!a-\u0002\"\u0005\u0011\u0011n\\\u0005\u0005\u0003o\u000b\tL\u0001\u0003GS2,\u0017!D<sSR,7K\\1qg\"|G\u000f\u0006\u0004\u0002>\u0006\r\u0017Q\u0019\t\u0004o\u0006}\u0016bAAaq\n!QK\\5u\u0011\u001d\tY\u000b\u000ba\u0001\u0003[Cq!a2)\u0001\u0004\tI-A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005-\u0017Q[Am\u0003Gk!!!4\u000b\t\u0005=\u0017\u0011[\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019\u000e_\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAl\u0003\u001b\u00141!T1q!\r9\u00181\\\u0005\u0004\u0003;D(\u0001\u0002'p]\u001e\fa\"[:T]\u0006\u00048\u000f[8u\r&dW\r\u0006\u0003\u0002d\u0006%\bcA<\u0002f&\u0019\u0011q\u001d=\u0003\u000f\t{w\u000e\\3b]\"9\u00111V\u0015A\u0002\u00055\u0016!\u00057jgR\u001cf.\u00199tQ>$h)\u001b7fgR!\u0011q^A~!\u0019\ti)!=\u0002v&!\u00111_AQ\u0005\r\u0019V-\u001d\t\u0004g\u0006]\u0018bAA}[\na1K\\1qg\"|GOR5mK\"9\u0011Q \u0016A\u0002\u00055\u0016a\u00013jeN!1F\u001eB\u0001!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004_\u0006)Q\u000f^5mg&!!1\u0002B\u0003\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003\u0012A!!1\u0003B\u000b\u001b\t\ty'\u0003\u0003\u0003\u0018\u0005=$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u00059q\f\\8h\t&\u0014XCAAW\u0003-yFn\\4ESJ|F%Z9\u0015\t\u0005u&1\u0005\u0005\n\u0005Ky\u0013\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003!yFn\\4ESJ\u0004\u0003f\u0001\u0019\u0003,A\u0019qO!\f\n\u0007\t=\u0002P\u0001\u0005w_2\fG/\u001b7f\u0003]i\u0017\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/\u0001\rnCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\n!\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"A!\u000f\u0011\u0007M\u0014Y$C\u0002\u0003>5\u0014!\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\f1\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"A!\u0012\u0011\t\t\u001d#1J\u0007\u0003\u0005\u0013RAAa\u0002\u0002p%!!Q\nB%\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0015\u0019\tM#Q\u000bB,\u00053\u0012YF!\u0018\u0011\u0005M\\\u0003b\u0002B\u0007o\u0001\u0007!\u0011\u0003\u0005\b\u000579\u0004\u0019AAW\u0011\u001d\u0011\td\u000ea\u0001\u0003\u0003AqA!\u000e8\u0001\u0004\u0011I\u0004C\u0004\u0003B]\u0002\rA!\u0012\u0002\u0013Mt\u0017\r]:i_R\u001cXC\u0001B2!!\u0011)Ga\u001c\u0003t\u0005UXB\u0001B4\u0015\u0011\u0011IGa\u001b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003n\u0005\u0005\u0012\u0001B;uS2LAA!\u001d\u0003h\t)2i\u001c8dkJ\u0014XM\u001c;TW&\u0004H*[:u\u001b\u0006\u0004\b\u0003BA\u000e\u0005kJA!!8\u0002\u001e\u0005i1O\\1qg\"|Go]0%KF$B!!0\u0003|!I!QE\u001d\u0002\u0002\u0003\u0007!1M\u0001\u000bg:\f\u0007o\u001d5piN\u0004\u0013!\u00039s_\u0012,8-\u001a:t+\t\tI-\u0001\u0006qe>$WoY3sg\u0002\nQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAAm\u0003Ea\u0017m\u001d;NCB|eMZ:fi~#S-\u001d\u000b\u0005\u0003{\u0013i\tC\u0005\u0003&y\n\t\u00111\u0001\u0002Z\u0006qA.Y:u\u001b\u0006\u0004xJ\u001a4tKR\u0004\u0013A\u00047bgR\u001cf.\u00199PM\u001a\u001cX\r^\u0001\u0013Y\u0006\u001cHo\u00158ba>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002>\n]\u0005\"\u0003B\u0013\u0003\u0006\u0005\t\u0019AAm\u0003=a\u0017m\u001d;T]\u0006\u0004xJ\u001a4tKR\u0004\u0013AF8mI\u0016\u001cH\u000f\u0016=o\u0019\u0006\u001cH\u000fV5nKN$\u0018-\u001c9\u00025=dG-Z:u)btG*Y:u)&lWm\u001d;b[B|F%Z9\u0015\t\u0005u&\u0011\u0015\u0005\n\u0005K!\u0015\u0011!a\u0001\u00033\fqc\u001c7eKN$H\u000b\u001f8MCN$H+[7fgR\fW\u000e\u001d\u0011)\u0007\u0015\u0013Y#A\u0006p]\u001e|\u0017N\\4Uq:\u001cXC\u0001BV!!\u0011iKa,\u0002Z\nMVB\u0001B6\u0013\u0011\u0011\tLa\u001b\u0003\u000fQ\u0013X-Z'baB\u00191O!.\n\u0007\t]VNA\u0006Uq:lU\r^1eCR\f\u0017\u0001D8oO>Lgn\u001a+y]N\u0004\u0013\u0001E;oe\u0016\u0004H.[2bi\u0016$G\u000b\u001f8t\u0003E)hN]3qY&\u001c\u0017\r^3e)bt7\u000fI\u0001\u0013Q\u0006\u001cH*\u0019;f)J\fgn]1di&|g\u000e\u0006\u0003\u0002d\n\r\u0007b\u0002Bc\u0015\u0002\u0007\u0011\u0011\\\u0001\u000eGV\u0014(/\u001a8u)&lW-T:)\u0007)\u0013I\r\u0005\u0003\u0003\u0004\t-\u0017\u0002\u0002Bg\u0005\u000b\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u00035aw.\u00193T]\u0006\u00048\u000f[8ugR\u0011!1M\u0001\u0015e\u0016lwN^3TiJ\f\u0017p\u00158baNDw\u000e^:\u0015\t\u0005u&q\u001b\u0005\b\u00053d\u0005\u0019\u0001Bn\u0003I\u0019XmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r^:\u0011\r\u00055\u0015\u0011_Am\u0003M1\u0017N]:u+:\u001cH/\u00192mK>3gm]3u+\t\u0011\t\u000fE\u0003x\u0005G\u00149/C\u0002\u0003fb\u0014aa\u00149uS>t\u0007\u0003\u0002Bu\u0005_l!Aa;\u000b\u0007\t5x.\u0001\u0004tKJ4XM]\u0005\u0005\u0005c\u0014YOA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006\fac\u001c8IS\u001eDw+\u0019;fe6\f'o[+qI\u0006$X\r\u001a\u000b\u0005\u0003{\u00139\u0010C\u0004\u0003z:\u0003\r!!7\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0003Q1\u0017N]:u+:$WmY5eK\u0012|eMZ:fiV\u0011!q \t\u0006o\n\r\u0018\u0011\\\u0001\r[\u0006\u0004XI\u001c3PM\u001a\u001cX\r^\u0001\u0010C\u000e$\u0018N^3Qe>$WoY3sgV\u00111q\u0001\t\t\u0007\u0013\u0019y!!7\u0002$6\u001111\u0002\u0006\u0005\u0007\u001b\t\t.A\u0005j[6,H/\u00192mK&!\u0011q[B\u0006\u0003\u001dI7/R7qif,\"!a9\u0002!1|\u0017\r\u001a$s_6\u001cf.\u00199tQ>$HCBA_\u00073\u0019i\u0002C\u0004\u0004\u001cM\u0003\r!!7\u0002\u001d1|wm\u0015;beR|eMZ:fi\"91qD*A\u0002\u0005e\u0017aC2veJ,g\u000e\u001e+j[\u0016\f\u0011\u0003\\8bIB\u0013x\u000eZ;dKJ,e\u000e\u001e:z)\u0011\til!\n\t\u000f\r\u001dB\u000b1\u0001\u0002$\u0006)QM\u001c;ss\u0006\t\u0012n\u001d)s_\u0012,8-\u001a:FqBL'/\u001a3\u0015\r\u0005\r8QFB\u0018\u0011\u001d\u0011)-\u0016a\u0001\u00033Dqa!\rV\u0001\u0004\t\u0019+A\u0007qe>$WoY3s'R\fG/Z\u0001\u0017e\u0016lwN^3FqBL'/\u001a3Qe>$WoY3sgR!\u0011QXB\u001c\u0011\u001d\u0011)M\u0016a\u0001\u00033\f\u0011\u0003\u001e:v]\u000e\fG/Z!oIJ+Gn\\1e)!\til!\u0010\u0004@\r\r\u0003bBB\u000e/\u0002\u0007\u0011\u0011\u001c\u0005\b\u0007\u0003:\u0006\u0019AAm\u00031awnZ#oI>3gm]3u\u0011\u001d\u0011)m\u0016a\u0001\u00033\fQ\u0002\u001d:fa\u0006\u0014X-\u00169eCR,GCBB%\u0007\u001f\u001a\u0019\u0006E\u0002t\u0007\u0017J1a!\u0014n\u0005I\u0001&o\u001c3vG\u0016\u0014\u0018\t\u001d9f]\u0012LeNZ8\t\u000f\rE\u0003\f1\u0001\u0002Z\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\rU\u0003\f1\u0001\u0004X\u00051qN]5hS:\u00042a]B-\u0013\r\u0019Y&\u001c\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001\u0007kB$\u0017\r^3\u0015\t\u0005u6\u0011\r\u0005\b\u0007GJ\u0006\u0019AB%\u0003)\t\u0007\u000f]3oI&sgm\\\u0001\u0019kB$\u0017\r^3PY\u0012,7\u000f\u001e+y]RKW.Z:uC6\u0004HCAA_\u0003I)\b\u000fZ1uK6\u000b\u0007/\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005u6Q\u000e\u0005\b\u0007_Z\u0006\u0019AAm\u0003)a\u0017m\u001d;PM\u001a\u001cX\r^\u0001\nY\u0006\u001cH/\u00128uef$Ba!\u001e\u0004xA)qOa9\u0002$\"91\u0011\u000b/A\u0002\u0005e\u0017\u0001\u0004;bW\u0016\u001cf.\u00199tQ>$\u0018aD;qI\u0006$X\rU1sK:$H)\u001b:\u0015\t\u0005u6q\u0010\u0005\b\u0007\u0003s\u0006\u0019AAW\u0003%\u0001\u0018M]3oi\u0012K'/\u0001\u000bmCR,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u0001\u0015_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\u0002+Mt\u0017\r]:i_R4\u0015\u000e\\3G_J|eMZ:fiR!11RBG!\u00159(1]A{\u0011\u001d\u0019y)\u0019a\u0001\u00033\faa\u001c4gg\u0016$\u0018aG8o\u0019><7\u000b^1si>3gm]3u\u0013:\u001c'/Z7f]R,G\r\u0006\u0003\u0002>\u000eU\u0005bBB\u000eE\u0002\u0007\u0011\u0011\\\u0001\u001fe\u0016lwN^3V]J,\u0007\u000f\\5dCR,G\r\u0016:b]N\f7\r^5p]N$B!!0\u0004\u001c\"91qR2A\u0002\u0005e\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0011\til!)\t\u000f\r=E\r1\u0001\u0002Z\u0006\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u000b\u0005\u00033\u001c9\u000bC\u0004\u0004*\u0016\u0004\raa+\u0002\u0019\r|W\u000e\u001d7fi\u0016$G\u000b\u001f8\u0011\u0007M\u001ci+C\u0002\u000406\u0014AbQ8na2,G/\u001a3Uq:\f1bY8na2,G/\u001a+y]R!\u0011QXB[\u0011\u001d\u0019IK\u001aa\u0001\u0007W\u000bQ\u0003Z3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\r\u0006\u0003\u0002>\u000em\u0006bBBHO\u0002\u0007\u0011\u0011\u001c\u0015\u0004O\n%\u0017AE8mI\u0016\u001cHo\u00158baNDw\u000e\u001e$jY\u0016,\"aa#\u0002%1\fG/Z:u':\f\u0007o\u001d5pi\u001aKG.Z\u0001\u0018e\u0016lwN^3B]\u0012$U\r\\3uKNs\u0017\r]:i_R$B!!0\u0004J\"911\u001a6A\u0002\u0005e\u0017AD:oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u0001!e\u0016lwN^3B]\u0012l\u0015M]6T]\u0006\u00048\u000f[8u\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0004\f\u000eE\u0007bBBfW\u0002\u0007\u0011\u0011\u001c\u0015\u0004W\rU\u0007\u0003\u0002B\u0002\u0007/LAa!7\u0003\u0006\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final Time time;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private volatile long oldestTxnLastTimestamp;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    public static int LateTransactionBufferMs() {
        return ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public Time time() {
        return this.time;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private long oldestTxnLastTimestamp() {
        return this.oldestTxnLastTimestamp;
    }

    private void oldestTxnLastTimestamp_$eq(long x$1) {
        this.oldestTxnLastTimestamp = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public boolean hasLateTransaction(long currentTimeMs) {
        long lastTimestamp = this.oldestTxnLastTimestamp();
        return lastTimestamp > 0L && currentTimeMs - lastTimestamp > (long)(this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs());
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1 & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                this.updateOldestTxnTimestamp();
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.producerStateManagerConfig().producerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((TraversableOnce)((MapLike)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.updateOldestTxnTimestamp();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
        this.updateOldestTxnTimestamp();
    }

    private void updateOldestTxnTimestamp() {
        Map.Entry<Object, TxnMetadata> firstEntry = this.ongoingTxns().firstEntry();
        if (firstEntry == null) {
            this.oldestTxnLastTimestamp_$eq(-1L);
            return;
        }
        TxnMetadata oldestTxnMetadata = firstEntry.getValue();
        this.oldestTxnLastTimestamp_$eq(BoxesRunTime.unboxToLong((Object)this.producers().get((Object)BoxesRunTime.boxToLong((long)oldestTxnMetadata.producerId())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.lastTimestamp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            long start = this.time().hiResClockMs();
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Wrote producer snapshot at offset ").append(this.lastMapOffset()).append(" with ").append(this.producers().size()).append(" producer ids in ").append(this.time().hiResClockMs() - start).append(" ms.").toString());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$8, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.offset()));
    }

    public Option<SnapshotFile> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
        this.updateOldestTxnTimestamp();
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$12))).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        this.updateOldestTxnTimestamp();
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$15 -> (SnapshotFile)x$15.getValue());
    }

    private void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deleteIfExists()));
    }

    public Option<SnapshotFile> removeAndMarkSnapshotForDeletion(long snapshotOffset) {
        return Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).flatMap((Function1 & Serializable & scala.Serializable)snapshot -> {
            try {
                snapshot.renameTo(UnifiedLog$.MODULE$.DeletedFileSuffix());
                return new Some(snapshot);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Failed to rename producer state snapshot ").append(snapshot.file().getAbsoluteFile()).append(" with deletion suffix because it was already deleted").toString());
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
            }
        });
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$12) {
        return x$12.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$13) {
        return x$13.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, Time time) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxTransactionTimeoutMs = maxTransactionTimeoutMs;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.oldestTxnLastTimestamp = -1L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

