/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.common.UnsentRequests;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Md!\u0002\u000e\u001c\u0003\u0003\u0001\u0003\"C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00156\u0011!1\u0004A!a\u0001\n\u00039\u0004\u0002C\"\u0001\u0005\u0003\u0007I\u0011\u0001#\t\u0011-\u0003!\u0011!Q!\naB\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"I1\f\u0001B\u0001B\u0003%Al\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019q\u0007\u0001)A\u0005W\")q\u000e\u0001D\u0001a\")Q\u0010\u0001C\u0001}\"1q\u0010\u0001C!\u0003\u0003Aq!a\u0001\u0001\t\u0013\t\t\u0001C\u0004\u0002\u0006\u0001!\t\"a\u0002\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0002!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u0013\u0001\t\u0003\t\taB\u0005\u0002Nm\t\t\u0011#\u0001\u0002P\u0019A!dGA\u0001\u0012\u0003\t\t\u0006\u0003\u0004a/\u0011\u0005\u0011\u0011\f\u0005\n\u00037:\u0012\u0013!C\u0001\u0003;\u0012Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fGM\u0003\u0002\u001d;\u000511m\\7n_:T\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%;\u0005)Q\u000f^5mg&\u0011ae\t\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0003oC6,\u0007CA\u00153\u001d\tQ\u0003\u0007\u0005\u0002,]5\tAF\u0003\u0002.?\u00051AH]8pizR\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\na\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011GL\u0005\u0003O\u0015\nQB\\3uo>\u00148n\u00117jK:$X#\u0001\u001d\u0011\u0005e\nU\"\u0001\u001e\u000b\u0005mb\u0014aB2mS\u0016tGo\u001d\u0006\u0003=uR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!I\u000f\u0002\f\u0017\u000647.Y\"mS\u0016tG/A\toKR<xN]6DY&,g\u000e^0%KF$\"!R%\u0011\u0005\u0019;U\"\u0001\u0018\n\u0005!s#\u0001B+oSRDqAS\u0002\u0002\u0002\u0003\u0007\u0001(A\u0002yIE\naB\\3uo>\u00148n\u00117jK:$\b\u0005\u000b\u0002\u0005\u001bB\u0011aIT\u0005\u0003\u001f:\u0012\u0001B^8mCRLG.Z\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\"A\u0012*\n\u0005Ms#aA%oi\u0006!A/[7f!\t1\u0016,D\u0001X\u0015\t!\u0003L\u0003\u0002\u001dy%\u0011!l\u0016\u0002\u0005)&lW-A\bjg&sG/\u001a:skB$\u0018N\u00197f!\t1U,\u0003\u0002_]\t9!i\\8mK\u0006t\u0017BA.&\u0003\u0019a\u0014N\\5u}Q1!\rZ3gO\"\u0004\"a\u0019\u0001\u000e\u0003mAQa\n\u0005A\u0002!BQA\u000e\u0005A\u0002aBQ\u0001\u0015\u0005A\u0002ECQ\u0001\u0016\u0005A\u0002UCqa\u0017\u0005\u0011\u0002\u0003\u0007A,\u0001\bv]N,g\u000e\u001e*fcV,7\u000f^:\u0016\u0003-\u0004\"a\u00197\n\u00055\\\"AD+og\u0016tGOU3rk\u0016\u001cHo]\u0001\u0010k:\u001cXM\u001c;SKF,Xm\u001d;tA\u0005\u0001r-\u001a8fe\u0006$XMU3rk\u0016\u001cHo\u001d\u000b\u0002cB\u0019!o\u001e>\u000f\u0005M,hBA\u0016u\u0013\u0005y\u0013B\u0001</\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0011%#XM]1cY\u0016T!A\u001e\u0018\u0011\u0005\r\\\u0018B\u0001?\u001c\u0005m\u0011V-];fgR\fe\u000eZ\"p[BdW\r^5p]\"\u000bg\u000e\u001a7fe\u0006\t\u0002.Y:V]N,g\u000e\u001e*fcV,7\u000f^:\u0016\u0003q\u000b\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002\u000b\u00061BM]1j]\u001e+g.\u001a:bi\u0016$'+Z9vKN$8/\u0001\u0005q_2dwJ\\2f)\r)\u0015\u0011\u0002\u0005\b\u0003\u0017y\u0001\u0019AA\u0007\u00031i\u0017\r\u001f+j[\u0016|W\u000f^'t!\r1\u0015qB\u0005\u0004\u0003#q#\u0001\u0002'p]\u001e\fa\u0001Z8X_J\\\u0017\u0001D:f]\u0012\u0014V-];fgR\u001cHCBA\u0007\u00033\ti\u0002C\u0004\u0002\u001cE\u0001\r!!\u0004\u0002\u00079|w\u000fC\u0004\u0002\fE\u0001\r!!\u0004\u0002!\rDWmY6ESN\u001cwN\u001c8fGR\u001cHcA#\u0002$!9\u00111\u0004\nA\u0002\u00055\u0011a\u00054bS2,\u0005\u0010]5sK\u0012\u0014V-];fgR\u001cHcA#\u0002*!9\u00111D\nA\u0002\u00055\u0011AF2p[BdW\r^3XSRDG)[:d_:tWm\u0019;\u0015\u000f\u0015\u000by#!\u000f\u0002<!9\u0011\u0011\u0007\u000bA\u0002\u0005M\u0012a\u0002:fcV,7\u000f\u001e\t\u0004s\u0005U\u0012bAA\u001cu\ti1\t\\5f]R\u0014V-];fgRDq!a\u0007\u0015\u0001\u0004\ti\u0001C\u0004\u0002>Q\u0001\r!a\u0010\u0002/\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015\u0003,\u0001\u0004feJ|'o]\u0005\u0005\u0003\u0013\n\u0019EA\fBkRDWM\u001c;jG\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u00061q/Y6fkB\fQ#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\r\u0005\u0002d/M\u0019q#a\u0015\u0011\u0007\u0019\u000b)&C\u0002\u0002X9\u0012a!\u00118z%\u00164GCAA(\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\f\u0016\u00049\u0006\u00054FAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055d&\u0001\u0006b]:|G/\u0019;j_:LA!!\u001d\u0002h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private volatile KafkaClient networkClient;
    private final int requestTimeoutMs;
    private final Time time;
    private final UnsentRequests unsentRequests;

    public static boolean $lessinit$greater$default$5() {
        return InterBrokerSendThread$.MODULE$.$lessinit$greater$default$5();
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(KafkaClient x$1) {
        this.networkClient = x$1;
    }

    private UnsentRequests unsentRequests() {
        return this.unsentRequests;
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    public boolean hasUnsentRequests() {
        return this.unsentRequests().iterator().hasNext();
    }

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient().initiateClose();
        this.awaitShutdown();
        this.networkClient().close();
    }

    private void drainGeneratedRequests() {
        this.generateRequests().foreach((Function1 & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$drainGeneratedRequests$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    public void pollOnce(long maxTimeoutMs) {
        try {
            this.drainGeneratedRequests();
            long now = this.time.milliseconds();
            long timeout = this.sendRequests(now, maxTimeoutMs);
            this.networkClient().poll(timeout, now);
            now = this.time.milliseconds();
            this.checkDisconnects(now);
            this.failExpiredRequests(now);
            this.unsentRequests().clean();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof DisconnectException && !this.networkClient().active()) {
                return;
            }
            if (throwable instanceof FatalExitError) {
                throw (FatalExitError)throwable;
            }
            if (throwable != null) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "unhandled exception caught in InterBrokerSendThread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                throw new FatalExitError();
            }
            throw null;
        }
    }

    @Override
    public void doWork() {
        this.pollOnce(Long.MAX_VALUE);
    }

    private long sendRequests(long now, long maxTimeoutMs) {
        LongRef pollTimeout = LongRef.create((long)maxTimeoutMs);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.unsentRequests().nodes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            InterBrokerSendThread.$anonfun$sendRequests$1(this, now, pollTimeout, node);
            return BoxedUnit.UNIT;
        });
        return pollTimeout.elem;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests().iterator();
        while (iterator.hasNext()) {
            void var6_5;
            void var5_4;
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            ArrayDeque<ClientRequest> arrayDeque = entry.getValue();
            Node node = entry.getKey();
            ArrayDeque<ClientRequest> requests = arrayDeque;
            void node2 = var5_4;
            void requests2 = var6_5;
            if (requests2.isEmpty() || !this.networkClient().connectionFailed((Node)node2)) continue;
            iterator.remove();
            ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)requests2).asScala()).foreach(arg_0 -> InterBrokerSendThread.$anonfun$checkDisconnects$1$adapted(this, (Node)node2, now, arg_0));
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> timedOutRequests = this.unsentRequests().removeAllTimedOut(now);
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(timedOutRequests).asScala()).foreach((Function1 & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$failExpiredRequests$1(this, now, request);
            return BoxedUnit.UNIT;
        });
    }

    public void completeWithDisconnect(ClientRequest request, long now, AuthenticationException authenticationException) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, authenticationException, null));
    }

    public void wakeup() {
        this.networkClient().wakeup();
    }

    public static final /* synthetic */ void $anonfun$drainGeneratedRequests$1(InterBrokerSendThread $this, RequestAndCompletionHandler request) {
        $this.unsentRequests().put(request.destination(), $this.networkClient().newClientRequest(request.destination().idString(), request.request(), request.creationTimeMs(), true, $this.requestTimeoutMs, request.handler()));
    }

    public static final /* synthetic */ void $anonfun$sendRequests$1(InterBrokerSendThread $this, long now$1, LongRef pollTimeout$1, Node node) {
        Iterator<ClientRequest> requestIterator = $this.unsentRequests().requestIterator(node);
        while (requestIterator.hasNext()) {
            ClientRequest request = requestIterator.next();
            if ($this.networkClient().ready(node, now$1)) {
                $this.networkClient().send(request, now$1);
                requestIterator.remove();
                continue;
            }
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient().connectionDelay(node, now$1));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDisconnects$1(InterBrokerSendThread $this, Node node$1, long now$2, ClientRequest request) {
        AuthenticationException authenticationException = $this.networkClient().authenticationException(node$1);
        if (authenticationException != null) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Failed to send the following request due to authentication error: ").append(request).toString());
        }
        $this.completeWithDisconnect(request, now$2, authenticationException);
    }

    public static final /* synthetic */ void $anonfun$failExpiredRequests$1(InterBrokerSendThread $this, long now$3, ClientRequest request) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Failed to send the following request after ").append(request.requestTimeoutMs()).append(" ms: ").append(request).toString());
        $this.completeWithDisconnect(request, now$3, null);
    }

    public InterBrokerSendThread(String name, KafkaClient networkClient, int requestTimeoutMs, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.requestTimeoutMs = requestTimeoutMs;
        this.time = time;
        super(name, isInterruptible);
        this.unsentRequests = new UnsentRequests();
    }

    public static final /* synthetic */ Object $anonfun$checkDisconnects$1$adapted(InterBrokerSendThread $this, Node node$1, long now$2, ClientRequest request) {
        InterBrokerSendThread.$anonfun$checkDisconnects$1($this, node$1, now$2, request);
        return BoxedUnit.UNIT;
    }
}

