/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerde;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class SubscriptionWrapperSerde<K>
extends WrappingNullableSerde<SubscriptionWrapper<K>, K, Void> {
    public SubscriptionWrapperSerde(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serde<K> primaryKeySerde) {
        super(new SubscriptionWrapperSerializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.serializer()), new SubscriptionWrapperDeserializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.deserializer()));
    }

    private static class SubscriptionWrapperDeserializer<K>
    implements Deserializer<SubscriptionWrapper<K>>,
    WrappingNullableDeserializer<SubscriptionWrapper<K>, K, Void> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Deserializer<K> primaryKeyDeserializer;

        SubscriptionWrapperDeserializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Deserializer<K> primaryKeyDeserializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeyDeserializer = primaryKeyDeserializer;
        }

        @Override
        public void setIfUnset(SerdeGetter getter) {
            if (this.primaryKeyDeserializer == null) {
                this.primaryKeyDeserializer = getter.keySerde().deserializer();
            }
        }

        public SubscriptionWrapper<K> deserialize(String ignored, byte[] data) {
            long[] hash;
            ByteBuffer buf = ByteBuffer.wrap(data);
            byte versionAndIsHashNull = buf.get();
            byte version = (byte)(0x7F & versionAndIsHashNull);
            boolean isHashNull = (0x80 & versionAndIsHashNull) == 128;
            SubscriptionWrapper.Instruction inst = SubscriptionWrapper.Instruction.fromValue(buf.get());
            int lengthSum = 2;
            if (isHashNull) {
                hash = null;
            } else {
                hash = new long[]{buf.getLong(), buf.getLong()};
                lengthSum += 16;
            }
            int primaryKeyLength = version > 0 ? data.length - lengthSum - 4 : data.length - lengthSum;
            byte[] primaryKeyRaw = new byte[primaryKeyLength];
            buf.get(primaryKeyRaw, 0, primaryKeyLength);
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            Object primaryKey = this.primaryKeyDeserializer.deserialize(this.primaryKeySerializationPseudoTopic, primaryKeyRaw);
            Integer primaryPartition = version > 0 ? Integer.valueOf(buf.getInt()) : null;
            return new SubscriptionWrapper<Object>(hash, inst, primaryKey, version, primaryPartition);
        }
    }

    private static class SubscriptionWrapperSerializer<K>
    implements Serializer<SubscriptionWrapper<K>>,
    WrappingNullableSerializer<SubscriptionWrapper<K>, K, Void> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Serializer<K> primaryKeySerializer;
        private boolean upgradeFromV0 = false;

        SubscriptionWrapperSerializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serializer<K> primaryKeySerializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeySerializer = primaryKeySerializer;
        }

        @Override
        public void setIfUnset(SerdeGetter getter) {
            if (this.primaryKeySerializer == null) {
                this.primaryKeySerializer = getter.keySerde().serializer();
            }
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.upgradeFromV0 = SubscriptionWrapperSerializer.upgradeFromV0(configs);
        }

        private static boolean upgradeFromV0(Map<String, ?> configs) {
            Object upgradeFrom = configs.get("upgrade.from");
            if (upgradeFrom == null) {
                return false;
            }
            switch ((String)upgradeFrom) {
                case "0.10.0": 
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": 
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": 
                case "2.4": 
                case "2.5": 
                case "2.6": 
                case "2.7": 
                case "2.8": 
                case "3.0": 
                case "3.1": 
                case "3.2": 
                case "3.3": {
                    return true;
                }
            }
            return false;
        }

        public byte[] serialize(String ignored, SubscriptionWrapper<K> data) {
            if (Byte.compare((byte)127, data.getVersion()) < 0) {
                throw new UnsupportedVersionException("SubscriptionWrapper version is larger than maximum supported 0x7F");
            }
            byte version = data.getVersion();
            if (this.upgradeFromV0 || version == 0) {
                return this.serializeV0(data);
            }
            if (version == 1) {
                return this.serializeV1(data);
            }
            throw new UnsupportedVersionException("Unsupported SubscriptionWrapper version " + data.getVersion());
        }

        private byte[] serializePrimaryKey(SubscriptionWrapper<K> data) {
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            return this.primaryKeySerializer.serialize(this.primaryKeySerializationPseudoTopic, data.getPrimaryKey());
        }

        private ByteBuffer serializeCommon(SubscriptionWrapper<K> data, byte version, int extraLength) {
            ByteBuffer buf;
            byte[] primaryKeySerializedData = this.serializePrimaryKey(data);
            int dataLength = 2 + primaryKeySerializedData.length + extraLength;
            if (data.getHash() != null) {
                buf = ByteBuffer.allocate(dataLength += 16);
                buf.put(version);
            } else {
                buf = ByteBuffer.allocate(dataLength);
                buf.put((byte)(version | 0xFFFFFF80));
            }
            buf.put(data.getInstruction().getValue());
            long[] elem = data.getHash();
            if (data.getHash() != null) {
                buf.putLong(elem[0]);
                buf.putLong(elem[1]);
            }
            buf.put(primaryKeySerializedData);
            return buf;
        }

        private byte[] serializeV0(SubscriptionWrapper<K> data) {
            return this.serializeCommon(data, (byte)0, 0).array();
        }

        private byte[] serializeV1(SubscriptionWrapper<K> data) {
            ByteBuffer buf = this.serializeCommon(data, data.getVersion(), 4);
            buf.putInt(data.getPrimaryPartition());
            return buf.array();
        }
    }
}

