/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionChangeBuilder {
    private static final Logger log = LoggerFactory.getLogger(PartitionChangeBuilder.class);
    private final PartitionRegistration partition;
    private final Uuid topicId;
    private final int partitionId;
    private final IntPredicate isAcceptableLeader;
    private final boolean isLeaderRecoverySupported;
    private List<Integer> targetIsr;
    private List<Integer> targetReplicas;
    private List<Integer> targetRemoving;
    private List<Integer> targetAdding;
    private Election election = Election.ONLINE;
    private LeaderRecoveryState targetLeaderRecoveryState;

    public static boolean changeRecordIsNoOp(PartitionChangeRecord record) {
        if (record.isr() != null) {
            return false;
        }
        if (record.leader() != -2) {
            return false;
        }
        if (record.replicas() != null) {
            return false;
        }
        if (record.removingReplicas() != null) {
            return false;
        }
        if (record.addingReplicas() != null) {
            return false;
        }
        return record.leaderRecoveryState() == -1;
    }

    public PartitionChangeBuilder(PartitionRegistration partition, Uuid topicId, int partitionId, IntPredicate isAcceptableLeader, boolean isLeaderRecoverySupported) {
        this.partition = partition;
        this.topicId = topicId;
        this.partitionId = partitionId;
        this.isAcceptableLeader = isAcceptableLeader;
        this.isLeaderRecoverySupported = isLeaderRecoverySupported;
        this.targetIsr = Replicas.toList(partition.isr);
        this.targetReplicas = Replicas.toList(partition.replicas);
        this.targetRemoving = Replicas.toList(partition.removingReplicas);
        this.targetAdding = Replicas.toList(partition.addingReplicas);
        this.targetLeaderRecoveryState = partition.leaderRecoveryState;
    }

    public PartitionChangeBuilder setTargetIsr(List<Integer> targetIsr) {
        this.targetIsr = targetIsr;
        return this;
    }

    public PartitionChangeBuilder setTargetReplicas(List<Integer> targetReplicas) {
        this.targetReplicas = targetReplicas;
        return this;
    }

    public PartitionChangeBuilder setElection(Election election) {
        this.election = election;
        return this;
    }

    public PartitionChangeBuilder setTargetRemoving(List<Integer> targetRemoving) {
        this.targetRemoving = targetRemoving;
        return this;
    }

    public PartitionChangeBuilder setTargetAdding(List<Integer> targetAdding) {
        this.targetAdding = targetAdding;
        return this;
    }

    public PartitionChangeBuilder setTargetLeaderRecoveryState(LeaderRecoveryState targetLeaderRecoveryState) {
        this.targetLeaderRecoveryState = targetLeaderRecoveryState;
        return this;
    }

    ElectionResult electLeader() {
        if (this.election == Election.PREFERRED) {
            return this.electPreferredLeader();
        }
        return this.electAnyLeader();
    }

    private ElectionResult electPreferredLeader() {
        int preferredReplica = this.targetReplicas.get(0);
        if (this.isValidNewLeader(preferredReplica)) {
            return new ElectionResult(preferredReplica, false);
        }
        if (this.isValidNewLeader(this.partition.leader)) {
            return new ElectionResult(this.partition.leader, false);
        }
        Optional<Integer> onlineLeader = this.targetReplicas.stream().skip(1L).filter(this::isValidNewLeader).findFirst();
        if (onlineLeader.isPresent()) {
            return new ElectionResult(onlineLeader.get(), false);
        }
        return new ElectionResult(-1, false);
    }

    private ElectionResult electAnyLeader() {
        Optional<Integer> uncleanLeader;
        if (this.isValidNewLeader(this.partition.leader)) {
            return new ElectionResult(this.partition.leader, false);
        }
        Optional<Integer> onlineLeader = this.targetReplicas.stream().filter(this::isValidNewLeader).findFirst();
        if (onlineLeader.isPresent()) {
            return new ElectionResult(onlineLeader.get(), false);
        }
        if (this.election == Election.UNCLEAN && (uncleanLeader = this.targetReplicas.stream().filter(replica -> this.isAcceptableLeader.test((int)replica)).findFirst()).isPresent()) {
            return new ElectionResult(uncleanLeader.get(), true);
        }
        return new ElectionResult(-1, false);
    }

    private boolean isValidNewLeader(int replica) {
        return this.targetIsr.contains(replica) && this.isAcceptableLeader.test(replica);
    }

    private void tryElection(PartitionChangeRecord record) {
        ElectionResult electionResult = this.electLeader();
        if (electionResult.node != this.partition.leader) {
            log.debug("Setting new leader for topicId {}, partition {} to {} using {} election", new Object[]{this.topicId, this.partitionId, electionResult.node, electionResult.unclean ? "an unclean" : "a clean"});
            record.setLeader(electionResult.node);
            if (electionResult.unclean) {
                record.setIsr(Collections.singletonList(electionResult.node));
                if (this.partition.leaderRecoveryState != LeaderRecoveryState.RECOVERING && this.isLeaderRecoverySupported) {
                    record.setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value());
                }
            }
        } else {
            log.debug("Failed to find a new leader with current state: {}", (Object)this);
        }
    }

    void triggerLeaderEpochBumpIfNeeded(PartitionChangeRecord record) {
        if (!(record.leader() != -2 || Replicas.contains(this.targetIsr, this.partition.isr) && Replicas.contains(this.targetReplicas, this.partition.replicas))) {
            record.setLeader(this.partition.leader);
        }
    }

    private void completeReassignmentIfNeeded() {
        if (this.targetRemoving.isEmpty() && this.targetAdding.isEmpty()) {
            return;
        }
        List<Integer> newTargetIsr = this.targetIsr;
        List<Integer> newTargetReplicas = this.targetReplicas;
        if (!this.targetRemoving.isEmpty()) {
            newTargetIsr = new ArrayList<Integer>(this.targetIsr.size());
            for (int replica : this.targetIsr) {
                if (this.targetRemoving.contains(replica)) continue;
                newTargetIsr.add(replica);
            }
            if (newTargetIsr.isEmpty()) {
                return;
            }
            newTargetReplicas = new ArrayList<Integer>(this.targetReplicas.size());
            for (int replica : this.targetReplicas) {
                if (this.targetRemoving.contains(replica)) continue;
                newTargetReplicas.add(replica);
            }
            if (newTargetReplicas.isEmpty()) {
                return;
            }
        }
        for (int replica : this.targetAdding) {
            if (newTargetIsr.contains(replica)) continue;
            return;
        }
        this.targetIsr = newTargetIsr;
        this.targetReplicas = newTargetReplicas;
        this.targetRemoving = Collections.emptyList();
        this.targetAdding = Collections.emptyList();
    }

    public Optional<ApiMessageAndVersion> build() {
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(this.topicId).setPartitionId(this.partitionId);
        this.completeReassignmentIfNeeded();
        this.tryElection(record);
        this.triggerLeaderEpochBumpIfNeeded(record);
        if (record.isr() == null && !this.targetIsr.isEmpty() && !this.targetIsr.equals(Replicas.toList(this.partition.isr))) {
            record.setIsr(this.targetIsr);
        }
        if (!this.targetReplicas.isEmpty() && !this.targetReplicas.equals(Replicas.toList(this.partition.replicas))) {
            record.setReplicas(this.targetReplicas);
        }
        if (!this.targetRemoving.equals(Replicas.toList(this.partition.removingReplicas))) {
            record.setRemovingReplicas(this.targetRemoving);
        }
        if (!this.targetAdding.equals(Replicas.toList(this.partition.addingReplicas))) {
            record.setAddingReplicas(this.targetAdding);
        }
        if (this.targetLeaderRecoveryState != this.partition.leaderRecoveryState) {
            record.setLeaderRecoveryState(this.targetLeaderRecoveryState.value());
        }
        if (PartitionChangeBuilder.changeRecordIsNoOp(record)) {
            return Optional.empty();
        }
        return Optional.of(new ApiMessageAndVersion((ApiMessage)record, MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
    }

    public String toString() {
        return "PartitionChangeBuilder(partition=" + this.partition + ", topicId=" + this.topicId + ", partitionId=" + this.partitionId + ", isAcceptableLeader=" + this.isAcceptableLeader + ", targetIsr=" + this.targetIsr + ", targetReplicas=" + this.targetReplicas + ", targetRemoving=" + this.targetRemoving + ", targetAdding=" + this.targetAdding + ", election=" + (Object)((Object)this.election) + ", targetLeaderRecoveryState=" + (Object)((Object)this.targetLeaderRecoveryState) + ')';
    }

    static class ElectionResult {
        final int node;
        final boolean unclean;

        private ElectionResult(int node, boolean unclean) {
            this.node = node;
            this.unclean = unclean;
        }
    }

    public static enum Election {
        PREFERRED,
        ONLINE,
        UNCLEAN;

    }
}

