/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\r\u001a\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$U\u0011!I\u0006A!A!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003y\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007o\u0002\u0001\u000b\u0011\u00026\t\u000fa\u0004!\u0019!C\u0005s\"9\u0011\u0011\u0002\u0001!\u0002\u0013Q\bBCA\u0006\u0001\u0001\u0007I\u0011A\r\u0002\u000e!Q\u0011Q\u0003\u0001A\u0002\u0013\u0005\u0011$a\u0006\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003\u001fAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA)\u0001\u0011\u0005\u00131\u000b\u0005\t\u0003[\u0002A\u0011A\r\u0002p!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAC\u0001\u0011\u0005\u00131\u0011\u0002 \u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'OU3rk\u0016\u001cH\u000f\u00165sK\u0006$'B\u0001\u000e\u001c\u0003\u0019\u0019XM\u001d<fe*\tA$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u001c\u0003\u0019\u0019w.\\7p]&\u0011A%\t\u0002\u0016\u0013:$XM\u001d\"s_.,'oU3oIRC'/Z1e\u00035qW\r^<pe.\u001cE.[3oiB\u0011qeL\u0007\u0002Q)\u0011\u0011FK\u0001\bG2LWM\u001c;t\u0015\ta2F\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019)\u0005-Y\u0015MZ6b\u00072LWM\u001c;\u0002\u001f5,G/\u00193bi\u0006,\u0006\u000fZ1uKJ\u0004\"aJ\u001a\n\u0005QB#!F'b]V\fG.T3uC\u0012\fG/Y+qI\u0006$XM]\u0001\u0017G>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3feB\u0011q\u0007O\u0007\u00023%\u0011\u0011(\u0007\u0002\u0017\u0007>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3fe\u000611m\u001c8gS\u001e\u0004\"a\u000e\u001f\n\u0005uJ\"aC&bM.\f7i\u001c8gS\u001e\fA\u0001^5nKB\u0011\u0001\tR\u0007\u0002\u0003*\u0011!iQ\u0001\u0006kRLGn\u001d\u0006\u0003E)J!!R!\u0003\tQKW.Z\u0001\u000bi\"\u0014X-\u00193OC6,\u0007C\u0001%R\u001d\tIu\n\u0005\u0002K\u001b6\t1J\u0003\u0002M;\u00051AH]8pizR\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u000ba\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001+T\u0005\u0003+Z\u000bAA\\1nK&\u0011q\u000b\u0017\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fGM\u0003\u0002C7\u0005q!/\u001a;ssRKW.Z8vi6\u001b\bCA.]\u001b\u0005i\u0015BA/N\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)!\u0001\u0017MY2eK\u001a<\u0007CA\u001c\u0001\u0011\u0015)\u0003\u00021\u0001'\u0011\u0015\t\u0004\u00021\u00013\u0011\u0015)\u0004\u00021\u00017\u0011\u0015Q\u0004\u00021\u0001<\u0011\u0015q\u0004\u00021\u0001@\u0011\u00151\u0005\u00021\u0001H\u0011\u0015I\u0006\u00021\u0001[\u00031\u0011X-];fgR\fV/Z;f+\u0005Q\u0007cA6si6\tAN\u0003\u0002n]\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=\u0004\u0018\u0001B;uS2T\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002tY\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<G)Z9vKB\u0011q'^\u0005\u0003mf\u00111D\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7feF+X-^3Ji\u0016l\u0017!\u0004:fcV,7\u000f^)vKV,\u0007%\u0001\tbGRLg/Z\"p]R\u0014x\u000e\u001c7feV\t!\u0010\u0005\u0003|}\u0006\u0005Q\"\u0001?\u000b\u0005ud\u0017AB1u_6L7-\u0003\u0002\u0000y\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u0004\u0005\u0015Q\"A\"\n\u0007\u0005\u001d1I\u0001\u0003O_\u0012,\u0017!E1di&4XmQ8oiJ|G\u000e\\3sA\u000591\u000f^1si\u0016$WCAA\b!\rY\u0016\u0011C\u0005\u0004\u0003'i%a\u0002\"p_2,\u0017M\\\u0001\fgR\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005}\u0001cA.\u0002\u001c%\u0019\u0011QD'\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Cq\u0011\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00132\u0003!\u0019H/\u0019:uK\u0012\u0004\u0003fA\b\u0002(A\u00191,!\u000b\n\u0007\u0005-RJ\u0001\u0005w_2\fG/\u001b7f\u0003]\t7\r^5wK\u000e{g\u000e\u001e:pY2,'/\u00113ee\u0016\u001c8\u000f\u0006\u0002\u00022A)1,a\r\u0002\u0002%\u0019\u0011QG'\u0003\r=\u0003H/[8o\u0003])\b\u000fZ1uK\u000e{g\u000e\u001e:pY2,'/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0002\u001a\u0005m\u0002bBA\u001f#\u0001\u0007\u0011\u0011A\u0001\u0014]\u0016<\u0018i\u0019;jm\u0016\u001cuN\u001c;s_2dWM]\u0001\bK:\fX/Z;f)\u0011\tI\"a\u0011\t\r\u0005\u0015#\u00031\u0001u\u0003\u001d\u0011X-];fgR\f\u0011\"];fk\u0016\u001c\u0016N_3\u0016\u0005\u0005-\u0003cA.\u0002N%\u0019\u0011qJ'\u0003\u0007%sG/\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011Q\u000b\t\u0007\u0003/\n\t'a\u001a\u000f\t\u0005e\u0013Q\f\b\u0004\u0015\u0006m\u0013\"\u0001(\n\u0007\u0005}S*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0014Q\r\u0002\t\u0013R,'/\u00192mK*\u0019\u0011qL'\u0011\u0007\u0001\nI'C\u0002\u0002l\u0005\u00121DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0005\u0003c\ni\b\u0006\u0003\u0002\u001a\u0005M\u0004bBA;+\u0001\u0007\u0011qO\u0001\te\u0016\u001c\bo\u001c8tKB\u0019q%!\u001f\n\u0007\u0005m\u0004F\u0001\bDY&,g\u000e\u001e*fgB|gn]3\t\r\u0005}T\u00031\u0001u\u0003%\tX/Z;f\u0013R,W.\u0001\u0004e_^{'o\u001b\u000b\u0003\u00033\tQa\u001d;beR\u0004")
public class BrokerToControllerRequestThread
extends InterBrokerSendThread {
    private final KafkaClient networkClient;
    private final ManualMetadataUpdater metadataUpdater;
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final long retryTimeoutMs;
    private final LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue;
    private final AtomicReference<Node> activeController;
    private volatile boolean started;

    private LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue() {
        return this.requestQueue;
    }

    private AtomicReference<Node> activeController() {
        return this.activeController;
    }

    public boolean started() {
        return this.started;
    }

    public void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public Option<Node> activeControllerAddress() {
        return Option$.MODULE$.apply((Object)this.activeController().get());
    }

    private void updateControllerAddress(Node newActiveController) {
        this.activeController().set(newActiveController);
    }

    public void enqueue(BrokerToControllerQueueItem request) {
        if (!this.started()) {
            throw new IllegalStateException("Cannot enqueue a request if the request thread is not running");
        }
        this.requestQueue().add(request);
        if (this.activeControllerAddress().isDefined()) {
            this.wakeup();
        }
    }

    public int queueSize() {
        return this.requestQueue().size();
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        Iterator<BrokerToControllerQueueItem> requestIter = this.requestQueue().iterator();
        while (requestIter.hasNext()) {
            BrokerToControllerQueueItem request = requestIter.next();
            if (currentTimeMs - request.createdTimeMs() >= this.retryTimeoutMs) {
                requestIter.remove();
                request.callback().onTimeout();
                continue;
            }
            Option<Node> controllerAddress = this.activeControllerAddress();
            if (!controllerAddress.isDefined()) continue;
            requestIter.remove();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new RequestAndCompletionHandler(this.time.milliseconds(), (Node)controllerAddress.get(), request.request(), response -> this.handleResponse(request, response))));
        }
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    public void handleResponse(BrokerToControllerQueueItem queueItem, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Request ").append(queueItem.request()).append(" failed due to authentication error with controller").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> response.authenticationException());
            queueItem.callback().onComplete(response);
            return;
        }
        if (response.versionMismatch() != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Request ").append(queueItem.request()).append(" failed due to unsupported version error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> response.versionMismatch());
            queueItem.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected()) {
            this.updateControllerAddress(null);
            this.requestQueue().putFirst(queueItem);
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.activeControllerAddress().foreach((Function1 & Serializable)controllerAddress -> {
                BrokerToControllerRequestThread.$anonfun$handleResponse$5(this, controllerAddress);
                return BoxedUnit.UNIT;
            });
            this.requestQueue().putFirst(queueItem);
            return;
        }
        queueItem.callback().onComplete(response);
    }

    @Override
    public void doWork() {
        if (this.activeControllerAddress().isDefined()) {
            super.pollOnce(Long.MAX_VALUE);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Controller isn't cached, looking for local metadata changes");
        Option<Node> option = this.controllerNodeProvider.get();
        if (option instanceof Some) {
            Node controllerNode = (Node)((Some)option).value();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Recorded new controller, from now on will use node ").append(controllerNode).toString());
            this.updateControllerAddress(controllerNode);
            this.metadataUpdater.setNodes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)controllerNode, (List)Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "No controller defined in metadata cache, retrying after backoff");
            super.pollOnce(100L);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void start() {
        super.start();
        this.started_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$handleResponse$5(BrokerToControllerRequestThread $this, Node controllerAddress) {
        $this.networkClient.disconnect(controllerAddress.idString());
        $this.updateControllerAddress(null);
    }

    public BrokerToControllerRequestThread(KafkaClient networkClient, ManualMetadataUpdater metadataUpdater, ControllerNodeProvider controllerNodeProvider, KafkaConfig config, Time time, String threadName, long retryTimeoutMs) {
        this.networkClient = networkClient;
        this.metadataUpdater = metadataUpdater;
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.retryTimeoutMs = retryTimeoutMs;
        super(threadName, networkClient, (int)Math.min(Integer.MAX_VALUE, Math.min((long)config.controllerSocketTimeoutMs(), retryTimeoutMs)), time, false);
        this.requestQueue = new LinkedBlockingDeque();
        this.activeController = new AtomicReference<Object>(null);
        this.started = false;
    }
}

