/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public final class WordCountTransformerDemo {
    public static void main(String[] args) throws IOException {
        Properties props = new Properties();
        if (args != null && args.length > 0) {
            try (FileInputStream fis = new FileInputStream(args[0]);){
                props.load(fis);
            }
            if (args.length > 1) {
                System.out.println("Warning: Some command line arguments were ignored. This demo only accepts an optional configuration file.");
            }
        }
        props.putIfAbsent("application.id", "streams-wordcount-transformer");
        props.putIfAbsent("bootstrap.servers", "localhost:9092");
        props.putIfAbsent("cache.max.bytes.buffering", (Object)0);
        props.putIfAbsent("default.key.serde", Serdes.String().getClass());
        props.putIfAbsent("default.value.serde", Serdes.String().getClass());
        props.putIfAbsent("auto.offset.reset", "earliest");
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("streams-plaintext-input").process((ProcessorSupplier)new MyProcessorSupplier(), new String[0]).to("streams-wordcount-processor-output");
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-wordcount-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }

    static class MyProcessorSupplier
    implements ProcessorSupplier<String, String, String, String> {
        MyProcessorSupplier() {
        }

        public Processor<String, String, String, String> get() {
            return new Processor<String, String, String, String>(){
                private KeyValueStore<String, Integer> kvStore;

                public void init(ProcessorContext<String, String> context) {
                    context.schedule(Duration.ofSeconds(1L), PunctuationType.STREAM_TIME, timestamp -> {
                        try (KeyValueIterator iter = this.kvStore.all();){
                            System.out.println("----------- " + timestamp + " ----------- ");
                            while (iter.hasNext()) {
                                KeyValue entry = (KeyValue)iter.next();
                                System.out.println("[" + (String)entry.key + ", " + entry.value + "]");
                                context.forward(new Record(entry.key, (Object)((Integer)entry.value).toString(), timestamp));
                            }
                        }
                    });
                    this.kvStore = (KeyValueStore)context.getStateStore("Counts");
                }

                public void process(Record<String, String> record) {
                    String[] words;
                    for (String word : words = ((String)record.value()).toLowerCase(Locale.getDefault()).split("\\W+")) {
                        Integer oldValue = (Integer)this.kvStore.get((Object)word);
                        if (oldValue == null) {
                            this.kvStore.put((Object)word, (Object)1);
                            continue;
                        }
                        this.kvStore.put((Object)word, (Object)(oldValue + 1));
                    }
                }

                public void close() {
                }
            };
        }

        public Set<StoreBuilder<?>> stores() {
            return Collections.singleton(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"Counts"), (Serde)Serdes.String(), (Serde)Serdes.Integer()));
        }
    }
}

