/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowStoreIteratorWrapper;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBTimeOrderedWindowStore
extends WrappedStateStore<RocksDBTimeOrderedSegmentedBytesStore, Object, Object>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    private final long windowSize;
    private int seqnum = 0;

    RocksDBTimeOrderedWindowStore(RocksDBTimeOrderedSegmentedBytesStore store, boolean retainDuplicates, long windowSize) {
        super(store);
        Objects.requireNonNull(store, "store is null");
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).init(context, root);
    }

    @Override
    public void flush() {
        ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).flush();
    }

    @Override
    public void close() {
        ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).close();
    }

    @Override
    public boolean persistent() {
        return ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).persistent();
    }

    @Override
    public boolean isOpen() {
        return ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).isOpen();
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        if (value != null || !this.retainDuplicates) {
            this.maybeUpdateSeqnumForDups();
            ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).put(key, windowStartTimestamp, this.seqnum, value);
        }
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).fetch(key, timestamp, this.seqnum);
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).valuesIterator();
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).valuesIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).all();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).backwardAll();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSegmentedBytesStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }
}

