/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.SessionCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.SessionTupleForwarder;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamSessionWindowAggregate<KIn, VIn, VAgg>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamSessionWindowAggregate.class);
    private final String storeName;
    private final SessionWindows windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private final Merger<? super KIn, VAgg> sessionMerger;
    private boolean sendOldValues = false;

    public KStreamSessionWindowAggregate(SessionWindows windows, String storeName, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator, Merger<? super KIn, VAgg> sessionMerger) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
        this.sessionMerger = sessionMerger;
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamSessionWindowAggregateProcessor();
    }

    public SessionWindows windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private SessionWindow mergeSessionWindow(SessionWindow one, SessionWindow two) {
        long start = Math.min(one.start(), two.start());
        long end = Math.max(one.end(), two.end());
        return new SessionWindow(start, end);
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KTableSessionWindowValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSessionWindowAggregate.this.storeName};
            }
        };
    }

    private class KTableSessionWindowValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private SessionStore<KIn, VAgg> store;

        private KTableSessionWindowValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> key) {
            return ValueAndTimestamp.make(this.store.fetchSession(key.key(), key.window().start(), key.window().end()), key.window().end());
        }
    }

    private class KStreamSessionWindowAggregateProcessor
    extends ContextualProcessor<KIn, VIn, Windowed<KIn>, Change<VAgg>> {
        private SessionStore<KIn, VAgg> store;
        private SessionTupleForwarder<KIn, VAgg> tupleForwarder;
        private Sensor droppedRecordsSensor;
        private long observedStreamTime = -1L;

        private KStreamSessionWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<Windowed<KIn>, Change<VAgg>> context) {
            super.init(context);
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            String threadId = Thread.currentThread().getName();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, context.taskId().toString(), metrics);
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
            this.tupleForwarder = new SessionTupleForwarder(this.store, context, new SessionCacheFlushListener(context), KStreamSessionWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            SessionWindow newSessionWindow;
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            long timestamp = record.timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long closeTime = this.observedStreamTime - KStreamSessionWindowAggregate.this.windows.gracePeriodMs() - KStreamSessionWindowAggregate.this.windows.inactivityGap();
            ArrayList<KeyValue> merged = new ArrayList<KeyValue>();
            SessionWindow mergedWindow = newSessionWindow = new SessionWindow(timestamp, timestamp);
            Object agg = KStreamSessionWindowAggregate.this.initializer.apply();
            try (KeyValueIterator iterator = this.store.findSessions(record.key(), timestamp - KStreamSessionWindowAggregate.this.windows.inactivityGap(), timestamp + KStreamSessionWindowAggregate.this.windows.inactivityGap());){
                while (iterator.hasNext()) {
                    KeyValue next = (KeyValue)iterator.next();
                    merged.add(next);
                    agg = KStreamSessionWindowAggregate.this.sessionMerger.apply(record.key(), agg, next.value);
                    mergedWindow = KStreamSessionWindowAggregate.this.mergeSessionWindow(mergedWindow, (SessionWindow)((Windowed)next.key).window());
                }
            }
            if (mergedWindow.end() < closeTime) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), timestamp, mergedWindow.start(), mergedWindow.end(), closeTime, this.observedStreamTime});
                } else {
                    LOG.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{timestamp, mergedWindow.start(), mergedWindow.end(), closeTime, this.observedStreamTime});
                }
                this.droppedRecordsSensor.record();
            } else {
                if (!mergedWindow.equals(newSessionWindow)) {
                    for (KeyValue session : merged) {
                        this.store.remove((Windowed)session.key);
                        this.tupleForwarder.maybeForward(record.withKey(session.key).withValue(new Change<Object>(null, session.value)));
                    }
                }
                agg = KStreamSessionWindowAggregate.this.aggregator.apply(record.key(), record.value(), agg);
                Windowed sessionKey = new Windowed(record.key(), mergedWindow);
                this.store.put(sessionKey, agg);
                this.tupleForwarder.maybeForward(record.withKey(sessionKey).withValue(new Change<Object>(agg, null)));
            }
        }
    }
}

