/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.metadata.BrokerMetadataListener$;
import kafka.server.metadata.BrokerMetadataListener$BatchLoadResults$;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011]s!\u00028p\u0011\u00031h!\u0002=p\u0011\u0003I\bbBA\u0001\u0003\u0011\u0005\u00111\u0001\u0005\n\u0003\u000b\t!\u0019!C\u0001\u0003\u000fA\u0001\"!\u0007\u0002A\u0003%\u0011\u0011\u0002\u0005\n\u00037\t!\u0019!C\u0001\u0003\u000fA\u0001\"!\b\u0002A\u0003%\u0011\u0011\u0002\u0004\u0006q>\u0004\u0011q\u0004\u0005\u000b\u0003?:!Q1A\u0005\u0002\u0005\u0005\u0004BCA5\u000f\t\u0005\t\u0015!\u0003\u0002d!Q\u00111N\u0004\u0003\u0002\u0003\u0006I!!\u001c\t\u0015\u0005mtA!A!\u0002\u0013\ti\b\u0003\u0006\u0002\u0018\u001e\u0011)\u0019!C\u0001\u00033C!\"!)\b\u0005\u0003\u0005\u000b\u0011BAN\u0011)\t\u0019k\u0002BC\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003_;!\u0011!Q\u0001\n\u0005\u001d\u0006bBA\u0001\u000f\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003\u007f;!\u0019!C\u0005\u0003\u0003D\u0001\"!3\bA\u0003%\u00111\u0019\u0005\n\u0003\u0017<!\u0019!C\u0005\u0003\u001bD\u0001\"a7\bA\u0003%\u0011q\u001a\u0005\n\u0003;<!\u0019!C\u0005\u0003?D\u0001\"a>\bA\u0003%\u0011\u0011\u001d\u0005\n\u0003s<!\u0019!C\u0005\u0003?D\u0001\"a?\bA\u0003%\u0011\u0011\u001d\u0005\n\u0003{<\u0001\u0019!C\u0001\u00033C\u0011\"a@\b\u0001\u0004%\tA!\u0001\t\u0011\t5q\u0001)Q\u0005\u00037C\u0011Ba\u0006\b\u0001\u0004%I!!'\t\u0013\teq\u00011A\u0005\n\tm\u0001\u0002\u0003B\u0010\u000f\u0001\u0006K!a'\t\u0013\t\u0005r\u00011A\u0005\n\t\r\u0002\"\u0003B\u0019\u000f\u0001\u0007I\u0011\u0002B\u001a\u0011!\u00119d\u0002Q!\n\t\u0015\u0002\"\u0003B\u001d\u000f\u0001\u0007I\u0011\u0002B\u001e\u0011%\u0011\u0019e\u0002a\u0001\n\u0013\u0011)\u0005\u0003\u0005\u0003J\u001d\u0001\u000b\u0015\u0002B\u001f\u0011%\u0011Ye\u0002a\u0001\n\u0013\u0011i\u0005C\u0005\u0003X\u001d\u0001\r\u0011\"\u0003\u0003Z!A!QL\u0004!B\u0013\u0011y\u0005C\u0005\u0003`\u001d\u0001\r\u0011\"\u0003\u0002\u001a\"I!\u0011M\u0004A\u0002\u0013%!1\r\u0005\t\u0005O:\u0001\u0015)\u0003\u0002\u001c\"I!\u0011N\u0004C\u0002\u0013\u0005!1\u000e\u0005\t\u0005s:\u0001\u0015!\u0003\u0003n!9!1P\u0004\u0005\u0002\u0005e\u0005b\u0002B?\u000f\u0011\u0005#q\u0010\u0004\u0007\u0005\u0017;\u0001A!$\t\u0015\t\ruF!A!\u0002\u0013\u0011)\tC\u0004\u0002\u0002=\"\tA!(\t\u000f\t\u0015v\u0006\"\u0011\u0003(\"9!\u0011V\u0004\u0005\n\t-\u0006b\u0002BZ\u000f\u0011\u0005#Q\u0017\u0004\u0007\u0005\u000b<\u0001Aa2\t\u0015\t\rUG!A!\u0002\u0013\u0011I\fC\u0004\u0002\u0002U\"\tA!3\t\u000f\t\u0015V\u0007\"\u0011\u0003(\u001a1!qZ\u0004A\u0005#D!Ba;:\u0005+\u0007I\u0011AA1\u0011)\u0011i/\u000fB\tB\u0003%\u00111\r\u0005\u000b\u0005_L$Q3A\u0005\u0002\u0005\u0005\u0004B\u0003Bys\tE\t\u0015!\u0003\u0002d!Q!1_\u001d\u0003\u0016\u0004%\t!!'\t\u0015\tU\u0018H!E!\u0002\u0013\tY\n\u0003\u0006\u0003xf\u0012)\u001a!C\u0001\u00033C!B!?:\u0005#\u0005\u000b\u0011BAN\u0011\u001d\t\t!\u000fC\u0001\u0005wDqaa\u0002:\t\u0003\u001aI\u0001C\u0005\u0004\fe\n\t\u0011\"\u0001\u0004\u000e!I1qC\u001d\u0012\u0002\u0013\u00051\u0011\u0004\u0005\n\u0007_I\u0014\u0013!C\u0001\u00073A\u0011b!\r:#\u0003%\taa\r\t\u0013\r]\u0012(%A\u0005\u0002\rM\u0002\"CB\u001ds\u0005\u0005I\u0011IA\u0004\u0011%\u0019Y$OA\u0001\n\u0003\t\t\u0007C\u0005\u0004>e\n\t\u0011\"\u0001\u0004@!I1\u0011J\u001d\u0002\u0002\u0013\u000531\n\u0005\n\u00073J\u0014\u0011!C\u0001\u00077B\u0011ba\u0018:\u0003\u0003%\te!\u0019\t\u0013\r\u0015\u0014(!A\u0005B\r\u001d\u0004\"CB5s\u0005\u0005I\u0011IB6\u000f%\u0019ygBA\u0001\u0012\u0003\u0019\tHB\u0005\u0003P\u001e\t\t\u0011#\u0001\u0004t!9\u0011\u0011\u0001*\u0005\u0002\r-\u0005\"CB\u0004%\u0006\u0005IQIBG\u0011%\u0019yIUA\u0001\n\u0003\u001b\t\nC\u0005\u0004\u001cJ\u000b\t\u0011\"!\u0004\u001e\"911V\u0004\u0005\n\r5\u0006bBBl\u000f\u0011\u00051\u0011\u001c\u0004\u0007\u0007c<\u0001aa=\t\u0015\r=\u0018L!A!\u0002\u0013\u0011\t\u0006C\u0004\u0002\u0002e#\ta!>\t\u0013\rm\u0018L1A\u0005\u0002\ru\b\u0002CB\u00003\u0002\u0006Iaa7\t\u000f\t\u0015\u0016\f\"\u0011\u0003(\"9A\u0011A\u0004\u0005\n\u0011\r\u0001b\u0002C\u0004\u000f\u0011\u0005C\u0011\u0002\u0005\b\t+9A\u0011\tBT\r\u0019!9b\u0002\u0001\u0005\u001a!9\u0011\u0011\u00012\u0005\u0002\u0011m\u0001b\u0002BSE\u0012\u0005#q\u0015\u0005\b\t?9A\u0011\u0001BT\u0011!!\tc\u0002C\u0001g\u0012\rbA\u0002C\u0017\u000f\u0001!y\u0003\u0003\u0006\u0004|\u001e\u0014\t\u0011)A\u0005\tKAq!!\u0001h\t\u0003!i\u0004C\u0005\u0005D\u001d\u0014\r\u0011\"\u0001\u0005F!AAQJ4!\u0002\u0013!9\u0005C\u0004\u0005P\u001d$\t\u0005\"\u0015\t\u000f\t\u0015v\r\"\u0011\u0003(\u00061\"I]8lKJlU\r^1eCR\fG*[:uK:,'O\u0003\u0002qc\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002sg\u000611/\u001a:wKJT\u0011\u0001^\u0001\u0006W\u000647.Y\u0002\u0001!\t9\u0018!D\u0001p\u0005Y\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u00148CA\u0001{!\tYh0D\u0001}\u0015\u0005i\u0018!B:dC2\f\u0017BA@}\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A^\u0001\u001e\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195Qe>\u001cWm]:j]\u001e$\u0016.\\3VgV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006LA!a\u0006\u0002\u000e\t11\u000b\u001e:j]\u001e\fa$T3uC\u0012\fG/\u0019\"bi\u000eD\u0007K]8dKN\u001c\u0018N\\4US6,Wk\u001d\u0011\u0002%5+G/\u00193bi\u0006\u0014\u0015\r^2i'&TXm]\u0001\u0014\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195TSj,7\u000fI\n\b\u000f\u0005\u0005\u0012qEA*!\u0011\tY!a\t\n\t\u0005\u0015\u0012Q\u0002\u0002\u0007\u001f\nTWm\u0019;\u0011\r\u0005%\u0012qHA#\u001d\u0011\tY#a\u000f\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tAA]1gi*\u0019A/a\r\u000b\t\u0005U\u0012qG\u0001\u0007CB\f7\r[3\u000b\u0005\u0005e\u0012aA8sO&!\u0011QHA\u0017\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0005MSN$XM\\3s\u0015\u0011\ti$!\f\u0011\t\u0005\u001d\u0013qJ\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u000511m\\7n_:T1A]A\u0019\u0013\u0011\t\t&!\u0013\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-g\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA/\u0003/\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003!\u0011'o\\6fe&#WCAA2!\rY\u0018QM\u0005\u0004\u0003Ob(aA%oi\u0006I!M]8lKJLE\rI\u0001\u0005i&lW\r\u0005\u0003\u0002p\u0005]TBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u000bU$\u0018\u000e\\:\u000b\t\u0005-\u0013\u0011G\u0005\u0005\u0003s\n\tH\u0001\u0003US6,\u0017\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\u0015Y\u0018qPAB\u0013\r\t\t\t \u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u00151\u0013\b\u0005\u0003\u000f\u000by\tE\u0002\u0002\nrl!!a#\u000b\u0007\u00055U/\u0001\u0004=e>|GOP\u0005\u0004\u0003#c\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005U%bAAIy\u0006AR.\u0019=CsR,7OQ3uo\u0016,gn\u00158baNDw\u000e^:\u0016\u0005\u0005m\u0005cA>\u0002\u001e&\u0019\u0011q\u0014?\u0003\t1{gnZ\u0001\u001a[\u0006D()\u001f;fg\n+Go^3f]Ns\u0017\r]:i_R\u001c\b%A\u0006t]\u0006\u00048\u000f[8ui\u0016\u0014XCAAT!\u0015Y\u0018qPAU!\r9\u00181V\u0005\u0004\u0003[{'aE'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8ui\u0016\u0014\u0018\u0001D:oCB\u001c\bn\u001c;uKJ\u0004C\u0003DAZ\u0003k\u000b9,!/\u0002<\u0006u\u0006CA<\b\u0011\u001d\ty\u0006\u0005a\u0001\u0003GBq!a\u001b\u0011\u0001\u0004\ti\u0007C\u0004\u0002|A\u0001\r!! \t\u000f\u0005]\u0005\u00031\u0001\u0002\u001c\"9\u00111\u0015\tA\u0002\u0005\u001d\u0016A\u00037pO\u000e{g\u000e^3yiV\u0011\u00111\u0019\t\u0005\u0003_\n)-\u0003\u0003\u0002H\u0006E$A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003\rawnZ\u000b\u0003\u0003\u001f\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0005\u0003+\f9$A\u0003tY\u001a$$.\u0003\u0003\u0002Z\u0006M'A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013a\u00062bi\u000eD\u0007K]8dKN\u001c\u0018N\\4US6,\u0007*[:u+\t\t\t\u000f\u0005\u0003\u0002d\u0006MXBAAs\u0015\u0011\t9/!;\u0002\t\r|'/\u001a\u0006\u0005\u00033\nYO\u0003\u0003\u0002n\u0006=\u0018AB=b[6,'O\u0003\u0002\u0002r\u0006\u00191m\\7\n\t\u0005U\u0018Q\u001d\u0002\n\u0011&\u001cHo\\4sC6\f\u0001DY1uG\"\u0004&o\\2fgNLgn\u001a+j[\u0016D\u0015n\u001d;!\u0003UiW\r^1eCR\f')\u0019;dQNK'0\u001a%jgR\fa#\\3uC\u0012\fG/\u0019\"bi\u000eD7+\u001b>f\u0011&\u001cH\u000fI\u0001\u000f?\"Lw\r[3ti>3gm]3u\u0003Iy\u0006.[4iKN$xJ\u001a4tKR|F%Z9\u0015\t\t\r!\u0011\u0002\t\u0004w\n\u0015\u0011b\u0001B\u0004y\n!QK\\5u\u0011%\u0011YAGA\u0001\u0002\u0004\tY*A\u0002yIE\nqb\u00185jO\",7\u000f^(gMN,G\u000f\t\u0015\u00047\tE\u0001cA>\u0003\u0014%\u0019!Q\u0003?\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011c\u00185jO\",7\u000f\u001e+j[\u0016\u001cH/Y7q\u0003Uy\u0006.[4iKN$H+[7fgR\fW\u000e]0%KF$BAa\u0001\u0003\u001e!I!1B\u000f\u0002\u0002\u0003\u0007\u00111T\u0001\u0013?\"Lw\r[3tiRKW.Z:uC6\u0004\b%\u0001\u0004`S6\fw-Z\u000b\u0003\u0005K\u0001BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0005\u0005W\t\t$A\u0003j[\u0006<W-\u0003\u0003\u00030\t%\"!D'fi\u0006$\u0017\r^1J[\u0006<W-\u0001\u0006`S6\fw-Z0%KF$BAa\u0001\u00036!I!1\u0002\u0011\u0002\u0002\u0003\u0007!QE\u0001\b?&l\u0017mZ3!\u0003\u0019yF-\u001a7uCV\u0011!Q\b\t\u0005\u0005O\u0011y$\u0003\u0003\u0003B\t%\"!D'fi\u0006$\u0017\r^1EK2$\u0018-\u0001\u0006`I\u0016dG/Y0%KF$BAa\u0001\u0003H!I!1B\u0012\u0002\u0002\u0003\u0007!QH\u0001\b?\u0012,G\u000e^1!\u0003)y\u0006/\u001e2mSNDWM]\u000b\u0003\u0005\u001f\u0002Ra_A@\u0005#\u00022a\u001eB*\u0013\r\u0011)f\u001c\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018AD0qk\nd\u0017n\u001d5fe~#S-\u001d\u000b\u0005\u0005\u0007\u0011Y\u0006C\u0005\u0003\f\u0019\n\t\u00111\u0001\u0003P\u0005Yq\f];cY&\u001c\b.\u001a:!\u0003]y&-\u001f;fgNKgnY3MCN$8K\\1qg\"|G/A\u000e`Ef$Xm]*j]\u000e,G*Y:u':\f\u0007o\u001d5pi~#S-\u001d\u000b\u0005\u0005\u0007\u0011)\u0007C\u0005\u0003\f%\n\t\u00111\u0001\u0002\u001c\u0006ArLY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cHo\u00158baNDw\u000e\u001e\u0011\u0002\u0015\u00154XM\u001c;Rk\u0016,X-\u0006\u0002\u0003nA!!q\u000eB;\u001b\t\u0011\tH\u0003\u0003\u0003t\u0005E\u0012!B9vKV,\u0017\u0002\u0002B<\u0005c\u0012qbS1gW\u0006,e/\u001a8u#V,W/Z\u0001\fKZ,g\u000e^)vKV,\u0007%A\u000biS\u001eDWm\u001d;NKR\fG-\u0019;b\u001f\u001a47/\u001a;\u0002\u0019!\fg\u000e\u001a7f\u0007>lW.\u001b;\u0015\t\t\r!\u0011\u0011\u0005\b\u0005\u0007s\u0003\u0019\u0001BC\u0003\u0019\u0011X-\u00193feB1\u00111\u0006BD\u0003\u000bJAA!#\u0002.\tY!)\u0019;dQJ+\u0017\rZ3s\u0005IA\u0015M\u001c3mK\u000e{W.\\5ug\u00163XM\u001c;\u0014\u0007=\u0012y\t\u0005\u0003\u0003\u0012\n]e\u0002\u0002B8\u0005'KAA!&\u0003r\u0005QQI^3oiF+X-^3\n\t\te%1\u0014\u0002\u0014\r\u0006LG.\u001e:f\u0019><w-\u001b8h\u000bZ,g\u000e\u001e\u0006\u0005\u0005+\u0013\t\b\u0006\u0003\u0003 \n\r\u0006c\u0001BQ_5\tq\u0001C\u0004\u0003\u0004F\u0002\rA!\"\u0002\u0007I,h\u000e\u0006\u0002\u0003\u0004\u0005q1\u000f[8vY\u0012\u001cf.\u00199tQ>$HC\u0001BW!\rY(qV\u0005\u0004\u0005cc(a\u0002\"p_2,\u0017M\\\u0001\u000fQ\u0006tG\r\\3T]\u0006\u00048\u000f[8u)\u0011\u0011\u0019Aa.\t\u000f\t\rE\u00071\u0001\u0003:B1!1\u0018Ba\u0003\u000bj!A!0\u000b\t\t}\u0016\u0011G\u0001\tg:\f\u0007o\u001d5pi&!!1\u0019B_\u00059\u0019f.\u00199tQ>$(+Z1eKJ\u00141\u0003S1oI2,7K\\1qg\"|G/\u0012<f]R\u001c2!\u000eBH)\u0011\u0011YM!4\u0011\u0007\t\u0005V\u0007C\u0004\u0003\u0004^\u0002\rA!/\u0003!\t\u000bGo\u00195M_\u0006$'+Z:vYR\u001c8CB\u001d{\u0005'\u0014I\u000eE\u0002|\u0005+L1Aa6}\u0005\u001d\u0001&o\u001c3vGR\u0004BAa7\u0003f:!!Q\u001cBq\u001d\u0011\tIIa8\n\u0003uL1Aa9}\u0003\u001d\u0001\u0018mY6bO\u0016LAAa:\u0003j\na1+\u001a:jC2L'0\u00192mK*\u0019!1\u001d?\u0002\u00159,XNQ1uG\",7/A\u0006ok6\u0014\u0015\r^2iKN\u0004\u0013A\u00038v[J+7m\u001c:eg\u0006Ya.^7SK\u000e|'\u000fZ:!\u0003%)G.\u00199tK\u0012,6/\u0001\u0006fY\u0006\u00048/\u001a3Vg\u0002\n\u0001B\\;n\u0005f$Xm]\u0001\n]Vl')\u001f;fg\u0002\"\"B!@\u0003\u0000\u000e\u000511AB\u0003!\r\u0011\t+\u000f\u0005\b\u0005W\u0014\u0005\u0019AA2\u0011\u001d\u0011yO\u0011a\u0001\u0003GBqAa=C\u0001\u0004\tY\nC\u0004\u0003x\n\u0003\r!a'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a!\u0002\t\r|\u0007/\u001f\u000b\u000b\u0005{\u001cya!\u0005\u0004\u0014\rU\u0001\"\u0003Bv\tB\u0005\t\u0019AA2\u0011%\u0011y\u000f\u0012I\u0001\u0002\u0004\t\u0019\u0007C\u0005\u0003t\u0012\u0003\n\u00111\u0001\u0002\u001c\"I!q\u001f#\u0011\u0002\u0003\u0007\u00111T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YB\u000b\u0003\u0002d\ru1FAB\u0010!\u0011\u0019\tca\u000b\u000e\u0005\r\r\"\u0002BB\u0013\u0007O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r%B0\u0001\u0006b]:|G/\u0019;j_:LAa!\f\u0004$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u001bU\u0011\tYj!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004B\r\u001d\u0003cA>\u0004D%\u00191Q\t?\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\f-\u000b\t\u00111\u0001\u0002d\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004NA11qJB+\u0007\u0003j!a!\u0015\u000b\u0007\rMC0\u0001\u0006d_2dWm\u0019;j_:LAaa\u0016\u0004R\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011ik!\u0018\t\u0013\t-Q*!AA\u0002\r\u0005\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0003\u0004d!I!1\u0002(\u0002\u0002\u0003\u0007\u00111M\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111M\u0001\u0007KF,\u0018\r\\:\u0015\t\t56Q\u000e\u0005\n\u0005\u0017\u0001\u0016\u0011!a\u0001\u0007\u0003\n\u0001CQ1uG\"du.\u00193SKN,H\u000e^:\u0011\u0007\t\u0005&kE\u0003S\u0007k\u001a\t\t\u0005\b\u0004x\ru\u00141MA2\u00037\u000bYJ!@\u000e\u0005\re$bAB>y\u00069!/\u001e8uS6,\u0017\u0002BB@\u0007s\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0019\u0019i!#\u000e\u0005\r\u0015%\u0002BBD\u0003#\t!![8\n\t\t\u001d8Q\u0011\u000b\u0003\u0007c\"\"!!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\tu81SBK\u0007/\u001bI\nC\u0004\u0003lV\u0003\r!a\u0019\t\u000f\t=X\u000b1\u0001\u0002d!9!1_+A\u0002\u0005m\u0005b\u0002B|+\u0002\u0007\u00111T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yja*\u0011\u000bm\fyh!)\u0011\u0017m\u001c\u0019+a\u0019\u0002d\u0005m\u00151T\u0005\u0004\u0007Kc(A\u0002+va2,G\u0007C\u0005\u0004*Z\u000b\t\u00111\u0001\u0003~\u0006\u0019\u0001\u0010\n\u0019\u0002\u00171|\u0017\r\u001a\"bi\u000eDWm\u001d\u000b\r\u0005{\u001cyka-\u0004H\u000e57\u0011\u001b\u0005\b\u0007c;\u0006\u0019\u0001B\u001f\u0003\u0015!W\r\u001c;b\u0011\u001d\u0019)l\u0016a\u0001\u0007o\u000b\u0001\"\u001b;fe\u0006$xN\u001d\t\u0007\u0007s\u001byl!1\u000e\u0005\rm&\u0002BB_\u0003#\tA!\u001e;jY&!1qKB^!\u0019\tYca1\u0002F%!1QYA\u0017\u0005\u0015\u0011\u0015\r^2i\u0011\u001d\u0019Im\u0016a\u0001\u0007\u0017\f1\u0003\\1ti\u0006\u0003\b/\u001a8e)&lWm\u001d;b[B\u0004Ra_A@\u00037Cqaa4X\u0001\u0004\u0019Y-A\nmCN$8i\\7nSR$X\rZ(gMN,G\u000fC\u0004\u0004T^\u0003\ra!6\u0002%1\f7\u000f^\"p[6LG\u000f^3e\u000bB|7\r\u001b\t\u0006w\u0006}\u00141M\u0001\u0010gR\f'\u000f\u001e)vE2L7\u000f[5oOR!11\\Bw!\u0019\u0019ina9\u0004h6\u00111q\u001c\u0006\u0005\u0007C\u001cY,\u0001\u0006d_:\u001cWO\u001d:f]RLAa!:\u0004`\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005-1\u0011^\u0005\u0005\u0007W\fiA\u0001\u0003W_&$\u0007bBBx1\u0002\u0007!\u0011K\u0001\naV\u0014G.[:iKJ\u0014Ac\u0015;beR\u0004VO\u00197jg\"LgnZ#wK:$8cA-\u0003\u0010R!1q_B}!\r\u0011\t+\u0017\u0005\b\u0007_\\\u0006\u0019\u0001B)\u0003\u00191W\u000f^;sKV\u001111\\\u0001\bMV$XO]3!\u0003\u001d\u0001XO\u00197jg\"$BAa\u0001\u0005\u0006!91q^0A\u0002\tE\u0013A\u00055b]\u0012dW\rT3bI\u0016\u00148\t[1oO\u0016$BAa\u0001\u0005\f!9AQ\u00021A\u0002\u0011=\u0011A\u00047fC\u0012,'/\u00118e\u000bB|7\r\u001b\t\u0005\u0003W!\t\"\u0003\u0003\u0005\u0014\u00055\"A\u0004'fC\u0012,'/\u00118e\u000bB|7\r[\u0001\u000eE\u0016<\u0017N\\*ikR$wn\u001e8\u0003\u001bMCW\u000f\u001e3po:,e/\u001a8u'\r\u0011'q\u0012\u000b\u0003\t;\u00012A!)c\u0003\u0015\u0019Gn\\:f\u0003=9W\r^%nC\u001e,'+Z2pe\u0012\u001cHC\u0001C\u0013!\u0019\u0019ina9\u0005(A11\u0011\u0018C\u0015\u0003\u000bJA\u0001b\u000b\u0004<\n!A*[:u\u0005Q9U\r^%nC\u001e,'+Z2pe\u0012\u001cXI^3oiN)qMa$\u00052A1A1\u0007C\u001d\tOi!\u0001\"\u000e\u000b\t\u0011]21X\u0001\tMVt7\r^5p]&!A1\bC\u001b\u0005!\u0019uN\\:v[\u0016\u0014H\u0003\u0002C \t\u0003\u00022A!)h\u0011\u001d\u0019Y0\u001ba\u0001\tK\tqA]3d_J$7/\u0006\u0002\u0005HA11\u0011\u0018C%\u0003\u000bJA\u0001b\u0013\u0004<\nI\u0011I\u001d:bs2K7\u000f^\u0001\te\u0016\u001cwN\u001d3tA\u00051\u0011mY2faR$BAa\u0001\u0005T!9AQ\u000b7A\u0002\u0011\u001d\u0012!\u00022bi\u000eD\u0007")
public class BrokerMetadataListener
implements RaftClient.Listener<ApiMessageAndVersion>,
KafkaMetricsGroup {
    private volatile BrokerMetadataListener$BatchLoadResults$ BatchLoadResults$module;
    private final int brokerId;
    private final Time time;
    private final long maxBytesBetweenSnapshots;
    private final Option<MetadataSnapshotter> snapshotter;
    private final LogContext logContext;
    private final Logger kafka$server$metadata$BrokerMetadataListener$$log;
    private final Histogram batchProcessingTimeHist;
    private final Histogram metadataBatchSizeHist;
    private volatile long _highestOffset;
    private long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    private MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image;
    private MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta;
    private Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher;
    private long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    private final KafkaEventQueue eventQueue;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String MetadataBatchSizes() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchSizes();
    }

    public static String MetadataBatchProcessingTimeUs() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public BrokerMetadataListener$BatchLoadResults$ BatchLoadResults() {
        if (this.BatchLoadResults$module == null) {
            this.BatchLoadResults$lzycompute$1();
        }
        return this.BatchLoadResults$module;
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long maxBytesBetweenSnapshots() {
        return this.maxBytesBetweenSnapshots;
    }

    public Option<MetadataSnapshotter> snapshotter() {
        return this.snapshotter;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Logger kafka$server$metadata$BrokerMetadataListener$$log() {
        return this.kafka$server$metadata$BrokerMetadataListener$$log;
    }

    private Histogram batchProcessingTimeHist() {
        return this.batchProcessingTimeHist;
    }

    private Histogram metadataBatchSizeHist() {
        return this.metadataBatchSizeHist;
    }

    public long _highestOffset() {
        return this._highestOffset;
    }

    public void _highestOffset_$eq(long x$1) {
        this._highestOffset = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    }

    private void _highestTimestamp_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = x$1;
    }

    public MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_image;
    }

    private void _image_$eq(MetadataImage x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_image = x$1;
    }

    public MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_delta;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(MetadataDelta x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = x$1;
    }

    public Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_publisher;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq(Option<MetadataPublisher> x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public long highestMetadataOffset() {
        return this._highestOffset();
    }

    /*
     * WARNING - void declaration
     */
    public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
        void append_event;
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        HandleCommitsEvent handleCommitsEvent = new HandleCommitsEvent(this, reader);
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
    }

    public boolean kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() >= this.maxBytesBetweenSnapshots();
    }

    /*
     * WARNING - void declaration
     */
    public void handleSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
        void append_event;
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        HandleSnapshotEvent handleSnapshotEvent = new HandleSnapshotEvent(this, reader);
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
    }

    public BatchLoadResults kafka$server$metadata$BrokerMetadataListener$$loadBatches(MetadataDelta delta, java.util.Iterator<Batch<ApiMessageAndVersion>> iterator, Option<Object> lastAppendTimestamp, Option<Object> lastCommittedOffset, Option<Object> lastCommittedEpoch) {
        long startTimeNs = this.time.nanoseconds();
        int numBatches = 0;
        IntRef numRecords = IntRef.create((int)0);
        long numBytes = 0L;
        while (iterator.hasNext()) {
            Batch<ApiMessageAndVersion> batch = iterator.next();
            int epoch = BoxesRunTime.unboxToInt((Object)lastCommittedEpoch.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> batch.epoch()));
            this._highestTimestamp_$eq(BoxesRunTime.unboxToLong((Object)lastAppendTimestamp.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> batch.appendTimestamp())));
            IntRef index = IntRef.create((int)0);
            batch.records().forEach(messageAndVersion -> {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(32).append("Metadata batch ").append(batch.lastOffset()).append(": processing [").append(index$1.elem + 1).append("/").append(batch.records().size()).append("]:").toString()).append(new StringBuilder(1).append(" ").append(messageAndVersion.message()).toString()).toString());
                }
                this._highestOffset_$eq(BoxesRunTime.unboxToLong((Object)lastCommittedOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> batch.baseOffset() + (long)index$1.elem)));
                delta.replay(this.highestMetadataOffset(), epoch, messageAndVersion.message());
                ++numRecords$1.elem;
                ++index$1.elem;
            });
            numBytes += (long)batch.sizeInBytes();
            this.metadataBatchSizeHist().update(batch.records().size());
            ++numBatches;
        }
        long endTimeNs = this.time.nanoseconds();
        long elapsedUs = TimeUnit.MICROSECONDS.convert(endTimeNs - startTimeNs, TimeUnit.NANOSECONDS);
        this.batchProcessingTimeHist().update(elapsedUs);
        return new BatchLoadResults(this, numBatches, numRecords.elem, elapsedUs, numBytes);
    }

    public CompletableFuture<Void> startPublishing(MetadataPublisher publisher) {
        StartPublishingEvent event = new StartPublishingEvent(this, publisher);
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)event);
        return event.future();
    }

    public void kafka$server$metadata$BrokerMetadataListener$$publish(MetadataPublisher publisher) {
        MetadataDelta delta = this.kafka$server$metadata$BrokerMetadataListener$$_delta();
        this._image_$eq(this.kafka$server$metadata$BrokerMetadataListener$$_delta().apply());
        this.kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image()));
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Publishing new metadata delta ").append(delta).append(" at offset ").append($this.kafka$server$metadata$BrokerMetadataListener$$_image().highestOffsetAndEpoch().offset).append(".").toString());
        }
        publisher.publish(delta, this.kafka$server$metadata$BrokerMetadataListener$$_image());
    }

    public void handleLeaderChange(LeaderAndEpoch leaderAndEpoch) {
    }

    /*
     * WARNING - void declaration
     */
    public void beginShutdown() {
        void beginShutdown_cleanupEvent;
        void beginShutdown_source;
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        ShutdownEvent shutdownEvent = new ShutdownEvent();
        String string = "beginShutdown";
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.beginShutdown((String)beginShutdown_source, (EventQueue.Event)beginShutdown_cleanupEvent, 0L, TimeUnit.SECONDS);
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<List<ApiMessageAndVersion>> getImageRecords() {
        void var1_1;
        void append_event;
        CompletableFuture<List<ApiMessageAndVersion>> future = new CompletableFuture<List<ApiMessageAndVersion>>();
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        GetImageRecordsEvent getImageRecordsEvent = new GetImageRecordsEvent(this, future);
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
        return var1_1;
    }

    private final void BatchLoadResults$lzycompute$1() {
        synchronized (this) {
            if (this.BatchLoadResults$module == null) {
                this.BatchLoadResults$module = new BrokerMetadataListener$BatchLoadResults$(this);
            }
            return;
        }
    }

    public BrokerMetadataListener(int brokerId, Time time, Option<String> threadNamePrefix, long maxBytesBetweenSnapshots, Option<MetadataSnapshotter> snapshotter) {
        this.brokerId = brokerId;
        this.time = time;
        this.maxBytesBetweenSnapshots = maxBytesBetweenSnapshots;
        this.snapshotter = snapshotter;
        this.logContext = new LogContext(new StringBuilder(29).append("[BrokerMetadataListener id=").append(brokerId).append("] ").toString());
        this.kafka$server$metadata$BrokerMetadataListener$$log = this.logContext().logger(BrokerMetadataListener.class);
        this.logIdent_$eq(this.logContext().logPrefix());
        this.batchProcessingTimeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this.metadataBatchSizeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this._highestOffset = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_image = MetadataImage.EMPTY;
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image());
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = None$.MODULE$;
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = 0L;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), (String)threadNamePrefix.getOrElse((Function0 & Serializable)() -> ""));
    }

    public class BatchLoadResults
    implements Product,
    Serializable {
        private final int numBatches;
        private final int numRecords;
        private final long elapsedUs;
        private final long numBytes;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int numBatches() {
            return this.numBatches;
        }

        public int numRecords() {
            return this.numRecords;
        }

        public long elapsedUs() {
            return this.elapsedUs;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public String toString() {
            return new StringBuilder(0).append(new StringBuilder(37).append(this.numBatches()).append(" batch(es) with ").append(this.numRecords()).append(" record(s) in ").append(this.numBytes()).append(" bytes ").toString()).append(new StringBuilder(34).append("ending at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer().highestMetadataOffset()).append(" in ").append(this.elapsedUs()).append(" microseconds").toString()).toString();
        }

        public BatchLoadResults copy(int numBatches, int numRecords, long elapsedUs, long numBytes) {
            return new BatchLoadResults(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer(), numBatches, numRecords, elapsedUs, numBytes);
        }

        public int copy$default$1() {
            return this.numBatches();
        }

        public int copy$default$2() {
            return this.numRecords();
        }

        public long copy$default$3() {
            return this.elapsedUs();
        }

        public long copy$default$4() {
            return this.numBytes();
        }

        public String productPrefix() {
            return "BatchLoadResults";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.numBatches());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.numRecords());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.elapsedUs());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.numBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BatchLoadResults;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "numBatches";
                }
                case 1: {
                    return "numRecords";
                }
                case 2: {
                    return "elapsedUs";
                }
                case 3: {
                    return "numBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.numBatches()), (int)this.numRecords()), (int)Statics.longHash((long)this.elapsedUs())), (int)Statics.longHash((long)this.numBytes())), (int)4);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof BatchLoadResults && ((BatchLoadResults)x$1).kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() == this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer();
                    if (!bl) break block3;
                    BatchLoadResults batchLoadResults = (BatchLoadResults)x$1;
                    if (!(this.numBatches() == batchLoadResults.numBatches() && this.numRecords() == batchLoadResults.numRecords() && this.elapsedUs() == batchLoadResults.elapsedUs() && this.numBytes() == batchLoadResults.numBytes() && batchLoadResults.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() {
            return this.$outer;
        }

        public BatchLoadResults(BrokerMetadataListener $outer, int numBatches, int numRecords, long elapsedUs, long numBytes) {
            this.numBatches = numBatches;
            this.numRecords = numRecords;
            this.elapsedUs = elapsedUs;
            this.numBytes = numBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class GetImageRecordsEvent
    extends EventQueue.FailureLoggingEvent
    implements Consumer<List<ApiMessageAndVersion>> {
        private final CompletableFuture<List<ApiMessageAndVersion>> future;
        private final ArrayList<ApiMessageAndVersion> records;
        public final /* synthetic */ BrokerMetadataListener $outer;

        @Override
        public Consumer<List<ApiMessageAndVersion>> andThen(Consumer<? super List<ApiMessageAndVersion>> x$1) {
            return Consumer.super.andThen(x$1);
        }

        public ArrayList<ApiMessageAndVersion> records() {
            return this.records;
        }

        @Override
        public void accept(List<ApiMessageAndVersion> batch) {
            this.records().addAll(batch);
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image().write((Consumer)this);
            this.future.complete(this.records());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer() {
            return this.$outer;
        }

        public GetImageRecordsEvent(BrokerMetadataListener $outer, CompletableFuture<List<ApiMessageAndVersion>> future) {
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.records = new ArrayList();
        }
    }

    public class HandleCommitsEvent
    extends EventQueue.FailureLoggingEvent {
        private final BatchReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        /*
         * WARNING - void declaration
         */
        public void run() {
            void var1_1;
            try {
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Loaded new commits: ").append(loadResults).toString());
                }
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable)publisher -> {
                HandleCommitsEvent.$anonfun$run$2(this, publisher);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().snapshotter().foreach(arg_0 -> HandleCommitsEvent.$anonfun$run$3$adapted(this, (BatchLoadResults)var1_1, arg_0));
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(HandleCommitsEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public static final /* synthetic */ void $anonfun$run$3(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() + results$1.numBytes());
            if ($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() && snapshotter.maybeStartSnapshot($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp(), $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().apply())) {
                $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(0L);
                return;
            }
        }

        public HandleCommitsEvent(BrokerMetadataListener $outer, BatchReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }

        public static final /* synthetic */ Object $anonfun$run$3$adapted(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            HandleCommitsEvent.$anonfun$run$3($this, results$1, snapshotter);
            return BoxedUnit.UNIT;
        }
    }

    public class HandleSnapshotEvent
    extends EventQueue.FailureLoggingEvent {
        private final SnapshotReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public void run() {
            try {
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Loading snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(".").toString());
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image()));
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogTimestamp())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogOffset())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.reader.lastContainedLogEpoch())));
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().finishSnapshot();
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(19).append("Loaded snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(": ").toString()).append(String.valueOf(loadResults)).toString());
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable)publisher -> {
                HandleSnapshotEvent.$anonfun$run$6(this, publisher);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(HandleSnapshotEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public HandleSnapshotEvent(BrokerMetadataListener $outer, SnapshotReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class ShutdownEvent
    extends EventQueue.FailureLoggingEvent {
        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer() {
            return BrokerMetadataListener.this;
        }

        public ShutdownEvent() {
            if (BrokerMetadataListener.this == null) {
                throw null;
            }
            super(BrokerMetadataListener.this.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class StartPublishingEvent
    extends EventQueue.FailureLoggingEvent {
        private final MetadataPublisher publisher;
        private final CompletableFuture<Void> future;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public CompletableFuture<Void> future() {
            return this.future;
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq((Option<MetadataPublisher>)new Some((Object)this.publisher));
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log().info(new StringBuilder(47).append("Starting to publish metadata events at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().highestMetadataOffset()).append(".").toString());
            try {
                this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(this.publisher);
                this.future().complete(null);
                return;
            }
            catch (Throwable e) {
                this.future().completeExceptionally(e);
                throw e;
            }
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer() {
            return this.$outer;
        }

        public StartPublishingEvent(BrokerMetadataListener $outer, MetadataPublisher publisher) {
            this.publisher = publisher;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.future = new CompletableFuture();
        }
    }
}

