/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153Aa\u0001\u0003\u0001\u0013!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C!E\t\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001475\tAC\u0003\u0002\u0016-\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005\u001d9\"B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001eL!\u0001\b\u000b\u0003-\r{gNZ5hkJ\fG/[8o-\u0006d\u0017\u000eZ1u_J\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0003\u0002\u0011Y\fG.\u001b3bi\u0016$2aI\u00154!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0011)f.\u001b;\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u0011I,7o\\;sG\u0016\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\r\r|gNZ5h\u0015\t\u0001d#\u0001\u0004d_6lwN\\\u0005\u0003e5\u0012abQ8oM&<'+Z:pkJ\u001cW\rC\u0003/\u0005\u0001\u0007A\u0007\u0005\u00036qiRT\"\u0001\u001c\u000b\u0005]r\u0011\u0001B;uS2L!!\u000f\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{\u0015j\u0011A\u0010\u0006\u0003\u007f!\ta\u0001\u0010:p_Rt\u0014BA!&\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005+\u0003")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (resource.name().isEmpty()) {
                throw new InvalidRequestException("Default topic resources are not allowed.");
            }
            Topic.validate((String)resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidRequestException(new StringBuilder(45).append("Null value not supported for topic configs : ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig$.MODULE$.validate(properties);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (new StringOps(Predef$.MODULE$.augmentString(resource.name())).nonEmpty()) {
                Integer n;
                try {
                    n = Integer.valueOf(resource.name());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
                }
                Integer brokerId = n;
                if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                    throw new InvalidRequestException("Invalid negative broker ID.");
                }
            }
        } else {
            throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
        }
    }
}

