/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;

class StandbyTaskCreator {
    private final TopologyMetadata topologyMetadata;
    private final StreamsConfig applicationConfig;
    private final StreamsMetricsImpl streamsMetrics;
    private final StateDirectory stateDirectory;
    private final ChangelogReader storeChangelogReader;
    private final ThreadCache dummyCache;
    private final Logger log;
    private final Sensor createTaskSensor;
    private final Map<TaskId, Set<TopicPartition>> unknownTasksToBeCreated = new HashMap<TaskId, Set<TopicPartition>>();

    StandbyTaskCreator(TopologyMetadata topologyMetadata, StreamsConfig applicationConfig, StreamsMetricsImpl streamsMetrics, StateDirectory stateDirectory, ChangelogReader storeChangelogReader, String threadId, Logger log) {
        this.topologyMetadata = topologyMetadata;
        this.applicationConfig = applicationConfig;
        this.streamsMetrics = streamsMetrics;
        this.stateDirectory = stateDirectory;
        this.storeChangelogReader = storeChangelogReader;
        this.log = log;
        this.createTaskSensor = ThreadMetrics.createTaskSensor(threadId, streamsMetrics);
        this.dummyCache = new ThreadCache(new LogContext(String.format("stream-thread [%s] ", Thread.currentThread().getName())), 0L, streamsMetrics);
    }

    void removeRevokedUnknownTasks(Set<TaskId> assignedTasks) {
        this.unknownTasksToBeCreated.keySet().retainAll(assignedTasks);
    }

    Map<TaskId, Set<TopicPartition>> uncreatedTasksForTopologies(Set<String> currentTopologies) {
        return Utils.filterMap(this.unknownTasksToBeCreated, t -> currentTopologies.contains(((TaskId)t.getKey()).topologyName()));
    }

    Collection<Task> createTasks(Map<TaskId, Set<TopicPartition>> tasksToBeCreated) {
        ArrayList<Task> createdTasks = new ArrayList<Task>();
        HashMap<TaskId, Set<TopicPartition>> newUnknownTasks = new HashMap<TaskId, Set<TopicPartition>>();
        for (Map.Entry<TaskId, Set<TopicPartition>> newTaskAndPartitions : tasksToBeCreated.entrySet()) {
            TaskId taskId = newTaskAndPartitions.getKey();
            Set<TopicPartition> partitions = newTaskAndPartitions.getValue();
            if (taskId.topologyName() != null && !this.topologyMetadata.namedTopologiesView().contains(taskId.topologyName())) {
                newUnknownTasks.put(taskId, partitions);
                continue;
            }
            ProcessorTopology topology = this.topologyMetadata.buildSubtopology(taskId);
            if (topology.hasStateWithChangelogs()) {
                ProcessorStateManager stateManager = new ProcessorStateManager(taskId, Task.TaskType.STANDBY, StreamsConfigUtils.eosEnabled(this.applicationConfig), this.getLogContext(taskId), this.stateDirectory, this.storeChangelogReader, topology.storeToChangelogTopic(), partitions);
                ProcessorContextImpl context = new ProcessorContextImpl(taskId, this.applicationConfig, stateManager, this.streamsMetrics, this.dummyCache);
                createdTasks.add(this.createStandbyTask(taskId, partitions, topology, stateManager, context));
            } else {
                this.log.trace("Skipped standby task {} with assigned partitions {} since it does not have any state stores to materialize", (Object)taskId, partitions);
            }
            this.unknownTasksToBeCreated.remove(taskId);
        }
        if (!newUnknownTasks.isEmpty()) {
            this.log.info("Delaying creation of tasks not yet known by this instance: {}", newUnknownTasks.keySet());
            this.unknownTasksToBeCreated.putAll(newUnknownTasks);
        }
        return createdTasks;
    }

    StandbyTask createStandbyTaskFromActive(StreamTask streamTask, Set<TopicPartition> inputPartitions) {
        InternalProcessorContext context = streamTask.processorContext();
        ProcessorStateManager stateManager = streamTask.stateMgr;
        streamTask.closeCleanAndRecycleState();
        stateManager.transitionTaskType(Task.TaskType.STANDBY, this.getLogContext(streamTask.id()));
        return this.createStandbyTask(streamTask.id(), inputPartitions, this.topologyMetadata.buildSubtopology(streamTask.id), stateManager, context);
    }

    StandbyTask createStandbyTask(TaskId taskId, Set<TopicPartition> inputPartitions, ProcessorTopology topology, ProcessorStateManager stateManager, InternalProcessorContext context) {
        StandbyTask task = new StandbyTask(taskId, inputPartitions, topology, this.topologyMetadata.getTaskConfigFor(taskId), this.streamsMetrics, stateManager, this.stateDirectory, this.dummyCache, context);
        this.log.trace("Created task {} with assigned partitions {}", (Object)taskId, inputPartitions);
        this.createTaskSensor.record();
        return task;
    }

    private LogContext getLogContext(TaskId taskId) {
        String threadIdPrefix = String.format("stream-thread [%s] ", Thread.currentThread().getName());
        String logPrefix = threadIdPrefix + String.format("%s [%s] ", "standby-task", taskId);
        return new LogContext(logPrefix);
    }
}

