/*
 * Decompiled with CFR 0.152.
 */
package kafka.internals.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class TransactionLogValue
implements ApiMessage {
    long producerId;
    short producerEpoch;
    int transactionTimeoutMs;
    byte transactionStatus;
    List<PartitionsSchema> transactionPartitions;
    long transactionLastUpdateTimestampMs;
    long transactionStartTimestampMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "Producer id in use by the transactional id"), new Field("producer_epoch", (Type)Type.INT16, "Epoch associated with the producer id"), new Field("transaction_timeout_ms", (Type)Type.INT32, "Transaction timeout in milliseconds"), new Field("transaction_status", (Type)Type.INT8, "TransactionState the transaction is in"), new Field("transaction_partitions", (Type)ArrayOf.nullable((Type)PartitionsSchema.SCHEMA_0), "Set of partitions involved in the transaction"), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, "Time the transaction was last updated"), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, "Time the transaction was started")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public TransactionLogValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public TransactionLogValue() {
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 0;
        this.transactionStatus = 0;
        this.transactionPartitions = new ArrayList<PartitionsSchema>(0);
        this.transactionLastUpdateTimestampMs = 0L;
        this.transactionStartTimestampMs = 0L;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        this.transactionTimeoutMs = _readable.readInt();
        this.transactionStatus = _readable.readByte();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            this.transactionPartitions = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionsSchema> newCollection = new ArrayList<PartitionsSchema>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionsSchema(_readable, _version));
            }
            this.transactionPartitions = newCollection;
        }
        this.transactionLastUpdateTimestampMs = _readable.readLong();
        this.transactionStartTimestampMs = _readable.readLong();
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        _writable.writeInt(this.transactionTimeoutMs);
        _writable.writeByte(this.transactionStatus);
        if (this.transactionPartitions == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.transactionPartitions.size());
            for (PartitionsSchema transactionPartitionsElement : this.transactionPartitions) {
                transactionPartitionsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeLong(this.transactionLastUpdateTimestampMs);
        _writable.writeLong(this.transactionStartTimestampMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(8);
        _size.addBytes(2);
        _size.addBytes(4);
        _size.addBytes(1);
        if (this.transactionPartitions == null) {
            _size.addBytes(4);
        } else {
            _size.addBytes(4);
            for (PartitionsSchema transactionPartitionsElement : this.transactionPartitions) {
                transactionPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        _size.addBytes(8);
        _size.addBytes(8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionLogValue)) {
            return false;
        }
        TransactionLogValue other = (TransactionLogValue)obj;
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        if (this.transactionTimeoutMs != other.transactionTimeoutMs) {
            return false;
        }
        if (this.transactionStatus != other.transactionStatus) {
            return false;
        }
        if (this.transactionPartitions == null ? other.transactionPartitions != null : !this.transactionPartitions.equals(other.transactionPartitions)) {
            return false;
        }
        if (this.transactionLastUpdateTimestampMs != other.transactionLastUpdateTimestampMs) {
            return false;
        }
        if (this.transactionStartTimestampMs != other.transactionStartTimestampMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + this.transactionTimeoutMs;
        hashCode = 31 * hashCode + this.transactionStatus;
        hashCode = 31 * hashCode + (this.transactionPartitions == null ? 0 : this.transactionPartitions.hashCode());
        hashCode = 31 * hashCode + ((int)(this.transactionLastUpdateTimestampMs >> 32) ^ (int)this.transactionLastUpdateTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.transactionStartTimestampMs >> 32) ^ (int)this.transactionStartTimestampMs);
        return hashCode;
    }

    public TransactionLogValue duplicate() {
        TransactionLogValue _duplicate = new TransactionLogValue();
        _duplicate.producerId = this.producerId;
        _duplicate.producerEpoch = this.producerEpoch;
        _duplicate.transactionTimeoutMs = this.transactionTimeoutMs;
        _duplicate.transactionStatus = this.transactionStatus;
        if (this.transactionPartitions == null) {
            _duplicate.transactionPartitions = null;
        } else {
            ArrayList<PartitionsSchema> newTransactionPartitions = new ArrayList<PartitionsSchema>(this.transactionPartitions.size());
            for (PartitionsSchema _element : this.transactionPartitions) {
                newTransactionPartitions.add(_element.duplicate());
            }
            _duplicate.transactionPartitions = newTransactionPartitions;
        }
        _duplicate.transactionLastUpdateTimestampMs = this.transactionLastUpdateTimestampMs;
        _duplicate.transactionStartTimestampMs = this.transactionStartTimestampMs;
        return _duplicate;
    }

    public String toString() {
        return "TransactionLogValue(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ", transactionStatus=" + this.transactionStatus + ", transactionPartitions=" + (this.transactionPartitions == null ? "null" : MessageUtil.deepToString(this.transactionPartitions.iterator())) + ", transactionLastUpdateTimestampMs=" + this.transactionLastUpdateTimestampMs + ", transactionStartTimestampMs=" + this.transactionStartTimestampMs + ")";
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public byte transactionStatus() {
        return this.transactionStatus;
    }

    public List<PartitionsSchema> transactionPartitions() {
        return this.transactionPartitions;
    }

    public long transactionLastUpdateTimestampMs() {
        return this.transactionLastUpdateTimestampMs;
    }

    public long transactionStartTimestampMs() {
        return this.transactionStartTimestampMs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TransactionLogValue setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public TransactionLogValue setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public TransactionLogValue setTransactionTimeoutMs(int v) {
        this.transactionTimeoutMs = v;
        return this;
    }

    public TransactionLogValue setTransactionStatus(byte v) {
        this.transactionStatus = v;
        return this;
    }

    public TransactionLogValue setTransactionPartitions(List<PartitionsSchema> v) {
        this.transactionPartitions = v;
        return this;
    }

    public TransactionLogValue setTransactionLastUpdateTimestampMs(long v) {
        this.transactionLastUpdateTimestampMs = v;
        return this;
    }

    public TransactionLogValue setTransactionStartTimestampMs(long v) {
        this.transactionStartTimestampMs = v;
        return this;
    }

    public static class PartitionsSchema
    implements Message {
        String topic;
        List<Integer> partitionIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, ""), new Field("partition_ids", (Type)new ArrayOf((Type)Type.INT32), "")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionsSchema(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionsSchema() {
            this.topic = "";
            this.partitionIds = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString((int)length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIds was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIds = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topic);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitionIds.size());
            _stringBytes = this.partitionIds.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIdsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIdsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            _size.addBytes(this.partitionIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionsSchema)) {
                return false;
            }
            PartitionsSchema other = (PartitionsSchema)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitionIds == null ? other.partitionIds != null : !this.partitionIds.equals(other.partitionIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionIds == null ? 0 : this.partitionIds.hashCode());
            return hashCode;
        }

        public PartitionsSchema duplicate() {
            PartitionsSchema _duplicate = new PartitionsSchema();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitionIds = new ArrayList<Integer>(this.partitionIds.size());
            for (Integer _element : this.partitionIds) {
                newPartitionIds.add(_element);
            }
            _duplicate.partitionIds = newPartitionIds;
            return _duplicate;
        }

        public String toString() {
            return "PartitionsSchema(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionIds=" + MessageUtil.deepToString(this.partitionIds.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionIds() {
            return this.partitionIds;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionsSchema setTopic(String v) {
            this.topic = v;
            return this;
        }

        public PartitionsSchema setPartitionIds(List<Integer> v) {
            this.partitionIds = v;
            return this;
        }
    }
}

