/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.kafka.timeline.Delta;
import org.apache.kafka.timeline.Revertable;

class Snapshot {
    private final long epoch;
    private IdentityHashMap<Revertable, Delta> map = new IdentityHashMap(4);
    private Snapshot prev = this;
    private Snapshot next = this;

    Snapshot(long epoch) {
        this.epoch = epoch;
    }

    long epoch() {
        return this.epoch;
    }

    <T extends Delta> T getDelta(Revertable owner) {
        return (T)this.map.get(owner);
    }

    void setDelta(Revertable owner, Delta delta) {
        this.map.put(owner, delta);
    }

    void handleRevert() {
        for (Map.Entry<Revertable, Delta> entry : this.map.entrySet()) {
            entry.getKey().executeRevert(this.epoch, entry.getValue());
        }
    }

    void mergeFrom(Snapshot source) {
        for (Map.Entry<Revertable, Delta> entry : source.map.entrySet()) {
            Delta destinationDelta = this.map.putIfAbsent(entry.getKey(), entry.getValue());
            if (destinationDelta == null) continue;
            destinationDelta.mergeFrom(this.epoch, entry.getValue());
        }
        source.erase();
    }

    Snapshot prev() {
        return this.prev;
    }

    Snapshot next() {
        return this.next;
    }

    void appendNext(Snapshot newNext) {
        newNext.prev = this;
        newNext.next = this.next;
        this.next.prev = newNext;
        this.next = newNext;
    }

    void erase() {
        this.map = null;
        this.next.prev = this.prev;
        this.prev.next = this.next;
        this.prev = this;
        this.next = this;
    }
}

