/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Instant;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlySessionStore;

public interface SessionStore<K, AGG>
extends StateStore,
ReadOnlySessionStore<K, AGG> {
    @Override
    default public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, Instant earliestSessionEndTime, Instant latestSessionStartTime) {
        return this.findSessions(key, ApiUtils.validateMillisecondInstant(earliestSessionEndTime, ApiUtils.prepareMillisCheckFailMsgPrefix(earliestSessionEndTime, "earliestSessionEndTime")), ApiUtils.validateMillisecondInstant(latestSessionStartTime, ApiUtils.prepareMillisCheckFailMsgPrefix(latestSessionStartTime, "latestSessionStartTime")));
    }

    @Override
    default public KeyValueIterator<Windowed<K>, AGG> backwardFindSessions(K key, Instant earliestSessionEndTime, Instant latestSessionStartTime) {
        return this.backwardFindSessions(key, ApiUtils.validateMillisecondInstant(earliestSessionEndTime, ApiUtils.prepareMillisCheckFailMsgPrefix(earliestSessionEndTime, "earliestSessionEndTime")), ApiUtils.validateMillisecondInstant(latestSessionStartTime, ApiUtils.prepareMillisCheckFailMsgPrefix(latestSessionStartTime, "latestSessionStartTime")));
    }

    @Override
    default public KeyValueIterator<Windowed<K>, AGG> findSessions(K keyFrom, K keyTo, Instant earliestSessionEndTime, Instant latestSessionStartTime) {
        return this.findSessions(keyFrom, keyTo, ApiUtils.validateMillisecondInstant(earliestSessionEndTime, ApiUtils.prepareMillisCheckFailMsgPrefix(earliestSessionEndTime, "earliestSessionEndTime")), ApiUtils.validateMillisecondInstant(latestSessionStartTime, ApiUtils.prepareMillisCheckFailMsgPrefix(latestSessionStartTime, "latestSessionStartTime")));
    }

    @Override
    default public KeyValueIterator<Windowed<K>, AGG> backwardFindSessions(K keyFrom, K keyTo, Instant earliestSessionEndTime, Instant latestSessionStartTime) {
        return this.backwardFindSessions(keyFrom, keyTo, ApiUtils.validateMillisecondInstant(earliestSessionEndTime, ApiUtils.prepareMillisCheckFailMsgPrefix(earliestSessionEndTime, "earliestSessionEndTime")), ApiUtils.validateMillisecondInstant(latestSessionStartTime, ApiUtils.prepareMillisCheckFailMsgPrefix(latestSessionStartTime, "latestSessionStartTime")));
    }

    @Override
    default public AGG fetchSession(K key, Instant earliestSessionEndTime, Instant latestSessionStartTime) {
        return this.fetchSession(key, ApiUtils.validateMillisecondInstant(earliestSessionEndTime, ApiUtils.prepareMillisCheckFailMsgPrefix(earliestSessionEndTime, "startTime")), ApiUtils.validateMillisecondInstant(latestSessionStartTime, ApiUtils.prepareMillisCheckFailMsgPrefix(latestSessionStartTime, "endTime")));
    }

    public void remove(Windowed<K> var1);

    public void put(Windowed<K> var1, AGG var2);
}

