/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;

public final class ZkProducerIdManager$ {
    public static ZkProducerIdManager$ MODULE$;

    static {
        new ZkProducerIdManager$();
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock getNewProducerIdBlock(int brokerId, KafkaZkClient zkClient, Logging logger) {
        boolean zkWriteComplete = false;
        while (!zkWriteComplete) {
            void var13_13;
            void var12_12;
            ProducerIdsBlock producerIdsBlock;
            void var7_7;
            Tuple2<Option<byte[]>, Object> tuple2 = zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option dataOpt = (Option)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (var7_7 instanceof Some) {
                byte[] data = (byte[])((Some)var7_7).value();
                ProducerIdsBlock currProducerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(data);
                logger.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(48).append("Read current producerId block ").append(currProducerIdBlock).append(", Zk path version ").append(n).toString());
                if (currProducerIdBlock.producerIdEnd() > 9223372036854774807L) {
                    logger.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(132).append("Exhausted all producerIds as the next block's end producerId is will has exceeded long type limit (current block end producerId is ").append(currProducerIdBlock.producerIdEnd()).append(")").toString());
                    throw new KafkaException("Have exhausted all producerIds.");
                }
                producerIdsBlock = new ProducerIdsBlock(brokerId, currProducerIdBlock.producerIdEnd() + 1L, 1000);
            } else if (None$.MODULE$.equals(var7_7)) {
                logger.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(77).append("There is no producerId block yet (Zk path version ").append(n).append("), creating the first block").toString());
                producerIdsBlock = new ProducerIdsBlock(brokerId, 0L, 1000);
            } else {
                throw new MatchError((Object)var7_7);
            }
            byte[] newProducerIdBlockData = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(producerIdsBlock);
            Tuple2<Object, Object> tuple22 = zkClient.conditionalUpdatePath(ProducerIdBlockZNode$.MODULE$.path(), newProducerIdBlockData, n, (Option<Function3<KafkaZkClient, String, byte[], Tuple2<Object, Object>>>)None$.MODULE$);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            boolean succeeded = tuple22._1$mcZ$sp();
            int version = tuple22._2$mcI$sp();
            zkWriteComplete = var12_12;
            if (!zkWriteComplete) continue;
            logger.info((Function0<String>)((Function0 & java.io.Serializable & Serializable)() -> ZkProducerIdManager$.$anonfun$getNewProducerIdBlock$4(producerIdsBlock, (int)var13_13)));
            return producerIdsBlock;
        }
        throw new IllegalStateException();
    }

    public static final /* synthetic */ String $anonfun$getNewProducerIdBlock$4(ProducerIdsBlock newProducerIdBlock$1, int version$1) {
        return new StringBuilder(66).append("Acquired new producerId block ").append(newProducerIdBlock$1).append(" by writing to Zk with path version ").append(version$1).toString();
    }

    private ZkProducerIdManager$() {
        MODULE$ = this;
    }
}

