/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.slf4j.Logger;

public class LeaderState<T>
implements EpochState {
    static final long OBSERVER_SESSION_TIMEOUT_MS = 300000L;
    private final int localId;
    private final int epoch;
    private final long epochStartOffset;
    private Optional<LogOffsetMetadata> highWatermark;
    private final Map<Integer, ReplicaState> voterStates = new HashMap<Integer, ReplicaState>();
    private final Map<Integer, ReplicaState> observerStates = new HashMap<Integer, ReplicaState>();
    private final Set<Integer> grantingVoters = new HashSet<Integer>();
    private final Logger log;
    private final BatchAccumulator<T> accumulator;
    private volatile boolean resignRequested = false;

    protected LeaderState(int localId, int epoch, long epochStartOffset, Set<Integer> voters, Set<Integer> grantingVoters, BatchAccumulator<T> accumulator, LogContext logContext) {
        this.localId = localId;
        this.epoch = epoch;
        this.epochStartOffset = epochStartOffset;
        this.highWatermark = Optional.empty();
        for (int voterId : voters) {
            boolean hasAcknowledgedLeader = voterId == localId;
            this.voterStates.put(voterId, new ReplicaState(voterId, hasAcknowledgedLeader));
        }
        this.grantingVoters.addAll(grantingVoters);
        this.log = logContext.logger(LeaderState.class);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator must be non-null");
    }

    public BatchAccumulator<T> accumulator() {
        return this.accumulator;
    }

    private static List<LeaderChangeMessage.Voter> convertToVoters(Set<Integer> voterIds) {
        return voterIds.stream().map(follower -> new LeaderChangeMessage.Voter().setVoterId(follower.intValue())).collect(Collectors.toList());
    }

    public void appendLeaderChangeMessage(long currentTimeMs) {
        List<LeaderChangeMessage.Voter> voters = LeaderState.convertToVoters(this.voterStates.keySet());
        List<LeaderChangeMessage.Voter> grantingVoters = LeaderState.convertToVoters(this.grantingVoters());
        LeaderChangeMessage leaderChangeMessage = new LeaderChangeMessage().setVersion(ControlRecordUtils.LEADER_CHANGE_SCHEMA_HIGHEST_VERSION).setLeaderId(this.election().leaderId()).setVoters(voters).setGrantingVoters(grantingVoters);
        this.accumulator.appendLeaderChangeMessage(leaderChangeMessage, currentTimeMs);
        this.accumulator.forceDrain();
    }

    public boolean isResignRequested() {
        return this.resignRequested;
    }

    public void requestResign() {
        this.resignRequested = true;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localId, this.voterStates.keySet());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    public Set<Integer> grantingVoters() {
        return this.grantingVoters;
    }

    public int localId() {
        return this.localId;
    }

    public Set<Integer> nonAcknowledgingVoters() {
        HashSet<Integer> nonAcknowledging = new HashSet<Integer>();
        for (ReplicaState state : this.voterStates.values()) {
            if (state.hasAcknowledgedLeader) continue;
            nonAcknowledging.add(state.nodeId);
        }
        return nonAcknowledging;
    }

    private boolean updateHighWatermark() {
        List<ReplicaState> followersByDescendingFetchOffset = this.followersByDescendingFetchOffset();
        int indexOfHw = this.voterStates.size() / 2;
        Optional<LogOffsetMetadata> highWatermarkUpdateOpt = followersByDescendingFetchOffset.get((int)indexOfHw).endOffset;
        if (highWatermarkUpdateOpt.isPresent()) {
            LogOffsetMetadata highWatermarkUpdateMetadata = highWatermarkUpdateOpt.get();
            long highWatermarkUpdateOffset = highWatermarkUpdateMetadata.offset;
            if (highWatermarkUpdateOffset > this.epochStartOffset) {
                if (this.highWatermark.isPresent()) {
                    LogOffsetMetadata currentHighWatermarkMetadata = this.highWatermark.get();
                    if (highWatermarkUpdateOffset > currentHighWatermarkMetadata.offset || highWatermarkUpdateOffset == currentHighWatermarkMetadata.offset && !highWatermarkUpdateMetadata.metadata.equals(currentHighWatermarkMetadata.metadata)) {
                        this.highWatermark = highWatermarkUpdateOpt;
                        this.log.trace("High watermark updated to {} based on indexOfHw {} and voters {}", new Object[]{this.highWatermark, indexOfHw, followersByDescendingFetchOffset});
                        return true;
                    }
                    if (highWatermarkUpdateOffset < currentHighWatermarkMetadata.offset) {
                        this.log.error("The latest computed high watermark {} is smaller than the current value {}, which suggests that one of the voters has lost committed data. Full voter replication state: {}", new Object[]{highWatermarkUpdateOffset, currentHighWatermarkMetadata.offset, this.voterStates.values()});
                        return false;
                    }
                    return false;
                }
                this.highWatermark = highWatermarkUpdateOpt;
                this.log.trace("High watermark set to {} based on indexOfHw {} and voters {}", new Object[]{this.highWatermark, indexOfHw, followersByDescendingFetchOffset});
                return true;
            }
        }
        return false;
    }

    public boolean updateLocalState(long fetchTimestamp, LogOffsetMetadata logOffsetMetadata) {
        return this.updateReplicaState(this.localId, fetchTimestamp, logOffsetMetadata);
    }

    public boolean updateReplicaState(int replicaId, long fetchTimestamp, LogOffsetMetadata logOffsetMetadata) {
        if (replicaId < 0) {
            return false;
        }
        ReplicaState state = this.getReplicaState(replicaId);
        state.updateFetchTimestamp(fetchTimestamp);
        return this.updateEndOffset(state, logOffsetMetadata);
    }

    public List<Integer> nonLeaderVotersByDescendingFetchOffset() {
        return this.followersByDescendingFetchOffset().stream().filter(state -> state.nodeId != this.localId).map(state -> state.nodeId).collect(Collectors.toList());
    }

    private List<ReplicaState> followersByDescendingFetchOffset() {
        return new ArrayList<ReplicaState>(this.voterStates.values()).stream().sorted().collect(Collectors.toList());
    }

    private boolean updateEndOffset(ReplicaState state, LogOffsetMetadata endOffsetMetadata) {
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset > endOffsetMetadata.offset) {
                if (state.nodeId == this.localId) {
                    throw new IllegalStateException("Detected non-monotonic update of local end offset: " + currentEndOffset.offset + " -> " + endOffsetMetadata.offset);
                }
                this.log.warn("Detected non-monotonic update of fetch offset from nodeId {}: {} -> {}", new Object[]{state.nodeId, currentEndOffset.offset, endOffsetMetadata.offset});
            }
        });
        state.endOffset = Optional.of(endOffsetMetadata);
        state.hasAcknowledgedLeader = true;
        return this.isVoter(state.nodeId) && this.updateHighWatermark();
    }

    public void addAcknowledgementFrom(int remoteNodeId) {
        ReplicaState voterState = this.ensureValidVoter(remoteNodeId);
        voterState.hasAcknowledgedLeader = true;
    }

    private ReplicaState ensureValidVoter(int remoteNodeId) {
        ReplicaState state = this.voterStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Unexpected acknowledgement from non-voter " + remoteNodeId);
        }
        return state;
    }

    public long epochStartOffset() {
        return this.epochStartOffset;
    }

    private ReplicaState getReplicaState(int remoteNodeId) {
        ReplicaState state = this.voterStates.get(remoteNodeId);
        if (state == null) {
            this.observerStates.putIfAbsent(remoteNodeId, new ReplicaState(remoteNodeId, false));
            return this.observerStates.get(remoteNodeId);
        }
        return state;
    }

    Map<Integer, Long> getVoterEndOffsets() {
        return LeaderState.getReplicaEndOffsets(this.voterStates);
    }

    Map<Integer, Long> getObserverStates(long currentTimeMs) {
        this.clearInactiveObservers(currentTimeMs);
        return LeaderState.getReplicaEndOffsets(this.observerStates);
    }

    private static <R extends ReplicaState> Map<Integer, Long> getReplicaEndOffsets(Map<Integer, R> replicaStates) {
        return replicaStates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReplicaState)e.getValue()).endOffset.map(logOffsetMetadata -> logOffsetMetadata.offset).orElse(-1L)));
    }

    private void clearInactiveObservers(long currentTimeMs) {
        this.observerStates.entrySet().removeIf(integerReplicaStateEntry -> currentTimeMs - ((ReplicaState)integerReplicaStateEntry.getValue()).lastFetchTimestamp.orElse(-1L) >= 300000L);
    }

    private boolean isVoter(int remoteNodeId) {
        return this.voterStates.containsKey(remoteNodeId);
    }

    @Override
    public boolean canGrantVote(int candidateId, boolean isLogUpToDate) {
        this.log.debug("Rejecting vote request from candidate {} since we are already leader in epoch {}", (Object)candidateId, (Object)this.epoch);
        return false;
    }

    public String toString() {
        return String.format("Leader(localId=%s, epoch=%s, epochStartOffset=%s, highWatermark=%s, voterStates=%s)", this.localId, this.epoch, this.epochStartOffset, this.highWatermark, this.voterStates);
    }

    @Override
    public String name() {
        return "Leader";
    }

    @Override
    public void close() {
        this.accumulator.close();
    }

    private static class ReplicaState
    implements Comparable<ReplicaState> {
        final int nodeId;
        Optional<LogOffsetMetadata> endOffset;
        OptionalLong lastFetchTimestamp;
        boolean hasAcknowledgedLeader;

        public ReplicaState(int nodeId, boolean hasAcknowledgedLeader) {
            this.nodeId = nodeId;
            this.endOffset = Optional.empty();
            this.lastFetchTimestamp = OptionalLong.empty();
            this.hasAcknowledgedLeader = hasAcknowledgedLeader;
        }

        void updateFetchTimestamp(long currentFetchTimeMs) {
            this.lastFetchTimestamp = OptionalLong.of(Math.max(this.lastFetchTimestamp.orElse(-1L), currentFetchTimeMs));
        }

        @Override
        public int compareTo(ReplicaState that) {
            if (this.endOffset.equals(that.endOffset)) {
                return Integer.compare(this.nodeId, that.nodeId);
            }
            if (!this.endOffset.isPresent()) {
                return 1;
            }
            if (!that.endOffset.isPresent()) {
                return -1;
            }
            return Long.compare(that.endOffset.get().offset, this.endOffset.get().offset);
        }

        public String toString() {
            return String.format("ReplicaState(nodeId=%s, endOffset=%s, lastFetchTimestamp=%s, hasAcknowledgedLeader=%s)", this.nodeId, this.endOffset, this.lastFetchTimestamp, this.hasAcknowledgedLeader);
        }
    }
}

