/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u00193\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004R\u0001\u0001\u0006IA\u0012\u0005\b%\u0002\u0001\r\u0011\"\u0003T\u0011\u001d9\u0006\u00011A\u0005\naCaA\u0018\u0001!B\u0013!\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000e\u0001Q\u0001\n)DQA\u001c\u0001\u0005\u0002=DQa\u001f\u0001\u0005\u0002=DQ! \u0001\u0005\u0002=DQa \u0001\u0005\u0002=Da!a\u0001\u0001\t\u0003y\u0007BBA\u0004\u0001\u0011\u0005q\u000e\u0003\u0004\u0002\f\u0001!\ta\u001c\u0005\u0007\u0003\u001f\u0001A\u0011A8\t\r\u0005M\u0001\u0001\"\u0001p\u0011\u0019\t9\u0002\u0001C\u0001_\"1\u00111\u0004\u0001\u0005\u0002=Da!a\b\u0001\t\u0003y\u0007BBA\u0012\u0001\u0011\u0005q\u000e\u0003\u0004\u0002(\u0001!\ta\u001c\u0005\u0007\u0003W\u0001A\u0011A8\t\r\u0005=\u0002\u0001\"\u0001p\u0011\u0019\t\u0019\u0004\u0001C\u0001_\"1\u0011q\u0007\u0001\u0005\u0002=Da!a\u000f\u0001\t\u0003y\u0007BBA \u0001\u0011\u0005q\u000e\u0003\u0004\u0002D\u0001!\ta\u001c\u0005\u0007\u0003\u000f\u0002A\u0011A8\t\r\u0005-\u0003\u0001\"\u0001p\u0011\u0019\ty\u0005\u0001C\u0001_\"1\u00111\u000b\u0001\u0005\u0002=Da!a\u0016\u0001\t\u0003y\u0007BBA.\u0001\u0011\u0005q\u000e\u0003\u0004\u0002`\u0001!\ta\u001c\u0005\u0007\u0003G\u0002A\u0011A8\t\r\u0005\u001d\u0004\u0001\"\u0001p\u0011\u0019\tY\u0007\u0001C\u0001_\"1\u0011q\u000e\u0001\u0005\u0002=Da!a\u001d\u0001\t\u0003y\u0007BBA<\u0001\u0011\u0005q\u000e\u0003\u0004\u0002|\u0001!\ta\u001c\u0005\u0007\u0003\u007f\u0002A\u0011A8\t\r\u0005\r\u0005\u0001\"\u0001p\u0011\u0019\t9\t\u0001C\u0001_\nAB*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016$Vm\u001d;\u000b\u0005M\"\u0014!B3q_\u000eD'BA\u001b7\u0003\u0019\u0019XM\u001d<fe*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0005B\u00111\tA\u0007\u0002e\u0005\u0011A\u000f]\u000b\u0002\rB\u0011qiT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0007G>lWn\u001c8\u000b\u0005]Z%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001\u0015%\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0016\u0003Q\u0003\"aO+\n\u0005Yc$\u0001\u0002'p]\u001e\f\u0001\u0003\\8h\u000b:$wJ\u001a4tKR|F%Z9\u0015\u0005ec\u0006CA\u001e[\u0013\tYFH\u0001\u0003V]&$\bbB/\u0006\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0014!\u00047pO\u0016sGm\u00144gg\u0016$\b%\u0001\u0006dQ\u0016\u001c7\u000e]8j]R,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IR\n1b\u00195fG.\u0004x.\u001b8ug&\u0011am\u0019\u0002\u0016\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115fG.\u0004x.\u001b8u\u0003-\u0019\u0007.Z2la>Lg\u000e\u001e\u0011\u0002\u000b\r\f7\r[3\u0016\u0003)\u0004\"aQ6\n\u00051\u0014$\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW-\u0001\u0004dC\u000eDW\rI\u0001\u0012i\u0016\u001cH\u000f\u0015:fm&|Wo]#q_\u000eDG#A-)\u0005-\t\bC\u0001:z\u001b\u0005\u0019(B\u0001;v\u0003\r\t\u0007/\u001b\u0006\u0003m^\fqA[;qSR,'O\u0003\u0002y\u001b\u0006)!.\u001e8ji&\u0011!p\u001d\u0002\u0005)\u0016\u001cH/A\u0013tQ>,H\u000eZ!eI\u0016\u0003xn\u00195B]\u0012lUm]:bO\u0016|eMZ:fiR{7)Y2iK\"\u0012A\"]\u0001/g\"|W\u000f\u001c3SKR,(O\u001c'pO\u0016sGm\u00144gg\u0016$\u0018J\u001a'bi\u0016\u001cH/\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002\u000ec\u0006!4\u000f[8vY\u0012\u0014V\r^;s]VsG-\u001a4j]\u0016$wJ\u001a4tKRLe-\u00168eK\u001aLg.\u001a3Fa>\u001c\u0007NU3rk\u0016\u001cH/\u001a3)\u00059\t\u0018AQ:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016dunZ#oI>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012q\"]\u00011g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oON#\u0018M\u001d;PM\u001a\u001cX\r^:)\u0005A\t\u0018\u0001P:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016|eMZ:fi\u001a{'/\u0011'fC\u0012,'/\u00129pG\"|enY3Ji\"\u000b7OQ3f]\u0006\u001b8/[4oK\u0012D#!E9\u0002QMDw.\u001e7e%\u0016$XO\u001d8V]N,\b\u000f]8si\u0016$\u0017J\u001a(p\u000bB|7\r\u001b*fG>\u0014H-\u001a3)\u0005I\t\u0018AQ:i_VdGMU3ukJtWK\\:vaB|'\u000f^3e\u0013\u001atu.\u00129pG\"\u0014VmY8sI\u0016$\u0017I\u001c3V]\u0012,g-\u001b8fI\u0016\u0003xn\u00195SKF,Xm\u001d;fI\"\u00121#]\u00019g\"|W\u000f\u001c3SKR,(O\u001c$jeN$X\t]8dQ&3'+Z9vKN$X\rZ#q_\u000eDG*Z:t)\"\fgNR5sgR,\u0005o\\2iQ\t!\u0012/A\u001btQ>,H\u000e\u001a+sk:\u001c\u0017\r^3JM6\u000bGo\u00195j]\u001e,\u0005o\\2i\u0005V$X)\u0019:mS\u0016\u00148\u000b^1si&twm\u00144gg\u0016$\bFA\u000br\u0003!\u001b\bn\\;mI\u001e+GOR5sgR|eMZ:fi>37+\u001e2tKF,XM\u001c;Fa>\u001c\u0007n\u00165f]>3gm]3u%\u0016\fX/Z:uK\u00124uN\u001d)sKZLw.^:Fa>\u001c\u0007\u000e\u000b\u0002\u0017c\u0006)5\u000f[8vY\u0012\u0014V\r^;s]:+\u0007\u0010^!wC&d\u0017M\u00197f\u000bB|7\r[%g)\",'/Z%t\u001d>,\u00050Y2u\u000bB|7\r\u001b$peRCWm\u00148f%\u0016\fX/Z:uK\u0012D#aF9\u0002eMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016,\u0005o\\2i\u0003:$7\u000b^1si>3gm]3u\u0013\u001aLE\u000fR5e\u001d>$8\t[1oO\u0016D#\u0001G9\u0002\u000bNDw.\u001e7e%\u0016$XO\u001d8J]Z\fG.\u001b3PM\u001a\u001cX\r^%g\u000bB|7\r[%t%\u0016\fX/Z:uK\u0012<\u0006.[2i\u0013Ntu\u000e^\"veJ,g\u000e\u001e7z)J\f7m[3eQ\tI\u0012/A\u0015tQ>,H\u000eZ*vaB|'\u000f^#q_\u000eD7\u000f\u00165bi\u0012{gj\u001c;Ti\u0006\u0014HO\u0012:p[j+'o\u001c\u0015\u00035E\f1e\u001d5pk2$\u0007+\u001a:tSN$X\t]8dQN\u0014U\r^<fK:Len\u001d;b]\u000e,7\u000f\u000b\u0002\u001cc\u0006Q3\u000f[8vY\u0012,eNZ8sG\u0016luN\\8u_:L7-\u00197ms&s7M]3bg&tw-\u00129pG\"\u001c\bF\u0001\u000fr\u0003%\u001a\bn\\;mI\u0016sgm\u001c:dK>3gm]3ug&s7M]3bg\u0016luN\\8u_:L7-\u00197ms\"\u0012Q$]\u00015g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003NdU-\u00193feN\u001c\u0005.\u00198hK6\u000bg.\u001f+j[\u0016\u001c\bF\u0001\u0010r\u0003i\u001a\bn\\;mI&s7M]3bg\u0016\fe\u000e\u001a+sC\u000e\\W\t]8dQN\f5OR8mY><XM\u001d*fG\u0016Lg/Z:NC:LX*Z:tC\u001e,7\u000f\u000b\u0002 c\u0006I4\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:P]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a'bi\u0016\u001cH/\u00128ue&,7\u000f\u000b\u0002!c\u0006\u00194\u000f[8vY\u0012\u0004&/Z:feZ,'+Z:fi>3gm]3u\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3ti&3wJ\\3Fq&\u001cHo\u001d\u0015\u0003CE\f\u0011h\u001d5pk2$W\u000b\u001d3bi\u0016\u001c\u0016M^3e\u001f\u001a47/\u001a;XQ\u0016twJ\u001a4tKR$vn\u00117fCJ$v.S:CKR<X-\u001a8Fa>\u001c\u0007n\u001d\u0015\u0003EE\fQe\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u0016\u000b'\u000f\\=)\u0005\r\n\u0018aK:i_VdGMT8u\u00072,\u0017M]!osRD\u0017N\\4JM>3gm]3u)>4\u0015N]:u\u001f\u001a47/\u001a;)\u0005\u0011\n\u0018!K:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH\u000f\u000b\u0002&c\u000694\u000f[8vY\u0012,\u0006\u000fZ1uK>3gm]3u\u0005\u0016$x/Z3o\u000bB|7\r\u001b\"pk:$\u0017M]5fg>s7\t\\3be\u0016\u000b'\u000f\\5fgRD#AJ9\u0002qMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:ue!\u0012q%]\u0001<g\"|W\u000f\u001c3SKR\f\u0017N\u001c'bi\u0016\u001cH/\u00129pG\"|en\u00117fCJ\fE\u000e\\#be2LWm\u001d;B]\u0012,\u0006\u000fZ1uK&#8o\u00144gg\u0016$\bF\u0001\u0015r\u0003]\u001a\bn\\;mI\u0012\u0013x\u000e]#oiJLWm\u001d\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001etUm^3ti\"\u0012\u0011&]\u0001\u0016g\"|W\u000f\u001c3DY\u0016\f'/\u00117m\u000b:$(/[3tQ\tQ\u0013/A\u0018tQ>,H\u000e\u001a(piJ+7/\u001a;Fa>\u001c\u0007\u000eS5ti>\u0014\u0018\u0010S3bI&3WK\u001c3fM&tW\r\u001a)bgN,G\r\u000b\u0002,c\u0006y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ssR\u000b\u0017\u000e\\%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u0012A&]\u0001#g\"|W\u000f\u001c3GKR\u001c\u0007\u000eT1uKN$X\t]8dQ>3W)\u001c9us\u000e\u000b7\r[3)\u00055\n\u0018\u0001I:i_VdGMR3uG\",e\u000eZ(gMN,Go\u00144F[B$\u0018pQ1dQ\u0016D#AL9\u0002?MDw.\u001e7e\u00072,\u0017M]#be2LWm\u001d;P]\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u00020c\u0006i2\u000f[8vY\u0012\u001cE.Z1s\u0019\u0006$Xm\u001d;P]\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u00021c\u0002")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private long logEndOffset = 0L;
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Iterable<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private long logEndOffset() {
        return this.logEndOffset;
    }

    private void logEndOffset_$eq(long x$1) {
        this.logEndOffset = x$1;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        this.logEndOffset_$eq(11L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        this.logEndOffset_$eq(14L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1);
        Assertions.assertEquals((Object)expectedEpochEndOffset, (Object)epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.logEndOffset_$eq(9L);
        this.cache().assign(2, this.logEndOffset());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)this.logEndOffset(), (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        this.logEndOffset_$eq(73L);
        Tuple2 offsetFor = this.cache().endOffsetFor(-1);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        this.logEndOffset_$eq(17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.logEndOffset_$eq(100L);
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(1, 7L);
        this.logEndOffset_$eq(8L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.logEndOffset_$eq(5L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(2, 5L);
        this.logEndOffset_$eq(10L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.logEndOffset_$eq(1L);
        this.cache().assign(0, 1L);
        this.logEndOffset_$eq(2L);
        this.cache().assign(0, 2L);
        this.logEndOffset_$eq(3L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(0, this.logEndOffset()), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(1, 3L);
        this.logEndOffset_$eq(4L);
        this.cache().assign(1, 4L);
        this.logEndOffset_$eq(5L);
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(1, this.logEndOffset()), (Object)this.cache().endOffsetFor(1));
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(2, 7L);
        this.logEndOffset_$eq(8L);
        this.cache().assign(2, 8L);
        this.logEndOffset_$eq(9L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

