/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000f\u001e\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r1\u0003\u0001\u0015)\u00036\u0011\u001di\u0005A1A\u0005\u00029CaA\u0015\u0001!\u0002\u0013y\u0005\"B*\u0001\t\u0003\"\u0006\"B0\u0001\t\u0003\"\u0006\"\u00023\u0001\t\u0003)\u0007BB@\u0001\t\u0003\n\t\u0001\u0003\u0004\u0002\u001c\u0001!\t\u0001\u0016\u0005\u0007\u0003K\u0001A\u0011\u0001+\t\r\u0005%\u0002\u0001\"\u0001U\u000f\u001d\tI$\bE\u0001\u0003w1a\u0001H\u000f\t\u0002\u0005u\u0002BB\u0018\u0010\t\u0003\t)E\u0002\u0004\u0002H=\u0001\u0011\u0011\n\u0005\u0007_E!\t!!\u0017\t\u0017\u0005}\u0013\u00031AA\u0002\u0013\u0005\u0011\u0011\r\u0005\f\u0003\u0003\u000b\u0002\u0019!a\u0001\n\u0003\t\u0019\tC\u0006\u0002rE\u0001\r\u0011!Q!\n\u0005\r\u0004\"CAH#\u0001\u0007I\u0011AAI\u0011%\tI*\u0005a\u0001\n\u0003\tY\n\u0003\u0005\u0002 F\u0001\u000b\u0015BAJ\u0011\u001d\t\t+\u0005C\u0001\u0003GCq!!-\u0012\t\u0003\t\u0019\f\u0003\u0004\u0002HF!\t\u0001\u0016\u0002'\u0003\u0012l\u0017N\\\"mS\u0016tGoV5uQB{G.[2jKNLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\u0011aeH\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002)K\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u00023\u00015\tQ$\u0001\u0004dY&,g\u000e^\u000b\u0002kA\u0011a\u0007Q\u0007\u0002o)\u0011\u0001(O\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003um\nqa\u00197jK:$8O\u0003\u0002!y)\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\tuGA\u0003BI6Lg.\u0001\u0006dY&,g\u000e^0%KF$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u000e\t\t\u00111\u00016\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003=\u0003\"!\u0012)\n\u0005E3%aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)1/\u001a;VaR\tA\t\u000b\u0002\b-B\u0011q+X\u0007\u00021*\u0011a$\u0017\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002]}\u0005)!.\u001e8ji&\u0011a\f\u0017\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005!\t\u0007CA,c\u0013\t\u0019\u0007LA\u0005BMR,'/R1dQ\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\ta\r\u0005\u0003hY:LX\"\u00015\u000b\u0005%T\u0017\u0001B;uS2T\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n\u0019Q*\u00199\u0011\u0005=4hB\u00019u!\t\th)D\u0001s\u0015\t\u0019\u0018%\u0001\u0004=e>|GOP\u0005\u0003k\u001a\u000ba\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QO\u0012\t\u0003uvl\u0011a\u001f\u0006\u0003y*\fA\u0001\\1oO&\u0011ap\u001f\u0002\u0007\u001f\nTWm\u0019;\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!a\u0001\u0011\r\u0005\u0015\u00111BA\b\u001b\t\t9AC\u0002\u0002\n\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti!a\u0002\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bH\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005e\u00111\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u000buKN$h+\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\u0007-\ty\u0002E\u0002X\u0003CI1!a\tY\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u0007\u0002 \u0005\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGfD3!DA\u0010Q\u001d\u0001\u0011qFA\u001b\u0003o\u00012aVA\u0019\u0013\r\t\u0019\u0004\u0017\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\u0018AJ!e[&t7\t\\5f]R<\u0016\u000e\u001e5Q_2L7-[3t\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0011!gD\n\u0004\u001f\u0005}\u0002cA#\u0002B%\u0019\u00111\t$\u0003\r\u0005s\u0017PU3g)\t\tYD\u0001\u0004Q_2L7-_\n\u0005#e\fY\u0005\u0005\u0003\u0002N\u0005USBAA(\u0015\u0011\t\t&a\u0015\u0002\rA|G.[2z\u0015\r\t)bO\u0005\u0005\u0003/\nyEA\tBYR,'oQ8oM&<\u0007k\u001c7jGf$\"!a\u0017\u0011\u0007\u0005u\u0013#D\u0001\u0010\u0003\u001d\u0019wN\u001c4jON,\"!a\u00191\t\u0005\u0015\u0014Q\u000e\t\u0007_\u0006\u001dd.!\u001b\n\u00055D\b\u0003BA6\u0003[b\u0001\u0001B\u0006\u0002pU\t\t\u0011!A\u0003\u0002\u0005M$aA0%c\u0005A1m\u001c8gS\u001e\u001c\b%\u0005\u0003\u0002v\u0005m\u0004cA#\u0002x%\u0019\u0011\u0011\u0010$\u0003\u000f9{G\u000f[5oOB\u0019Q)! \n\u0007\u0005}dIA\u0002B]f\f1bY8oM&<7o\u0018\u0013fcR\u0019A)!\"\t\u0011-#\u0012\u0011!a\u0001\u0003\u000f\u0003D!!#\u0002\u000eB1q.a\u001ao\u0003\u0017\u0003B!a\u001b\u0002\u000e\u0012a\u0011qNAC\u0003\u0003\u0005\tQ!\u0001\u0002t\u000511\r\\8tK\u0012,\"!a%\u0011\u0007\u0015\u000b)*C\u0002\u0002\u0018\u001a\u0013qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cX\rZ0%KF$2\u0001RAO\u0011!Yu#!AA\u0002\u0005M\u0015aB2m_N,G\rI\u0001\nG>tg-[4ve\u0016$2\u0001RAS\u0011\u001d\ty&\u0007a\u0001\u0003O\u0003D!!+\u0002.B)q\r\u001c8\u0002,B!\u00111NAW\t1\ty+!*\u0002\u0002\u0003\u0005)\u0011AA:\u0005\ryFEM\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019A)!.\t\u000f\u0005]&\u00041\u0001\u0002:\u0006y!/Z9vKN$X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002<\u0006\u0005g\u0002BA'\u0003{KA!a0\u0002P\u0005\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\n\t\u0005\r\u0017Q\u0019\u0002\u0010%\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uC*!\u0011qXA(\u0003\u0015\u0019Gn\\:f\u0001")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client = null;
    private final int brokerCount;

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), 15000L);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        configs.foreach((Function1 & Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().head()).config().brokerId()));
        List brokerConfigEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(requestMetadata.resource().name())), (Function0 & Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

