/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r)\u0003\u0001\u0015)\u00035\u0011\u001dY\u0005A1A\u0005\u00021Ca!\u0017\u0001!\u0002\u0013i\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007G\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0011\u0004A\u0011I3\t\u000bM\u0004A\u0011A3\t\u000ba\u0004A\u0011A3\t\u000bi\u0004A\u0011A3\t\u000bq\u0004A\u0011A3\t\u000by\u0004A\u0011B@\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u00111\u000b\u0001\u0005\n\u0005U\u0003BBA/\u0001\u0011%Q\rC\u0004\u0002`\u0001!I!!\u0019\t\r\u0005u\u0004\u0001\"\u0001f\u0011\u0019\t\t\t\u0001C\u0001K\"1\u0011Q\u0011\u0001\u0005\u0002\u0015Da!!#\u0001\t\u0003)\u0007BBAG\u0001\u0011\u0005Q\r\u0003\u0004\u0002\u0012\u0002!\t!\u001a\u0005\u0007\u0003+\u0003A\u0011A3\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"I\u0011q\u0018\u0001\u0012\u0002\u0013%\u0011\u0011\u0019\u0005\n\u0003/\u0004\u0011\u0013!C\u0005\u00033Dq!!'\u0001\t\u0013\ti\u000eC\u0004\u0002z\u0002!I!a?\t\r\t]\u0001\u0001\"\u0001f\u0011\u0019\u0011Y\u0002\u0001C\u0001K\nyA)\u001a7fi\u0016$v\u000e]5d)\u0016\u001cHO\u0003\u0002$I\u0005)\u0011\rZ7j]*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#BA\u0016%\u0003\tQ8.\u0003\u0002.U\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0012\u0002\u000fM,'O^3sgV\tA\u0007E\u00026uqj\u0011A\u000e\u0006\u0003oa\n!bY8mY\u0016\u001cG/[8o\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e7\u0005\r\u0019V-\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\naa]3sm\u0016\u0014\u0018BA!?\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\t\"\u0003\"!\u0012$\u000e\u0003aJ!a\u0012\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+\u0005i\u0005\u0003\u0002(R'Zk\u0011a\u0014\u0006\u0003!Z\n\u0011\"[7nkR\f'\r\\3\n\u0005I{%aA'baB\u0011Q\tV\u0005\u0003+b\u00121!\u00138u!\rqukU\u0005\u00031>\u0013A\u0001T5ti\u0006QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA\u0005iR\r\u001f9fGR,GMU3qY&\u001c\u0017MR;mY\u0006\u001b8/[4o[\u0016tG/F\u0001]!\u0011q\u0015kU/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0011!m\u0018\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018AH3ya\u0016\u001cG/\u001a3SKBd\u0017nY1Gk2d\u0017i]:jO:lWM\u001c;!\u0003!!X-\u0019:E_^tG#\u0001#)\u0005%9\u0007C\u00015r\u001b\u0005I'B\u00016l\u0003\r\t\u0007/\u001b\u0006\u0003Y6\fqA[;qSR,'O\u0003\u0002o_\u0006)!.\u001e8ji*\t\u0001/A\u0002pe\u001eL!A]5\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\t;fgR$U\r\\3uKR{\u0007/[2XSRD\u0017\t\u001c7BY&4XMU3qY&\u001c\u0017m\u001d\u0015\u0003\u0015U\u0004\"\u0001\u001b<\n\u0005]L'\u0001\u0002+fgR\f!\u0006^3tiJ+7/^7f\t\u0016dW\r^3U_BL7mV5uQJ+7m\u001c<fe\u0016$gi\u001c7m_^,'\u000f\u000b\u0002\fk\u0006IC/Z:u%\u0016\u001cX/\\3EK2,G/\u001a+pa&\u001cwJ\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJD#\u0001D;\u0002UQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e#ve&tw\rR3mKR,Gk\u001c9jG\"\u0012Q\"^\u0001\u0013o\u0006LG/\u00168uS2$v\u000e]5d\u000f>tW\rF\u0003E\u0003\u0003\tI\u0002C\u0004\u0002\u00049\u0001\r!!\u0002\u0002\u0017\u0005$W.\u001b8DY&,g\u000e\u001e\t\u0005\u0003\u000f\t)\"\u0004\u0002\u0002\n)\u00191%a\u0003\u000b\t\u00055\u0011qB\u0001\bG2LWM\u001c;t\u0015\r)\u0013\u0011\u0003\u0006\u0004\u0003'y\u0017AB1qC\u000eDW-\u0003\u0003\u0002\u0018\u0005%!!B!e[&t\u0007bBA\u000e\u001d\u0001\u0007\u0011QD\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004B!a\b\u0002.9!\u0011\u0011EA\u0015!\r\t\u0019\u0003O\u0007\u0003\u0003KQ1!a\n'\u0003\u0019a$o\\8u}%\u0019\u00111\u0006\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tY\u0003O\u0001\"m\u0016\u0014\u0018NZ=SK\u0006\u001c8/[4o[\u0016tGOR1jYN4uN]'jgNLgn\u001a\u000b\b\t\u0006]\u0012\u0011HA%\u0011\u001d\t\u0019a\u0004a\u0001\u0003\u000bAq!a\u000f\u0010\u0001\u0004\ti$A\u0005qCJ$\u0018\u000e^5p]B!\u0011qHA#\u001b\t\t\tE\u0003\u0003\u0002D\u0005=\u0011AB2p[6|g.\u0003\u0003\u0002H\u0005\u0005#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u0017z\u0001\u0019AA'\u00031\u0011X-Y:tS\u001etW.\u001a8u!\u0011\t9!a\u0014\n\t\u0005E\u0013\u0011\u0002\u0002\u0019\u001d\u0016<\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018!D4fi\u000e{g\u000e\u001e:pY2,'\u000f\u0006\u0002\u0002XA)Q)!\u0017='&\u0019\u00111\f\u001d\u0003\rQ+\b\u000f\\33\u0003Y)gn];sK\u000e{g\u000e\u001e:pY2,'/\u0012=jgR\u001c\u0018\u0001H4fi\u0006cGNU3qY&\u001c\u0017m\u001d$s_6\f5o]5h]6,g\u000e\u001e\u000b\u0007\u0003G\ny'a\u001d\u0011\r\u0005}\u0011QMA5\u0013\u0011\t9'!\r\u0003\u0007M+G\u000fE\u0002_\u0003WJ1!!\u001c`\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0011\u001d\t\tH\u0005a\u0001\u0003;\tQ\u0001^8qS\u000eDq!!\u001e\u0013\u0001\u0004\t9(\u0001\u0006bgNLwM\\7f]R\u0004r!a\b\u0002zM\u000bY(C\u0002S\u0003c\u00012!\u000e\u001eT\u0003-\"Xm\u001d;J]\u000e\u0014X-Y:f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007FA\nv\u0003\u0005\"Xm\u001d;EK2,G/\u001a+pa&\u001cG)\u001e:j]\u001e\fE\r\u001a)beRLG/[8oQ\t!R/A\u0011uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002\u0016k\u0006qB/Z:u%\u0016\u001c'/Z1uKR{\u0007/[2BMR,'\u000fR3mKRLwN\u001c\u0015\u0003-U\f!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&tw\rV8qS\u000eD#aF;\u00025Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5DY\u0016\fg.\u001a:)\u0005a)\u0018!\n;fgR$U\r\\3uKR{\u0007/[2BYJ,\u0017\rZ=NCJ\\W\rZ!t\t\u0016dW\r^3eQ\tIR/A\rde\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014Hc\u0002\u001b\u0002\u001e\u0006}\u0015\u0011\u0016\u0005\b\u0003cR\u0002\u0019AA\u000f\u0011%\t\tK\u0007I\u0001\u0002\u0004\t\u0019+\u0001\neK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007cA#\u0002&&\u0019\u0011q\u0015\u001d\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0016\u000e\u0011\u0002\u0003\u0007\u0011QV\u0001\u0012e\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcBA\u0010\u0003s\u001a\u0016q\u0016\t\u0006\u0003c\u000bYl\u0015\b\u0005\u0003g\u000b9L\u0004\u0003\u0002$\u0005U\u0016\"A\u001d\n\u0007\u0005e\u0006(A\u0004qC\u000e\\\u0017mZ3\n\u0007a\u000biLC\u0002\u0002:b\n1e\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002D*\"\u00111UAcW\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\u0013Ut7\r[3dW\u0016$'bAAiq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aI2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$C-\u001a4bk2$HeM\u000b\u0003\u00037TC!!,\u0002FR9A'a8\u0002b\u0006]\bbBA9;\u0001\u0007\u0011Q\u0004\u0005\b\u0003Gl\u0002\u0019AAs\u00035\u0011'o\\6fe\u000e{gNZ5hgB!QGOAt!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\fA!\u001e;jY*\u0011\u0011\u0011_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002v\u0006-(A\u0003)s_B,'\u000f^5fg\"9\u00111V\u000fA\u0002\u00055\u0016!C<sSR,G)\u001e9t)!\tiP!\u0001\u0003\u0006\t%\u0001\u0003B\u001b;\u0003\u007f\u0004R!RA-'NCaAa\u0001\u001f\u0001\u0004\u0019\u0016a\u00028v[.+\u0017p\u001d\u0005\u0007\u0005\u000fq\u0002\u0019A*\u0002\u000f9,X\u000eR;qg\"9!1\u0002\u0010A\u0002\t5\u0011a\u00017pOB!!q\u0002B\n\u001b\t\u0011\tBC\u0002\u0003\f\u0011JAA!\u0006\u0003\u0012\t\u0019Aj\\4\u0002-Q,7\u000f\u001e#jg\u0006\u0014G.\u001a#fY\u0016$X\rV8qS\u000eD#aH;\u0002CQ,7\u000f\u001e#fY\u0016$\u0018N\\4QCJ$\u0018.\u00197ms\u0012+G.\u001a;fIR{\u0007/[2)\u0005\u0001*\b")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment = (scala.collection.immutable.Map)this.expectedReplicaAssignment().map((Function1 & Serializable)x0$1 -> {
        void apply_removingReplicas;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int k = x0$1._1$mcI$sp();
        List v = (List)x0$1._2();
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_addingReplicas = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Object var4_4 = null;
        seq = null;
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment((Seq)v, apply_addingReplicas, (Seq)apply_removingReplicas));
        return tuple2;
    });

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$2(this, follower, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas 0,1 have not deleted log.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$6(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Admin path /admin/delete_topics/test path deleted even when a follower replica is down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Controller doesn't exist")));
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$4(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Admin path /admin/delete_topics/test path deleted even when a replica is down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$5(topicPartition$2, x$2)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)servers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)servers, SecurityProtocol.PLAINTEXT));
        try (Admin adminClient = Admin.create((Properties)props);){
            this.waitUntilTopicGone(adminClient, "test");
            this.verifyReassignmentFailsForMissing(adminClient, new TopicPartition(topic, 0), new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3))));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    private void waitUntilTopicGone(Admin adminClient, String topicName) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$waitUntilTopicGone$1(adminClient, topicName)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$waitUntilTopicGone$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private void verifyReassignmentFailsForMissing(Admin adminClient, TopicPartition partition, NewPartitionReassignment reassignment) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> adminClient.alterPartitionReassignments(Collections.singletonMap(partition, Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get());
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
    }

    private Tuple2<KafkaServer, Object> getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Controller doesn't exist");
        }));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$ensureControllerExists$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Controller should eventually exist");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((IterableOnceOps)assignment.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq seq = (Seq)((Seq)x0$1._2()).map((Function1 & Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)));
            return seq;
        })).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        void var9_12;
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(topicPartition$3, x$3)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)servers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, this.expectedReplicaAssignment());
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$8((KafkaServer)var9_12, topic, allReplicasForTopic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$9(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)servers, SecurityProtocol.PLAINTEXT));
        Admin adminClient = Admin.create((Properties)props);
        try {
            adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        }
        catch (ExecutionException executionException) {}
        var9_12.shutdown();
        this.ensureControllerExists();
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$10(this, n)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"The new controller should not have the failed controller id");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        follower.startup();
        var9_12.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
        adminClient.close();
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$6)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        follower.shutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$2(this, follower)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$3(follower));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, 2, (Option)x$7, x$8);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$4(this, newPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Replica logs not for new partition [test,1] not deleted after delete topic is complete.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$82 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, 2, (Option)x$7, x$82);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))), (String)"Replica logs not deleted after delete topic is complete");
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$1(this, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().deleteTopic("test2"));
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2(this, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((boolean)this.zkClient().topicExists(topic), (String)"Topic test mistakenly deleted");
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Log log = (Log)qual$1.getLog(topicPartition, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, 0L, x$5);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        Assertions.assertThrows(TopicAlreadyMarkedForDeletionException.class, () -> this.adminZkClient().deleteTopic(topic));
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        brokerConfigs.foreach((Function1 & Serializable)x$11 -> x$11.setProperty("delete.topic.enable", Boolean.toString(deleteTopicEnabled)));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$4(topicPartition$6, x$12)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$13 -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)x$13)));
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic("test");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$1(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$14))));
        Assertions.assertTrue((boolean)this.zkClient().topicExists(topic), (String)"Topic path disappeared");
        Assertions.assertTrue((boolean)this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0)).isDefined(), (String)"Leader should exist for topic test");
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable)x$16 -> {
            x$16.startup();
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"No controller is elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaServer x$1) {
        LogManager qual$1 = x$1.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$2(DeleteTopicTest $this, KafkaServer follower$1, TopicPartition topicPartition$1) {
        return ((IterableOnceOps)$this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower$1, s)))).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition$1, x$1)));
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$5() {
        return "Replicas 0,1 have not deleted log.";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$6(DeleteTopicTest $this, String topic$1) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$1);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$7() {
        return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$2, int controllerId$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$4(DeleteTopicTest $this, String topic$2) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicOnControllerFailover$5() {
        return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((List)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$5(TopicPartition topicPartition$2, KafkaServer x$2) {
        LogManager qual$1 = x$2.getLogManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$2, x$22).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTopicGone$1(Admin adminClient$1, String topicName$1) {
        try {
            adminClient$1.describeTopics(Collections.singletonList(topicName$1)).all().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$waitUntilTopicGone$2(String topicName$1) {
        return new StringBuilder(25).append("Topic ").append(topicName$1).append(" should be deleted.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerExists$1(DeleteTopicTest $this) {
        try {
            $this.getController();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureControllerExists$2() {
        return "Controller should eventually exist";
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$2, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$2), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((List)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(TopicPartition topicPartition$3, KafkaServer x$3) {
        LogManager qual$1 = x$3.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$8(KafkaServer controller$1, String topic$4, scala.collection.immutable.Set allReplicasForTopic$1) {
        Set replicasInDeletionSuccessful = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Set offlineReplicas = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)OfflineReplica$.MODULE$);
        scala.collection.immutable.Set set = allReplicasForTopic$1;
        SetOps setOps = replicasInDeletionSuccessful.union(offlineReplicas);
        return !(set != null ? !set.equals(setOps) : setOps != null);
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$9(String topic$4) {
        return new StringBuilder(95).append("Not all replicas for topic ").append(topic$4).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$10(DeleteTopicTest $this, int previousControllerId$1) {
        Tuple2<KafkaServer, Object> tuple2 = $this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer cfr_ignored_0 = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        return n != previousControllerId$1;
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$11() {
        return "The new controller should not have the failed controller id";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$6) {
        return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$2(DeleteTopicTest $this, KafkaServer follower$2) {
        return $this.zkClient().getBroker(follower$2.config().brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$3(KafkaServer follower$2) {
        return new StringBuilder(33).append("Follower ").append(follower$2.config().brokerId()).append(" was not removed from ZK").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(TopicPartition newPartition$1, KafkaServer x$7) {
        LogManager qual$3 = x$7.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$1, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$4(DeleteTopicTest $this, TopicPartition newPartition$1) {
        return $this.servers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(newPartition$1, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$6() {
        return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$8) {
        LogManager qual$3 = x$8.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$2, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$4, KafkaServer x$9) {
        LogManager qual$1 = x$9.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$4, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$1(DeleteTopicTest $this, TopicPartition topicPartition$4) {
        return $this.servers().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition$4, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testRecreateTopicAfterDeletion$3() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$3(TopicPartition topicPartition$5, KafkaServer x$10) {
        LogManager qual$1 = x$10.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$5, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$2(DeleteTopicTest $this, TopicPartition topicPartition$5) {
        return $this.servers().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(topicPartition$5, x$10)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$4() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$4(TopicPartition topicPartition$6, KafkaServer x$12) {
        LogManager qual$1 = x$12.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$6, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$5() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, Log log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(counter$1.elem).getBytes(), Integer.toString(key).getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, Log log$1, int x$13) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$1(DeleteTopicTest $this, String topic$6) {
        return !$this.zkClient().isTopicMarkedForDeletion(topic$6);
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$14) {
        LogManager qual$1 = x$14.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$7, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaServer x$17) {
        return x$17.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$3(DeleteTopicTest $this) {
        return $this.servers().exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDeletingPartiallyDeletedTopic$5() {
        return "No controller is elected";
    }
}

