/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaCache;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.Sanitizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u001d4Aa\u0003\u0007\u0001'!I\u0001\u0005\u0001BC\u0002\u0013\u0005A\"\t\u0005\ta\u0001\u0011\t\u0011)A\u0005E!I\u0011\u0007\u0001BC\u0002\u0013\u0005AB\r\u0005\ts\u0001\u0011\t\u0011)A\u0005g!I!\b\u0001BC\u0002\u0013\u0005Ab\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005y!)\u0011\t\u0001C\u0001\u0005\")q\t\u0001C\u0001\u0011\")!\f\u0001C\u00017\")!\r\u0001C\u0001G\nQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe*\u0011QBD\u0001\t[\u0016$\u0018\rZ1uC*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0011\u0003\u0015)H/\u001b7t\u0013\tyBDA\u0004M_\u001e<\u0017N\\4\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\u0005\u0011\u0003CA\u0012.\u001d\t!3F\u0004\u0002&U9\u0011a%K\u0007\u0002O)\u0011\u0001FE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00051r\u0011\u0001D)v_R\fg)Y2u_JL\u0018B\u0001\u00180\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011AFD\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u00014!\t!t'D\u00016\u0015\t1\u0004#A\u0004oKR<xN]6\n\u0005a*$\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u000bcV|G/Y\"bG\",W#\u0001\u001f\u0011\u0005urT\"\u0001\u0007\n\u0005}b!\u0001E\"mS\u0016tG/U;pi\u0006\u001c\u0015m\u00195f\u0003-\tXo\u001c;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005u\u0002\u0001\"\u0002\u0011\b\u0001\u0004\u0011\u0003\"B\u0019\b\u0001\u0004\u0019\u0004\"\u0002\u001e\b\u0001\u0004a\u0014!\u00055b]\u0012dW-U;pi\u0006\u0014VmY8sIR\u0011\u0011\n\u0014\t\u0003+)K!a\u0013\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\"\u0001\rAT\u0001\fcV|G/\u0019*fG>\u0014H\r\u0005\u0002P16\t\u0001K\u0003\u0002\u000e#*\u0011!kU\u0001\u0007G>lWn\u001c8\u000b\u0005E!&BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001eL!!\u0017)\u0003\u0017E+x\u000e^1SK\u000e|'\u000fZ\u0001\u000eQ\u0006tG\r\\3JaF+x\u000e^1\u0015\u0007%c\u0016\rC\u0003^\u0013\u0001\u0007a,\u0001\u0005ja\u0016sG/\u001b;z!\tit,\u0003\u0002a\u0019\tY\u0011+^8uC\u0016sG/\u001b;z\u0011\u0015i\u0015\u00021\u0001O\u0003UA\u0017M\u001c3mKV\u001bXM]\"mS\u0016tG/U;pi\u0006$2!\u00133g\u0011\u0015)'\u00021\u0001_\u0003-\tXo\u001c;b\u000b:$\u0018\u000e^=\t\u000b5S\u0001\u0019\u0001(")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private final ClientQuotaCache quotaCache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public ClientQuotaCache quotaCache() {
        return this.quotaCache;
    }

    public void handleQuotaRecord(QuotaRecord quotaRecord) {
        Map entityMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaRecord.entity().forEach(entityData -> entityMap.put((Object)entityData.entityType(), (Object)entityData.entityName()));
        if (entityMap.contains((Object)"ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entityMap.apply((Object)"ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            this.handleIpQuota((QuotaEntity)product, quotaRecord);
            return;
        }
        if (entityMap.contains((Object)"user") || entityMap.contains((Object)"client-id")) {
            String userVal = (String)entityMap.getOrElse((Object)"user", (Function0 & Serializable)() -> null);
            String clientIdVal = (String)entityMap.getOrElse((Object)"client-id", (Function0 & Serializable)() -> null);
            Product userClientEntity = entityMap.contains((Object)"user") && entityMap.contains((Object)"client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entityMap.contains((Object)"user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            this.handleUserClientQuota((QuotaEntity)userClientEntity, quotaRecord);
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Ignoring unsupported quota entity ").append(quotaRecord.entity()).toString());
    }

    public void handleIpQuota(QuotaEntity ipEntity, QuotaRecord quotaRecord) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            Some some;
            String ip = ((IpEntity)ipEntity).ip();
            try {
                some = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unable to resolve address ").append(ip).toString());
            }
            none$ = some;
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        String string = quotaRecord.key();
        String string2 = "connection_creation_rate";
        if (string == null || !string.equals(string2)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaRecord.key()).append(" for entity ").append(ipEntity).toString());
            return;
        }
        this.quotaCache().updateQuotaCache(ipEntity, quotaRecord.key(), quotaRecord.value(), quotaRecord.remove());
        None$ newValue = quotaRecord.remove() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)quotaRecord.value())).map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1);
        this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)none$, (Option<Object>)newValue);
    }

    /*
     * WARNING - void declaration
     */
    public void handleUserClientQuota(QuotaEntity quotaEntity, QuotaRecord quotaRecord) {
        void var14_16;
        void var13_15;
        Some some;
        None$ none$;
        ClientQuotaManager clientQuotaManager;
        block28: {
            block24: {
                block27: {
                    block25: {
                        block26: {
                            String string = quotaRecord.key();
                            switch (string == null ? 0 : string.hashCode()) {
                                case -1805480786: {
                                    if ("consumer_byte_rate".equals(string)) {
                                        break;
                                    }
                                    break block24;
                                }
                                case -965904822: {
                                    if (!"request_percentage".equals(string)) break block24;
                                    break block25;
                                }
                                case -832502454: {
                                    if (!"producer_byte_rate".equals(string)) break block24;
                                    break block26;
                                }
                                case -748852909: {
                                    if (!"controller_mutation_rate".equals(string)) break block24;
                                    break block27;
                                }
                                default: {
                                    break block24;
                                }
                            }
                            clientQuotaManager = this.quotaManagers().fetch();
                            break block28;
                        }
                        clientQuotaManager = this.quotaManagers().produce();
                        break block28;
                    }
                    clientQuotaManager = this.quotaManagers().request();
                    break block28;
                }
                clientQuotaManager = this.quotaManagers().controllerMutation();
                break block28;
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaRecord.key()).append(" for entity ").append(quotaEntity).toString());
            return;
        }
        if (quotaEntity instanceof UserEntity) {
            String user = ((UserEntity)quotaEntity).user();
            none$ = None$.MODULE$;
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (DefaultUserEntity$.MODULE$.equals(quotaEntity)) {
            none$ = None$.MODULE$;
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof ClientIdEntity) {
            String clientId = ((ClientIdEntity)quotaEntity).clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = None$.MODULE$;
        } else if (DefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = None$.MODULE$;
        } else if (quotaEntity instanceof ExplicitUserExplicitClientIdEntity) {
            ExplicitUserExplicitClientIdEntity explicitUserExplicitClientIdEntity = (ExplicitUserExplicitClientIdEntity)quotaEntity;
            String user = explicitUserExplicitClientIdEntity.user();
            String clientId = explicitUserExplicitClientIdEntity.clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (quotaEntity instanceof ExplicitUserDefaultClientIdEntity) {
            String user = ((ExplicitUserDefaultClientIdEntity)quotaEntity).user();
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (quotaEntity instanceof DefaultUserExplicitClientIdEntity) {
            String clientId = ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else {
            boolean bl = quotaEntity instanceof IpEntity ? true : DefaultIpEntity$.MODULE$.equals(quotaEntity);
            if (bl) {
                throw new IllegalStateException("Should not see IP quota entities here");
            }
            throw new MatchError((Object)quotaEntity);
        }
        Option sanitizedUser = (Option)some;
        Option sanitizedClientId = (Option)none$;
        None$ quotaValue = quotaRecord.remove() ? None$.MODULE$ : new Some((Object)new Quota(quotaRecord.value(), true));
        clientQuotaManager.updateQuota((Option<String>)var13_15, (Option<String>)var14_16.map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1)), (Option<String>)var14_16, (Option<Quota>)quotaValue);
        this.quotaCache().updateQuotaCache(quotaEntity, quotaRecord.key(), quotaRecord.value(), quotaRecord.remove());
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas, ClientQuotaCache quotaCache) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        this.quotaCache = quotaCache;
    }
}

