/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import kafka.security.auth.Acl;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AuthorizerWrapper$ {
    public static final AuthorizerWrapper$ MODULE$ = new AuthorizerWrapper$();

    public Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ResourceType$.MODULE$.fromJava(filter.patternFilter().resourceType())).flatMap((Function1 & Serializable)resourceType -> Try$.MODULE$.apply((Function0 & Serializable)() -> SecurityUtils.parseKafkaPrincipal((String)filter.entryFilter().principal())).flatMap((Function1 & Serializable)principal -> Try$.MODULE$.apply((Function0 & Serializable)() -> Operation$.MODULE$.fromJava(filter.entryFilter().operation())).flatMap((Function1 & Serializable)operation -> Try$.MODULE$.apply((Function0 & Serializable)() -> PermissionType$.MODULE$.fromJava(filter.entryFilter().permissionType())).map((Function1 & Serializable)permissionType -> {
            Resource resource = new Resource((ResourceType)resourceType, filter.patternFilter().name(), filter.patternFilter().patternType());
            Acl acl = new Acl((KafkaPrincipal)principal, (PermissionType)permissionType, filter.entryFilter().host(), (Operation)operation);
            return new Tuple3(permissionType, (Object)resource, (Object)acl);
        }).map((Function1 & Serializable)x$1 -> {
            if (x$1 == null) {
                throw new MatchError(null);
            }
            Resource resource = (Resource)x$1._2();
            Acl acl = (Acl)x$1._3();
            Tuple2 tuple2 = new Tuple2((Object)resource, (Object)acl);
            return tuple2;
        }))));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            right = package$.MODULE$.Left().apply((Object)new ApiError(Errors.INVALID_REQUEST, throwable.getMessage()));
        } else if (try_ instanceof Success) {
            Tuple2 s = (Tuple2)((Success)try_).value();
            right = package$.MODULE$.Right().apply((Object)s);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public AclBinding convertToAclBinding(Resource resource, Acl acl) {
        ResourcePattern resourcePattern = new ResourcePattern(resource.resourceType().toJava(), resource.name(), resource.patternType());
        return new AclBinding(resourcePattern, this.convertToAccessControlEntry(acl));
    }

    public AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava());
    }

    public Acl convertToAcl(AccessControlEntry ace) {
        return new Acl(SecurityUtils.parseKafkaPrincipal((String)ace.principal()), PermissionType$.MODULE$.fromJava(ace.permissionType()), ace.host(), Operation$.MODULE$.fromJava(ace.operation()));
    }

    public Resource convertToResource(ResourcePattern resourcePattern) {
        return new Resource(ResourceType$.MODULE$.fromJava(resourcePattern.resourceType()), resourcePattern.name(), resourcePattern.patternType());
    }

    private AuthorizerWrapper$() {
    }
}

