/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import kafka.tools.ClusterTool$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.reflect.ScalaSignature;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001U2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\ty1\t\\;ti\u0016\u0014Hk\\8m)\u0016\u001cHO\u0003\u0002\t\u0013\u0005)Ao\\8mg*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u000f\u0005\u0011B/Z:u!JLg\u000e^\"mkN$XM]%e)\u0005I\u0002C\u0001\b\u001b\u0013\tYrB\u0001\u0003V]&$\bF\u0001\u0002\u001e!\tqr%D\u0001 \u0015\t\u0001\u0013%A\u0002ba&T!AI\u0012\u0002\u000f),\b/\u001b;fe*\u0011A%J\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002M\u0005\u0019qN]4\n\u0005!z\"\u0001\u0002+fgR\f\u0011\u0004^3ti\u000ecWo\u001d;feR{wn\u00147e)>D\u0015M^3JI\"\u00121!H\u0001\u0015i\u0016\u001cH/\u00168sK\u001eL7\u000f^3s\u0005J|7.\u001a:)\u0005\u0011i\u0012a\u000b;fgRdUmZ1ds6{G-Z\"mkN$XM]\"b]:|G/\u00168sK\u001eL7\u000f^3s\u0005J|7.\u001a:)\u0005\u0015i\u0002\u0006\u0002\u00011gQ\u0002\"AH\u0019\n\u0005Iz\"a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002y\u0001")
public class ClusterToolTest {
    @Test
    public void testPrintClusterId() {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId("QtNwvtfVQ3GEFpzOmDEE-w").build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool$.MODULE$.clusterIdCommand(new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"Cluster ID: QtNwvtfVQ3GEFpzOmDEE-w\n", (Object)stream.toString());
    }

    @Test
    public void testClusterTooOldToHaveId() {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId(null).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool$.MODULE$.clusterIdCommand(new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"No cluster ID found. The Kafka version is probably too old.\n", (Object)stream.toString());
    }

    @Test
    public void testUnregisterBroker() {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(true).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool$.MODULE$.unregisterCommand(new PrintStream(stream), (Admin)adminClient, 0);
        Assertions.assertEquals((Object)"Broker 0 is no longer registered.\n", (Object)stream.toString());
    }

    @Test
    public void testLegacyModeClusterCannotUnregisterBroker() {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(false).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool$.MODULE$.unregisterCommand(new PrintStream(stream), (Admin)adminClient, 0);
        Assertions.assertEquals((Object)"The target cluster does not support the broker unregistration API.\n", (Object)stream.toString());
    }
}

