/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003B\u0002\u0016\u0001A\u0003%A\u0005C\u0004,\u0001\t\u0007I\u0011A\u0012\t\r1\u0002\u0001\u0015!\u0003%\u0011\u001di\u0003\u00011A\u0005\u00029BqA\u0010\u0001A\u0002\u0013\u0005q\b\u0003\u0004F\u0001\u0001\u0006Ka\f\u0005\b\r\u0002\u0001\r\u0011\"\u0001H\u0011\u001dY\u0005\u00011A\u0005\u00021CaA\u0014\u0001!B\u0013A\u0005\"B(\u0001\t\u0003\u0002\u0006\"\u00020\u0001\t\u0003\u0002\u0006\"B2\u0001\t\u0003\u0001\u0006\"\u00025\u0001\t\u0003\u0001\u0006\"\u00026\u0001\t\u0013Y'A\u0005'fC\u0012,'/\u00127fGRLwN\u001c+fgRT!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u000b\u0002\u0005i\\\u0017BA\u000f\u001b\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011AE\u0001\nEJ|7.\u001a:JIF*\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0004\u0013:$\u0018A\u00032s_.,'/\u001332A\u0005I!M]8lKJLEMM\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0013aB:feZ,'o]\u000b\u0002_A\u0019\u0001\u0007O\u001e\u000f\u0005E2dB\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0017\u0003\u0019a$o\\8u}%\tq%\u0003\u00028M\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u0005\r\u0019V-\u001d\u0006\u0003o\u0019\u0002\"!\t\u001f\n\u0005u\u0012\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001i\u0011\t\u0003K\u0005K!A\u0011\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\t\u001e\t\t\u00111\u00010\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005a2\u000f^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$U\r^3di\u0016$W#\u0001%\u0011\u0005\u0015J\u0015B\u0001&'\u0005\u001d\u0011un\u001c7fC:\f\u0001e\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,Gm\u0018\u0013fcR\u0011\u0001)\u0014\u0005\b\t*\t\t\u00111\u0001I\u0003u\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012\u0004\u0013!B:fiV\u0003H#\u0001!)\u00051\u0011\u0006CA*]\u001b\u0005!&BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bqA[;qSR,'O\u0003\u0002Z5\u0006)!.\u001e8ji*\t1,A\u0002pe\u001eL!!\u0018+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ti\u0001\r\u0005\u0002TC&\u0011!\r\u0016\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004^3ti2+\u0017\rZ3s\u000b2,7\r^5p]\u0006sG-\u00129pG\"D#AD3\u0011\u0005M3\u0017BA4U\u0005\u0011!Vm\u001d;\u0002UQ,7\u000f\u001e'fC\u0012,'/\u00127fGRLwN\\,ji\"\u001cF/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"\u0012q\"Z\u0001\u001dgR\fG.Z\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195DC2d'-Y2l)\t\u0001E\u000eC\u0003n!\u0001\u0007a.\u0001\u0005sKN\u0004xN\\:f!\tyw/D\u0001q\u0015\t\t(/\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0019H/\u0001\u0004d_6lwN\u001c\u0006\u0003+UT!A\u001e.\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\bO\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\u0002")
public class LeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private boolean staleControllerEpochDetected = false;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        configProps1.put("unclean.leader.election.enable", "true");
        configProps2.put("unclean.leader.election.enable", "true");
        KafkaServer server1 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps1), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps2), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionAndEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertTrue((leader1 == 0 ? 1 : 0) != 0, (String)"Leader should be broker 0");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        ((KafkaServer)this.servers().head()).shutdown();
        KafkaZkClient x$1 = this.zkClient();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader1));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, topic, partitionId, x$5, (Option<Object>)x$4, x$6);
        int leaderEpoch2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)1, (int)leader2, (String)"Leader must move to broker 1");
        Assertions.assertEquals((int)(leaderEpoch1 + 2), (int)leaderEpoch2, (String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 2))})));
        ((KafkaServer)this.servers().head()).startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$1(this, topic, partitionId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.servers().last()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        KafkaZkClient x$7 = this.zkClient();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, topic, partitionId, x$11, (Option<Object>)x$10, x$12);
        int leaderEpoch3 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)0, (int)leader3, (String)"Leader must return to 0");
        Assertions.assertEquals((int)(leaderEpoch2 + 2), (int)leaderEpoch3, (String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 2))})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("leader Epoch: ").append(leaderEpoch1).toString());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader1)})));
        Assertions.assertTrue((leader1 == 0 || leader1 == 1 ? 1 : 0) != 0, (String)"Leader could be broker 0 or broker 1");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, TestUtils$.MODULE$.boundPort$default$2()), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.node(listenerName), Iterable$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokers((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            .colon.colon partitionStates = new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(partitionId).setControllerEpoch(2).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(false), (List)Nil$.MODULE$);
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, staleControllerEpoch, ((KafkaServer)this.servers().apply(this.brokerId2())).kafkaController().brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), Collections.singletonMap(topic, Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            controllerChannelManager.sendRequest(this.brokerId2(), (AbstractControlRequest.Builder)requestBuilder, (Function1 & Serializable & scala.Serializable)response -> {
                this.staleControllerEpochCallback(response);
                return BoxedUnit.UNIT;
            });
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.staleControllerEpochDetected()) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)LeaderElectionTest.$anonfun$testLeaderElectionWithStaleControllerEpoch$9());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)this.staleControllerEpochDetected(), (String)"Stale controller epoch not detected by the broker");
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private void staleControllerEpochCallback(AbstractResponse response) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response;
        Errors errors = leaderAndIsrResponse.error();
        boolean bl = Errors.STALE_CONTROLLER_EPOCH.equals(errors);
        this.staleControllerEpochDetected_$eq(bl);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return x$1.isr().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$1(LeaderElectionTest $this, String topic$1, int partitionId$1) {
        return ((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo(topic$1, partitionId$1).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$2(x$1)));
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionAndEpoch$3() {
        return "Inconsistent metadata after second broker startup";
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionWithStaleControllerEpoch$9() {
        return "Controller epoch should be stale";
    }

    public LeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

