/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001E\u0011\u0019Y\u0005\u0001)A\u0005\u000b\"9A\n\u0001b\u0001\n\u0003i\u0005B\u0002.\u0001A\u0003%a\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011%\t\u0007\u00011AA\u0002\u0013\u0005!\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0001O\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019!\b\u0001)A\u0005a\"9Q\u000f\u0001b\u0001\n\u0003y\u0007B\u0002<\u0001A\u0003%\u0001\u000fC\u0004x\u0001\t\u0007I\u0011A8\t\ra\u0004\u0001\u0015!\u0003q\u0011\u0015I\b\u0001\"\u0001{\u0011\u0019\ti\u0001\u0001C\u0001u\"1\u0011q\u0003\u0001\u0005\u0002iDa!a\u0007\u0001\t\u0003Q\bBBA\u0010\u0001\u0011\u0005!\u0010\u0003\u0004\u0002$\u0001!\tA\u001f\u0005\u0007\u0003O\u0001A\u0011\u0001>\t\r\u0005-\u0002\u0001\"\u0001{\u0011\u0019\ty\u0003\u0001C\u0001u\"9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\u0007\u00037\u0002A\u0011\u0001>\t\r\u0005}\u0003\u0001\"\u0001{\u0011\u0019\t\u0019\u0007\u0001C\u0001u\"9\u0011q\r\u0001\u0005\n\u0005%\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\u0007\u0003{\u0002A\u0011\u0001>\t\r\u0005\u0005\u0005\u0001\"\u0001{\u0011\u0019\t)\t\u0001C\u0001u\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-%aE!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:UKN$(BA\u0015+\u0003\u0019\u0019XM\u001d<fe*\t1&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002mA\u0011q\u0007A\u0007\u0002Q\u0005)Ao\u001c9jGV\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!A/[7f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%+\u0003\u0015)H/\u001b7t\u0013\tQuI\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012A\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003\u0019FS!AU*\u0002\r\r|W.\\8o\u0015\tYCK\u0003\u0002V-\u00061\u0011\r]1dQ\u0016T\u0011aV\u0001\u0004_J<\u0017BA-Q\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tEJ|7.\u001a:JIV\tQ\f\u0005\u00020=&\u0011q\f\r\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003\r\u0004\"a\u000e3\n\u0005\u0015D#\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faC\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe~#S-\u001d\u000b\u0003Q.\u0004\"aL5\n\u0005)\u0004$\u0001B+oSRDq\u0001\\\u0006\u0002\u0002\u0003\u00071-A\u0002yIE\n1C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u0002\n1\u0001\u001e91+\u0005\u0001\bCA9s\u001b\u0005\t\u0016BA:R\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fA\u0001\u001e91A\u0005\u0019A\u000f]\u0019\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nQa]3ukB$\u0012\u0001\u001b\u0015\u0003'q\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005\u0019\u0011\r]5\u000b\t\u0005\r\u0011QA\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9AV\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u0017q(A\u0003\"fM>\u0014X-R1dQ\u0006IA/Z:u\u0005\u0006\u001c\u0018n\u0019\u0015\u0004)\u0005E\u0001cA?\u0002\u0014%\u0019\u0011Q\u0003@\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cHo\u0014<fe^\u0014\u0018\u000e^3XSRD\u0017N\u001c\"bi\u000eD\u0007fA\u000b\u0002\u0012\u0005yA/Z:u'&tw\r\\3CCR\u001c\u0007\u000eK\u0002\u0017\u0003#\tq\u0003^3ti\u0006+H\u000f[8sSj\fG/[8o\r\u0006LG.\u001a3)\u0007]\t\t\"\u0001\u000buKN$8\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u00041\u0005E\u0011!\u0005;fgR,fn\u001b8po:\u001cVM\u001d<fe\"\u001a\u0011$!\u0005\u0002AQ,7\u000f\u001e*fiJLxJ\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u00045\u0005E\u0011A\t;fgR\u0014V\r\u001e:z\u001f:,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8FeJ|'\u000fK\u0002\u001c\u0003#\t\u0001\u0004^3tiJ+GO]=P]R{\u0007\u000fT3wK2,%O]8s)\rA\u0017q\u0007\u0005\b\u0003sa\u0002\u0019AA\u001e\u0003\u0015)'O]8s!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!#\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002F\u0005}\"AB#se>\u00148/\u0001\ruKN$(+\u001a;ss>sWI\u001d:peJ+7\u000f]8og\u0016$2\u0001[A&\u0011\u001d\ti%\ba\u0001\u0003\u001f\n\u0001B]3ta>t7/\u001a\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK*\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011LA*\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f\u0001\u0004^3ti&sg/\u00197jIV\u0003H-\u0019;f-\u0016\u00148/[8oQ\rq\u0012\u0011C\u0001\u001ai\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eK\u0002 \u0003#\tq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0007\u0001\n\t\"A\ndQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8FeJ|'\u000fF\u0002i\u0003WBq!!\u000f\"\u0001\u0004\tY$\u0001\nuKN$\b+\u0019:uSRLwN\\#se>\u0014HCBA9\u0003o\nY\bE\u00028\u0003gJ1!!\u001e)\u0005=\tE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\bBBA=E\u0001\u0007\u0001/\u0001\u0002ua\"9\u0011\u0011\b\u0012A\u0002\u0005m\u0012a\u0004;fgR|e.Z%o\r2Lw\r\u001b;)\u0007\r\n\t\"\u0001\u0010uKN$\b+\u0019:uSRLwN\\'jgNLgnZ%o%\u0016\u001c\bo\u001c8tK\"\u001aA%!\u0005\u0002\u0017Q,7\u000f\u001e.l\u0005\u0006\u001c\u0018n\u0019\u0015\u0004K\u0005E\u0011!\u00059beRLG/[8o%\u0016\u001c\bo\u001c8tKR1\u0011QRAM\u00037\u0003B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'\u000b\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0015\u0011\u0013\u0002\u0011\u00032$XM]%teJ+7\u000f]8og\u0016Da!!\u001f'\u0001\u0004\u0001\bbBA\u001dM\u0001\u0007\u00111\b")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)EasyMock.createMock(BrokerToControllerChannelManager.class));
    }

    @Test
    public void testBasic() {
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$1 -> {
            AlterIsrManagerTest.$anonfun$testBasic$2(x$1);
            return BoxedUnit.UNIT;
        }, 0));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testOverwriteWithinBatch() {
        Capture capture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (ControllerRequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        Assertions.assertTrue((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$2 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$2(x$2);
            return BoxedUnit.UNIT;
        }, 0)));
        Assertions.assertFalse((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), 10), (Function1 & Serializable & scala.Serializable)x$3 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$3(x$3);
            return BoxedUnit.UNIT;
        }, 0)));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterIsrRequestData.PartitionData)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)3);
    }

    @Test
    public void testSingleBatch() {
        Capture capture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$4 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$2(x$4);
            return BoxedUnit.UNIT;
        }, 0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> alterIsrManager.submit(new AlterIsrItem(new TopicPartition(this.topic(), i), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$5 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$4(x$5);
            return BoxedUnit.UNIT;
        }, 0)));
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10);
        .colon.colon isrs = new .colon.colon((Object)new AlterIsrItem(this.tp0(), leaderAndIsr, (Function1 & Serializable & scala.Serializable)x$6 -> {
            AlterIsrManagerTest.$anonfun$testRetryOnErrorResponse$1(x$6);
            return BoxedUnit.UNIT;
        }, 0), (List)Nil$.MODULE$);
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        isrs.foreach((Function1 & Serializable & scala.Serializable)alterIsrItem -> BoxesRunTime.boxToBoolean((boolean)alterIsrManager.submit(alterIsrItem)));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterIsrResponse retryAlterIsrResponse = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterIsrResponse);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertTrue((boolean)this.testPartitionError(this.tp0(), error).submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$7 -> {
            AlterIsrManagerTest.$anonfun$checkPartitionError$1(x$7);
            return BoxedUnit.UNIT;
        }, 0)));
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        ObjectRef capturedError = ObjectRef.create((Object)None$.MODULE$);
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
            AlterIsrManagerTest.$anonfun$testPartitionError$2(capturedError, result);
            return BoxedUnit.UNIT;
        };
        alterIsrManager.submit(new AlterIsrItem(tp, new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback, 0));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = this.partitionResponse(tp, error);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)((Option)capturedError.elem).isDefined());
        Assertions.assertEquals((Object)((Option)capturedError.elem).get(), (Object)error);
        return alterIsrManager;
    }

    @Test
    public void testOneInFlight() {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$8 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$2(x$8);
            return BoxedUnit.UNIT;
        }, 0));
        alterIsrManager.submit(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$9 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$3(x$9);
            return BoxedUnit.UNIT;
        }, 0));
        alterIsrManager.submit(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable & scala.Serializable)x$10 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$4(x$10);
            return BoxedUnit.UNIT;
        }, 0));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testPartitionMissingInResponse() {
        Object object = new Object();
        try {
            Capture callbackCapture = EasyMock.newCapture();
            EasyMock.reset((Object[])new Object[]{this.brokerToController()});
            this.brokerToController().start();
            EasyMock.expect((Object)BoxedUnit.UNIT);
            this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
            EasyMock.replay((Object[])new Object[]{this.brokerToController()});
            MockScheduler scheduler = new MockScheduler((Time)this.time());
            DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
            alterIsrManager.start();
            AtomicInteger count = new AtomicInteger(0);
            Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
                count.incrementAndGet();
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback, 0));
            alterIsrManager.submit(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback, 0));
            alterIsrManager.submit(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback, 0));
            EasyMock.verify((Object[])new Object[]{this.brokerToController()});
            AlterIsrResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR);
            ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
            ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
            Assertions.assertEquals((int)count.get(), (int)3, (String)"Expected all callbacks to run");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$11 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$12 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        Assertions.assertTrue((boolean)zkIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 1), arg_0 -> AlterIsrManagerTest.$anonfun$testZkBasic$3$adapted(package$.MODULE$.Right().apply((Object)new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 2)), arg_0), 0)));
        Assertions.assertTrue((boolean)zkIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 3), arg_0 -> AlterIsrManagerTest.$anonfun$testZkBasic$4$adapted(package$.MODULE$.Left().apply((Object)Errors.INVALID_UPDATE_VERSION), arg_0), 0)));
    }

    private AlterIsrResponse partitionResponse(TopicPartition tp, Errors error) {
        return new AlterIsrResponse(new AlterIsrResponseData().setTopics(Collections.singletonList(new AlterIsrResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterIsrResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(error.code()))))));
    }

    public static final /* synthetic */ void $anonfun$testBasic$2(Either x$1) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$2(Either x$2) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$3(Either x$3) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$2(Either x$4) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$4(Either x$5) {
    }

    public static final /* synthetic */ void $anonfun$testRetryOnErrorResponse$1(Either x$6) {
    }

    public static final /* synthetic */ void $anonfun$checkPartitionError$1(Either x$7) {
    }

    public static final /* synthetic */ void $anonfun$testPartitionError$2(ObjectRef capturedError$1, Either result) {
        Errors error;
        if (result instanceof Left && (error = (Errors)((Left)result).value()) != null) {
            capturedError$1.elem = new Some((Object)error);
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should have seen error");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$2(Either x$8) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$3(Either x$9) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$4(Either x$10) {
    }

    private static final void expectMatch$1(Either expect, Either result) {
        Assertions.assertEquals((Object)expect, (Object)result);
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }

    public static final /* synthetic */ Object $anonfun$testZkBasic$3$adapted(Right eta$0$1$1, Either result) {
        AlterIsrManagerTest.expectMatch$1((Either)eta$0$1$1, result);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testZkBasic$4$adapted(Left eta$0$2$1, Either result) {
        AlterIsrManagerTest.expectMatch$1((Either)eta$0$2$1, result);
        return BoxedUnit.UNIT;
    }
}

