/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RecordSerde;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001\u0002\u0014(\u00051BQa\r\u0001\u0005\u0002QBqa\u000e\u0001A\u0002\u0013\u0005\u0001\bC\u0004B\u0001\u0001\u0007I\u0011\u0001\"\t\r!\u0003\u0001\u0015)\u0003:\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0015\u0001!\u0002\u0013Y\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B1\u0001\t\u0003\u0019\u0006\"\u00024\u0001\t\u0003\u0019\u0006\"B6\u0001\t\u0003\u0019\u0006\"B7\u0001\t\u0003\u0019\u0006\"B8\u0001\t\u0003\u0019\u0006\"B9\u0001\t\u0003\u0019\u0006\"B:\u0001\t\u0003\u0019\u0006\"B;\u0001\t\u0003\u0019\u0006\"B<\u0001\t\u0003\u0019\u0006\"B=\u0001\t\u0003\u0019\u0006\"B>\u0001\t\u0003\u0019\u0006\"B?\u0001\t\u0003\u0019\u0006BB@\u0001\t\u0013\t\taB\u0004\u0002,\u001dB\t!!\f\u0007\r\u0019:\u0003\u0012AA\u0018\u0011\u0019\u0019d\u0003\"\u0001\u00022\u00191\u00111\u0007\f\u0001\u0003kAaa\r\r\u0005\u0002\u0005e\u0003bBA\u00131\u0011\u0005\u0013q\f\u0005\b\u0003kBB\u0011IA<\u0011\u001d\t9\t\u0007C!\u0003\u0013Cq!!'\u0017\t\u0003\tY\nC\u0005\u0002FZ\t\n\u0011\"\u0001\u0002H\"I\u0011Q\u001c\f\u0012\u0002\u0013\u0005\u0011q\u0019\u0005\b\u0003?4B\u0011AAq\u0011%\tYOFI\u0001\n\u0003\t9\rC\u0005\u0002nZ\t\n\u0011\"\u0001\u0002H\"9\u0011q\u001e\f\u0005\u0002\u0005E\b\"\u0003B\u000b-E\u0005I\u0011\u0001B\f\u0011\u001d\u0011YB\u0006C\u0005\u0005;\u0011AcS1gW\u0006lU\r^1eCR\fGj\\4UKN$(B\u0001\u0015*\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003)\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0011\u0005Y\u0002Q\"A\u0014\u0002\u000fQ,W\u000e\u001d#jeV\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005\u0011\u0011n\u001c\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0003GS2,\u0017a\u0003;f[B$\u0015N]0%KF$\"a\u0011$\u0011\u00059\"\u0015BA#0\u0005\u0011)f.\u001b;\t\u000f\u001d\u001b\u0011\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\u0002\u0011Q,W\u000e\u001d#je\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*K\u0001\u0006kRLGn]\u0005\u0003!6\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nQa]3u+B$\u0012a\u0011\u0015\u0003\u000fU\u0003\"AV0\u000e\u0003]S!\u0001W-\u0002\u0007\u0005\u0004\u0018N\u0003\u0002[7\u00069!.\u001e9ji\u0016\u0014(B\u0001/^\u0003\u0015QWO\\5u\u0015\u0005q\u0016aA8sO&\u0011\u0001m\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005!\u0019\u0007C\u0001,e\u0013\t)wKA\u0005BMR,'/R1dQ\u0006QB/Z:u+:,\u0007\u0010]3di\u0016$\u0017\t\u001d9f]\u0012|eMZ:fi\"\u0012\u0011\u0002\u001b\t\u0003-&L!A[,\u0003\tQ+7\u000f^\u0001\u0013i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G\u000f\u000b\u0002\u000bQ\u00069B/Z:u%\u0016\fG-T5tg&twm\u00158baNDw\u000e\u001e\u0015\u0003\u0017!\f\u0001\u0004^3tiV\u0003H-\u0019;f\u0019><7\u000b^1si>3gm]3uQ\ta\u0001.A\u0016uKN$X\u000b\u001d3bi\u0016dunZ*uCJ$xJ\u001a4tKR<\u0016\u000e\u001e5NSN\u001c\u0018N\\4T]\u0006\u00048\u000f[8uQ\ti\u0001.A\u0016uKN$h)Y5m)>Len\u0019:fCN,Gj\\4Ti\u0006\u0014H\u000fU1ti\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\tq\u0001.A\u0011uKN$HK];oG\u0006$XMR;mYf$v\u000eT1uKN$8K\\1qg\"|G\u000f\u000b\u0002\u0010Q\u00069B/Z:u\t>,7O\u001c;UeVt7-\u0019;f\rVdG.\u001f\u0015\u0003!!\fA\u0003^3ti\u000ecW-\u00198vaNs\u0017\r]:i_R\u001c\bFA\ti\u0003\u0015\"Xm\u001d;De\u0016\fG/\u001a*fa2L7-\u0019;fI2{w\r\u0016:v]\u000e\fG/Z:Gk2d\u0017\u0010\u000b\u0002\u0013Q\u0006\u0001B/Z:u\u001b\u0006D()\u0019;dQNK'0\u001a\u0015\u0003'!\faBY;jY\u00124U\u000f\u001c7CCR\u001c\u0007\u000e\u0006\u0005\u0002\u0004\u0005e\u00111EA\u0014!\u0011\t)!!\u0006\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\taA]3d_J$'\u0002BA\u0007\u0003\u001f\taaY8n[>t'b\u0001\u0016\u0002\u0012)\u0019\u00111C/\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t9\"a\u0002\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\tY\u0002\u0006a\u0001\u0003;\t1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019a&a\b\n\u0007\u0005\u0005rFA\u0002J]RDq!!\n\u0015\u0001\u0004\ti\"\u0001\u0006sK\u000e|'\u000fZ*ju\u0016Dq!!\u000b\u0015\u0001\u0004\ti\"A\nnCb\u0014\u0015\r^2i'&TX-\u00138CsR,7/\u0001\u000bLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pOR+7\u000f\u001e\t\u0003mY\u0019\"AF\u0017\u0015\u0005\u00055\"A\u0004\"zi\u0016\f%O]1z'\u0016\u0014H-Z\n\u00061\u0005]\u00121\t\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH\u001f\u0002\t1\fgnZ\u0005\u0005\u0003\u0003\nYD\u0001\u0004PE*,7\r\u001e\t\u0007\u0003\u000b\nI%!\u0014\u000e\u0005\u0005\u001d#b\u0001\u0015\u0002\u0010%!\u00111JA$\u0005-\u0011VmY8sIN+'\u000fZ3\u0011\u000b9\ny%a\u0015\n\u0007\u0005EsFA\u0003BeJ\f\u0017\u0010E\u0002/\u0003+J1!a\u00160\u0005\u0011\u0011\u0015\u0010^3\u0015\u0005\u0005m\u0003cAA/15\ta\u0003\u0006\u0004\u0002\u001e\u0005\u0005\u0014Q\r\u0005\b\u0003GR\u0002\u0019AA'\u0003\u0011!\u0017\r^1\t\u000f\u0005\u001d$\u00041\u0001\u0002j\u0005\u00112/\u001a:jC2L'0\u0019;j_:\u001c\u0015m\u00195f!\u0011\tY'!\u001d\u000e\u0005\u00055$\u0002BA8\u0003\u0017\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003g\niG\u0001\rPE*,7\r^*fe&\fG.\u001b>bi&|gnQ1dQ\u0016\fQa\u001e:ji\u0016$raQA=\u0003w\ni\bC\u0004\u0002dm\u0001\r!!\u0014\t\u000f\u0005\u001d4\u00041\u0001\u0002j!9\u0011qP\u000eA\u0002\u0005\u0005\u0015aA8viB!\u00111NAB\u0013\u0011\t))!\u001c\u0003\u0011]\u0013\u0018\u000e^1cY\u0016\fAA]3bIR1\u0011QJAF\u0003+Cq!!$\u001d\u0001\u0004\ty)A\u0003j]B,H\u000f\u0005\u0003\u0002l\u0005E\u0015\u0002BAJ\u0003[\u0012\u0001BU3bI\u0006\u0014G.\u001a\u0005\b\u0003/c\u0002\u0019AA\u000f\u0003\u0011\u0019\u0018N_3\u0002-\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><\u0017I\u001c3ESJ$\"\"!(\u0002:\u0006m\u0016qXAa!\u001dq\u0013qTAR\u0003gK1!!)0\u0005\u0019!V\u000f\u001d7feA!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016\u0001\u00024jY\u0016T1!!,>\u0003\rq\u0017n\\\u0005\u0005\u0003c\u000b9K\u0001\u0003QCRD\u0007c\u0001\u001c\u00026&\u0019\u0011qW\u0014\u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0007\"B\u001c\u001e\u0001\u0004I\u0004BBA_;\u0001\u00071*\u0001\u0003uS6,\u0007\"CA\u0015;A\u0005\t\u0019AA\u000f\u0011%\t\u0019-\bI\u0001\u0002\u0004\ti\"A\nnCb4U\r^2i'&TX-\u00138CsR,7/\u0001\u0011ck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5sI\u0011,g-Y;mi\u0012\u001aTCAAeU\u0011\ti\"a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a60\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001EY;jY\u0012lU\r^1eCR\fGj\\4B]\u0012$\u0015N\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u000b\u0003g\u000b\u0019/!:\u0002h\u0006%\b\"B\u001c!\u0001\u0004I\u0004BBA_A\u0001\u00071\nC\u0005\u0002*\u0001\u0002\n\u00111\u0001\u0002\u001e!I\u00111\u0019\u0011\u0011\u0002\u0003\u0007\u0011QD\u0001\u001bEVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$C-\u001a4bk2$HeM\u0001\u001bEVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$C-\u001a4bk2$H\u0005N\u0001\u0007CB\u0004XM\u001c3\u0015\u0015\u0005M\u0018\u0011 B\u0002\u0005\u000f\u0011Y\u0001\u0005\u0003\u0002F\u0005U\u0018\u0002BA|\u0003\u000f\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBA~G\u0001\u0007\u0011Q`\u0001\u0004Y><\u0007\u0003BA#\u0003\u007fLAA!\u0001\u0002H\ti!+\u001a9mS\u000e\fG/\u001a3M_\u001eDqA!\u0002$\u0001\u0004\ti\"A\bok6\u0014WM](g%\u0016\u001cwN\u001d3t\u0011\u001d\u0011Ia\ta\u0001\u0003;\tQ!\u001a9pG\"D\u0011B!\u0004$!\u0003\u0005\rAa\u0004\u0002\u001b%t\u0017\u000e^5bY>3gm]3u!\rq#\u0011C\u0005\u0004\u0005'y#\u0001\u0002'p]\u001e\f\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\te!\u0006\u0002B\b\u0003\u0017\f!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR)\u0011Ha\b\u0003$!1!\u0011E\u0013A\u0002e\na\u0001\\8h\t&\u0014\bb\u0002B\u0013K\u0001\u0007!qE\u0001\u000bY><G)\u001b:OC6,\u0007\u0003\u0002B\u0015\u0005oqAAa\u000b\u00034A\u0019!QF\u0018\u000e\u0005\t=\"b\u0001B\u0019W\u00051AH]8pizJ1A!\u000e0\u0003\u0019\u0001&/\u001a3fM&!!\u0011\bB\u001e\u0005\u0019\u0019FO]5oO*\u0019!QG\u0018")
public final class KafkaMetadataLogTest {
    private File tempDir = null;
    private final MockTime mockTime = new MockTime();

    public static long append$default$4() {
        return KafkaMetadataLogTest$.MODULE$.append$default$4();
    }

    public static LogAppendInfo append(ReplicatedLog replicatedLog, int n, int n2, long l) {
        return KafkaMetadataLogTest$.MODULE$.append(replicatedLog, n, n2, l);
    }

    public static int buildMetadataLog$default$4() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4();
    }

    public static int buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3();
    }

    public static KafkaMetadataLog buildMetadataLog(File file, MockTime mockTime, int n, int n2) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(file, mockTime, n, n2);
    }

    public static int buildMetadataLogAndDir$default$4() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$4();
    }

    public static int buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3();
    }

    public static Tuple2<Path, KafkaMetadataLog> buildMetadataLogAndDir(File file, MockTime mockTime, int n, int n2) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(file, mockTime, n, n2);
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void resource_resource;
        void resource_resource2;
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(snapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        AutoCloseable autoCloseable = (AutoCloseable)log.readSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testCreateSnapshot$2((RawSnapshotReader)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateLogStartOffset() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int offset = 10;
        int epoch = 0;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(snapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.deleteBeforeSnapshot(snapshotId));
        Assertions.assertEquals((long)offset, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
        int newRecords = 10;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, newRecords, epoch + 1, log.endOffset().offset);
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch((long)(offset + newRecords), epoch)));
        Assertions.assertEquals((long)offset, (long)log.startOffset());
        Assertions.assertEquals((int)(epoch + 1), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)(offset + newRecords), (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    @Test
    public void testUpdateLogStartOffsetWithMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(1L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailToIncreaseLogStartPastHighWatermark() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int offset = 10;
        int epoch = 0;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(2 * offset), 1 + epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(snapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> log.deleteBeforeSnapshot(snapshotId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateFullyToLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(sameEpochSnapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, log.endOffset().offset);
        RawSnapshotWriter rawSnapshotWriter2 = log.createSnapshot(greaterEpochSnapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDoesntTruncateFully() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(olderEpochSnapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, log.endOffset().offset);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        RawSnapshotWriter rawSnapshotWriter2 = log.createSnapshot(olderOffsetSnapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupSnapshots() {
        void resource_resource;
        void var3_3;
        void var2_2;
        Tuple2<Path, KafkaMetadataLog> tuple2 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$4());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple2._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple2._2();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        RawSnapshotWriter rawSnapshotWriter = log2.createSnapshot(snapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch, KafkaMetadataLogTest$.MODULE$.append$default$4());
        RawSnapshotWriter rawSnapshotWriter = log.createSnapshot(snapshotId);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch, (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), maxBatchSizeInBytes, KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$4());
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    public static final /* synthetic */ void $anonfun$testCreateSnapshot$2(RawSnapshotReader snapshot) {
        Assertions.assertEquals((long)0L, (long)snapshot.sizeInBytes());
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$2$adapted(RawSnapshotReader snapshot) {
        KafkaMetadataLogTest.$anonfun$testCreateSnapshot$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testUpdateLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testFailToIncreaseLogStartPastHighWatermark$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

