/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u00199\u0006\u0001)A\u0005)\"9\u0001\f\u0001b\u0001\n\u0003\u0019\u0006BB-\u0001A\u0003%A\u000bC\u0004[\u0001\t\u0007I\u0011A.\t\r\u0011\u0004\u0001\u0015!\u0003]\u0011\u001d)\u0007A1A\u0005\u0002\u0019DaA\u001b\u0001!\u0002\u00139\u0007bB6\u0001\u0001\u0004%\t\u0001\u001c\u0005\bg\u0002\u0001\r\u0011\"\u0001u\u0011\u0019Q\b\u0001)Q\u0005[\"91\u0010\u0001a\u0001\n\u0003a\b\"CA\u0001\u0001\u0001\u0007I\u0011AA\u0002\u0011\u001d\t9\u0001\u0001Q!\nuD\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?Aq!a\n\u0001\t\u0003\tI\u0003C\u0004\u0002F\u0001!\t!!\u000b\t\u000f\u0005=\u0003\u0001\"\u0001\u0002*!9\u0011\u0011\f\u0001\u0005\u0002\u0005%\u0002bBA/\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003C\u0002A\u0011AA\u0015\u0011\u001d\t)\u0007\u0001C\u0001\u0003SAq!!\u001b\u0001\t\u0003\tI\u0003C\u0004\u0002n\u0001!\t!!\u000b\t\u000f\u0005E\u0004\u0001\"\u0001\u0002*!9\u0011Q\u000f\u0001\u0005\u0002\u0005%\u0002bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003+\u0003A\u0011AA\u0015\u0011\u001d\tI\n\u0001C\u0001\u0003SAq!!(\u0001\t\u0003\tI\u0003C\u0004\u0002\"\u0002!\t!!\u000b\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002*!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005%\u0002bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003;\u0004A\u0011BAp\u0011%\tY\u0010AI\u0001\n\u0013\ti\u0010C\u0005\u0003\u0014\u0001\t\n\u0011\"\u0003\u0003\u0016!9!\u0011\u0004\u0001\u0005\u0002\u0005%\u0002b\u0002B\u000f\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0005C\u0001A\u0011AA\u0015\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OA\u0011B!\u0011\u0001#\u0003%IAa\u0011\t\u000f\t\u001d\u0003\u0001\"\u0001\u0002*!9!1\n\u0001\u0005\u0002\u0005%\u0002b\u0002B(\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0005'\u0002A\u0011AA\u0015\u0011\u001d\u00119\u0006\u0001C\u0001\u0003SAqAa\u0017\u0001\t\u0003\tI\u0003C\u0004\u0003`\u0001!\t!!\u000b\u0003\u001d1{w-T1oC\u001e,'\u000fV3ti*\u0011!hO\u0001\u0004Y><'\"\u0001\u001f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0005C\u0001%\u0001\u001b\u0005I\u0014\u0001\u0002;j[\u0016,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dn\nQ!\u001e;jYNL!\u0001U'\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq\"\\1y%>dG.\u00138uKJ4\u0018\r\\\u000b\u0002)B\u0011\u0001)V\u0005\u0003-\u0006\u00131!\u00138u\u0003Ai\u0017\r\u001f*pY2Le\u000e^3sm\u0006d\u0007%A\u0006nCbdunZ!hK6\u001b\u0018\u0001D7bq2{w-Q4f\u001bN\u0004\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\tU$\u0018\u000e\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gL\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<W#A4\u0011\u0005!C\u0017BA5:\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\na\u0001\\8h\t&\u0014X#A7\u0011\u00059\fX\"A8\u000b\u0005A\u0004\u0017AA5p\u0013\t\u0011xN\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003\u0001ZL!a^!\u0003\tUs\u0017\u000e\u001e\u0005\bs6\t\t\u00111\u0001n\u0003\rAH%M\u0001\bY><G)\u001b:!\u0003)awnZ'b]\u0006<WM]\u000b\u0002{B\u0011\u0001J`\u0005\u0003\u007ff\u0012!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$2!^A\u0003\u0011\u001dI\b#!AA\u0002u\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005!a.Y7f+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002Y\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0018\u0005E!AB*ue&tw-A\u0003oC6,\u0007%A\rwKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006dWCAA\u0010!\r\u0001\u0015\u0011E\u0005\u0004\u0003G\t%\u0001\u0002'p]\u001e\f!D^3ss2\u000b'oZ3M_\u001e4E.^:i\u0013:$XM\u001d<bY\u0002\nQa]3u+B$\u0012!\u001e\u0015\u0004-\u00055\u0002\u0003BA\u0018\u0003\u0003j!!!\r\u000b\t\u0005M\u0012QG\u0001\u0004CBL'\u0002BA\u001c\u0003s\tqA[;qSR,'O\u0003\u0003\u0002<\u0005u\u0012!\u00026v]&$(BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n\tD\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004/\u0005%\u0003\u0003BA\u0018\u0003\u0017JA!!\u0014\u00022\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\u0007a\t\u0019\u0006\u0005\u0003\u00020\u0005U\u0013\u0002BA,\u0003c\u0011A\u0001V3ti\u0006!C/Z:u\u0011\u0006tG\r\\5oO\u0016C8-\u001a9uS>t7\u000fR;sS:<7\u000b[;uI><h\u000eK\u0002\u001a\u0003'\na\u0004^3ti\u000e\u0013X-\u0019;f\u0019><w+\u001b;i\u0013:4\u0018\r\\5e\u0019><G)\u001b:)\u0007i\t\u0019&A\u0010uKN$8I]3bi\u0016dunZ,ji\"dun\u001a#je\u001a\u000bG\u000e\u001c2bG.D3aGA*\u0003U!Xm\u001d;HKRtuN\\#ySN$XM\u001c;M_\u001eD3\u0001HA*\u0003i!Xm\u001d;DY\u0016\fg.\u001e9FqBL'/\u001a3TK\u001elWM\u001c;tQ\ri\u00121K\u0001\"i\u0016\u001cHo\u00117fC:,\boU3h[\u0016tGo\u001d+p\u001b\u0006Lg\u000e^1j]NK'0\u001a\u0015\u0004=\u0005M\u0013A\u000b;fgR$u.Z:oi\u000ecW-\u00198M_\u001e\u001cx+\u001b;i\u0007>l\u0007/Y2u\t\u0016dW\r^3Q_2L7-\u001f\u0015\u0004?\u0005M\u0013\u0001\n;fgR$u.Z:oi\u000ecW-\u00198M_\u001e\u001cx+\u001b;i\u0007>l\u0007/Y2u!>d\u0017nY=)\u0007\u0001\n\u0019&A\nuKN$Hi\\3t]R\u001cE.Z1o\u0019><7\u000fF\u0002v\u0003{Bq!a \"\u0001\u0004\t\t)\u0001\u0004q_2L7-\u001f\t\u0005\u0003\u0007\u000b\tJ\u0004\u0003\u0002\u0006\u00065\u0005cAAD\u00036\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017k\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u0010\u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\f\u0003'S1!a$B\u0003I!Xm\u001d;US6,')Y:fI\u001acWo\u001d5)\u0007\t\n\u0019&A\ruKN$H*Z1ti2{\u0017\rZ3e\u0003N\u001c\u0018n\u001a8nK:$\bfA\u0012\u0002T\u0005\u0019C/Z:u)^|Gj\\4NC:\fw-\u001a:t+NLgnZ*b[\u0016$\u0015N\u001d$bS2\u001c\bf\u0001\u0013\u0002T\u0005aB/Z:u\u0007\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R\u001c\bfA\u0013\u0002T\u0005iC/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i)J\f\u0017\u000e\\5oONc\u0017m\u001d5)\u0007\u0019\n\u0019&A\u0019uKN$(+Z2pm\u0016\u0014\u0018\u0010R5sK\u000e$xN]=NCB\u0004\u0018N\\4XSRD'+\u001a7bi&4X\rR5sK\u000e$xN]=)\u0007\u001d\n\u0019&\u0001\rwKJLg-_\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef$r!^AY\u00033\fY\u000eC\u0004\u00024\"\u0002\r!!.\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004b!a.\u0002B\u0006\u001dg\u0002BA]\u0003{sA!a\"\u0002<&\t!)C\u0002\u0002@\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002D\u0006\u0015'aA*fc*\u0019\u0011qX!\u0011\t\u0005%\u0017Q[\u0007\u0003\u0003\u0017TA!!4\u0002P\u000611m\\7n_:T1\u0001PAi\u0015\u0011\t\u0019.!\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t9.a3\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")1\u0010\u000ba\u0001{\")1\u000e\u000ba\u0001[\u0006\u00012M]3bi\u0016dunZ'b]\u0006<WM\u001d\u000b\u0006{\u0006\u0005\u0018q\u001d\u0005\n\u0003GL\u0003\u0013!a\u0001\u0003K\fq\u0001\\8h\t&\u00148\u000fE\u0003\u00028\u0006\u0005W\u000eC\u0005\u0002j&\u0002\n\u00111\u0001\u0002l\u0006\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003!iW\r^1eCR\f'bAA{w\u000511/\u001a:wKJLA!!?\u0002p\n\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fTC!!:\u0003\u0002-\u0012!1\u0001\t\u0005\u0005\u000b\u0011y!\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tBa\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ede\u0016\fG/\u001a'pO6\u000bg.Y4fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0018)\"\u00111\u001eB\u0001\u0003\t\"Xm\u001d;GS2,'+\u001a4fe\u0016t7-Z:BMR,'/Q:z]\u000e$U\r\\3uK\"\u001aA&a\u0015\u0002EQ,7\u000f^\"sK\u0006$X-\u00118e\t\u0016dW\r^3Pm\u0016\u0014H.\u001f'p]\u001e$v\u000e]5dQ\ri\u00131K\u0001\"i\u0016\u001cHo\u00115fG.\u0004x.\u001b8u\r>\u0014xJ\u001c7z\u0003\u001a4Wm\u0019;fI2{wm\u001d\u0015\u0004]\u0005M\u0013a\u0002:fC\u0012dun\u001a\u000b\t\u0005S\u0011\tD!\u000f\u0003>A!!1\u0006B\u0017\u001b\t\t\u00190\u0003\u0003\u00030\u0005M(!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000e\u0003\u0004;_\u0001\u0007!1\u0007\t\u0004\u0011\nU\u0012b\u0001B\u001cs\t\u0019Aj\\4\t\u000f\tmr\u00061\u0001\u0002 \u00051qN\u001a4tKRD\u0001Ba\u00100!\u0003\u0005\r\u0001V\u0001\n[\u0006DH*\u001a8hi\"\f\u0011C]3bI2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)EK\u0002U\u0005\u0003\tQ\u0005^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<W-\u00169eCR,7\u000fT8h\u0007>tg-[4)\u0007E\n\u0019&A\u000fuKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\u001e+Go]\"mK\u0006tW\rZ+qQ\r\u0011\u00141K\u0001)i\u0016\u001cHO\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hK\u0012+G.\u001b<fe\u0016$Gk\\!mY2{wm\u001d\u0015\u0004g\u0005M\u0013\u0001\f;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4fg^KG\u000f\u001b(p\u0019><w)\u001a;uS:<\u0017J\\5uS\u0006d\u0017N_3eQ\r!\u00141K\u00011i\u0016\u001cH/T3ue&\u001c7/\u0012=jgR<\u0006.\u001a8M_\u001eL5OU3de\u0016\fG/\u001a3CK\u001a|'/\u001a#fY\u0016$\u0018n\u001c8)\u0007U\n\u0019&A\u0019uKN$X*\u001a;sS\u000e\u001c\u0018I]3SK6|g/\u001a3XQ\u0016tWj\u001c<j]\u001e\u001cUO\u001d:f]R$vNR;ukJ,Gj\\4)\u0007Y\n\u0019&\u0001\ruKN$x+Y5u\r>\u0014\u0018\t\u001c7U_\u000e{W\u000e\u001d7fi\u0016D3aNA*\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), this.createLogManager$default$2()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            boolean x$2 = qual$1.getOrCreateLog$default$2();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            Log log1 = qual$1.getOrCreateLog(x$1, x$2, x$3);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$4 = new TopicPartition(this.name(), 1);
            boolean x$5 = qual$2.getOrCreateLog$default$2();
            boolean x$6 = qual$2.getOrCreateLog$default$3();
            Log log2 = qual$2.getOrCreateLog(x$4, x$5, x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, Log$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, Log$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = true;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        boolean x$22 = true;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, x$22, x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable & scala.Serializable containsLogFile = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$32 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$32);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$3)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        CachedConfigRepository configRepository = new CachedConfigRepository();
        int segmentBytes = 10 * setSize;
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(50L * (long)setSize + 10L));
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)configRepository));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$3, x$4, x$5);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        CachedConfigRepository configRepository = new CachedConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)configRepository));
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        boolean x$42 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$3, x$42, x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        CachedConfigRepository configRepository = new CachedConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.FlushMsProp(), "1000");
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)configRepository));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        boolean x$4 = qual$1.getOrCreateLog$default$2();
        boolean x$5 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$3, x$4, x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            boolean x$2 = qual$1.getOrCreateLog$default$2();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$2, x$3);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size()), Iterable$.MODULE$.canBuildFrom());
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4(), TestUtils$.MODULE$.createLogManager$default$5()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), this.createLogManager$default$2()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$7 -> logManager.getOrCreateLog(x$7, logManager.getOrCreateLog$default$2(), logManager.getOrCreateLog$default$3()), Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, ConfigRepository configRepository) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager(logDirs, x$1, configRepository, x$5, x$4);
    }

    private Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new CachedConfigRepository();
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$2, x$3).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$8)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        boolean x$5 = qual$2.asyncDelete$default$2();
        boolean x$6 = qual$2.asyncDelete$default$3();
        Log removedLog = (Log)qual$2.asyncDelete(x$4, x$5, x$6).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach(arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$2, x$3);
        LogManager qual$2 = this.logManager();
        TopicPartition x$4 = new TopicPartition(invalidTopicName, 0);
        boolean x$5 = qual$2.asyncDelete$default$2();
        boolean x$6 = qual$2.asyncDelete$default$3();
        qual$2.asyncDelete(x$4, x$5, x$6);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            LogManager qual$1 = this.logManager();
            boolean x$2 = qual$1.getOrCreateLog$default$2();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$11, x$2, x$3);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(Log log, long offset, int maxLength) {
        return log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)new CachedConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Log mockLog = (Log)Mockito.mock(Log.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)new CachedConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)new CachedConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, (ConfigRepository)spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Log mockLog = (Log)Mockito.mock(Log.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$2, x$3);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$5 = qual$2.asyncDelete$default$2();
        boolean x$6 = qual$2.asyncDelete$default$3();
        Log removedLog = (Log)qual$2.asyncDelete(tp, x$5, x$6).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        boolean x$8 = qual$3.getOrCreateLog$default$2();
        boolean x$9 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$8, x$9);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), this.createLogManager$default$2()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$2, x$3);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        boolean x$5 = true;
        boolean x$6 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$6, x$5);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWaitForAllToComplete() {
        void waitForAllToComplete_callback;
        void waitForAllToComplete_jobs;
        void waitForAllToComplete_callback2;
        void waitForAllToComplete_jobs2;
        void waitForAllToComplete_callback3;
        void waitForAllToComplete_jobs3;
        void waitForAllToComplete_callback4;
        void waitForAllToComplete_jobs4;
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$12 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$12)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$13 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$14 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$14);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon2 = new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl = waitForAllToComplete_jobs4.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback4, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$15);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon3 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = waitForAllToComplete_jobs3.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback3, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$16 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$16);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon4 = new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl3 = waitForAllToComplete_jobs2.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback2, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$17 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$17);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon5 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl4 = waitForAllToComplete_jobs.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$3) {
        return x$3.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(Log log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$8) {
        return x$8.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$9) {
        String string = x$9.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$9)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$1(String topicName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$1(topicName$1).size());
        LogManagerTest.logMetrics$1(topicName$1).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$2) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$2(topicName$2).size());
        LogManagerTest.logMetrics$2(topicName$2).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$12) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$14) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$15) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$16) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$17) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

