/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)1\u0007\u0001C\u0001E!)Q\u0007\u0001C\u0001E!)q\u0007\u0001C\u0001E!)\u0011\b\u0001C\u0001E!)1\b\u0001C\u0001E!)Q\b\u0001C\u0001E!)q\b\u0001C\u0001E!)\u0011\t\u0001C\u0001E!)1\t\u0001C\u0001E!)Q\t\u0001C\u0001E!)q\t\u0001C\u0001E!)\u0011\n\u0001C\u0005\u0015\")1\f\u0001C\u00059\niAj\\4D_:4\u0017n\u001a+fgRT!AE\n\u0002\u00071|wMC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u0005\u0019\u0003C\u0001\r%\u0013\t)\u0013D\u0001\u0003V]&$\bF\u0001\u0002(!\tA\u0013'D\u0001*\u0015\tQ3&A\u0002ba&T!\u0001L\u0017\u0002\u000f),\b/\u001b;fe*\u0011afL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#\u0001\u0002+fgR\fa\u0003^3ti.\u000bgm[1D_:4\u0017n\u001a+p!J|\u0007o\u001d\u0015\u0003\u0007\u001d\n!\u0003^3ti\u001a\u0013x.\u001c)s_B\u001cX)\u001c9us\"\u0012AaJ\u0001\u0015i\u0016\u001cHO\u0012:p[B\u0013x\u000e]:J]Z\fG.\u001b3)\u0005\u00159\u0013A\b;fgRLeN^1mS\u0012\u001cu.\u001c9bGRLwN\u001c'bO\u000e{gNZ5hQ\t1q%A\u0013tQ>,H\u000e\u001a,bY&$\u0017\r^3UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCN\u001cuN\u001c4jO\"\u0012qaJ\u0001\u0010i\u0016\u001cH\u000fV8Ii6dG+\u00192mK\"\u0012\u0001bJ\u0001\u000bi\u0016\u001cH\u000fV8Ii6d\u0007FA\u0005(\u0003E!Xm\u001d;U_\u0016s'/[2iK\u0012\u00146\u000f\u001e\u0015\u0003\u0015\u001d\n\u0011\u0002^3tiR{'k\u001d;)\u0005-9\u0013A\u0005;fgR<U\r^\"p]\u001aLwMV1mk\u0016D#\u0001D\u0014\u0002KQ,7\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\u0006\u001bHj\\4hC\ndWm\u0015;sS:<\u0007FA\u0007(\u0003\u001dI7OV1mS\u0012$\"a\u0013(\u0011\u0005aa\u0015BA'\u001a\u0005\u001d\u0011un\u001c7fC:DQa\u0014\bA\u0002A\u000b1bY8oM&<g+\u00197vKB\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"aU\r\u000e\u0003QS!!V\u000b\u0002\rq\u0012xn\u001c;?\u0013\t9\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\u001a\u0003U\t7o]3siB\u0013x\u000e]3sifLeN^1mS\u0012$2aI/`\u0011\u0015qv\u00021\u0001Q\u0003\u0011q\u0017-\\3\t\u000b\u0001|\u0001\u0019A1\u0002\rY\fG.^3t!\rA\"mF\u0005\u0003Gf\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig$.MODULE$.validate(props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(LogConfig$.MODULE$.RetentionBytesProp(), "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig), topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            return;
        }
        String string2 = LogConfig$.MODULE$.RetentionBytesProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string3 = LogConfig$.MODULE$.RetentionMsProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string4 = LogConfig$.MODULE$.CleanupPolicyProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
            return;
        }
        String string5 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
            return;
        }
        String string6 = LogConfig$.MODULE$.MinInSyncReplicasProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
            return;
        }
        String string7 = LogConfig$.MODULE$.MessageFormatVersionProp();
        if (!(string7 != null ? !string7.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
            return;
        }
        $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
    }
}

