/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005d\u0001B4i\u00015DQ\u0001\u001e\u0001\u0005\u0002UDq\u0001\u001f\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002>\t\u0011\u0005\u001d\u0001A1A\u0005\u0002eDq!!\u0003\u0001A\u0003%!\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0001\u0002\u000e!A\u00111\u0004\u0001!\u0002\u0013\ty\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002,!A\u0011\u0011\b\u0001!\u0002\u0013\ti\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0001\u0002>!A\u0011Q\t\u0001!\u0002\u0013\ty\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005-\u0004\u0001\"\u0001\u0002J!9\u0011Q\u000f\u0001\u0005\u0002\u0005%\u0003bBA=\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003{\u0002A\u0011AA%\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007Cq!a,\u0001\t\u0013\t\t\fC\u0004\u00026\u0002!\t!!\u0013\t\u000f\u0005e\u0006\u0001\"\u0001\u0002J!9\u0011Q\u0018\u0001\u0005\u0002\u0005%\u0003bBAa\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u000b\u0004A\u0011AA%\u0011\u001d\tI\r\u0001C\u0001\u0003\u0013Bq!!4\u0001\t\u0003\tI\u0005C\u0004\u0002R\u0002!\t!!\u0013\t\u000f\u0005U\u0007\u0001\"\u0001\u0002J!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005%\u0003bBAo\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003C\u0004A\u0011AA%\u0011\u001d\t)\u000f\u0001C\u0001\u0003\u0013Bq!!;\u0001\t\u0003\tI\u0005C\u0004\u0002n\u0002!\t!!\u0013\t\u000f\u0005E\b\u0001\"\u0001\u0002J!9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bb\u0002B\b\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005'\u0001A\u0011AA%\u0011\u001d\u00119\u0002\u0001C\u0001\u0003\u0013BqAa\u0007\u0001\t\u0003\tI\u0005C\u0004\u0003 \u0001!\t!!\u0013\t\u000f\t\r\u0002\u0001\"\u0001\u0002J!9!q\u0005\u0001\u0005\u0002\u0005%\u0003b\u0002B\u0016\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005_\u0001A\u0011AA%\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002B5\u0001\u0011\u0005!1\u000e\u0005\b\u0005\u0007\u0003A\u0011AA%\u0011\u001d\u00119\t\u0001C\u0001\u0003\u0013BqAa#\u0001\t\u0003\tI\u0005C\u0004\u0003\u0010\u0002!\t!!\u0013\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!\u0011\u0016\u0001\u0005\u0002\u0005%\u0003b\u0002BW\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005c\u0003A\u0011AA%\u0011\u001d\u0011)\f\u0001C\u0001\u0003\u0013BqA!/\u0001\t\u0003\tI\u0005C\u0004\u0003>\u0002!\t!!\u0013\t\u000f\t\u0005\u0007\u0001\"\u0001\u0002J!9!Q\u0019\u0001\u0005\u0002\u0005%\u0003b\u0002Be\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005\u001b\u0004A\u0011AA%\u0011\u001d\u0011\t\u000e\u0001C\u0005\u0005'DqAa9\u0001\t\u0013\u0011)\u000fC\u0005\u0004\u0004\u0001\t\n\u0011\"\u0003\u0004\u0006!911\u0004\u0001\u0005\n\ru\u0001bBB\u000e\u0001\u0011%1q\u0007\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011%\u0019i\u0005AI\u0001\n\u0013\u0019y\u0005C\u0005\u0004T\u0001\t\n\u0011\"\u0003\u0004V!I1\u0011\f\u0001\u0012\u0002\u0013%11\f\u0005\b\u0007?\u0002A\u0011BB1\u0011%\u0019Y\bAI\u0001\n\u0013\u0019i\bC\u0005\u0004\u0002\u0002\t\n\u0011\"\u0003\u0004\u0004\"9!\u0011\u001b\u0001\u0005\n\r\u001d\u0005bBB\u0011\u0001\u0011%1q\u0012\u0005\b\u0005[\u0004A\u0011BBQ\u0011%\u0019i\fAI\u0001\n\u0013\u0019Y\u0006C\u0005\u0004@\u0002\t\n\u0011\"\u0003\u0004B\"I1Q\u0019\u0001\u0012\u0002\u0013%11\u0011\u0005\n\u0007\u000f\u0004\u0011\u0013!C\u0005\u0007\u0007Cqa!3\u0001\t\u0013\u0019Y\rC\u0005\u0004l\u0002\t\n\u0011\"\u0003\u0004\u0004\"I1Q\u001e\u0001\u0012\u0002\u0013%1q\u001e\u0005\b\u0007g\u0004A\u0011BB{\u0011%!Y\u0001AI\u0001\n\u0013!i\u0001C\u0005\u0005\u0012\u0001\t\n\u0011\"\u0003\u0004\u0004\"IA1\u0003\u0001\u0012\u0002\u0013%1q\u001e\u0005\b\t+\u0001A\u0011\u0002C\f\u0011%!\t\u0003AI\u0001\n\u0013\u0019Y\u0006C\u0004\u0005$\u0001!I\u0001\"\n\t\u0013\u00115\u0002!%A\u0005\n\rm\u0003b\u0002C\u0018\u0001\u0011%A\u0011\u0007\u0005\b\u0005[\u0004A\u0011\u0002C#\u0011\u001d!Y\u0005\u0001C\u0005\t\u001bBq\u0001\"\u0015\u0001\t\u0013!\u0019\u0006C\u0004\u0005X\u0001!I\u0001\"\u0017\u0003\u001d1{wm\u00117fC:,'\u000fV3ti*\u0011\u0011N[\u0001\u0004Y><'\"A6\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0002c\u0006)1oY1mC&\u00111\u000f\u001d\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\bCA<\u0001\u001b\u0005A\u0017A\u0002;na\u0012L'/F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0003S>T\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004q\u0014AAR5mK\u00069A/\u001c9eSJ\u0004\u0013a\u00013je\u0006!A-\u001b:!\u0003!awn\u001a)s_B\u001cXCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b}\u0006!Q\u000f^5m\u0013\u0011\tI\"a\u0005\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005m_\u001e\u0004&o\u001c9tA\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003C\u00012a^A\u0012\u0013\r\t)\u0003\u001b\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\".A\u0003vi&d7/\u0003\u0003\u00028\u0005E\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0013QD'o\u001c;uY\u0016\u0014XCAA !\u0011\ty#!\u0011\n\t\u0005\r\u0013\u0011\u0007\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!!X-\u0019:e_^tGCAA&!\ry\u0017QJ\u0005\u0004\u0003\u001f\u0002(\u0001B+oSRD3ADA*!\u0011\t)&a\u001a\u000e\u0005\u0005]#\u0002BA-\u00037\n1!\u00199j\u0015\u0011\ti&a\u0018\u0002\u000f),\b/\u001b;fe*!\u0011\u0011MA2\u0003\u0015QWO\\5u\u0015\t\t)'A\u0002pe\u001eLA!!\u001b\u0002X\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001c\bfA\b\u0002pA!\u0011QKA9\u0013\u0011\t\u0019(a\u0016\u0003\tQ+7\u000f^\u0001/i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0007>t7-\u001e:sK:$8+Z4nK:$H)\u001a7fi&|g\u000eK\u0002\u0011\u0003_\nq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD3!EA8\u0003}!Xm\u001d;EkBd\u0017nY1uK\u000eCWmY6BMR,'o\u00117fC:Lgn\u001a\u0015\u0004%\u0005=\u0014\u0001F1tg\u0016\u0014H/\u00117m\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u0002L\u0005\u0015\u0015q\u0015\u0005\b\u0003\u000f\u001b\u0002\u0019AAE\u0003M)\u0007\u0010]3di\u0016$\u0017IY8si\u0016$G\u000b\u001f8t!\u0019\tY)a'\u0002\":!\u0011QRAL\u001d\u0011\ty)!&\u000e\u0005\u0005E%bAAJY\u00061AH]8pizJ\u0011!]\u0005\u0004\u00033\u0003\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003;\u000byJ\u0001\u0003MSN$(bAAMaB\u0019q/a)\n\u0007\u0005\u0015\u0006N\u0001\u0006BE>\u0014H/\u001a3Uq:Da![\nA\u0002\u0005%\u0006cA<\u0002,&\u0019\u0011Q\u00165\u0003\u00071{w-A\u000fbgN,'\u000f^!mYR\u0013\u0018M\\:bGRLwN\\:D_6\u0004H.\u001a;f)\u0011\tY%a-\t\r%$\u0002\u0019AAU\u0003M\"Xm\u001d;Nk2$\u0018\u000eU1tgN+w-\\3oi\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000fK\u0002\u0016\u0003_\n\u0011\u0005^3ti\n\u000b7/[2Ue\u0006t7/Y2uS>t\u0017i^1sK\u000ecW-\u00198j]\u001eD3AFA8\u0003%\"Xm\u001d;DY\u0016\fgnV5uQR\u0013\u0018M\\:bGRLwN\\:Ta\u0006tg.\u001b8h'\u0016<W.\u001a8ug\"\u001aq#a\u001c\u0002/Q,7\u000f^\"p[6LG/T1sW\u0016\u0014(+Z7pm\u0006d\u0007f\u0001\r\u0002p\u0005!C/Z:u\t\u0016dW\r^3e\u0005\u0006$8\r[3t/&$\bNT8NKN\u001c\u0018mZ3t%\u0016\fG\rK\u0002\u001a\u0003_\nq\u0005^3ti\u000e{W.\\5u\u001b\u0006\u00148.\u001a:SKR,g\u000e^5p]^KG\u000f[#naRL()\u0019;dQ\"\u001a!$a\u001c\u00025Q,7\u000f^\"mK\u0006tW)\u001c9us\u000e{g\u000e\u001e:pY\n\u000bGo\u00195)\u0007m\ty'\u0001\u0015uKN$8i\\7nSR$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0006/\u00198oS:<7+Z4nK:$8\u000fK\u0002\u001d\u0003_\na\u0005^3ti\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\*qC:t\u0017N\\4TK\u001elWM\u001c;tQ\ri\u0012qN\u0001\u0017i\u0016\u001cH/\u00112peRl\u0015M]6feJ+Wn\u001c<bY\"\u001aa$a\u001c\u0002MQ,7\u000f^#naRL()\u0019;dQJ+Wn\u001c<bY^KG\u000f[*fcV,gnY3SKV\u001cX\rK\u0002 \u0003_\na\u0005^3ti\u0006\u0013wN\u001d;NCJ\\WM\u001d*fi\u0016tG/[8o/&$\b.R7qif\u0014\u0015\r^2iQ\r\u0001\u0013qN\u0001\u0011i\u0016\u001cH\u000fT1sO\u0016lUm]:bO\u0016D3!IA8\u0003\r\"Xm\u001d;NKN\u001c\u0018mZ3MCJ<WM\u001d+iC:l\u0015\r_'fgN\fw-Z*ju\u0016D3AIA8\u0003Q\"Xm\u001d;NKN\u001c\u0018mZ3MCJ<WM\u001d+iC:l\u0015\r_'fgN\fw-Z*ju\u0016<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;IK\u0006$WM\u001d\u0015\u0004G\u0005=\u0014A\f;fgR\u001cuN\u001d:vaRlUm]:bO\u0016\u001c\u0016N_3MCJ<WM\u001d+iC:\u0014\u0015\u0010^3t\u0003Z\f\u0017\u000e\\1cY\u0016D3\u0001JA8\u0003\u0019\u001a'/Z1uK2{wmV5uQ6+7o]1hKNd\u0015M]4feRC\u0017M\\'bqNK'0\u001a\u000b\u0005\u0003s\u0014)\u0001E\u0004p\u0003w\fI+a@\n\u0007\u0005u\bO\u0001\u0004UkBdWM\r\t\u0004o\n\u0005\u0011b\u0001B\u0002Q\nia)Y6f\u001f\u001a47/\u001a;NCBDqAa\u0002&\u0001\u0004\u0011I!\u0001\tmCJ<W-T3tg\u0006<WmU5{KB\u0019qNa\u0003\n\u0007\t5\u0001OA\u0002J]R\fq\u0003^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5EK2,G/Z:)\u0007\u0019\ny'A\nuKN$Hj\\4DY\u0016\fg.\u001a:Ti\u0006$8\u000fK\u0002(\u0003_\n\u0011\u0006^3ti2{wm\u00117fC:,'OU3uC&t7\u000f\u0015:pIV\u001cWM\u001d'bgR\u001cV-];f]\u000e,\u0007f\u0001\u0015\u0002p\u0005ID/Z:u\u0019><7\t\\3b]\u0016\u0014(+\u001a;bS:\u001cH*Y:u'\u0016\fX/\u001a8dK\u00163XM\\%g)J\fgn]1di&|g.\u00112peR,G\rK\u0002*\u0003_\nq\u0003^3tiB\u000b'\u000f^5bYN+w-\\3oi\u000ecW-\u00198)\u0007)\ny'\u0001\u0012uKN$8\t\\3b]&twmV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004W\u0005=\u0014A\u0004;fgRdun\u001a+p\u00072,\u0017M\u001c\u0015\u0004Y\u0005=\u0014\u0001\n;fgRdun\u001a+p\u00072,\u0017M\\,ji\",fn\u00197fC:\f'\r\\3TK\u000e$\u0018n\u001c8)\u00075\ny'A\u0010uKN$8\t\\3b]&twmV5uQVs7.Z=fI6+7o]1hKND3ALA8\u0003U\u0011\u0017\r^2i\u0005\u0006\u001cXm\u00144gg\u0016$8/\u00138M_\u001e$BAa\u000e\u0003JA1!\u0011\bB \u0005\u0007j!Aa\u000f\u000b\u0007\tu\u0002/\u0001\u0006d_2dWm\u0019;j_:LAA!\u0011\u0003<\tA\u0011\n^3sC\ndW\rE\u0002p\u0005\u000bJ1Aa\u0012q\u0005\u0011auN\\4\t\r%|\u0003\u0019AAU\u0003aa\u0017m\u001d;PM\u001a\u001cX\r^:QKJ\u0014\u0015\r^2i\u0013:dun\u001a\u000b\u0005\u0005o\u0011y\u0005\u0003\u0004ja\u0001\u0007\u0011\u0011V\u0001\u0013Y\u0006\u001cHoU3rk\u0016t7-Z:J]2{w\r\u0006\u0003\u0003V\tm\u0003\u0003\u0003B\u001d\u0005/\u0012\u0019E!\u0003\n\t\te#1\b\u0002\u0004\u001b\u0006\u0004\bBB52\u0001\u0004\tI+\u0001\u0007pM\u001a\u001cX\r^:J]2{w\r\u0006\u0003\u00038\t\u0005\u0004BB53\u0001\u0004\tI+\u0001\rv].,\u00170\u001a3NKN\u001c\u0018mZ3D_VtG/\u00138M_\u001e$BA!\u0003\u0003h!1\u0011n\ra\u0001\u0003S\u000ba\"\u00192peR\u001c\u0005.Z2l\t>tW\r\u0006\u0003\u0002L\t5\u0004b\u0002B8i\u0001\u0007!\u0011O\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011\u0019Ha \u000e\u0005\tU$\u0002\u0002B<\u0005s\naaY8n[>t'bA6\u0003|)!!QPA2\u0003\u0019\t\u0007/Y2iK&!!\u0011\u0011B;\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0004^3ti\u000ecW-\u00198TK\u001elWM\u001c;t/&$\b.\u00112peRD3!NA8\u0003M!Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8hQ\r1\u0014qN\u0001%i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgnZ,ji\"\u001c\u0006/\u0019:tK>3gm]3ug\"\u001aq'a\u001c\u0002WQ,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4G_2dwn^5oO2{\u0017\rZ(g5\u0016\u0014x.\u00138eKbD3\u0001OA8\u0003E\u0019\u0007.Z2l'\u0016<W.\u001a8u\u001fJ$WM\u001d\u000b\u0005\u0003\u0017\u00129\nC\u0004\u0003\u001af\u0002\rAa'\u0002\r\u001d\u0014x.\u001e9t!\u0019\u0011ID!(\u0003\"&!!q\u0014B\u001e\u0005\r\u0019V-\u001d\t\u0007\u0005s\u0011iJa)\u0011\u0007]\u0014)+C\u0002\u0003(\"\u0014!\u0002T8h'\u0016<W.\u001a8u\u0003I!Xm\u001d;Ck&dGm\u00144gg\u0016$X*\u00199)\u0007i\ny'A\u000fuKN$8+Z4nK:$x+\u001b;i\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8xQ\rY\u0014qN\u0001\u0017i\u0016\u001cHOU3d_Z,'/_!gi\u0016\u00148I]1tQ\"\u001aA(a\u001c\u00027Q,7\u000f\u001e\"vS2$wJ\u001a4tKRl\u0015\r\u001d$bW\u0016d\u0015M]4fQ\ri\u0014qN\u0001\u001ai\u0016\u001cHOQ;jY\u0012\u0004\u0016M\u001d;jC2|eMZ:fi6\u000b\u0007\u000fK\u0002?\u0003_\n!\u0004^3ti\u000ecW-\u00198D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3TKRD3aPA8\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002A\u0003_\n!\u0003^3ti\u000ecW-\u00198U_6\u00147\u000f^8oK\"\u001a\u0011)a\u001c\u0002AQ,7\u000f^\"mK\u0006t\u0017N\\4CKf|g\u000eZ'jgNLgnZ(gMN,Go\u001d\u0015\u0004\u0005\u0006=\u0014\u0001\u0006;fgRl\u0015\r_\"mK\u0006tG+[7f'\u0016\u001c7\u000fK\u0002D\u0003_\n!b\u001e:ji\u0016$v\u000eT8h)!\u00119D!6\u0003X\n}\u0007BB5E\u0001\u0004\tI\u000bC\u0004\u0003Z\u0012\u0003\rAa7\u0002\u001b-,\u0017p]!oIZ\u000bG.^3t!\u0019\u0011IDa\u0010\u0003^B9q.a?\u0003\n\t%\u0001b\u0002Bq\t\u0002\u0007!qG\u0001\n_\u001a47/\u001a;TKF\fQ#\u001b8wC2LGm\u00117fC:,G-T3tg\u0006<W\r\u0006\u0005\u0003h\nM(q\u001fB}!\u0011\u0011IOa<\u000e\u0005\t-(\u0002\u0002Bw\u0005k\naA]3d_J$\u0017\u0002\u0002By\u0005W\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002B{\u000b\u0002\u0007!1I\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\t\u000f\teW\t1\u0001\u0003\\\"I!1`#\u0011\u0002\u0003\u0007!Q`\u0001\u0006G>$Wm\u0019\t\u0005\u0005S\u0014y0\u0003\u0003\u0004\u0002\t-(aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\b)\"!Q`B\u0005W\t\u0019Y\u0001\u0005\u0003\u0004\u000e\r]QBAB\b\u0015\u0011\u0019\tba\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAB\u000ba\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\re1q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E7fgN\fw-Z,ji\"|eMZ:fiRA!q]B\u0010\u0007_\u0019\u0019\u0004C\u0004\u0004\"\u001d\u0003\raa\t\u0002\u0007-,\u0017\u0010E\u0003p\u0007K\u0019I#C\u0002\u0004(A\u0014Q!\u0011:sCf\u00042a\\B\u0016\u0013\r\u0019i\u0003\u001d\u0002\u0005\u0005f$X\rC\u0004\u00042\u001d\u0003\raa\t\u0002\u000bY\fG.^3\t\u000f\rUr\t1\u0001\u0003D\u00051qN\u001a4tKR$\u0002Ba:\u0004:\rm2Q\b\u0005\b\u0007CA\u0005\u0019\u0001B\u0005\u0011\u001d\u0019\t\u0004\u0013a\u0001\u0005\u0013Aqa!\u000eI\u0001\u0004\u0011\u0019%A\u0004nC.,Gj\\4\u0015\u0011\u0005%61IB#\u0007\u0013B\u0001\"a\u0002J!\u0003\u0005\rA\u001f\u0005\n\u0007\u000fJ\u0005\u0013!a\u0001\u0003C\taaY8oM&<\u0007\"CB&\u0013B\u0005\t\u0019\u0001B\"\u00035\u0011XmY8wKJL\bk\\5oi\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rE#f\u0001>\u0004\n\u0005\tR.Y6f\u0019><G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r]#\u0006BA\u0011\u0007\u0013\t\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iF\u000b\u0003\u0003D\r%\u0011aC7bW\u0016\u001cE.Z1oKJ$\u0002ba\u0019\u0004j\r54q\u000f\t\u0004o\u000e\u0015\u0014bAB4Q\n91\t\\3b]\u0016\u0014\bbBB6\u001b\u0002\u0007!\u0011B\u0001\tG\u0006\u0004\u0018mY5us\"I1qN'\u0011\u0002\u0003\u00071\u0011O\u0001\nG\",7m\u001b#p]\u0016\u0004ra\\B:\u0005c\nY%C\u0002\u0004vA\u0014\u0011BR;oGRLwN\\\u0019\t\u0013\reT\n%AA\u0002\t%\u0011AD7bq6+7o]1hKNK'0Z\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019yH\u000b\u0003\u0004r\r%\u0011!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HeM\u000b\u0003\u0007\u000bSCA!\u0003\u0004\nQ1!qGBE\u0007\u0017Ca!\u001b)A\u0002\u0005%\u0006bBBG!\u0002\u0007!1\\\u0001\u0004g\u0016\fH\u0003BBI\u0007;\u0003Baa%\u0004\u001a6\u00111Q\u0013\u0006\u0004\u0007/s\u0018a\u00018j_&!11TBK\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0007?\u000b\u0006\u0019\u0001B\"\u0003\tIG\r\u0006\b\u0003h\u000e\r6QUBT\u0007W\u001b)l!/\t\u000f\r\u0005\"\u000b1\u0001\u0003\n!91\u0011\u0007*A\u0002\t%\u0001\"CBU%B\u0005\t\u0019\u0001B\"\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\n\u0007[\u0013\u0006\u0013!a\u0001\u0007_\u000bQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA8\u00042&\u001911\u00179\u0003\u000bMCwN\u001d;\t\u0013\r]&\u000b%AA\u0002\t%\u0011\u0001C:fcV,gnY3\t\u0013\rm&\u000b%AA\u0002\t%\u0011\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u0007TCaa,\u0004\n\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$H%N\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIY\n1$\u00199qK:$GK]1og\u0006\u001cG/[8oC2\f5\u000fT3bI\u0016\u0014H\u0003DBg\u0007/\u001cIna7\u0004^\u000e\u0005\bcB8\u0004t\r=7\u0011\u001b\t\u0007\u0005s\u0011iJ!\u0003\u0011\u0007]\u001c\u0019.C\u0002\u0004V\"\u0014Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007BB5X\u0001\u0004\tI\u000bC\u0004\u0004*^\u0003\rAa\u0011\t\u000f\r5v\u000b1\u0001\u00040\"I1q\\,\u0011\u0002\u0003\u0007!\u0011B\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0005\u0004d^\u0003\n\u00111\u0001\u0004f\u00061qN]5hS:\u00042a^Bt\u0013\r\u0019I\u000f\u001b\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001&CB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIQ\nQ%\u00199qK:$GK]1og\u0006\u001cG/[8oC2\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\rE(\u0006BBs\u0007\u0013\t\u0001$\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3s)9\u0019ima>\u0004z\u000em8Q C\u0004\t\u0013Aa!\u001b.A\u0002\u0005%\u0006bBBU5\u0002\u0007!1\t\u0005\b\u0007[S\u0006\u0019ABX\u0011%\u0019yP\u0017I\u0001\u0002\u0004!\t!A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\ryG1A\u0005\u0004\t\u000b\u0001(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0007?T\u0006\u0013!a\u0001\u0005\u0013A\u0011ba9[!\u0003\u0005\ra!:\u0002E\u0005\u0004\b/\u001a8e\u0013\u0012,W\u000e]8uK:$\u0018i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t!yA\u000b\u0003\u0005\u0002\r%\u0011AI1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193fe\u0012\"WMZ1vYR$S'\u0001\u0012baB,g\u000eZ%eK6\u0004x\u000e^3oi\u0006\u001bH*Z1eKJ$C-\u001a4bk2$HEN\u0001\rG>lW.\u001b;NCJ\\WM\u001d\u000b\t\u0005O$I\u0002b\u0007\u0005\u001e!91\u0011\u00160A\u0002\t\r\u0003bBBW=\u0002\u00071q\u0016\u0005\n\t?q\u0006\u0013!a\u0001\u0005\u0007\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002-\r|W.\\5u\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIM\n1\"\u00192peRl\u0015M]6feRA!q\u001dC\u0014\tS!Y\u0003C\u0004\u0004*\u0002\u0004\rAa\u0011\t\u000f\r5\u0006\r1\u0001\u00040\"IAq\u00041\u0011\u0002\u0003\u0007!1I\u0001\u0016C\n|'\u000f^'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u00031)g\u000e\u001a+y]6\u000b'o[3s)1\u00119\u000fb\r\u00056\u0011]B\u0011\tC\"\u0011\u001d\u0019IK\u0019a\u0001\u0005\u0007Bqa!,c\u0001\u0004\u0019y\u000bC\u0004\u0005:\t\u0004\r\u0001b\u000f\u0002#\r|g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\r\u0005\u0003\u0003j\u0012u\u0012\u0002\u0002C \u0005W\u0014\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\u0019)D\u0019a\u0001\u0005\u0007Bq\u0001b\bc\u0001\u0004\u0011\u0019\u0005\u0006\u0004\u0003h\u0012\u001dC\u0011\n\u0005\b\u0007C\u0019\u0007\u0019\u0001B\u0005\u0011\u001d\u0019\td\u0019a\u0001\u0007G\tQ\"\u001e8lKf,GMU3d_J$G\u0003\u0002Bt\t\u001fBqa!\re\u0001\u0004\u0011I!A\bu_6\u00147\u000f^8oKJ+7m\u001c:e)\u0011\u00119\u000f\"\u0016\t\u000f\r\u0005R\r1\u0001\u0003\n\u0005y!/Z2pm\u0016\u0014\u0018I\u001c3DQ\u0016\u001c7\u000e\u0006\u0004\u0002*\u0012mCQ\f\u0005\b\u0007\u000f2\u0007\u0019AA\u0011\u0011\u001d!yF\u001aa\u0001\u0005o\tA\"\u001a=qK\u000e$X\rZ&fsN\u0004")
public class LogCleanerTest {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$22, x$12, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$2)))), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        Log log = new Log(this, logProps, topicPartition, producerStateManager, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), LogConfig$.MODULE$.fromProps($outer.logConfig().originals(), logProps$1), 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, producerStateManager$1, new LogDirFailureChannel(10), Log$.MODULE$.$lessinit$greater$default$13(), Log$.MODULE$.$lessinit$greater$default$14());
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final Log log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            log.roll(log.roll$default$1());
        }
        Assertions.assertEquals((int)3, (int)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log, segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assertions.assertEquals((int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertTrue((((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0, (String)"Cleaned segment file should be trimmed to its real size.");
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$2, x$1, x$3));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log.elem;
        Option x$4 = qual$1.roll$default$1();
        qual$1.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog((Log)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(log, logProps);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assertions.assertEquals((long)6L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assertions.assertEquals((long)3L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log.elem;
        Option x$5 = qual$2.roll$default$1();
        qual$2.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog((Log)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(log, logProps);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    private void assertAllAbortedTxns(List<AbortedTxn> expectedAbortedTxns, Log log) {
        List abortedTxns = log.collectAbortedTransactions(0L, log.logEndOffset());
        Assertions.assertEquals(expectedAbortedTxns, (Object)abortedTxns);
    }

    private void assertAllTransactionsComplete(Log log) {
        Assertions.assertTrue((boolean)log.activeProducers().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$assertAllTransactionsComplete$1(x$3))));
    }

    @Test
    public void testMultiPassSegmentCleaningWithAbortedTransactions() {
        int deleteRetentionMs = 50000;
        int offsetMapSlots = 4;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), Integer.toString(deleteRetentionMs));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int producerId1 = 1;
        int producerId2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, producerId1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, producerId2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        this.commit$1(producerId1, log, producerEpoch);
        this.commit$1(producerId2, log, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        this.abort$1(producerId1, log, producerEpoch);
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        this.commit$1(producerId1, log, producerEpoch);
        this.abort$1(producerId2, log, producerEpoch);
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        this.commit$1(producerId2, log, producerEpoch);
        log.roll(log.roll$default$1());
        Assertions.assertEquals((long)20L, (long)log.logEndOffset());
        .colon.colon expectedAbortedTxns = new .colon.colon((Object)new AbortedTxn((long)producerId1, 8L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn((long)producerId2, 11L, 16L, 17L), (List)Nil$.MODULE$));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)expectedAbortedTxns, log);
        LongRef dirtyOffset = LongRef.create((long)0L);
        this.cleanSegments$1(0L, offsetMapSlots, log, cleaner, dirtyOffset);
        Assertions.assertEquals((long)4L, (long)dirtyOffset.elem);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 10, 13, 15, 16, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5, 6, 7, 10, 13, 14, 15, 16, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)expectedAbortedTxns, log);
        this.cleanSegments$1(0L, offsetMapSlots, log, cleaner, dirtyOffset);
        Assertions.assertEquals((long)14L, (long)dirtyOffset.elem);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 10, 13, 15, 16, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 5, 6, 7, 10, 13, 14, 15, 16, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)Nil$.MODULE$, log);
        this.cleanSegments$1(Long.MAX_VALUE, offsetMapSlots, log, cleaner, dirtyOffset);
        Assertions.assertEquals((long)20L, (long)dirtyOffset.elem);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 7, 13, 15, 17, 19})), this.batchBaseOffsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 5, 6, 7, 13, 15, 17, 18, 19})), this.offsetsInLog(log));
        this.assertAllTransactionsComplete(log);
        this.assertAllAbortedTxns((List<AbortedTxn>)Nil$.MODULE$, log);
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()))._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 100;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        Log log = this.makeLog(x$5, x$4, x$6);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int x$8 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$8, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int x$13 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$13, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((int)0, (int)log.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$42 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        Log log = this.makeLog(x$5, x$42, x$6);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)((LogSegment)log.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$4)))), LogTest$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(x$1, x$3, x$2).cleanSegments((Log)log2, (Seq)new .colon.colon((Object)((LogSegment)log2.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog((Log)log2).filter((Function1)((JFunction1.mcZJ.sp & Serializable & scala.Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)offsetMap2, arg_0)))), LogTest$.MODULE$.keysInLog((Log)log2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (Log)log2, (FakeOffsetMap)offsetMap2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (Log)log2, (FakeOffsetMap)offsetMap2));
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable & scala.Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Set keys = LogTest$.MODULE$.keysInLog(log).toSet();
        Assertions.assertTrue((boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$8))), (String)"None of the keys we deleted should still exist.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerStats() {
        void var13_10;
        void var11_9;
        Cleaner cleaner = this.makeCleaner(4, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((long)5L, (long)var11_9);
        Assertions.assertEquals((long)5L, (long)var13_10.messagesRead());
        Assertions.assertEquals((long)initialLogSize, (long)var13_10.bytesRead());
        Assertions.assertEquals((long)2L, (long)var13_10.messagesWritten());
        Assertions.assertEquals((long)log.size(), (long)var13_10.bytesWritten());
        Assertions.assertEquals((long)0L, (long)var13_10.invalidMessagesRead());
        Assertions.assertTrue((var13_10.endTime() >= var13_10.startTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 > N), (String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.");
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))), (String)"The cleanable segments should have fewer number of values after cleaning");
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))), (String)"The uncleanable segments should have the same number of values after cleaning");
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        Assertions.assertEquals((long)new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()).totalBytes(), (long)(log.size() - (long)log.activeSegment().size()), (String)"Total bytes of LogToClean should equal size of all segments excluding the active segment");
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), LogToClean$.MODULE$.apply$default$5());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertEquals((long)logToClean.cleanBytes(), (long)expectedCleanSize, (String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty");
        Assertions.assertEquals((long)logToClean.cleanableBytes(), (long)expectedCleanableSize, (String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset");
        Assertions.assertEquals((long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize), (String)"Total bytes should be the sum of the clean and cleanable segments");
        Assertions.assertEquals((double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6, (String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var14_11;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((int)0, (int)this.unkeyedMessageCountInLog(log), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)expectedSizeAfterCleaning, (long)log.size(), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)numInvalidMessages, (long)var14_11.invalidMessagesRead(), (String)"Cleaner should have seen %d invalid messages.");
    }

    private Iterable<Object> batchBaseOffsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.baseOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log) {
        return ((TraversableOnce)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable & scala.Serializable)batch -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        void makeCleaner_checkDone;
        void makeCleaner_maxMessageSize;
        int n = this.makeCleaner$default$3();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), (int)makeCleaner_maxMessageSize, (int)makeCleaner_maxMessageSize, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$16))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$17))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$19))), (String)"All but the last group should be the target size.");
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$20)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$21))), (String)"All but the last group should be the target size.");
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)(log.numberOfSegments() - 1), (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assertions.assertTrue((log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Actual offset range should be > Int.MaxValue");
        Assertions.assertTrue((((LogSegment)log.logSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"index.lastOffset is reporting the wrong last offset");
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$22 -> (Seq)x$22.map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)x$23.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets, (String)"Offsets should be in increasing order.");
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        long x$2 = Long.MAX_VALUE;
        File x$3 = this.makeLog$default$1();
        Log log = this.makeLog(x$3, config, x$2);
        LogSegment segmentWithOverflow = (LogSegment)LogTest$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        int numSegmentsInitial = log.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            expectedKeysAfterCleaning.$plus$eq(allKeys.apply(k - 1));
            offsetMap.put(this.key(BoxesRunTime.unboxToLong((Object)allKeys.apply(k))), Long.MAX_VALUE);
        });
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)log.logSegments().size());
        Assertions.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentToClean, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, config, x$3);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$5 = 0;
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$4, x$5, x$6, x$7);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$8 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$9 = 0;
            AppendOrigin x$10 = log.appendAsLeader$default$3();
            ApiVersion x$11 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$8, x$9, x$10, x$11);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$12 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$13 = 0;
            AppendOrigin x$14 = log.appendAsLeader$default$3();
            ApiVersion x$15 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$12, x$13, x$14, x$15);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((long)offsetEnd, (long)map.latestOffset(), (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(keyEnd - keyStart), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        Assertions.assertEquals((long)0L, (long)map.get(this.key(0L)), (String)"Map should contain first value");
        Assertions.assertEquals((long)offsetEnd, (long)map.get(this.key(1L)), (String)"Map should contain second value");
    }

    @Test
    public void testBuildPartialOffsetMap() {
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        OffsetMap map = cleaner.offsetMap();
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, map, stats);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assertions.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assertions.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assertions.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3()).buffer());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$7 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$8 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, x$8), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$12 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$13 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, x$13), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType x$17 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$18 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_9;
        void var6_6;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(0x100000));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Log log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)11L)));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)var6_6, (String)"Cleaning point should pass offset gap");
        Log log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)15L)));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(15L)).to((Object)BoxesRunTime.boxToLong((long)24L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)30L)));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)log2.activeSegment().baseOffset(), (long)var10_9, (String)"Cleaning point should pass offset gap in multiple segments");
    }

    @Test
    public void testMaxCleanTimeSecs() {
        LogCleaner logCleaner = new LogCleaner(new CleanerConfig(CleanerConfig$.MODULE$.$lessinit$greater$default$1(), CleanerConfig$.MODULE$.$lessinit$greater$default$2(), CleanerConfig$.MODULE$.$lessinit$greater$default$3(), CleanerConfig$.MODULE$.$lessinit$greater$default$4(), CleanerConfig$.MODULE$.$lessinit$greater$default$5(), CleanerConfig$.MODULE$.$lessinit$greater$default$6(), CleanerConfig$.MODULE$.$lessinit$greater$default$7(), CleanerConfig$.MODULE$.$lessinit$greater$default$8(), CleanerConfig$.MODULE$.$lessinit$greater$default$9()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir()}), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()), new LogDirFailureChannel(1), (Time)this.time());
        try {
            this.checkGauge$1("max-buffer-utilization-percent", logCleaner);
            this.checkGauge$1("max-clean-time-secs", logCleaner);
            this.checkGauge$1("max-compaction-delay-secs", logCleaner);
        }
        finally {
            logCleaner.shutdown();
        }
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null))).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$24)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])Integer.toString(kv._1$mcI$sp()).getBytes(), (byte[])Integer.toString(kv._2$mcI$sp()).getBytes()), Iterable$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToInteger((int)x$25.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(Integer.toString(key).getBytes(), Integer.toString(value).getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        long x$3 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        boolean x$11 = Log$.MODULE$.apply$default$11();
        boolean x$12 = Log$.MODULE$.apply$default$12();
        return Log$.MODULE$.apply(dir, config, x$3, recoveryPoint, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$12);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$26 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$26);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$27)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(Long.toString(id).getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        boolean x$4 = true;
        int x$6 = this.appendIdempotentAsLeader$default$5();
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, x$4, x$6, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$1 = Integer.toString(key).getBytes();
        CompressionType x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, x$4, x$5);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(Integer.toString(value).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler());
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$2) {
        ((Log)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$2);
        long x$2 = 0L;
        File x$3 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$3, x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$assertAllTransactionsComplete$1(DescribeProducersResponseData.ProducerState x$3) {
        return x$3.currentTxnStartOffset() == -1L;
    }

    private final void abort$1(long producerId, Log log$3, short producerEpoch$1) {
        log$3.appendAsLeader(this.abortMarker(producerId, producerEpoch$1, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Replication$.MODULE$, log$3.appendAsLeader$default$4());
    }

    private final void commit$1(long producerId, Log log$3, short producerEpoch$1) {
        log$3.appendAsLeader(this.commitMarker(producerId, producerEpoch$1, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Replication$.MODULE$, log$3.appendAsLeader$default$4());
    }

    private final void cleanSegments$1(long deleteHorizonMs, int offsetMapSlots$1, Log log$3, Cleaner cleaner$1, LongRef dirtyOffset$1) {
        FakeOffsetMap offsetMap = new FakeOffsetMap(offsetMapSlots$1);
        Seq segments = log$3.logSegments(0L, log$3.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats((Time)this.time());
        cleaner$1.buildOffsetMap(log$3, dirtyOffset$1.elem, log$3.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner$1.cleanSegments(log$3, segments, (OffsetMap)offsetMap, deleteHorizonMs, stats, new CleanedTransactionMetadata());
        dirtyOffset$1.elem = offsetMap.latestOffset() + 1L;
    }

    private static final void assertAbortedTransactionIndexed$1(Log log$4, long producerId$1) {
        List abortedTxns = log$4.collectAbortedTransactions(0L, 100L);
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        Assertions.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(Long.toString(k));
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$2, Log log$5, FakeOffsetMap offsetMap$2) {
        cleaner$2.cleanSegments(log$5, (Seq)new .colon.colon((Object)((LogSegment)log$5.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$3, Log log$6, FakeOffsetMap offsetMap$3) {
        cleaner$3.cleanSegments(log$6, (Seq)new .colon.colon((Object)((LogSegment)log$6.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(Log log$8) {
        return ((TraversableOnce)log$8.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int before = x0$1._1$mcI$sp();
        boolean bl = x0$1._2$mcI$sp() < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$16) {
        return x$16.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$17) {
        return x$17.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$19) {
        return x$19.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$20) {
        return x$20.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$21) {
        return x$21.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$5, Log log$12) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$5.buildOffsetMap(log$12, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assertions.assertEquals((long)end, (long)endOffset, (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(end - start), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i)), (String)"Should find all the keys"));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(start - 1)), (String)"Should not find a value too small");
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(end)), (String)"Should not find a value too large");
        Assertions.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assertions.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ int kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1() {
        return 999;
    }

    private final void checkGauge$1(String name, LogCleaner logCleaner$1) {
        Gauge gauge = logCleaner$1.newGauge(name, (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerTest $outer;

            public final int value() {
                return LogCleanerTest.kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, logCleaner$1.newGauge$default$3());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$14, Tuple2 x$24) {
        long offset;
        Tuple2 tuple2;
        block3: {
            block2: {
                if (x$24 == null) break block2;
                tuple2 = (Tuple2)x$24._1();
                offset = x$24._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x$24);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$14.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$26) {
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$15, Tuple2 x$27) {
        if (x$27 == null) {
            throw new MatchError(null);
        }
        int key = x$27._1$mcI$sp();
        int value = x$27._2$mcI$sp();
        long l = ((LogOffsetMetadata)log$15.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$15.appendAsLeader$default$3(), log$15.appendAsLeader$default$4()).firstOffset().get()).messageOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = Integer.toString(key).getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$1 = Double.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        MockTime x$3 = this.time();
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$1, x$2, x$4, x$5, x$6, (Time)x$3);
    }
}

