/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\u0015*\u00019BQa\u0010\u0001\u0005\u0002\u0001C\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011B\"\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0006\"\u0003/\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0011%i\u0006\u00011AA\u0002\u0013%a\fC\u0005h\u0001\u0001\u0007\t\u0019!C\u0005Q\"I!\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u0018\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u0002!9\u0011Q\u0003\u0001\u0005\u0002\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003;\u0001A\u0011AA\u0001\u0011\u001d\t\t\u0003\u0001C\u0001\u0003\u0003Aq!!\n\u0001\t\u0003\t\t\u0001C\u0004\u0002*\u0001!\t!!\u0001\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u0002!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u0005\u0001bBA\u001b\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003s\u0001A\u0011AA\u0001\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u0003Aq!!\u0011\u0001\t\u0003\t\t\u0001C\u0004\u0002F\u0001!\t!!\u0001\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u0002!9\u0011Q\n\u0001\u0005\u0002\u0005\u0005\u0001bBA)\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003+\u0002A\u0011AA\u0001\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u0003Aq!!\u0018\u0001\t\u0003\t\t\u0001C\u0004\u0002b\u0001!\t!!\u0001\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\u0002!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u0005\u0001bBA7\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003c\u0002A\u0011AA\u0001\u0011\u001d\t)\b\u0001C\u0001\u0003\u0003Aq!!\u001f\u0001\t\u0003\t\t\u0001C\u0004\u0002~\u0001!\t!!\u0001\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0002!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d%\u0001\b+pa&\u001c7i\\7nC:$w+\u001b;i5.\u001bE.[3oiR+7\u000f\u001e\u0006\u0003U-\nQ!\u00193nS:T\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q&N\u001e\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IZ\u0013A\u0001>l\u0013\t!\u0014G\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q-\nQ!\u001e;jYNL!AO\u001c\u0003\u000f1{wmZ5oOB\u0011A(P\u0007\u0002S%\u0011a(\u000b\u0002\u000e%\u0006\u001c7.Q<be\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\u001f\u0001\u00031!x\u000e]5d'\u0016\u0014h/[2f+\u0005!\u0005CA#P\u001d\t1UJ\u0004\u0002H\u0019:\u0011\u0001jS\u0007\u0002\u0013*\u0011!*L\u0001\u0007yI|w\u000e\u001e \n\u00031J!AK\u0016\n\u00059K\u0013\u0001\u0004+pa&\u001c7i\\7nC:$\u0017B\u0001)R\u0005UQvn\\6fKB,'\u000fV8qS\u000e\u001cVM\u001d<jG\u0016T!AT\u0015\u0002!Q|\u0007/[2TKJ4\u0018nY3`I\u0015\fHC\u0001+[!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u0011)f.\u001b;\t\u000fm\u001b\u0011\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQ|\u0007/[2TKJ4\u0018nY3!\u00035!Xm\u001d;U_BL7MT1nKV\tq\f\u0005\u0002aI:\u0011\u0011M\u0019\t\u0003\u0011ZK!a\u0019,\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GZ\u000b\u0011\u0003^3tiR{\u0007/[2OC6,w\fJ3r)\t!\u0016\u000eC\u0004\\\r\u0005\u0005\t\u0019A0\u0002\u001dQ,7\u000f\u001e+pa&\u001cg*Y7fA\u0005)1/\u001a;vaR\u0011A+\u001c\u0005\u0006]\"\u0001\ra\\\u0001\u0005S:4w\u000e\u0005\u0002qs6\t\u0011O\u0003\u0002sg\u0006\u0019\u0011\r]5\u000b\u0005Q,\u0018a\u00026va&$XM\u001d\u0006\u0003m^\fQA[;oSRT\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>r\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\u0005}!\t\u0001X0\u0003\u0002\u007fc\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:$\u0012\u0001\u0016\u0015\u0004\u0013\u0005\u0015\u0001c\u00019\u0002\b%\u0019\u0011\u0011B9\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0003;fgR\u001c%/Z1uK\"\u001a!\"a\u0004\u0011\u0007A\f\t\"C\u0002\u0002\u0014E\u0014A\u0001V3ti\u0006)B/Z:u\u0007J,\u0017\r^3XSRD7i\u001c8gS\u001e\u001c\bfA\u0006\u0002\u0010\u0005)B/Z:u\u0007J,\u0017\r^3JM:{G/\u0012=jgR\u001c\bf\u0001\u0007\u0002\u0010\u0005yB/Z:u\u0007J,\u0017\r^3XSRD'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u00075\ty!\u0001\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JD3ADA\b\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007=\ty!\u0001\u0013uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r\u0001\u0012qB\u0001\u001ci\u0016\u001cH/\u00138wC2LG\rV8qS\u000edUM^3m\u0007>tg-[4)\u0007E\ty!\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007I\ty!A\u000fuKN$H*[:u)>\u0004\u0018nY:XSRD\u0017J\\2mk\u0012,G*[:uQ\r\u0019\u0012qB\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0004)\u0005=\u0011a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r)\u0012qB\u0001\u0014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e\u001e\u0015\u0004-\u0005=\u0011A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002\u0018\u0003\u001f\t\u0011\u0003^3ti\u0006cG/\u001a:JM\u0016C\u0018n\u001d;tQ\rA\u0012qB\u0001\u0011i\u0016\u001cH/\u00117uKJ\u001cuN\u001c4jOND3!GA\b\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8oQ\rQ\u0012qB\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t\u0007fA\u000e\u0002\u0010\u0005\u0011B/Z:u\t\u0016dW\r^3JM\u0016C\u0018n\u001d;tQ\ra\u0012qB\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\u001c;fe:\fG\u000eV8qS\u000eD3!HA\b\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u0013\u001a$v\u000e]5d\u001d>$X\t_5tiND3AHA\b\u0003\u0005\"Xm\u001d;De\u0016\fG/Z!mi\u0016\u0014Hk\u001c9jG^KG\u000f\u001b*bG.\fu/\u0019:fQ\ry\u0012qB\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0004A\u0005=\u0011a\t;fgR$Um]2sS\n,'+\u001a9peR|e/\u001a:sS\u0012$WM\\\"p]\u001aLwm\u001d\u0015\u0004C\u0005=\u0011A\u000b;fgR$Um]2sS\n,\u0017I\u001c3MSN$Hk\u001c9jGNl\u0015M]6fI\u001a{'\u000fR3mKRLwN\u001c\u0015\u0004E\u0005=\u0011A\f;fgR$Um]2sS\n,\u0017I\u001c3MSN$Hk\u001c9jGN<\u0016\u000e\u001e5pkRLe\u000e^3s]\u0006dGk\u001c9jGND3aIA\b\u00035\"Xm\u001d;U_BL7m\u00149fe\u0006$\u0018n\u001c8t/&$\bNU3hKb\u001c\u00160\u001c2pY&sGk\u001c9jG:\u000bW.\u001a\u0015\u0004I\u0005=\u0011\u0001\n;fgR\fE\u000e^3s\u0013:$XM\u001d8bYR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0007\u0015\ny!A\"uKN$8I]3bi\u0016<\u0016\u000e\u001e5V]N\u0004XmY5gS\u0016$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:B]\u0012\u0004\u0016M\u001d;ji&|gn],ji\"T6n\u00117jK:$\bf\u0001\u0014\u0002\u0010\u0005q\u0011m]:feR,\u00050\u001b;D_\u0012,G#\u0002+\u0002\n\u0006M\u0005bBAFO\u0001\u0007\u0011QR\u0001\tKb\u0004Xm\u0019;fIB\u0019Q+a$\n\u0007\u0005EeKA\u0002J]RDq!!&(\u0001\u0004\t9*\u0001\u0004nKRDw\u000e\u001a\t\u0005+\u0006eE+C\u0002\u0002\u001cZ\u0013\u0011BR;oGRLwN\u001c\u0019")
public class TopicCommandWithZKClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService topicService;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private TopicCommand.ZookeeperTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.topicService = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    @BeforeEach
    public void setup(TestInfo info) {
        this.topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void teardown() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        KafkaZkClient qual$1 = this.zkClient();
        boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
        Assertions.assertTrue((boolean)qual$1.getAllTopicsInCluster(x$1).contains((Object)this.testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"})));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName(), "--if-not-exists"}));
        this.topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 0));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 1));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions.assertThrows(InvalidReplicationFactorException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions.assertThrows(InvalidPartitionsException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.format.version=boom"}));
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithIncludeList() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic1, x$2, x$3, x$4, x$5, x$6);
        AdminZkClient qual$2 = this.adminZkClient();
        int x$8 = 2;
        int x$9 = 2;
        Properties x$10 = qual$2.createTopic$default$4();
        RackAwareMode x$11 = qual$2.createTopic$default$5();
        boolean x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topic2, x$8, x$9, x$10, x$11, x$12);
        AdminZkClient qual$3 = this.adminZkClient();
        int x$14 = 2;
        int x$15 = 2;
        Properties x$16 = qual$3.createTopic$default$4();
        RackAwareMode x$17 = qual$3.createTopic$default$5();
        boolean x$18 = qual$3.createTopic$default$6();
        qual$3.createTopic(topic3, x$14, x$15, x$16, x$17, x$18);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertTrue((boolean)string.contains(topic2));
        Assertions.assertFalse((boolean)string.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$7 = "__consumer_offsets";
        int x$8 = 2;
        int x$9 = 2;
        Properties x$10 = qual$2.createTopic$default$4();
        RackAwareMode x$11 = qual$2.createTopic$default$5();
        boolean x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$7, x$8, x$9, x$10, x$11, x$12);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assertions.assertEquals((int)3, (int)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
    }

    @Test
    public void testAlterAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assertions.assertEquals((int)3, (int)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions.assertThrows(InvalidPartitionsException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().alterTopic(alterOpts));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
        this.topicService().alterTopic(alterExistsOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=compact"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains("Configs: cleanup.policy=compact"), (String)"The output should contain the modified config");
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=delete"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out2.toString().contains("Configs: cleanup.policy=delete"), (String)"The output should contain the modified config");
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)props.containsKey(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)props.getProperty(cleanupKey).equals(cleanupVal), (String)"Properties after creation have incorrect value");
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)newProps.containsKey(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)newProps.getProperty(cleanupKey).equals(cleanupVal), (String)"Updated properties have incorrect value");
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOpts);
        Assertions.assertTrue((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic should exist after deletion.");
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        Assertions.assertThrows(AdminOperationException.class, () -> this.topicService().deleteTopic(deleteOffsetTopicOpts));
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist after deletion.");
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        Assertions.assertThrows(AdminOperationException.class, () -> this.topicService().deleteTopic(deleteOffsetTopicOpts));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(describeOpts));
        TopicCommand.TopicCommandOptions describeOptsAllTopics = new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        this.topicService().describeTopic(describeOptsAllTopics);
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().describeTopic(describeOptsWithExists);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsWithConfig$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((string.contains(this.testTopicName()) && string.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsNoConfig$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((string2.contains(this.testTopicName()) && string2.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.listTopics$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = grabConsoleOutput_out3.toString();
        Assertions.assertTrue((string3.contains(this.testTopicName()) && string3.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)string2.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string2.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", topic1}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--topic", topic2}));
        this.topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", escapedTopic}));
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", unescapedTopic}));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(escapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertFalse((boolean)grabConsoleOutput_out.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(unescapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out2.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(escapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertFalse((boolean)grabConsoleOutput_out3.toString().contains(topic2));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect4 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(unescapedCommandOpts);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out4 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out4, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out4.toString().contains(topic2));
    }

    @Test
    public void testAlterInternalTopicPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "__consumer_offsets";
        int x$2 = 1;
        int x$3 = 1;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$7 = "__transaction_state";
        int x$8 = 1;
        int x$9 = 1;
        Properties x$10 = qual$2.createTopic$default$4();
        RackAwareMode x$11 = qual$2.createTopic$default$5();
        boolean x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$7, x$8, x$9, x$10, x$11, x$12);
        this.expectAlterInternalTopicPartitionCountFailed$1("__consumer_offsets");
        this.expectAlterInternalTopicPartitionCountFailed$1("__transaction_state");
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()})).checkArgs());
    }

    /*
     * WARNING - void declaration
     */
    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithZKClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(RuntimeException.class, () -> method.apply$mcV$sp());
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private final void describeTopicsWithConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    private final void describeTopicsNoConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    private final void listTopics$1() {
        this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    private final void expectAlterInternalTopicPartitionCountFailed$1(String topic) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topic, "--partitions", "2"}))));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assertions.assertEquals((int)expected$1, (int)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandWithZKClientTest() {
        RackAwareTest.$init$(this);
    }
}

