/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002!B\u0001\u0019CQa\u0016\u0001\u0005\u0002aCQA\u0017\u0001\u0005BmCqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004q\u0001\u0001\u0006I\u0001\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"Iq\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001f\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002\u0003\u0006\u0002\u001e\u0001\u0001\r\u0011!Q!\neD1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0011-\t\t\u0005\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011Q\t\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0006C\u0006\u0002^\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0003\u0002CA0\u0001\u0001&I!!\u0019\t\u0011\u00055\u0004\u0001)C\u0005\u0003_B\u0011\"!\u001f\u0001#\u0003%I!a\u001f\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAa\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0017\u0004A\u0011AA\\\u0011\u001d\ty\r\u0001C\u0001\u0003oCq!a5\u0001\t\u0003\t9\fC\u0004\u0002X\u0002!\t!a.\t\u000f\u0005m\u0007\u0001\"\u0001\u00028\"9\u0011q\u001c\u0001\u0005\u0002\u0005]\u0006bBAr\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003O\u0004A\u0011AA\\\u0011\u001d\tY\u000f\u0001C\u0001\u0003oCq!a<\u0001\t\u0003\t9\fC\u0004\u0002t\u0002!\t!a.\t\u000f\u0005]\b\u0001\"\u0001\u00028\"9\u00111 \u0001\u0005\u0002\u0005]\u0006bBA\u0000\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005\u0007\u0001A\u0011AA\\\u0011\u001d\u00119\u0001\u0001C\u0001\u0003oCqAa\u0003\u0001\t\u0003\t9\fC\u0004\u0003\u0010\u0001!\t!a.\t\u000f\tM\u0001\u0001\"\u0001\u00028\"9!q\u0003\u0001\u0005\u0002\u0005]\u0006b\u0002B\u000e\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005?\u0001A\u0011AA\\\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003oCqAa\n\u0001\t\u0003\t9\fC\u0004\u0003,\u0001!\t!a.\t\u000f\t=\u0002\u0001\"\u0001\u00028\"9!1\u0007\u0001\u0005\u0002\u0005]\u0006b\u0002B\u001c\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005w\u0001A\u0011AA\\\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003oCqAa\u0011\u0001\t\u0003\t9\fC\u0004\u0003H\u0001!\t!a.\t\u000f\t-\u0003\u0001\"\u0001\u00028\"9!q\n\u0001\u0005\u0002\u0005]\u0006b\u0002B*\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005/\u0002A\u0011AA\\\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003oCqAa\u0018\u0001\t\u0003\t9\fC\u0004\u0003d\u0001!\t!a.\t\u000f\t\u001d\u0004\u0001\"\u0001\u00028\"9!1\u000e\u0001\u0005\u0002\u0005]\u0006b\u0002B8\u0001\u0011\u0005\u0011q\u0017\u0002 )>\u0004\u0018nY\"p[6\fg\u000eZ,ji\"\fE-\\5o\u00072LWM\u001c;UKN$(B\u0001\"D\u0003\u0015\tG-\\5o\u0015\u0005!\u0015!B6bM.\f7\u0001A\n\u0005\u0001\u001dk5\u000b\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\u0007\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0013\ta\u0015J\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tq\u0015+D\u0001P\u0015\t\u00016)A\u0003vi&d7/\u0003\u0002S\u001f\n9Aj\\4hS:<\u0007C\u0001+V\u001b\u0005\t\u0015B\u0001,B\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\u00061A(\u001b8jiz\"\u0012!\u0017\t\u0003)\u0002\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u00029B\u0019QL\u00193\u000e\u0003yS!a\u00181\u0002\u0015\r|G\u000e\\3di&|gNC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019gLA\u0002TKF\u0004\"!\u001a5\u000e\u0003\u0019T!aZ\"\u0002\rM,'O^3s\u0013\tIgMA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001m!\tig.D\u0001a\u0013\ty\u0007MA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\reK\u001a\fW\u000f\u001c;SKBd\u0017nY1uS>tg)Y2u_J,\u0012a\u001d\t\u0003[RL!!\u001e1\u0003\u000bMCwN\u001d;\u00023\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\ri>\u0004\u0018nY*feZL7-Z\u000b\u0002sB\u0019!0!\u0003\u000f\u0007m\f)AD\u0002}\u0003\u0007q1!`A\u0001\u001b\u0005q(BA@F\u0003\u0019a$o\\8u}%\tA)\u0003\u0002C\u0007&\u0019\u0011qA!\u0002\u0019Q{\u0007/[2D_6l\u0017M\u001c3\n\t\u0005-\u0011Q\u0002\u0002\u0018\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fV8qS\u000e\u001cVM\u001d<jG\u0016T1!a\u0002B\u0003A!x\u000e]5d'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005e\u0001cA7\u0002\u0016%\u0019\u0011q\u00031\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037A\u0011\u0011!a\u0001s\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQ|\u0007/[2TKJ4\u0018nY3!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003oi!!a\n\u000b\u0007\t\u000bIC\u0003\u0003\u0002,\u00055\u0012aB2mS\u0016tGo\u001d\u0006\u0004\t\u0006=\"\u0002BA\u0019\u0003g\ta!\u00199bG\",'BAA\u001b\u0003\ry'oZ\u0005\u0005\u0003s\t9CA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\u0011\t\u0019\"a\u0010\t\u0013\u0005m1\"!AA\u0002\u0005\r\u0012\u0001D1e[&t7\t\\5f]R\u0004\u0013!\u0004;fgR$v\u000e]5d\u001d\u0006lW-\u0006\u0002\u0002HA!\u0011\u0011JA)\u001d\u0011\tY%!\u0014\u0011\u0005u\u0004\u0017bAA(A\u00061\u0001K]3eK\u001aLA!a\u0015\u0002V\t11\u000b\u001e:j]\u001eT1!a\u0014a\u0003E!Xm\u001d;U_BL7MT1nK~#S-\u001d\u000b\u0005\u0003'\tY\u0006C\u0005\u0002\u001c9\t\t\u00111\u0001\u0002H\u0005qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013AE2sK\u0006$X-\u00118e/\u0006LG\u000fV8qS\u000e$B!a\u0005\u0002d!9\u0011Q\r\tA\u0002\u0005\u001d\u0014\u0001B8qiN\u00042A_A5\u0013\u0011\tY'!\u0004\u0003'Q{\u0007/[2D_6l\u0017M\u001c3PaRLwN\\:\u0002']\f\u0017\u000e\u001e$peR{\u0007/[2De\u0016\fG/\u001a3\u0015\r\u0005M\u0011\u0011OA;\u0011\u001d\t\u0019(\u0005a\u0001\u0003\u000f\n\u0011\u0002^8qS\u000et\u0015-\\3\t\u0011\u0005]\u0014\u0003%AA\u00021\fq\u0001^5nK>,H/A\u000fxC&$hi\u001c:U_BL7m\u0011:fCR,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tiHK\u0002m\u0003\u007fZ#!!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017\u0003\u0017AC1o]>$\u0018\r^5p]&!\u0011qRAC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0005\u0003'\t)\nC\u0004\u0002\u0018N\u0001\r!!'\u0002\t%tgm\u001c\t\u0005\u00037\u000bI+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\r\t\u0007/\u001b\u0006\u0005\u0003G\u000b)+A\u0004kkBLG/\u001a:\u000b\t\u0005\u001d\u00161G\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003W\u000biJ\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0019\u0012q\u0016\t\u0005\u00037\u000b\t,\u0003\u0003\u00024\u0006u%A\u0003\"fM>\u0014X-R1dQ\u0006)1\r\\8tKR\u0011\u00111\u0003\u0015\u0004)\u0005m\u0006\u0003BAN\u0003{KA!a0\u0002\u001e\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cHo\u0011:fCR,\u0007fA\u000b\u0002FB!\u00111TAd\u0013\u0011\tI-!(\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7ug\"\u001aa#!2\u0002AQ,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c\u0015\u0004/\u0005\u0015\u0017a\b;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e\u001e)beRLG/[8og\"\u001a\u0001$!2\u0002+Q,7\u000f^\"sK\u0006$XmV5uQ\u000e{gNZ5hg\"\u001a\u0011$!2\u00027Q,7\u000f^\"sK\u0006$Xm\u00165f]\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\rQ\u0012QY\u0001+i\u0016\u001cHo\u0011:fCR,w\u000b[3o\u00032\u0014X-\u00193z\u000bbL7\u000f^:XSRD\u0017J\u001a(pi\u0016C\u0018n\u001d;tQ\rY\u0012QY\u0001 i\u0016\u001cHo\u0011:fCR,w+\u001b;i%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u000f\u0002F\u00061C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007u\t)-A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f%\u0016\u0004H.[2bi&|gNR1di>\u0014\bf\u0001\u0010\u0002F\u0006!C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4X\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002 \u0003\u000b\f1\u0004^3ti&sg/\u00197jIR{\u0007/[2MKZ,GnQ8oM&<\u0007f\u0001\u0011\u0002F\u0006qA/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\bfA\u0011\u0002F\u0006iB/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u0013:\u001cG.\u001e3f\u0019&\u001cH\u000fK\u0002#\u0003\u000b\f\u0011\u0005^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ\u0016C8\r\\;eK&sG/\u001a:oC2D3aIAc\u0003]!Xm\u001d;BYR,'\u000fU1si&$\u0018n\u001c8D_VtG\u000fK\u0002%\u0003\u000b\f1\u0003^3ti\u0006cG/\u001a:BgNLwM\\7f]RD3!JAc\u0003M\"Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u/&$\b.T8sK\u0006\u001b8/[4o[\u0016tG\u000f\u00165b]B\u000b'\u000f^5uS>t7\u000fK\u0002'\u0003\u000b\f1\u0007^3ti\u0006cG/\u001a:BgNLwM\\7f]R<\u0016\u000e\u001e5N_J,\u0007+\u0019:uSRLwN\\:UQ\u0006t\u0017i]:jO:lWM\u001c;)\u0007\u001d\n)-\u0001\u0012uKN$\u0018\t\u001c;fe^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004Q\u0005\u0015\u0017!\b;fgR\fE\u000e^3s/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;)\u0007%\n)-A\u0015uKN$\u0018\t\u001c;fe^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u/&$\b.\u00134Fq&\u001cHo\u001d\u0015\u0004U\u0005\u0015\u0017!\t;fgR\u001c%/Z1uK\u0006cG/\u001a:U_BL7mV5uQJ\u000b7m[!xCJ,\u0007fA\u0016\u0002F\u0006yC/Z:u\u0007>tg-[4Qe\u0016\u001cXM\u001d<bi&|g.Q2s_N\u001c\b+\u0019:uSRLwN\\!mi\u0016\u0014\u0018\r^5p]\"\u001aA&!2\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eK\u0002.\u0003\u000b\fq\u0003^3ti\u0012+G.\u001a;f\u0013:$XM\u001d8bYR{\u0007/[2)\u00079\n)-\u0001\u0010uKN$H)\u001a7fi\u0016<\u0006.\u001a8U_BL7\rR8fg:$X\t_5ti\"\u001aq&!2\u0002UQ,7\u000f\u001e#fY\u0016$Xm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$x+\u001b;i\u0013\u001a,\u00050[:ug\"\u001a\u0001'!2\u0002\u0019Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3)\u0007E\n)-\u0001\u0011uKN$H)Z:de&\u0014Wm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$\bf\u0001\u001a\u0002F\u0006aC/Z:u\t\u0016\u001c8M]5cK^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u/&$\b.\u00134Fq&\u001cHo\u001d\u0015\u0004g\u0005\u0015\u0017!\t;fgR$Um]2sS\n,WK\\1wC&d\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u001b\u0002F\u0006)C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004k\u0005\u0015\u0017!\t;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u001c\u0002F\u0006\tE/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn],iK:\u0014V-Y:tS\u001etW.\u001a8u\u0013NLe\u000e\u0015:pOJ,7o\u001d\u0015\u0004o\u0005\u0015\u0017A\b;fgR$Um]2sS\n,\u0017\t^'j]&\u001b(\u000fU1si&$\u0018n\u001c8tQ\rA\u0014QY\u0001'i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn]'jq\u0016$\u0007fA\u001d\u0002F\u0006\u0019C/Z:u\t\u0016\u001c8M]5cKJ+\u0007o\u001c:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\bf\u0001\u001e\u0002F\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\rY\u0014QY\u0001=i\u0016\u001cH\u000fR3tGJL'-\u001a#pKNtu\u000e\u001e$bS2<\u0006.\u001a8MSN$\u0018N\\4SK\u0006\u001c8/[4o[\u0016tG/S:V]\u0006,H\u000f[8sSj,G\rK\u0002=\u0003\u000b\f1\b^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019#pKNtu\u000e\u001e*fiJLH\u000b\u001b:piRd\u0017N\\4Rk>$\u0018-\u0012=dK\u0016$W\rZ#yG\u0016\u0004H/[8oQ\ri\u0014QY\u0001<i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0012{Wm\u001d(piJ+GO]=UQJ|G\u000f\u001e7j]\u001e\fVo\u001c;b\u000bb\u001cW-\u001a3fI\u0016C8-\u001a9uS>t\u0007f\u0001 \u0002F\u0006\u0001E/Z:u\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N$u.Z:O_R\u0014V\r\u001e:z)\"\u0014x\u000e\u001e;mS:<\u0017+^8uC\u0016C8-Z3eK\u0012,\u0005pY3qi&|g\u000eK\u0002@\u0003\u000b\u0004")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5).map((Function1 & Serializable & scala.Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @BeforeEach
    public void setup(TestInfo info) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateWhenAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @Test
    public void testCreateWhenAlreadyExistsWithIfNotExists() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-not-exists"}));
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithIncludeList() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertTrue((boolean)string.contains(topic2));
        Assertions.assertFalse((boolean)string.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService.alterTopic(alterOpts));
    }

    @Test
    public void testAlterWhenTopicDoesntExistWithIfExists() {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)props.containsKey(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)props.getProperty(cleanupKey).equals(cleanupVal), (String)"Properties after creation have incorrect value");
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)newProps.containsKey(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)newProps.getProperty(cleanupKey).equals(cleanupVal), (String)"Updated properties have incorrect value");
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @Test
    public void testDeleteWhenTopicDoesntExistWithIfExists() {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeWhenTopicDoesntExist() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
    }

    @Test
    public void testDescribeWhenTopicDoesntExistWithIfExists() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$5))).get()).partition();
            this.killBroker(0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$9)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$10)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$11)), Buffer$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDesc.partitions()).asScala()).head();
        Buffer replicasOfFirstPartition = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(firstPartition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Buffer$.MODULE$.canBuildFrom());
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)brokerIds.diff((GenSeq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])simpleDescribeOutputRows)).size());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out2.toString();
        Assertions.assertEquals((Object)"", (Object)string, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(string).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$13))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), TestUtils$.MODULE$.waitForAllReassignmentsToComplete$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$14)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)string2.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string2.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:1").toString());
    }

    @Test
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(adminClient);
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService.createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        NewTopic expectedNewTopic = new NewTopic(this.testTopicName(), Optional.empty(), Optional.empty()).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic}))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$15 -> !x$15.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)this.testTopicName(), (List)Nil$.MODULE$)).asJavaCollection()), (DeleteTopicsOptions)ArgumentMatchers.argThat(x$16 -> !x$16.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.testTopicName(), (TopicDescription)new TopicDescription(this.testTopicName(), false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$17 -> ((NewPartitions)x$17.get(this.testTopicName())).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$18 -> !x$18.shouldRetryOnQuotaViolation()));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$5) {
        return x$5.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$6) {
        return x$6.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponseData.MetadataResponseTopic x$7) {
        return x$7.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$8) {
        return x$8.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$7))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$8)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)$this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$6)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandWithAdminClientTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$10) {
        return x$10.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandWithAdminClientTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$13) {
        return x$13.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$14) {
        return x$14.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
    }
}

