/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$AdminClientTopicService$;
import kafka.admin.TopicCommand$ZookeeperTopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TopicCommand$
implements Logging {
    public static final TopicCommand$ MODULE$ = new TopicCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                } else if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                } else if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                } else if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                } else if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    this.printException(e.getCause());
                } else {
                    this.printException(e);
                }
                exitCode = 1;
            }
            catch (Throwable e) {
                this.printException(e);
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
        }
        topicService.close();
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString());
        if (this.logger().underlying().isErrorEnabled()) {
            String string;
            String string2 = string = Utils.stackTrace((Throwable)e);
            string = null;
            String msgWithLogIdent_msg = string2;
            Object var2_3 = null;
            this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> foundTopics, Option<String> requestedTopic, boolean requireTopicExists) {
        if (requestedTopic.isDefined() && requireTopicExists && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Topic '").append(requestedTopic.get()).append("' does not exist as expected").toString());
        }
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicIncludeList, boolean excludeInternalTopics) {
        if (topicIncludeList.isDefined()) {
            IncludeList topicsFilter = new IncludeList((String)topicIncludeList.get());
            return (Seq)allTopics.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)topicsFilter.isTopicAllowed(x$16, excludeInternalTopics)));
        }
        return (Seq)allTopics.filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$17)));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)opts.topicConfig().getOrElse((Function0 & Serializable)() -> Collections.emptyList())).asScala().map((Function1 & Serializable)x$18 -> x$18.split("\\s*=\\s*"));
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0 & Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1 & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(43).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").toString()).append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_2;
        Buffer configsToBeDeleted = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)opts.configsToDelete().getOrElse((Function0 & Serializable)() -> Collections.emptyList())).asScala().map((Function1 & Serializable)x$19 -> x$19.trim());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1 & Serializable)x$20 -> propsToBeDeleted.setProperty((String)x$20, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        Object[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(partitionList))).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> TopicCommand$.$anonfun$parseReplicaAssignment$1((String[])partitionList, ret, arg_0)));
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)original.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f._1$mcI$sp()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)f._2()).map((Function1 & Serializable)e -> BoxesRunTime.unboxToInt((Object)e))).asJava()))).asJava();
    }

    public int kafka$admin$TopicCommand$$getReplicationFactor(TopicPartitionInfo tpi, Option<PartitionReassignment> reassignment) {
        PartitionReassignment ra;
        int n = reassignment instanceof Some && TopicCommand$.isReassignmentInProgress$1(ra = (PartitionReassignment)((Some)reassignment).value(), tpi) ? ((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ra.replicas()).asScala().diff((Seq)CollectionConverters$.MODULE$.ListHasAsScala(ra.addingReplicas()).asScala())).size() : tpi.replicas().size();
        return n;
    }

    public static final /* synthetic */ String $anonfun$printException$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$17) {
        return Topic.isInternal((String)x$17) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ void $anonfun$parseReplicaAssignment$1(String[] partitionList$1, LinkedHashMap ret$1, int i) {
        int[] brokerList = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionList$1[i].split(":")), (Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s.trim()))), (ClassTag)ClassTag$.MODULE$.Int());
        Iterable duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
        if (duplicateBrokers.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString(",")).toString());
        }
        ret$1.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)Predef$.MODULE$.wrapIntArray(brokerList).toList());
        if (((SeqOps)ret$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqOps)ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
            throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
        }
    }

    private static final boolean isReassignmentInProgress$1(PartitionReassignment ra, TopicPartitionInfo tpi$1) {
        Set allReplicaIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(tpi$1.replicas()).asScala().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.id()))).toSet();
        Set changingReplicaIds = (Set)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ra.removingReplicas()).asScala().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22))).toSet().$plus$plus((IterableOnce)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ra.addingReplicas()).asScala().map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23))).toSet());
        return allReplicaIds.exists((Function1)(JFunction1.mcZI.sp & Serializable)elem -> changingReplicaIds.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
    }

    private TopicCommand$() {
    }
}

