/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\t\u0001b)Z1ukJ,'LT8eKR+7\u000f\u001e\u0006\u0003\u0011%\t!A_6\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0004\u0002!Q,7\u000f^#oG>$W\rR3d_\u0012,G#A\r\u0011\u00059Q\u0012BA\u000e\u0010\u0005\u0011)f.\u001b;)\u0005\ti\u0002C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nqA[;qSR,'O\u0003\u0002%K\u0005)!.\u001e8ji*\ta%A\u0002pe\u001eL!\u0001K\u0010\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cH\u000fR3d_\u0012,7+^2dKN\u001c\bFA\u0002\u001e\u0003\u001d\"Xm\u001d;EK\u000e|G-\u001a$bS2|e.\u00138wC2LGMV3sg&|g.\u00118e'R\fG/^:)\u0005\u0011i\u0012a\b;fgR$UmY8eK\u001a\u000b\u0017\u000e\\(o\u0013:4\u0018\r\\5e\r\u0016\fG/\u001e:fg\"\u0012Q!\b")
public class FeatureZNodeTest {
    @Test
    public void testEncodeDecode() {
        FeatureZNode featureZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)new FinalizedVersionRange(1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)new FinalizedVersionRange(2, 4))}))).asJava()));
        FeatureZNode decoded = FeatureZNode$.MODULE$.decode(FeatureZNode$.MODULE$.encode(featureZNode));
        Assertions.assertEquals((Object)featureZNode, (Object)decoded);
    }

    @Test
    public void testDecodeSuccess() {
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1,\n      \"features\":%s\n    }";
        String validFeatures = "{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}";
        FeatureZNode node1 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{validFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node1.status());
        Assertions.assertEquals((Object)Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)new FinalizedVersionRange(1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)new FinalizedVersionRange(2, 4))}))).asJava()), (Object)node1.features());
        String emptyFeatures = "{}";
        FeatureZNode node2 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{emptyFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node2.status());
        Assertions.assertEquals((Object)Features.emptyFinalizedFeatures(), (Object)node2.features());
    }

    @Test
    public void testDecodeFailOnInvalidVersionAndStatus() {
        String featureZNodeStrTemplate = "{\n      \"version\":%d,\n      \"status\":%d,\n      \"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}\n    }";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(FeatureZNode$.MODULE$.V1() - 1)), BoxesRunTime.boxToInteger((int)1)})).getBytes(StandardCharsets.UTF_8)));
        int invalidStatus = FeatureZNodeStatus.Enabled$.MODULE$.id() + 1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)FeatureZNode$.MODULE$.CurrentVersion()), BoxesRunTime.boxToInteger((int)invalidStatus)})).getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testDecodeFailOnInvalidFeatures() {
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1%s\n    }";
        String missingFeatures = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{missingFeatures})).getBytes(StandardCharsets.UTF_8)));
        String malformedFeatures = ",\"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"partial\"}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{malformedFeatures})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMinVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 0, \"max_version_level\": 2}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMaxVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 2, \"max_version_level\": 1}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMaxVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMissingMinVersionLevel = ",\"features\":{\"feature1\": {\"max_version_level\": 1}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMissingMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
    }
}

