/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ZkMetadataCache;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00045\u0001\u0001\u0006I\u0001\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019i\u0004\u0001)A\u0005o!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002'\u0001A\u0003%\u0001\tC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rY\u0003\u0001\u0015!\u0003P\u0011\u001d9\u0006A1A\u0005\naCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007M\u0002\u0001\u000b\u0011\u00022\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0003n\u0011%\u0019\b\u00011A\u0001B\u0003&\u0011\u000eC\u0005u\u0001\u0001\u0007\t\u0019!C\u0005k\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0011)\ty\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001e\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tY\u0003\u0001C\u0001\u0003'Aq!!\u000e\u0001\t\u0003\t\u0019\u0002C\u0004\u0002:\u0001!\t!a\u0005\t\u000f\u0005u\u0002\u0001\"\u0001\u0002\u0014!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBAA\u0001\u0011%\u00111\u0011\u0002\u001a\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i)\u0016\u001cHO\u0003\u0002\u001e=\u0005)Q\r]8dQ*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\u000f\u0002\r\r|gNZ5h+\u0005\u0001\u0004CA\u00193\u001b\u0005q\u0012BA\u001a\u001f\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005!A/[7f+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e!\u0003\u0015)H/\u001b7t\u0013\ta\u0014H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0011\t\u0003\u0003*k\u0011A\u0011\u0006\u0003}\rS!\u0001R#\u0002\r\r|W.\\8o\u0015\t\tcI\u0003\u0002H\u0011\u00061\u0011\r]1dQ\u0016T\u0011!S\u0001\u0004_J<\u0017BA&C\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0010C2$XM]%te6\u000bg.Y4feV\tq\n\u0005\u0002Q':\u0011\u0001(U\u0005\u0003%f\n\u0011\u0002V3tiV#\u0018\u000e\\:\n\u0005Q+&aE'pG.\fE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014(B\u0001*:\u0003A\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\b%\u0001\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ssV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]=\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002_7\n12)Y2iK\u0012\u001cuN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180A\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n!\u0001\u001e9\u0016\u0003\t\u0004\"a\u00193\u000e\u0003\rK!!Z\"\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t\u0011\u000e\u0005\u00022U&\u00111N\b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u00059\f\bCA\u0013p\u0013\t\u0001hE\u0001\u0003V]&$\bb\u0002:\u0010\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0014a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0016\u0003Y\u00042a^A\u0002\u001d\tAxP\u0004\u0002z}:\u0011!0`\u0007\u0002w*\u0011API\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\b\u0011\n\u0007\u0005\u0005a$\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002\u0006\u0005\u001d!!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002\u0002y\t\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u00079\fi\u0001C\u0004s%\u0005\u0005\t\u0019\u0001<\u0002\u001bE,x\u000e^1NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005q\u0007f\u0001\u000b\u0002\u0018A!\u0011\u0011DA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011aA1qS*!\u0011\u0011EA\u0012\u0003\u001dQW\u000f]5uKJT1!!\nI\u0003\u0015QWO\\5u\u0013\u0011\tI#a\u0007\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u000etQ>,H\u000eZ$fi\u0016\u0003xn\u00195t\rJ|WNU3qY&\u001c\u0017\rK\u0002\u0016\u0003_\u0001B!!\u0007\u00022%!\u00111GA\u000e\u0005\u0011!Vm\u001d;\u0002QMDw.\u001e7e%\u0016$XO\u001d8O_2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\%g)\"\u0014xn\u001e8)\u0007Y\ty#A\u0016tQ>,H\u000e\u001a*fiV\u0014h.\u00168l]><h\u000eV8qS\u000e|%\u000fU1si&$\u0018n\u001c8JMRC'o\\<oQ\r9\u0012qF\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001$!\u0011\u0011\t\u0005e\u00111I\u0005\u0005\u0003\u000b\nYBA\u0005BMR,'/R1dQ\u00069b.Z<PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018n\u0019\u000b\t\u0003\u0017\n\t(a\u001d\u0002~A!\u0011QJA6\u001d\u0011\ty%!\u001a\u000f\t\u0005E\u0013\u0011\r\b\u0005\u0003'\nyF\u0004\u0003\u0002V\u0005uc\u0002BA,\u00037r1A_A-\u0013\u0005I\u0015BA$I\u0013\t\tc)\u0003\u0002E\u000b&\u0019\u00111M\"\u0002\u000f5,7o]1hK&!\u0011qMA5\u0003}yeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003G\u001a\u0015\u0002BA7\u0003_\u0012Ac\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d+pa&\u001c'\u0002BA4\u0003SBQ\u0001Y\rA\u0002\tDq!!\u001e\u001a\u0001\u0004\t9(\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007cA\u0013\u0002z%\u0019\u00111\u0010\u0014\u0003\u0007%sG\u000fC\u0004\u0002\u0000e\u0001\r!a\u001e\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\u001e]\u0016<xJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e\u0014Vm];miRQ\u0011QQAJ\u0003+\u000b)+a*\u0011\t\u0005\u001d\u0015Q\u0012\b\u0005\u0003\u001f\nI)\u0003\u0003\u0002\f\u0006%\u0014\u0001I(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a#bi\u0006LA!a$\u0002\u0012\nQrJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e\u0014Vm];mi*!\u00111RA5\u0011\u0015\u0001'\u00041\u0001c\u0011\u001d\t9J\u0007a\u0001\u00033\u000bQ!\u001a:s_J\u0004B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?\u001b\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005\r\u0016Q\u0014\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005}$\u00041\u0001\u0002x!9\u0011\u0011\u0016\u000eA\u0002\u0005-\u0016!C3oI>3gm]3u!\r)\u0013QV\u0005\u0004\u0003_3#\u0001\u0002'p]\u001e\u0004")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TestUtils.MockAlterIsrManager alterIsrManager = new TestUtils.MockAlterIsrManager();
    private final CachedConfigRepository configRepository = new CachedConfigRepository();
    private final TopicPartition tp = new TopicPartition("topic", 1);
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManager;

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private CachedConfigRepository configRepository() {
        return this.configRepository;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    private void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""));
    }

    @Test
    public void shouldGetEpochsFromReplica() {
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        Log mockLog = (Log)EasyMock.createNiceMock(Log.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)mockLog.endOffsetForEpoch(epochRequested)).andReturn((Object)new Some((Object)offsetAndEpoch));
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLog, logManager});
        int zkMetadataCache_brokerId = this.config().brokerId();
        this.replicaManager_$eq(new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, null, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), new LogDirFailureChannel(this.config().logDirs().size()), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$));
        Partition partition = this.replicaManager().createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.NONE, offsetAndEpoch.leaderEpoch(), offsetAndEpoch.offset())})), (Object)response);
    }

    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        int zkMetadataCache_brokerId = this.config().brokerId();
        this.replicaManager_$eq(new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, null, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), new LogDirFailureChannel(this.config().logDirs().size()), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$));
        this.replicaManager().createPartition(this.tp());
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)})), (Object)response);
    }

    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        int zkMetadataCache_brokerId = this.config().brokerId();
        this.replicaManager_$eq(new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, null, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), new LogDirFailureChannel(this.config().logDirs().size()), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$));
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L)})), (Object)response);
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopic newOffsetForLeaderTopic(TopicPartition tp, int currentLeaderEpoch, int leaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition[]{new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setLeaderEpoch(leaderEpoch)}))).asJava());
    }

    private OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult newOffsetForLeaderTopicResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.EpochEndOffset[]{new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset)}))).asJava());
    }
}

