/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import kafka.api.ApiVersion$;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DefaultApiVersionManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.ForwardingManager;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000514AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002B\u0002\u0011\u0001A\u0003%Q\u0004C\u0004\"\u0001\t\u0007I\u0011\u0002\u0012\t\r\u0019\u0002\u0001\u0015!\u0003$\u0011\u00159\u0003\u0001\"\u0001)\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015A\u0007\u0001\"\u0001a\u0011\u0015Q\u0007\u0001\"\u0001a\u0005U\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d+fgRT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\f\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN,\u0012!\b\t\u00035yI!aH\u0006\u0003\u001d\t\u0013xn[3s\r\u0016\fG/\u001e:fg\u0006y!M]8lKJ4U-\u0019;ve\u0016\u001c\b%\u0001\u0007gK\u0006$XO]3DC\u000eDW-F\u0001$!\tQB%\u0003\u0002&\u0017\t)b)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",\u0017!\u00044fCR,(/Z\"bG\",\u0007%\u0001\u0007uKN$\u0018\t]5TG>\u0004X\r\u0006\u0002*YA\u0011!CK\u0005\u0003WM\u0011A!\u00168ji\")QF\u0002a\u0001]\u0005A\u0011\r]5TG>\u0004X\r\u0005\u00020\u0011:\u0011\u0001'\u0012\b\u0003c\ts!AM \u000f\u0005MjdB\u0001\u001b;\u001d\t)\u0004(D\u00017\u0015\t9t\"\u0001\u0004=e>|GOP\u0005\u0002s\u0005\u0019qN]4\n\u0005mb\u0014AB1qC\u000eDWMC\u0001:\u0013\tqaH\u0003\u0002<y%\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u00059q\u0014BA\"E\u0003\u001diWm]:bO\u0016T!\u0001Q!\n\u0005\u0019;\u0015AD!qS6+7o]1hKRK\b/\u001a\u0006\u0003\u0007\u0012K!!\u0013&\u0003\u00191K7\u000f^3oKJ$\u0016\u0010]3\u000b\u0005\u0019;\u0005\u0006\u0002\u0004M1f\u0003\"!\u0014,\u000e\u00039S!a\u0014)\u0002\u0011A\u0014xN^5eKJT!!\u0015*\u0002\rA\f'/Y7t\u0015\t\u0019F+A\u0004kkBLG/\u001a:\u000b\u0005Uc\u0014!\u00026v]&$\u0018BA,O\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002]!\u0012aa\u0017\t\u00039vk\u0011\u0001U\u0005\u0003=B\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003u!Xm\u001d;D_:$(o\u001c7mKJ\f\u0005/[%oi\u0016\u00148/Z2uS>tG#A\u0015)\u0005\u001d\u0011\u0007CA2g\u001b\u0005!'BA3S\u0003\r\t\u0007/[\u0005\u0003O\u0012\u0014A\u0001V3ti\u0006yC/Z:u\u000b:4X\r\\8qK\u0016s\u0017M\u00197fI^CWM\u001c$pe^\f'\u000fZ5oO6\u000bg.Y4feB\u0013Xm]3oi\"\u0012\u0001BY\u0001/i\u0016\u001cH/\u00128wK2|\u0007/\u001a#jg\u0006\u0014G.\u001a3XQ\u0016tgi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:F[B$\u0018\u0010\u000b\u0002\nE\u0002")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
    private final FinalizedFeatureCache featureCache = new FinalizedFeatureCache(this.brokerFeatures());

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private FinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, ApiVersion$.MODULE$.latestVersion(), (Option)None$.MODULE$, this.brokerFeatures(), this.featureCache());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala().forall((Function1 & Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)versionManager.isApiEnabled(apiKey))));
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 1;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)new Some((Object)forwardingManager), this.brokerFeatures(), this.featureCache()).apiVersionResponse(0).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeEnabledWhenForwardingManagerPresent() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)new Some((Object)forwardingManager), this.brokerFeatures(), this.featureCache());
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        ApiVersionsResponseData.ApiVersion envelopeVersion = versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id);
        Assertions.assertNotNull((Object)envelopeVersion);
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.oldestVersion(), (short)envelopeVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.latestVersion(), (short)envelopeVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledWhenForwardingManagerEmpty() {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)None$.MODULE$, this.brokerFeatures(), this.featureCache());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }
}

