/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.ConsumerGroupCommand;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0017.\u0001IBQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019!\u0006\u0001)A\u0005\u0015\"9Q\u000b\u0001b\u0001\n#2\u0006B\u00024\u0001A\u0003%q\u000bC\u0004h\u0001\t\u0007I\u0011\u000b5\t\rM\u0004\u0001\u0015!\u0003j\u0011\u001d!\bA1A\u0005R!Da!\u001e\u0001!\u0002\u0013I\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000fq\u0004!\u0019!C\u0001o\"1Q\u0010\u0001Q\u0001\naDqA \u0001C\u0002\u0013\u0005q\u000f\u0003\u0004\u0000\u0001\u0001\u0006I\u0001\u001f\u0005\t\u0003\u0003\u0001!\u0019!C\u0001}!9\u00111\u0001\u0001!\u0002\u0013y\u0004\u0002CA\u0003\u0001\t\u0007I\u0011A<\t\u000f\u0005\u001d\u0001\u0001)A\u0005q\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u000e!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003k\u0001A\u0011IA\r\u0011\u001d\tY\u0005\u0001C!\u00033Aq!!\u0016\u0001\t\u0003\tI\u0002C\u0004\u0002`\u0001!\t!!\u0007\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002\u001a!9\u0011q\r\u0001\u0005\u0002\u0005e\u0001bBA6\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\ti\t\u0001C\u0001\u00033Aq!!%\u0001\t\u0003\tI\u0002C\u0004\u0002\u0016\u0002!\t!!\u0007\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"9\u00111\u0018\u0001\u0005\n\u0005e\u0001bBA_\u0001\u0011%\u0011q\u0018\u0005\n\u00033\u0004\u0011\u0013!C\u0005\u00037Dq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\t)3+Y:m\u00072LWM\u001c;t/&$\b.\u00138wC2LGm\u0011:fI\u0016tG/[1mgR+7\u000f\u001e\u0006\u0003]=\n1!\u00199j\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0004\u0001M:\u0004C\u0001\u001b6\u001b\u0005i\u0013B\u0001\u001c.\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bC\u0001\u001b9\u0013\tITFA\u0005TCNd7+\u001a;va\u00061A(\u001b8jiz\"\u0012\u0001\u0010\t\u0003i\u0001\t\u0001d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:n+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007'R\u0014\u0018N\\4\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000eI\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001K!\rY%kP\u0007\u0002\u0019*\u0011QJT\u0001\nS6lW\u000f^1cY\u0016T!a\u0014)\u0002\u0015\r|G\u000e\\3di&|gNC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019FJ\u0001\u0003MSN$\u0018AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0013\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00059\u0006C\u0001-e\u001b\u0005I&B\u0001.\\\u0003\u0011\tW\u000f\u001e5\u000b\u0005qk\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005y{\u0016AB2p[6|gN\u0003\u00021A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)\u0017L\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006\t2/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0011\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\u0005I\u0007c\u00016l[6\t\u0001+\u0003\u0002m!\n!1k\\7f!\tq\u0017/D\u0001p\u0015\t\u00018)\u0001\u0003vi&d\u0017B\u0001:p\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013!D2p]N,X.\u001a:D_VtG/F\u0001y!\tQ\u00170\u0003\u0002{!\n\u0019\u0011J\u001c;\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA\u0005i\u0001O]8ek\u000e,'oQ8v]R\fa\u0002\u001d:pIV\u001cWM]\"pk:$\b%A\u0006ce>\\WM]\"pk:$\u0018\u0001\u00042s_.,'oQ8v]R\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003\t!\b/\u0006\u0002\u0002\u000eA!\u0011qBA\t\u001b\u0005i\u0016bAA\n;\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$HCAA\u000e!\rQ\u0017QD\u0005\u0004\u0003?\u0001&\u0001B+oSR\f1d\u0019:fCR,\u0007K]5wS2,w-\u001a3BI6Lgn\u00117jK:$HCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQ!\u00193nS:T1!a\f`\u0003\u001d\u0019G.[3oiNLA!a\r\u0002*\t)\u0011\tZ7j]\u0006)1/\u001a;Va\"\u001a!$!\u000f\u0011\t\u0005m\u0012qI\u0007\u0003\u0003{Q1ALA \u0015\u0011\t\t%a\u0011\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q\t2\u0002\u000b),h.\u001b;\n\t\u0005%\u0013Q\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007m\ty\u0005\u0005\u0003\u0002<\u0005E\u0013\u0002BA*\u0003{\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u000f\u0002ZA!\u00111HA.\u0013\u0011\ti&!\u0010\u0003\tQ+7\u000f^\u00013i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'oV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001aQ$!\u0017\u0002KQ,7\u000f^\"p]N,X.\u001a:XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u0010\u0002Z\u0005)D/Z:u\u001b\u0006tW/\u00197BgNLwM\\7f]R\u001cuN\\:v[\u0016\u0014x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\ry\u0012\u0011L\u0001Li\u0016\u001cH/T1ok\u0006d\u0017i]:jO:lWM\u001c;D_:\u001cX/\\3s/&$\b.Q;u_\u000e{W.\\5u\t&\u001c\u0018M\u00197fI^KG\u000f[!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004A\u0005e\u0013a\n<fe&4\u0017pQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!a\u0007\u0002t!9\u0011QO\u0011A\u0002\u0005]\u0014\u0001C2p]N,X.\u001a:\u0011\u0011\u0005e\u0014QPAA\u0003\u0003k!!a\u001f\u000b\t\u0005U\u0014QF\u0005\u0005\u0003\u007f\nYHA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006U\u0006\r\u0015qQ\u0005\u0004\u0003\u000b\u0003&!B!se\u0006L\bc\u00016\u0002\n&\u0019\u00111\u0012)\u0003\t\tKH/Z\u0001.i\u0016\u001cHoS1gW\u0006\fE-\\5o\u00072LWM\u001c;XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u0012\u0002Z\u0005\tD/Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007fA\u0012\u0002Z\u0005\tD/Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3XSRD\u0017)\u001e;iK:$\u0018nY1uS>t7+^2dKN\u001c\bf\u0001\u0013\u0002Z\u0005Y\u0002O]3qCJ,7i\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016,\"!!(\u0011\t\u0005}\u0015Q\u0017\b\u0005\u0003C\u000byK\u0004\u0003\u0002$\u00065f\u0002BAS\u0003Wk!!a*\u000b\u0007\u0005%\u0016'\u0001\u0004=e>|GOP\u0005\u0002a%\u0019\u00111F\u0018\n\t\u0005E\u00161W\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\u000b\u0007\u0005-r&\u0003\u0003\u00028\u0006e&\u0001F\"p]N,X.\u001a:He>,\boU3sm&\u001cWM\u0003\u0003\u00022\u0006M\u0016AF2sK\u0006$Xm\u00117jK:$8I]3eK:$\u0018.\u00197\u0002\u001bM,g\u000eZ(oKJ+7m\u001c:e)\u0019\tY\"!1\u0002P\"9\u00111Y\u0014A\u0002\u0005\u0015\u0017\u0001\u00039s_\u0012,8-\u001a:\u0011\u0011\u0005\u001d\u00171ZAA\u0003\u0003k!!!3\u000b\t\u0005\r\u0017QF\u0005\u0005\u0003\u001b\fIMA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\u0005\n\u0003#<\u0003\u0013!a\u0001\u0003'\f\u0011\"\\1y/\u0006LG/T:\u0011\u0007)\f).C\u0002\u0002XB\u0013A\u0001T8oO\u000692/\u001a8e\u001f:,'+Z2pe\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003;TC!a5\u0002`.\u0012\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003%)hn\u00195fG.,GMC\u0002\u0002lB\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty/!:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fwKJLg-_!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o)\u0011\tY\"!>\t\u0011\u0005]\u0018\u0006\"a\u0001\u0003s\fa!Y2uS>t\u0007#\u00026\u0002|\u0006m\u0011bAA\u007f!\nAAHY=oC6,g(A\bwKJLg-_,ji\"\u0014V\r\u001e:z)\u0011\tYBa\u0001\t\u0011\u0005](\u0006\"a\u0001\u0003s\f1d\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014HCAAc\u0001")
public class SaslClientsWithInvalidCredentialsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final SecurityProtocol securityProtocol;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final int consumerCount;
    private final int producerCount;
    private final int brokerCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createAdminClient(this.brokerList(), this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties(), this.kafkaClientSaslMechanism(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProducerWithAuthenticationFailure() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 10000L);
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var2_2 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> producer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs2).toString());
        Object var7_5 = null;
        this.createClientCredential();
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testTransactionalProducerWithAuthenticationFailure() {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> txProducer.initTransactions();
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var2_2 = null;
        this.createClientCredential();
        Assertions.assertThrows(KafkaException.class, () -> txProducer.initTransactions());
    }

    @Test
    public void testConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure() {
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    private void verifyConsumerWithAuthenticationFailure(KafkaConsumer<byte[], byte[]> consumer) {
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> consumer.poll(Duration.ofMillis(1000L));
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var3_2 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> consumer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs2).toString());
        Object var8_5 = null;
        this.createClientCredential();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        int n2 = 0;
        long l3 = 15000L;
        long l4 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n2;
                SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$4(consumer);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n2).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testKafkaAdminClientWithAuthenticationFailure() {
        Properties props = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties());
        props.put("bootstrap.servers", this.brokerList());
        try (Admin adminClient = Admin.create((Properties)props);){
            JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.describeTopic$1(adminClient);
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
            Object var4_3 = null;
            this.createClientCredential();
            int n = 0;
            long l = 15000L;
            long l2 = 100L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    this.describeTopic$1(adminClient);
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (!bl) {
                    if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                        Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationFailure() {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();){
            this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
            JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> consumerGroupService.listGroups();
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
            Object var3_2 = null;
        }
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationSuccess() {
        this.createClientCredential();
        ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
            int n = 0;
            long l = 15000L;
            long l2 = 100L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    consumer.poll(Duration.ofMillis(1000L));
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (bl) break;
                if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Assertions.assertEquals((int)1, (int)consumerGroupService.listConsumerGroups().size());
        }
        finally {
            consumerGroupService.close();
        }
    }

    private ConsumerGroupCommand.ConsumerGroupService prepareConsumerGroupService() {
        File propsFile = TestUtils.tempFile();
        try (OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);){
            propsStream.write("security.protocol=SASL_PLAINTEXT\n".getBytes());
            propsStream.write(new StringBuilder(15).append("sasl.mechanism=").append(this.kafkaClientSaslMechanism()).toString().getBytes());
        }
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "test.group", "--command-config", propsFile.getAbsolutePath()};
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        return new ConsumerGroupCommand.ConsumerGroupService(opts, (Map)Map$.MODULE$.empty());
    }

    private void createClientCredential() {
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    private void sendOneRecord(KafkaProducer<byte[], byte[]> producer, long maxWaitMs) {
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private long sendOneRecord$default$2() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> action.apply$mcV$sp());
        long elapsedMs = System.currentTimeMillis() - startMs;
        Assertions.assertTrue((elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(elapsedMs).toString());
    }

    private void verifyWithRetry(Function0<BoxedUnit> action) {
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                action.apply$mcV$sp();
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        return this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyConsumerWithAuthenticationFailure$4(KafkaConsumer consumer$1) {
        Assertions.assertEquals((int)1, (int)consumer$1.poll(Duration.ofMillis(1000L)).count());
    }

    private final void describeTopic$1(Admin adminClient$1) {
        try {
            java.util.Map response = (java.util.Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).all().get();
            Assertions.assertEquals((int)1, (int)response.size());
            response.forEach((topic, description) -> Assertions.assertEquals((int)this.numPartitions(), (int)description.partitions().size()));
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$1(IntRef attempts$1, Function0 action$2) {
        try {
            ++attempts$1.elem;
            action$2.apply$mcV$sp();
            return true;
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyWithRetry$2(IntRef attempts$1) {
        return new StringBuilder(47).append("Operation did not succeed within timeout after ").append(attempts$1.elem).toString();
    }

    public SaslClientsWithInvalidCredentialsTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.consumerCount = 1;
        this.producerCount = 1;
        this.brokerCount = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
        Statics.releaseFence();
    }
}

