/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import kafka.api.EndToEndAuthorizationTest;
import kafka.api.PlaintextEndToEndAuthorizationTest$;
import kafka.api.ZkSasl$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%s!\u0002\u000e\u001c\u0011\u0003\u0001c!\u0002\u0012\u001c\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0001\u0004%I!\f\u0005\by\u0005\u0001\r\u0011\"\u0003>\u0011\u0019\u0019\u0015\u0001)Q\u0005]!9\u0001*\u0001a\u0001\n\u0013i\u0003bB%\u0002\u0001\u0004%IA\u0013\u0005\u0007\u0019\u0006\u0001\u000b\u0015\u0002\u0018\u0007\t9\u000b\u0001a\u0014\u0005\u0006U%!\ta\u001a\u0005\u0006U&!\te\u001b\u0004\u0005i\u0006\u0001Q\u000fC\u0003+\u0019\u0011\u0005a\u000fC\u0003k\u0019\u0011\u0005\u0003P\u0002\u0003#7\u0001Q\b\"\u0002\u0016\u0010\t\u0003q\bbBA\u0001\u001f\u0011E\u00131\u0001\u0005\b\u0003\u0017yA\u0011KA\u0007\u0011\u001d\tYb\u0004C)\u0003\u001bA\u0011\"!\b\u0010\u0005\u0004%\t%a\b\t\u000f\u0005\u0005r\u0002)A\u0005Y\"I\u00111E\bC\u0002\u0013\u0005\u0013q\u0004\u0005\b\u0003Ky\u0001\u0015!\u0003m\u0011\u001d\t9c\u0004C!\u0003SAq!a\u0010\u0010\t\u0003\tI#\u0001\u0012QY\u0006Lg\u000e^3yi\u0016sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f\u001e\u0006\u00039u\t1!\u00199j\u0015\u0005q\u0012!B6bM.\f7\u0001\u0001\t\u0003C\u0005i\u0011a\u0007\u0002#!2\f\u0017N\u001c;fqR,e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u0014\u0005\u0005!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002A\u0005\u00112\r\\5f]Rd\u0015n\u001d;f]\u0016\u0014h*Y7f+\u0005q\u0003cA\u00130c%\u0011\u0001G\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005IJdBA\u001a8!\t!d%D\u00016\u0015\t1t$\u0001\u0004=e>|GOP\u0005\u0003q\u0019\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001HJ\u0001\u0017G2LWM\u001c;MSN$XM\\3s\u001d\u0006lWm\u0018\u0013fcR\u0011a(\u0011\t\u0003K}J!\u0001\u0011\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0012\t\t\u00111\u0001/\u0003\rAH%M\u0001\u0014G2LWM\u001c;MSN$XM\\3s\u001d\u0006lW\r\t\u0015\u0003\u000b\u0015\u0003\"!\n$\n\u0005\u001d3#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002%M,'O^3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0017g\u0016\u0014h/\u001a:MSN$XM\\3s\u001d\u0006lWm\u0018\u0013fcR\u0011ah\u0013\u0005\b\u0005\u001e\t\t\u00111\u0001/\u0003M\u0019XM\u001d<fe2K7\u000f^3oKJt\u0015-\\3!Q\tAQI\u0001\u000eUKN$8\t\\5f]R\u0004&/\u001b8dSB\fGNQ;jY\u0012,'oE\u0002\n!b\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0004PE*,7\r\u001e\t\u00033\u0016l\u0011A\u0017\u0006\u00037r\u000bA!Y;uQ*\u0011QLX\u0001\tg\u0016\u001cWO]5us*\u0011q\fY\u0001\u0007G>lWn\u001c8\u000b\u0005y\t'B\u00012d\u0003\u0019\t\u0007/Y2iK*\tA-A\u0002pe\u001eL!A\u001a.\u0003+-\u000bgm[1Qe&t7-\u001b9bY\n+\u0018\u000e\u001c3feR\t\u0001\u000e\u0005\u0002j\u00135\t\u0011!A\u0003ck&dG\r\u0006\u0002m_B\u0011\u0011,\\\u0005\u0003]j\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG\u000eC\u0003q\u0017\u0001\u0007\u0011/A\u0004d_:$X\r\u001f;\u0011\u0005e\u0013\u0018BA:[\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c;fqR\u0014!\u0004V3tiN+'O^3s!JLgnY5qC2\u0014U/\u001b7eKJ\u001c2\u0001\u0004)Y)\u00059\bCA5\r)\ta\u0017\u0010C\u0003q\u001d\u0001\u0007\u0011o\u0005\u0002\u0010wB\u0011\u0011\u0005`\u0005\u0003{n\u0011\u0011$\u00128e)>,e\u000eZ!vi\"|'/\u001b>bi&|g\u000eV3tiR\tq\u0010\u0005\u0002\"\u001f\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0003\u0003\u000b\u00012!WA\u0004\u0013\r\tIA\u0017\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006_\u0003\u001dqW\r^<pe.LA!!\u0007\u0002\u0014\taA*[:uK:,'OT1nK\u00069\u0012N\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bYV\tA.\u0001\tdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1mA\u0005q1.\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017aD6bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0003yB3\u0001GA\u0017!\u0011\ty#a\u000f\u000e\u0005\u0005E\"b\u0001\u000f\u00024)!\u0011QGA\u001c\u0003\u001dQW\u000f]5uKJT1!!\u000fd\u0003\u0015QWO\\5u\u0013\u0011\ti$!\r\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\tuKN$H*[:uK:,'OT1nK\"\u001a\u0011$a\u0011\u0011\t\u0005=\u0012QI\u0005\u0005\u0003\u000f\n\tD\u0001\u0003UKN$\b")
public class PlaintextEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final KafkaPrincipal clientPrincipal;
    private final KafkaPrincipal kafkaPrincipal;

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("SERVER");
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)package$.MODULE$.List().empty(), (Option<String>)None$.MODULE$, ZkSasl$.MODULE$, this.jaasSections$default$4()));
        super.setUp();
    }

    @Test
    public void testListenerName() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, 1, this.tp()));
        Assertions.assertEquals((Object)new Some((Object)"CLIENT"), PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$clientListenerName());
        Assertions.assertEquals((Object)new Some((Object)"SERVER"), PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$serverListenerName());
    }

    public PlaintextEndToEndAuthorizationTest() {
        this.serverConfig().setProperty("listener.name.client.principal.builder.class", TestClientPrincipalBuilder.class.getName());
        this.serverConfig().setProperty("listener.name.server.principal.builder.class", TestServerPrincipalBuilder.class.getName());
        this.clientPrincipal = new KafkaPrincipal("User", "client");
        this.kafkaPrincipal = new KafkaPrincipal("User", "server");
    }

    public static class TestClientPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$clientListenerName_$eq((Option<String>)new Some((Object)context.listenerName()));
            KafkaPrincipal kafkaPrincipal = context instanceof PlaintextAuthenticationContext && ((PlaintextAuthenticationContext)context).clientAddress() != null ? new KafkaPrincipal("User", "client") : KafkaPrincipal.ANONYMOUS;
            return kafkaPrincipal;
        }
    }

    public static class TestServerPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$serverListenerName_$eq((Option<String>)new Some((Object)context.listenerName()));
            KafkaPrincipal kafkaPrincipal = context instanceof PlaintextAuthenticationContext ? new KafkaPrincipal("User", "server") : KafkaPrincipal.ANONYMOUS;
            return kafkaPrincipal;
        }
    }
}

