/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorNodePunctuator;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.PunctuationQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManagerUtil;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class StreamTask
extends AbstractTask
implements ProcessorNodePunctuator,
Task {
    static final byte LATEST_MAGIC_BYTE = 1;
    private final Time time;
    private final Consumer<byte[], byte[]> mainConsumer;
    private final boolean eosEnabled;
    private final long maxTaskIdleMs;
    private final int maxBufferedSize;
    private final PartitionGroup partitionGroup;
    private final RecordCollector recordCollector;
    private final PartitionGroup.RecordInfo recordInfo;
    private final Map<TopicPartition, Long> consumedOffsets;
    private final Set<TopicPartition> resetOffsetsForPartitions;
    private final PunctuationQueue streamTimePunctuationQueue;
    private final PunctuationQueue systemTimePunctuationQueue;
    private final StreamsMetricsImpl streamsMetrics;
    private long processTimeMs = 0L;
    private final Sensor closeTaskSensor;
    private final Sensor processRatioSensor;
    private final Sensor processLatencySensor;
    private final Sensor punctuateLatencySensor;
    private final Sensor bufferedRecordsSensor;
    private final Sensor enforcedProcessingSensor;
    private final Map<String, Sensor> e2eLatencySensors = new HashMap<String, Sensor>();
    private final InternalProcessorContext processorContext;
    private final RecordQueueCreator recordQueueCreator;
    private StampedRecord record;
    private long idleStartTimeMs;
    private boolean commitNeeded = false;
    private boolean commitRequested = false;
    private boolean hasPendingTxCommit = false;

    public StreamTask(TaskId id, Set<TopicPartition> inputPartitions, ProcessorTopology topology, Consumer<byte[], byte[]> mainConsumer, StreamsConfig config, StreamsMetricsImpl streamsMetrics, StateDirectory stateDirectory, ThreadCache cache, Time time, ProcessorStateManager stateMgr, RecordCollector recordCollector, InternalProcessorContext processorContext) {
        super(id, topology, stateDirectory, stateMgr, inputPartitions, config.getLong("task.timeout.ms"), "task", StreamTask.class);
        this.mainConsumer = mainConsumer;
        this.processorContext = processorContext;
        processorContext.transitionToActive(this, recordCollector, cache);
        this.time = time;
        this.recordCollector = recordCollector;
        this.eosEnabled = StreamThread.eosEnabled(config);
        String threadId = Thread.currentThread().getName();
        this.streamsMetrics = streamsMetrics;
        this.closeTaskSensor = ThreadMetrics.closeTaskSensor(threadId, streamsMetrics);
        String taskId = id.toString();
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            Sensor parent = ThreadMetrics.commitOverTasksSensor(threadId, streamsMetrics);
            this.enforcedProcessingSensor = TaskMetrics.enforcedProcessingSensor(threadId, taskId, streamsMetrics, parent);
        } else {
            this.enforcedProcessingSensor = TaskMetrics.enforcedProcessingSensor(threadId, taskId, streamsMetrics, new Sensor[0]);
        }
        this.processRatioSensor = TaskMetrics.activeProcessRatioSensor(threadId, taskId, streamsMetrics);
        this.processLatencySensor = TaskMetrics.processLatencySensor(threadId, taskId, streamsMetrics);
        this.punctuateLatencySensor = TaskMetrics.punctuateSensor(threadId, taskId, streamsMetrics);
        this.bufferedRecordsSensor = TaskMetrics.activeBufferedRecordsSensor(threadId, taskId, streamsMetrics);
        for (String string : topology.terminalNodes()) {
            this.e2eLatencySensors.put(string, ProcessorNodeMetrics.e2ELatencySensor(threadId, taskId, string, streamsMetrics));
        }
        for (ProcessorNode processorNode : topology.sources()) {
            String sourceNodeName = processorNode.name();
            this.e2eLatencySensors.put(sourceNodeName, ProcessorNodeMetrics.e2ELatencySensor(threadId, taskId, sourceNodeName, streamsMetrics));
        }
        this.streamTimePunctuationQueue = new PunctuationQueue();
        this.systemTimePunctuationQueue = new PunctuationQueue();
        this.maxTaskIdleMs = config.getLong("max.task.idle.ms");
        this.maxBufferedSize = config.getInt("buffered.records.per.partition");
        this.consumedOffsets = new HashMap<TopicPartition, Long>();
        this.resetOffsetsForPartitions = new HashSet<TopicPartition>();
        this.recordQueueCreator = new RecordQueueCreator(this.logContext, config.defaultTimestampExtractor(), config.defaultDeserializationExceptionHandler());
        this.recordInfo = new PartitionGroup.RecordInfo();
        this.partitionGroup = new PartitionGroup(this.createPartitionQueues(), TaskMetrics.recordLatenessSensor(threadId, taskId, streamsMetrics));
        stateMgr.registerGlobalStateStores(topology.globalStateStores());
    }

    private Map<TopicPartition, RecordQueue> createPartitionQueues() {
        HashMap<TopicPartition, RecordQueue> partitionQueues = new HashMap<TopicPartition, RecordQueue>();
        for (TopicPartition partition : this.inputPartitions()) {
            partitionQueues.put(partition, this.recordQueueCreator.createQueue(partition));
        }
        return partitionQueues;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void initializeIfNeeded() {
        if (this.state() == Task.State.CREATED) {
            this.recordCollector.initialize();
            StateManagerUtil.registerStateStores(this.log, this.logPrefix, this.topology, this.stateMgr, this.stateDirectory, this.processorContext);
            this.offsetSnapshotSinceLastFlush = Collections.emptyMap();
            this.transitionTo(Task.State.RESTORING);
            this.log.info("Initialized");
        }
    }

    @Override
    public void addPartitionsForOffsetReset(Set<TopicPartition> partitionsForOffsetReset) {
        this.mainConsumer.pause(partitionsForOffsetReset);
        this.resetOffsetsForPartitions.addAll(partitionsForOffsetReset);
    }

    @Override
    public void completeRestoration(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
        switch (this.state()) {
            case RUNNING: {
                return;
            }
            case RESTORING: {
                this.resetOffsetsIfNeededAndInitializeMetadata(offsetResetter);
                this.initializeTopology();
                this.processorContext.initialize();
                this.idleStartTimeMs = -1L;
                this.transitionTo(Task.State.RUNNING);
                this.log.info("Restored and ready to run");
                break;
            }
            case CREATED: 
            case SUSPENDED: 
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while completing restoration for active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while completing restoration for active task " + this.id);
            }
        }
    }

    @Override
    public void suspend() {
        switch (this.state()) {
            case CREATED: {
                this.log.info("Suspended created");
                this.transitionTo(Task.State.SUSPENDED);
                break;
            }
            case RESTORING: {
                this.log.info("Suspended restoring");
                this.transitionTo(Task.State.SUSPENDED);
                break;
            }
            case RUNNING: {
                try {
                    this.closeTopology();
                    this.partitionGroup.clear();
                    break;
                }
                finally {
                    this.transitionTo(Task.State.SUSPENDED);
                    this.log.info("Suspended running");
                }
            }
            case SUSPENDED: {
                this.log.info("Skip suspending since state is {}", (Object)this.state());
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while suspending active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while suspending active task " + this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTopology() {
        this.log.trace("Closing processor topology");
        RuntimeException exception = null;
        for (ProcessorNode<?, ?, ?, ?> node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void resume() {
        switch (this.state()) {
            case RUNNING: 
            case RESTORING: 
            case CREATED: {
                this.log.trace("Skip resuming since state is {}", (Object)this.state());
                break;
            }
            case SUSPENDED: {
                try {
                    this.stateMgr.deleteCheckPointFileIfEOSEnabled();
                    this.log.debug("Deleted check point file upon resuming with EOS enabled");
                }
                catch (IOException ioe) {
                    this.log.error("Encountered error while deleting the checkpoint file due to this exception", (Throwable)ioe);
                }
                this.transitionTo(Task.State.RESTORING);
                this.log.info("Resumed to restoring state");
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while resuming active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while resuming active task " + this.id);
            }
        }
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
        switch (this.state()) {
            case RUNNING: 
            case RESTORING: 
            case CREATED: 
            case SUSPENDED: {
                if (this.commitNeeded) {
                    this.stateMgr.flushCache();
                    this.recordCollector.flush();
                    this.hasPendingTxCommit = this.eosEnabled;
                    this.log.debug("Prepared {} task for committing", (Object)this.state());
                    return this.committableOffsetsAndMetadata();
                }
                this.log.debug("Skipped preparing {} task for commit since there is nothing to commit", (Object)this.state());
                return Collections.emptyMap();
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while preparing active task " + this.id + " for committing");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while preparing active task " + this.id + " for committing");
    }

    private Map<TopicPartition, OffsetAndMetadata> committableOffsetsAndMetadata() {
        Map<TopicPartition, OffsetAndMetadata> committableOffsets;
        switch (this.state()) {
            case RESTORING: 
            case CREATED: {
                committableOffsets = Collections.emptyMap();
                break;
            }
            case RUNNING: 
            case SUSPENDED: {
                Map<TopicPartition, Long> partitionTimes = this.extractPartitionTimes();
                committableOffsets = new HashMap<TopicPartition, OffsetAndMetadata>(this.consumedOffsets.size());
                for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
                    TopicPartition partition = entry.getKey();
                    Long offset = this.partitionGroup.headRecordOffset(partition);
                    if (offset == null) {
                        try {
                            offset = this.mainConsumer.position(partition);
                        }
                        catch (TimeoutException error) {
                            throw new IllegalStateException(error);
                        }
                        catch (KafkaException fatal) {
                            throw new StreamsException(fatal);
                        }
                    }
                    long partitionTime = partitionTimes.get(partition);
                    committableOffsets.put(partition, new OffsetAndMetadata(offset.longValue(), StreamTask.encodeTimestamp(partitionTime)));
                }
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while getting committable offsets for active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
        }
        return committableOffsets;
    }

    @Override
    public void postCommit(boolean enforceCheckpoint) {
        switch (this.state()) {
            case CREATED: {
                this.log.debug("Skipped writing checkpoint for {} task", (Object)this.state());
                break;
            }
            case RESTORING: 
            case SUSPENDED: {
                this.maybeWriteCheckpoint(enforceCheckpoint);
                this.log.debug("Finalized commit for {} task with enforce checkpoint {}", (Object)this.state(), (Object)enforceCheckpoint);
                break;
            }
            case RUNNING: {
                if (enforceCheckpoint || !this.eosEnabled) {
                    this.maybeWriteCheckpoint(enforceCheckpoint);
                }
                this.log.debug("Finalized commit for {} task with eos {} enforce checkpoint {}", new Object[]{this.state(), this.eosEnabled, enforceCheckpoint});
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while post committing active task " + this.id);
            }
        }
        this.clearCommitStatuses();
    }

    private void clearCommitStatuses() {
        this.commitNeeded = false;
        this.commitRequested = false;
        this.hasPendingTxCommit = false;
    }

    private Map<TopicPartition, Long> extractPartitionTimes() {
        HashMap<TopicPartition, Long> partitionTimes = new HashMap<TopicPartition, Long>();
        for (TopicPartition partition : this.partitionGroup.partitions()) {
            partitionTimes.put(partition, this.partitionGroup.partitionTimestamp(partition));
        }
        return partitionTimes;
    }

    @Override
    public void closeClean() {
        this.validateClean();
        this.removeAllSensors();
        this.clearCommitStatuses();
        this.close(true);
        this.log.info("Closed clean");
    }

    @Override
    public void closeDirty() {
        this.removeAllSensors();
        this.clearCommitStatuses();
        this.close(false);
        this.log.info("Closed dirty");
    }

    @Override
    public void updateInputPartitions(Set<TopicPartition> topicPartitions, Map<String, List<String>> allTopologyNodesToSourceTopics) {
        super.updateInputPartitions(topicPartitions, allTopologyNodesToSourceTopics);
        this.partitionGroup.updatePartitions(topicPartitions, this.recordQueueCreator::createQueue);
    }

    @Override
    public void closeCleanAndRecycleState() {
        this.validateClean();
        this.removeAllSensors();
        this.clearCommitStatuses();
        switch (this.state()) {
            case SUSPENDED: {
                this.stateMgr.recycle();
                this.recordCollector.closeClean();
                break;
            }
            case RUNNING: 
            case RESTORING: 
            case CREATED: 
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while recycling active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while recycling active task " + this.id);
            }
        }
        this.closeTaskSensor.record();
        this.transitionTo(Task.State.CLOSED);
        this.log.info("Closed clean and recycled state");
    }

    @Override
    protected void maybeWriteCheckpoint(boolean enforceCheckpoint) {
        if (this.commitNeeded) {
            this.stateMgr.updateChangelogOffsets(this.checkpointableOffsets());
        }
        super.maybeWriteCheckpoint(enforceCheckpoint);
    }

    private void validateClean() {
        if (this.commitNeeded) {
            this.log.debug("Tried to close clean but there was pending uncommitted data, this means we failed to commit and should close as dirty instead");
            throw new TaskMigratedException("Tried to close dirty task as clean");
        }
    }

    private void removeAllSensors() {
        this.streamsMetrics.removeAllTaskLevelSensors(Thread.currentThread().getName(), this.id.toString());
        for (String nodeName : this.e2eLatencySensors.keySet()) {
            this.streamsMetrics.removeAllNodeLevelSensors(Thread.currentThread().getName(), this.id.toString(), nodeName);
        }
    }

    private void close(boolean clean) {
        switch (this.state()) {
            case SUSPENDED: {
                TaskManager.executeAndMaybeSwallow(clean, () -> StateManagerUtil.closeStateManager(this.log, this.logPrefix, clean, this.eosEnabled, this.stateMgr, this.stateDirectory, Task.TaskType.ACTIVE), "state manager close", this.log);
                TaskManager.executeAndMaybeSwallow(clean, clean ? this.recordCollector::closeClean : this.recordCollector::closeDirty, "record collector close", this.log);
                break;
            }
            case CLOSED: {
                this.log.trace("Skip closing since state is {}", (Object)this.state());
                return;
            }
            case RUNNING: 
            case RESTORING: 
            case CREATED: {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while closing active task " + this.id);
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state()) + " while closing active task " + this.id);
            }
        }
        this.record = null;
        this.partitionGroup.clear();
        this.closeTaskSensor.record();
        this.transitionTo(Task.State.CLOSED);
    }

    public boolean isProcessable(long wallClockTime) {
        if (this.state() == Task.State.CLOSED) {
            this.log.info("Stream task {} is already in {} state, skip processing it.", (Object)this.id(), (Object)this.state());
            return false;
        }
        if (this.hasPendingTxCommit) {
            return false;
        }
        if (this.partitionGroup.allPartitionsBuffered()) {
            this.idleStartTimeMs = -1L;
            return true;
        }
        if (this.partitionGroup.numBuffered() > 0) {
            if (this.idleStartTimeMs == -1L) {
                this.idleStartTimeMs = wallClockTime;
            }
            if (wallClockTime - this.idleStartTimeMs >= this.maxTaskIdleMs) {
                this.enforcedProcessingSensor.record(1.0, wallClockTime);
                return true;
            }
            return false;
        }
        this.idleStartTimeMs = -1L;
        return false;
    }

    @Override
    public boolean process(long wallClockTime) {
        if (this.record == null) {
            if (!this.isProcessable(wallClockTime)) {
                return false;
            }
            this.record = this.partitionGroup.nextRecord(this.recordInfo, wallClockTime);
            if (this.record == null) {
                return false;
            }
        }
        try {
            ProcessorNode<?, ?, ?, ?> currNode = this.recordInfo.node();
            TopicPartition partition = this.recordInfo.partition();
            this.log.trace("Start processing one record [{}]", (Object)this.record);
            ProcessorRecordContext recordContext = new ProcessorRecordContext(this.record.timestamp, this.record.offset(), this.record.partition(), this.record.topic(), this.record.headers());
            this.updateProcessorContext(currNode, wallClockTime, recordContext);
            this.maybeRecordE2ELatency(this.record.timestamp, wallClockTime, currNode.name());
            Record<Object, Object> toProcess = new Record<Object, Object>(this.record.key(), this.record.value(), this.processorContext.timestamp(), this.processorContext.headers());
            StreamsMetricsImpl.maybeMeasureLatency(() -> currNode.process(toProcess), this.time, this.processLatencySensor);
            this.log.trace("Completed processing one record [{}]", (Object)this.record);
            this.consumedOffsets.put(partition, this.record.offset());
            this.commitNeeded = true;
            if (this.recordInfo.queue().size() == this.maxBufferedSize) {
                this.mainConsumer.resume(Collections.singleton(partition));
            }
            this.record = null;
        }
        catch (TimeoutException timeoutException) {
            if (!this.eosEnabled) {
                throw timeoutException;
            }
            this.record = null;
            throw new TaskCorruptedException(Collections.singleton(this.id));
        }
        catch (StreamsException exception) {
            this.record = null;
            throw exception;
        }
        catch (RuntimeException e) {
            StreamsException error = new StreamsException(String.format("Exception caught in process. taskId=%s, processor=%s, topic=%s, partition=%d, offset=%d, stacktrace=%s", this.id(), this.processorContext.currentNode().name(), this.record.topic(), this.record.partition(), this.record.offset(), this.getStacktraceString(e)), e);
            this.record = null;
            throw error;
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
        return true;
    }

    @Override
    public void recordProcessBatchTime(long processBatchTime) {
        this.processTimeMs += processBatchTime;
    }

    @Override
    public void recordProcessTimeRatioAndBufferSize(long allTaskProcessMs, long now) {
        this.bufferedRecordsSensor.record((double)this.partitionGroup.numBuffered());
        this.processRatioSensor.record((double)this.processTimeMs / (double)allTaskProcessMs, now);
        this.processTimeMs = 0L;
    }

    private String getStacktraceString(RuntimeException e) {
        String stacktrace = null;
        try (StringWriter stringWriter = new StringWriter();
             PrintWriter printWriter = new PrintWriter(stringWriter);){
            e.printStackTrace(printWriter);
            stacktrace = stringWriter.toString();
        }
        catch (IOException ioe) {
            this.log.error("Encountered error extracting stacktrace from this exception", (Throwable)ioe);
        }
        return stacktrace;
    }

    @Override
    public void punctuate(ProcessorNode<?, ?, ?, ?> node, long timestamp, PunctuationType type, Punctuator punctuator) {
        if (this.processorContext.currentNode() != null) {
            throw new IllegalStateException(String.format("%sCurrent node is not null", this.logPrefix));
        }
        ProcessorRecordContext recordContext = new ProcessorRecordContext(timestamp, -1L, -1, null, (Headers)new RecordHeaders());
        this.updateProcessorContext(node, this.time.milliseconds(), recordContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Punctuating processor {} with timestamp {} and punctuation type {}", new Object[]{node.name(), timestamp, type});
        }
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> node.punctuate(timestamp, punctuator), this.time, this.punctuateLatencySensor);
        }
        catch (StreamsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new StreamsException(String.format("%sException caught while punctuating processor '%s'", this.logPrefix, node.name()), e);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
    }

    private void updateProcessorContext(ProcessorNode<?, ?, ?, ?> currNode, long wallClockTime, ProcessorRecordContext recordContext) {
        this.processorContext.setRecordContext(recordContext);
        this.processorContext.setCurrentNode(currNode);
        this.processorContext.setSystemTimeMs(wallClockTime);
    }

    private Map<TopicPartition, Long> checkpointableOffsets() {
        HashMap<TopicPartition, Long> checkpointableOffsets = new HashMap<TopicPartition, Long>(this.recordCollector.offsets());
        for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
            checkpointableOffsets.putIfAbsent(entry.getKey(), entry.getValue());
        }
        this.log.debug("Checkpointable offsets {}", checkpointableOffsets);
        return checkpointableOffsets;
    }

    private void resetOffsetsIfNeededAndInitializeMetadata(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
        try {
            Map offsetsAndMetadata = this.mainConsumer.committed(this.inputPartitions());
            for (Map.Entry committedEntry : offsetsAndMetadata.entrySet()) {
                OffsetAndMetadata offsetAndMetadata;
                if (!this.resetOffsetsForPartitions.contains(committedEntry.getKey()) || (offsetAndMetadata = (OffsetAndMetadata)committedEntry.getValue()) == null) continue;
                this.mainConsumer.seek((TopicPartition)committedEntry.getKey(), offsetAndMetadata);
                this.resetOffsetsForPartitions.remove(committedEntry.getKey());
            }
            offsetResetter.accept(this.resetOffsetsForPartitions);
            this.resetOffsetsForPartitions.clear();
            this.initializeTaskTime(offsetsAndMetadata.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        catch (TimeoutException timeoutException) {
            this.log.warn("Encountered {} while trying to fetch committed offsets, will retry initializing the metadata in the next loop.\nConsider overwriting consumer config {} to a larger value to avoid timeout errors", (Object)this.time.toString(), (Object)"default.api.timeout.ms");
            throw timeoutException;
        }
        catch (KafkaException e2) {
            throw new StreamsException(String.format("task [%s] Failed to initialize offsets for %s", this.id, this.inputPartitions()), e2);
        }
    }

    private void initializeTaskTime(Map<TopicPartition, OffsetAndMetadata> offsetsAndMetadata) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsetsAndMetadata.entrySet()) {
            TopicPartition partition = entry.getKey();
            OffsetAndMetadata metadata = entry.getValue();
            if (metadata != null) {
                long committedTimestamp = this.decodeTimestamp(metadata.metadata());
                this.partitionGroup.setPartitionTime(partition, committedTimestamp);
                this.log.debug("A committed timestamp was detected: setting the partition time of partition {} to {} in stream task {}", new Object[]{partition, committedTimestamp, this.id});
                continue;
            }
            this.log.debug("No committed timestamp was found in metadata for partition {}", (Object)partition);
        }
        HashSet<TopicPartition> nonCommitted = new HashSet<TopicPartition>(this.inputPartitions());
        nonCommitted.removeAll(offsetsAndMetadata.keySet());
        for (TopicPartition partition : nonCommitted) {
            this.log.debug("No committed offset for partition {}, therefore no timestamp can be found for this partition", (Object)partition);
        }
    }

    @Override
    public Map<TopicPartition, Long> purgeableOffsets() {
        HashMap<TopicPartition, Long> purgeableConsumedOffsets = new HashMap<TopicPartition, Long>();
        for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            if (!this.topology.isRepartitionTopic(tp.topic())) continue;
            purgeableConsumedOffsets.put(tp, entry.getValue() + 1L);
        }
        return purgeableConsumedOffsets;
    }

    private void initializeTopology() {
        this.log.trace("Initializing processor nodes of the topology");
        for (ProcessorNode<?, ?, ?, ?> node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.init(this.processorContext);
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
    }

    @Override
    public void addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
        int newQueueSize = this.partitionGroup.addRawRecords(partition, records);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added records into the buffered queue of partition {}, new queue size is {}", (Object)partition, (Object)newQueueSize);
        }
        if (newQueueSize > this.maxBufferedSize) {
            this.mainConsumer.pause(Collections.singleton(partition));
        }
    }

    public Cancellable schedule(long interval, PunctuationType type, Punctuator punctuator) {
        switch (type) {
            case STREAM_TIME: {
                return this.schedule(0L, interval, type, punctuator);
            }
            case WALL_CLOCK_TIME: {
                return this.schedule(this.time.milliseconds() + interval, interval, type, punctuator);
            }
        }
        throw new IllegalArgumentException("Unrecognized PunctuationType: " + (Object)((Object)type));
    }

    private Cancellable schedule(long startTime, long interval, PunctuationType type, Punctuator punctuator) {
        if (this.processorContext.currentNode() == null) {
            throw new IllegalStateException(String.format("%sCurrent node is null", this.logPrefix));
        }
        PunctuationSchedule schedule = new PunctuationSchedule(this.processorContext.currentNode(), startTime, interval, punctuator);
        switch (type) {
            case STREAM_TIME: {
                return this.streamTimePunctuationQueue.schedule(schedule);
            }
            case WALL_CLOCK_TIME: {
                return this.systemTimePunctuationQueue.schedule(schedule);
            }
        }
        throw new IllegalArgumentException("Unrecognized PunctuationType: " + (Object)((Object)type));
    }

    @Override
    public boolean maybePunctuateStreamTime() {
        long streamTime = this.partitionGroup.streamTime();
        if (streamTime == -1L) {
            return false;
        }
        boolean punctuated = this.streamTimePunctuationQueue.mayPunctuate(streamTime, PunctuationType.STREAM_TIME, this);
        if (punctuated) {
            this.commitNeeded = true;
        }
        return punctuated;
    }

    @Override
    public boolean maybePunctuateSystemTime() {
        long systemTime = this.time.milliseconds();
        boolean punctuated = this.systemTimePunctuationQueue.mayPunctuate(systemTime, PunctuationType.WALL_CLOCK_TIME, this);
        if (punctuated) {
            this.commitNeeded = true;
        }
        return punctuated;
    }

    void maybeRecordE2ELatency(long recordTimestamp, long now, String nodeName) {
        Sensor e2eLatencySensor = this.e2eLatencySensors.get(nodeName);
        if (e2eLatencySensor == null) {
            throw new IllegalStateException("Requested to record e2e latency but could not find sensor for node " + nodeName);
        }
        if (e2eLatencySensor.shouldRecord() && e2eLatencySensor.hasMetrics()) {
            e2eLatencySensor.record((double)(now - recordTimestamp), now);
        }
    }

    void requestCommit() {
        this.commitRequested = true;
    }

    @Override
    public boolean commitRequested() {
        return this.commitRequested;
    }

    static String encodeTimestamp(long partitionTime) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.put((byte)1);
        buffer.putLong(partitionTime);
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    long decodeTimestamp(String encryptedString) {
        if (encryptedString.isEmpty()) {
            return -1L;
        }
        ByteBuffer buffer = ByteBuffer.wrap(Base64.getDecoder().decode(encryptedString));
        byte version = buffer.get();
        switch (version) {
            case 1: {
                return buffer.getLong();
            }
        }
        this.log.warn("Unsupported offset metadata version found. Supported version {}. Found version {}.", (Object)1, (Object)version);
        return -1L;
    }

    public InternalProcessorContext processorContext() {
        return this.processorContext;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        Set<TopicPartition> partitions;
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("TaskId: ");
        sb.append(this.id);
        sb.append("\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        if ((partitions = this.inputPartitions()) != null && !partitions.isEmpty()) {
            sb.append(indent).append("Partitions [");
            for (TopicPartition topicPartition : partitions) {
                sb.append(topicPartition).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }

    @Override
    public boolean commitNeeded() {
        return this.commitNeeded;
    }

    @Override
    public Map<TopicPartition, Long> changelogOffsets() {
        if (this.state() == Task.State.RUNNING) {
            return this.changelogPartitions().stream().collect(Collectors.toMap(Function.identity(), tp -> -2L));
        }
        return Collections.unmodifiableMap(this.stateMgr.changelogOffsets());
    }

    public boolean hasRecordsQueued() {
        return this.numBuffered() > 0;
    }

    RecordCollector recordCollector() {
        return this.recordCollector;
    }

    int numBuffered() {
        return this.partitionGroup.numBuffered();
    }

    long streamTime() {
        return this.partitionGroup.streamTime();
    }

    private class RecordQueueCreator {
        private final LogContext logContext;
        private final TimestampExtractor defaultTimestampExtractor;
        private final DeserializationExceptionHandler defaultDeserializationExceptionHandler;

        private RecordQueueCreator(LogContext logContext, TimestampExtractor defaultTimestampExtractor, DeserializationExceptionHandler defaultDeserializationExceptionHandler) {
            this.logContext = logContext;
            this.defaultTimestampExtractor = defaultTimestampExtractor;
            this.defaultDeserializationExceptionHandler = defaultDeserializationExceptionHandler;
        }

        public RecordQueue createQueue(TopicPartition partition) {
            SourceNode<?, ?, ?, ?> source = StreamTask.this.topology.source(partition.topic());
            if (source == null) {
                throw new TopologyException("Topic is unknown to the topology. This may happen if different KafkaStreams instances of the same application execute different Topologies. Note that Topologies are only identical if all operators are added in the same order.");
            }
            TimestampExtractor sourceTimestampExtractor = source.getTimestampExtractor();
            TimestampExtractor timestampExtractor = sourceTimestampExtractor != null ? sourceTimestampExtractor : this.defaultTimestampExtractor;
            return new RecordQueue(partition, source, timestampExtractor, this.defaultDeserializationExceptionHandler, StreamTask.this.processorContext, this.logContext);
        }
    }
}

