/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.message.ZStdCompressionCodec$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0006\r\u0001EAQA\u0006\u0001\u0005\u0002]Aq!\u0007\u0001C\u0002\u0013\u0005!\u0004\u0003\u00042\u0001\u0001\u0006Ia\u0007\u0005\u0006e\u0001!\ta\r\u0005\u0006\u001f\u0002!\ta\r\u0005\u0006%\u0002!\ta\r\u0005\u0006+\u0002!IA\u0016\u0005\u0006U\u0002!\ta\r\u0005\u0006[\u0002!\ta\r\u0005\u0006a\u0002!I!\u001d\u0002\u0013!J|G-^2f%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00021A\u00111\u0003A\u0001\u000e[\u0016$(/[2t\u0017\u0016L8+\u001a;\u0016\u0003m\u00012\u0001H\u0012&\u001b\u0005i\"B\u0001\u0010 \u0003\u001diW\u000f^1cY\u0016T!\u0001I\u0011\u0002\u0015\r|G\u000e\\3di&|gNC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!SDA\u0002TKR\u0004\"AJ\u0018\u000e\u0003\u001dR!\u0001K\u0015\u0002\t\r|'/\u001a\u0006\u0003U-\nq!\\3ue&\u001c7O\u0003\u0002-[\u00051\u00110Y7nKJT\u0011AL\u0001\u0004G>l\u0017B\u0001\u0019(\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u000f[\u0016$(/[2t\u0017\u0016L8+\u001a;!\u0003a!Xm\u001d;TS6\u0004H.\u001a)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u000b\u0002iA\u0011QGN\u0007\u0002C%\u0011q'\t\u0002\u0005+:LG\u000f\u000b\u0002\u0005sA\u0011!hQ\u0007\u0002w)\u0011A(P\u0001\u0004CBL'B\u0001 @\u0003\u001dQW\u000f]5uKJT!\u0001Q!\u0002\u000b),h.\u001b;\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5H\u0001\u0003UKN$\b\u0006\u0002\u0003G\u00196\u0003\"a\u0012&\u000e\u0003!S!!S\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002L\u0011\n1an\\<be:\fQA^1mk\u0016\f\u0013AT\u0001\u0010G\u0006$X\bZ3qe\u0016\u001c\u0017\r^5p]\u0006yB/Z:u!J|G-^2f/&$\b.\u00138wC2LG\rV5nKN$\u0018-\u001c9)\u0005\u0015I\u0004\u0006B\u0003G\u00196\u000bq\u0003^3tiB\u0013x\u000eZ;dKR{gj\u001c8SKBd\u0017nY1)\u0005\u0019I\u0004\u0006\u0002\u0004G\u00196\u000bQe\u0019:fCR,Gk\u001c9jG\u0006sGMR5oIB\u000b'\u000f^5uS>tw+\u001b;i\u0019\u0016\fG-\u001a:\u0015\u0005]k\u0006\u0003B\u001bY5jK!!W\u0011\u0003\rQ+\b\u000f\\33!\t)4,\u0003\u0002]C\t\u0019\u0011J\u001c;\t\u000by;\u0001\u0019A0\u0002\u000bQ|\u0007/[2\u0011\u0005\u0001<gBA1f!\t\u0011\u0017%D\u0001d\u0015\t!\u0007#\u0001\u0004=e>|GOP\u0005\u0003M\u0006\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a-I\u0001\u001di\u0016\u001cHoQ8seV\u0004H\u000f\u0014>5!J|G-^2f%\u0016\fX/Z:uQ\tA\u0011\b\u000b\u0003\t\r2k\u0015A\u0006;fgRT6\u000b\u0016#Qe>$WoY3SKF,Xm\u001d;)\u0005%I\u0004\u0006B\u0005G\u00196\u000b!c]3oIB\u0013x\u000eZ;dKJ+\u0017/^3tiR\u0019!/`@\u0011\u0005M\\X\"\u0001;\u000b\u0005U4\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005]D\u0018AB2p[6|gN\u0003\u0002\u0010s*\u0011!0Q\u0001\u0007CB\f7\r[3\n\u0005q$(a\u0004)s_\u0012,8-\u001a*fgB|gn]3\t\u000byT\u0001\u0019\u0001.\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!!\u0001\u000b\u0001\u0004\t\u0019!A\u0004sKF,Xm\u001d;\u0011\u0007M\f)!C\u0002\u0002\bQ\u0014a\u0002\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleProduceRequest() {
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, (int)var2_2, (int)var3_3);
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceWithInvalidTimestamp() {
        void var10_10;
        void var9_9;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, System.currentTimeMillis() - 1001L, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        void tp2 = var9_9;
        void partitionResponse2 = var10_10;
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)partitionResponse2.error);
        Assertions.assertEquals((int)3, (int)partitionResponse2.recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)0)).batchIndex);
        Assertions.assertEquals((int)1, (int)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)1)).batchIndex);
        Assertions.assertEquals((int)2, (int)((ProduceResponse.RecordError)partitionResponse2.recordErrors.get((int)2)).batchIndex);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionResponse2.recordErrors).asScala()).foreach((Function1 & Serializable & scala.Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$1(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionResponse2.errorMessage);
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$4)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)((ProduceResponse.PartitionResponse)((Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)produceResponse.responses()).asScala()).head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        object = new Tuple2.mcII.sp(partition, leader);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() != -1;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptLz4ProduceRequest() {
        void var11_11;
        void var10_10;
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var2_2);
        ProduceResponse produceResponse = this.sendProduceRequest((int)var3_3, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Tuple2 tuple22 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
        void tp2 = var10_10;
        void partitionResponse2 = var11_11;
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
        Assertions.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
        Assertions.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$7))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZSTDProduceRequest() {
        void var17_17;
        void var16_16;
        void var11_11;
        void var10_10;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CompressionTypeProp(), ZStdCompressionCodec$.MODULE$.name());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.ZSTD, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse res1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(res1.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp1 = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple2._2();
        void tp12 = var10_10;
        void partitionResponse12 = var11_11;
        Assertions.assertEquals((Object)topicPartition, (Object)tp12);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
        Assertions.assertEquals((long)0L, (long)partitionResponse12.baseOffset);
        Assertions.assertEquals((long)-1L, (long)partitionResponse12.logAppendTime);
        ProduceResponse res2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        Tuple2 tuple22 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(res2.responses()).asScala()).head();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp2 = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple22._2();
        void tp22 = var16_16;
        void partitionResponse22 = var17_17;
        Assertions.assertEquals((Object)topicPartition, (Object)tp22);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)partitionResponse22.error);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    /*
     * WARNING - void declaration
     */
    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        void var10_9;
        void var9_8;
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        void tp2 = var9_8;
        void partitionResponse2 = var10_9;
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
        Assertions.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
        Assertions.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
        Assertions.assertTrue((boolean)partitionResponse2.recordErrors.isEmpty());
        return partitionResponse2;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$1(ProduceResponse.RecordError recordError) {
        Assertions.assertNotNull((Object)recordError.message);
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaServer x$4) {
        return x$4.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$7) {
        return x$7.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

