/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import integration.kafka.server.IntegrationTestUtils$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.ConfigEntityName$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ClusterTestDefaults(clusterType=Type.ZK)
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001\u0002\u0014(\u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"9!\n\u0001b\u0001\n\u0013\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0002!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u001dq\u0005A1A\u0005\n\u0001Caa\u0014\u0001!\u0002\u0013\t\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002/\u0001\t\u0003\t\u0006\"\u00020\u0001\t\u0003\t\u0006\"\u00021\u0001\t\u0003\t\u0006\"\u00022\u0001\t\u0003\t\u0006\"\u00023\u0001\t\u0013)\u0007\"B<\u0001\t\u0003\t\u0006\"B=\u0001\t\u0003\t\u0006\"B>\u0001\t\u0003\t\u0006bB?\u0001\u0005\u0004%IA \u0005\b\u0003k\u0001\u0001\u0015!\u0003\u0000\u0011!\t9\u0004\u0001b\u0001\n\u0013q\bbBA\u001d\u0001\u0001\u0006Ia \u0005\u0007\u0003w\u0001A\u0011B)\t\r\u0005u\u0002\u0001\"\u0001R\u0011\u0019\t\t\u0005\u0001C\u0001#\"1\u0011Q\t\u0001\u0005\u0002ECa!!\u0013\u0001\t\u0003\t\u0006BBA'\u0001\u0011\u0005\u0011\u000bC\u0004\u0002R\u0001!I!a\u0015\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a3\u0001\t\u0013\ti\rC\u0004\u0002n\u0002!I!a<\u0003/\rc\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;UKN$(B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]J\u0013\u0001\u0002;fgRL!!\u000f\u001c\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001\u001f?!\ti\u0004!D\u0001(\u0011\u0015\u0019$\u00011\u00015\u0003Q\u0019uN\\:v[\u0016\u0014()\u001f;f%\u0006$X\r\u0015:paV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\rM#(/\u001b8h\u0003U\u0019uN\\:v[\u0016\u0014()\u001f;f%\u0006$X\r\u0015:pa\u0002\nA\u0003\u0015:pIV\u001cWM\u001d\"zi\u0016\u0014\u0016\r^3Qe>\u0004\u0018!\u0006)s_\u0012,8-\u001a:CsR,'+\u0019;f!J|\u0007\u000fI\u0001\u0016%\u0016\fX/Z:u!\u0016\u00148-\u001a8uC\u001e,\u0007K]8q\u0003Y\u0011V-];fgR\u0004VM]2f]R\fw-\u001a)s_B\u0004\u0013\u0001F%q\u0007>tg.Z2uS>t'+\u0019;f!J|\u0007/A\u000bJa\u000e{gN\\3di&|gNU1uKB\u0013x\u000e\u001d\u0011\u00029Q,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiR\t!\u000b\u0005\u0002/'&\u0011Ak\f\u0002\u0005+:LG\u000f\u000b\u0002\f-B\u0011qKW\u0007\u00021*\u0011\u0011LN\u0001\u000bC:tw\u000e^1uS>t\u0017BA.Y\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002QQ,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiZ\u000bG.\u001b3bi\u0016|e\u000e\\=)\u000511\u0016!\b;fgR\u001cE.[3oiF+x\u000e^1t\r>\u00148k\u0019:b[V\u001bXM]:)\u000551\u0016\u0001\u0007;fgR\fE\u000e^3s\u0013B\fVo\u001c;bgJ+\u0017/^3ti\"\u0012aBV\u0001%i\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t\u0013:4\u0018\r\\5e%\u0016\fX/Z:ug\"\u0012qBV\u0001 Kb\u0004Xm\u0019;J]Z\fG.\u001b3SKF,Xm\u001d;XSRDW*Z:tC\u001e,Gc\u0001*gW\"1q\r\u0005CA\u0002!\f\u0001B];o]\u0006\u0014G.\u001a\t\u0004]%\u0014\u0016B\u000160\u0005!a$-\u001f8b[\u0016t\u0004\"\u00027\u0011\u0001\u0004i\u0017aD3ya\u0016\u001cG/\u001a3NKN\u001c\u0018mZ3\u0011\u00059,hBA8t!\t\u0001x&D\u0001r\u0015\t\u00118&\u0001\u0004=e>|GOP\u0005\u0003i>\na\u0001\u0015:fI\u00164\u0017B\u0001%w\u0015\t!x&A\u0017uKN$\u0018\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:J]Z\fG.\u001b3F]RLG/_\"p[\nLg.\u0019;j_:D#!\u0005,\u00025Q,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg\n\u000bG-\u00139)\u0005I1\u0016\u0001\r;fgR$Um]2sS\n,7\t\\5f]R\fVo\u001c;bg&sg/\u00197jI\u001aKG\u000e^3s\u0007>l'-\u001b8bi&|g\u000e\u000b\u0002\u0014-\u00069R.\u0019;dQV\u001bXM]\"mS\u0016tG/\u00128uSRLWm]\u000b\u0002\u007fB1\u0011\u0011AA\u0006\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS6lW\u000f^1cY\u0016T1!!\u00030\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0003MSN$\bc\u0002\u0018\u0002\u0012\u0005U\u0011qF\u0005\u0004\u0003'y#A\u0002+va2,'\u0007\u0005\u0003\u0002\u0018\u0005-RBAA\r\u0015\u0011\tY\"!\b\u0002\u000bE,x\u000e^1\u000b\t\u0005}\u0011\u0011E\u0001\u0007G>lWn\u001c8\u000b\u0007)\n\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AB1qC\u000eDWM\u0003\u0002\u0002*\u0005\u0019qN]4\n\t\u00055\u0012\u0011\u0004\u0002\u0012\u00072LWM\u001c;Rk>$\u0018-\u00128uSRL\bc\u0001\u0018\u00022%\u0019\u00111G\u0018\u0003\r\u0011{WO\u00197f\u0003ai\u0017\r^2i+N,'o\u00117jK:$XI\u001c;ji&,7\u000fI\u0001\u0010[\u0006$8\r[%q\u000b:$\u0018\u000e^5fg\u0006\u0001R.\u0019;dQ&\u0003XI\u001c;ji&,7\u000fI\u0001#g\u0016$X\u000f\u001d#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7/T1uG\"$Vm\u001d;\u0002EQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7/T1uG\",\u00050Y2uQ\tIb+\u0001\u0013uKN$H)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCNl\u0015\r^2i!\u0006\u0014H/[1mQ\tQb+\u0001\u0014uKN$8\t\\5f]R\fVo\u001c;bgVs7/\u001e9q_J$X\rZ#oi&$\u0018\u0010V=qKND#a\u0007,\u00023Q,7\u000f^\"mS\u0016tG/U;pi\u0006\u001c8+\u00198ji&TX\r\u001a\u0015\u00039Y\u000bq\u0004^3ti\u000ec\u0017.\u001a8u#V|G/Y:XSRDG)\u001a4bk2$h*Y7fQ\tib+\u0001\u000ewKJLg-\u001f#fg\u000e\u0014\u0018NY3F]RLG/_)v_R\f7\u000fF\u0003S\u0003+\nI\u0006C\u0004\u0002Xy\u0001\r!!\u0006\u0002\r\u0015tG/\u001b;z\u0011\u001d\tYF\ba\u0001\u0003;\na!];pi\u0006\u001c\bC\u00028\u0002`5\fy#C\u0002\u0002bY\u00141!T1q\u00039!xn\u00117jK:$XI\u001c;jif$b!!\u0006\u0002h\u0005E\u0004bBA5?\u0001\u0007\u00111N\u0001\u0005kN,'\u000f\u0005\u0003/\u0003[j\u0017bAA8_\t1q\n\u001d;j_:Dq!a\u001d \u0001\u0004\tY'\u0001\u0005dY&,g\u000e^%e\u0003)!x.\u00139F]RLG/\u001f\u000b\u0005\u0003+\tI\bC\u0004\u0002|\u0001\u0002\r!a\u001b\u0002\u0005%\u0004\u0018\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0002\u0002\u0006E\u0005\u0003CAB\u0003\u0013\u000b)\"a#\u000e\u0005\u0005\u0015%bAAD\u000b\u0006!Q\u000f^5m\u0013\u0011\t\t'!\"\u0011\u000f\u0005\r\u0015\u0011R7\u0002\u000eB\u0019!)a$\n\u0007\u0005M2\tC\u0004\u0002\u0014\u0006\u0002\r!!&\u0002\r\u0019LG\u000e^3s!\u0011\t9\"a&\n\t\u0005e\u0015\u0011\u0004\u0002\u0012\u00072LWM\u001c;Rk>$\u0018MR5mi\u0016\u0014\u0018aH:f]\u0012$Um]2sS\n,7\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiR!\u0011qTAV!\u0011\t\t+a*\u000e\u0005\u0005\r&\u0002BAS\u0003;\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003S\u000b\u0019K\u0001\u000fEKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3\t\u000f\u0005M%\u00051\u0001\u0002\u0016\u0006\t\u0012\r\u001c;fe\u0016sG/\u001b;z#V|G/Y:\u0015\u0011\u0005E\u0016qWA]\u0003\u0003\u00042AQAZ\u0013\r\t)l\u0011\u0002\u0005->LG\rC\u0004\u0002X\r\u0002\r!!\u0006\t\u000f\u0005m6\u00051\u0001\u0002>\u0006)\u0011\r\u001c;feB1a.a\u0018n\u0003\u007f\u0003RALA7\u0003_Aq!a1$\u0001\u0004\t)-\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010E\u0002/\u0003\u000fL1!!30\u0005\u001d\u0011un\u001c7fC:\f\u0011#\u00197uKJ\u001cE.[3oiF+x\u000e^1t)\u0019\ty-!:\u0002lBA\u0011\u0011[Al\u0003+\tI.\u0004\u0002\u0002T*!\u0011Q[A\u0004\u0003\u001diW\u000f^1cY\u0016LA!!\u0019\u0002TB1\u00111\\Aq\u0003ck!!!8\u000b\t\u0005}\u0017QD\u0001\nS:$XM\u001d8bYNLA!a9\u0002^\ny1*\u00194lC\u001a+H/\u001e:f\u00136\u0004H\u000eC\u0004\u0002h\u0012\u0002\r!!;\u0002\u000fI,\u0017/^3tiB9a.a\u0018\u0002\u0016\u0005u\u0006bBAbI\u0001\u0007\u0011QY\u0001\u001dg\u0016tG-\u00117uKJ\u001cE.[3oiF+x\u000e^1t%\u0016\fX/Z:u)\u0019\t\t0a>\u0003\u0014A!\u0011\u0011UAz\u0013\u0011\t)0a)\u00033\u0005cG/\u001a:DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a\u0005\b\u0003s,\u0003\u0019AA~\u0003\u001d)g\u000e\u001e:jKN\u0004b!!@\u0003\b\t5a\u0002BA\u0000\u0005\u0007q1\u0001\u001dB\u0001\u0013\u0005\u0001\u0014b\u0001B\u0003_\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0005\u0005\u0017\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005\u000by\u0003\u0003BA\f\u0005\u001fIAA!\u0005\u0002\u001a\t)2\t\\5f]R\fVo\u001c;b\u00032$XM]1uS>t\u0007bBAbK\u0001\u0007\u0011Q\u0019\u0015\b\u0001\t]!q\u0006B\u0019!\u0011\u0011IBa\u000b\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\t\t\u0005\"1E\u0001\u0004CBL'\u0002\u0002B\u0013\u0005O\tqA[;qSR,'O\u0003\u0003\u0003*\u0005\u001d\u0012!\u00026v]&$\u0018\u0002\u0002B\u0017\u00057\u0011!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\u0011\u0019d\t\u0002\u00036A!!q\u0007B\u001e\u001b\t\u0011IDC\u0002\u0003*YJAA!\u0010\u0003:\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\bf\u0002\u0001\u0003B\t\u001d#\u0011\n\t\u0004/\n\r\u0013b\u0001B#1\n\u00192\t\\;ti\u0016\u0014H+Z:u\t\u00164\u0017-\u001e7ug\u0006Y1\r\\;ti\u0016\u0014H+\u001f9fI\t\u0011Y%\u0003\u0003\u0003N\t=\u0013A\u0001.L\u0015\r\u0011\t\u0006W\u0001\u0005)f\u0004X\r")
public class ClientQuotasRequestTest {
    private final ClusterInstance cluster;
    private final String ConsumerByteRateProp;
    private final String ProducerByteRateProp;
    private final String RequestPercentageProp;
    private final String IpConnectionRateProp;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities;

    private String ConsumerByteRateProp() {
        return this.ConsumerByteRateProp;
    }

    private String ProducerByteRateProp() {
        return this.ProducerByteRateProp;
    }

    private String RequestPercentageProp() {
        return this.RequestPercentageProp;
    }

    private String IpConnectionRateProp() {
        return this.IpConnectionRateProp;
    }

    @ClusterTest
    public void testAlterClientQuotasRequest() {
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-id")}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)15000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)15000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)5000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)5000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.3)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)12.3))}))));
    }

    @ClusterTest
    public void testAlterClientQuotasRequestValidateOnly() {
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)23.45)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
    }

    @ClusterTest
    public void testClientQuotasForScramUsers() {
        String userName = "user";
        this.cluster.createAdminClient().alterUserScramCredentials(Arrays.asList((Object[])new UserScramCredentialAlteration[]{new UserScramCredentialUpsertion(userName, new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 4096), "password")})).all().get();
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)userName)}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testAlterIpQuotasRequest() {
        String knownHost = "1.2.3.4";
        String unknownHost = "2.3.4.5";
        ClientQuotaEntity entity = this.toIpEntity((Option<String>)new Some((Object)knownHost));
        ClientQuotaEntity defaultEntity = this.toIpEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"ip", (String)knownHost);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"ip");
        ClientQuotaFilterComponent allIpEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyIpQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.verifyIpQuotas$1(allIpEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(entityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidRequests() {
        ObjectRef entity = ObjectRef.create((Object)new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava()));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"name")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
        entity.elem = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)))}))), true));
        entity.elem = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$2.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
    }

    private void expectInvalidRequestWithMessage(Function0<BoxedUnit> runnable, String expectedMessage) {
        InvalidRequestException exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> runnable.apply$mcV$sp());
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage), (String)new StringBuilder(29).append("Expected message ").append(exception).append(" to contain ").append(expectedMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidEntityCombination() {
        ClientQuotaEntity userAndIpEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        ClientQuotaEntity clientAndIpEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        String expectedExceptionMessage = "Invalid quota entity combination";
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterEntityQuotas(userAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterEntityQuotas(clientAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasBadIp() {
        ClientQuotaEntity invalidHostPatternEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"abc-123")}))).asJava());
        ClientQuotaEntity unresolvableHostEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"ip")}))).asJava());
        String expectedExceptionMessage = "not a valid IP";
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterEntityQuotas(invalidHostPatternEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterEntityQuotas(unresolvableHostEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)userFilterComponent, (List)Nil$.MODULE$))).asJava())));
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        JFunction0.mcV.sp & Serializable & scala.Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)clientIdFilterComponent, (List)Nil$.MODULE$))).asJava())));
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities() {
        return this.matchUserClientEntities;
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities() {
        return this.matchIpEntities;
    }

    private void setupDescribeClientQuotasMatchTest() {
        scala.collection.immutable.Map userClientQuotas = ((TraversableOnce)this.matchUserClientEntities().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.RequestPercentageProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map ipQuotas = ((TraversableOnce)this.matchIpEntities().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity e = (ClientQuotaEntity)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.IpConnectionRateProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> result = this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)userClientQuotas.$plus$plus((GenTraversableOnce)ipQuotas), false);
        ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)e -> (Void)((KafkaFutureImpl)result.apply(e._1())).get(10L, TimeUnit.SECONDS));
    }

    @ClusterTest
    public void testDescribeClientQuotasMatchExact() {
        this.setupDescribeClientQuotasMatchTest();
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-2"), (Object)new Some(null)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-4"), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)new Some(null), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-3")), (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Option u = (Option)x0$2._1();
            Option c = (Option)x0$2._2();
            ClientQuotaEntity clientQuotaEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)Option$.MODULE$.option2Iterable(u.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2((Object)"user", x$1))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(c.map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2((Object)"client-id", x$2))), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
            return clientQuotaEntity;
        }, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$6(this, e);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testDescribeClientQuotasMatchPartial() {
        void var90_90;
        void testMatchEntities$1_expectedMatchSize;
        void testMatchEntities$1_partition;
        void var83_83;
        void testMatchEntities$1_expectedMatchSize2;
        void testMatchEntities$1_partition2;
        void var76_76;
        void testMatchEntities$1_expectedMatchSize3;
        void testMatchEntities$1_partition3;
        void var69_69;
        void testMatchEntities$1_expectedMatchSize4;
        void testMatchEntities$1_partition4;
        void var62_62;
        void testMatchEntities$1_expectedMatchSize5;
        void testMatchEntities$1_partition5;
        void var55_55;
        void testMatchEntities$1_expectedMatchSize6;
        void testMatchEntities$1_partition6;
        void var48_48;
        void testMatchEntities$1_expectedMatchSize7;
        void testMatchEntities$1_partition7;
        void var41_41;
        void testMatchEntities$1_expectedMatchSize8;
        void testMatchEntities$1_partition8;
        void var34_34;
        void testMatchEntities$1_expectedMatchSize9;
        void testMatchEntities$1_partition9;
        void var27_27;
        void testMatchEntities$1_expectedMatchSize10;
        void testMatchEntities$1_partition10;
        void var20_20;
        void testMatchEntities$1_expectedMatchSize11;
        void testMatchEntities$1_partition11;
        void var13_13;
        void testMatchEntities$1_expectedMatchSize12;
        void testMatchEntities$1_partition12;
        void var6_6;
        void testMatchEntities$1_partition13;
        this.setupDescribeClientQuotasMatchTest();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(entity));
        int testMatchEntities$1_expectedMatchSize13 = 3;
        ClientQuotaFilter testMatchEntities$1_filter = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-1"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result = this.describeClientQuotas(testMatchEntities$1_filter);
        Tuple2 tuple2 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition13, arg_0));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize13, (int)var6_6.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize13, (int)testMatchEntities$1_result.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap = var6_6.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$5(entity));
        boolean bl = false;
        ClientQuotaFilter testMatchEntities$1_filter2 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"unknown"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result2 = this.describeClientQuotas(testMatchEntities$1_filter2);
        Tuple2 tuple22 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition12, arg_0));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches2 = (List)tuple22._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize12, (int)var13_13.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize12, (int)testMatchEntities$1_result2.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap2 = var13_13.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$6(entity));
        int n = 2;
        ClientQuotaFilter testMatchEntities$1_filter3 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-2"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result3 = this.describeClientQuotas(testMatchEntities$1_filter3);
        Tuple2 tuple23 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition11, arg_0));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches3 = (List)tuple23._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize11, (int)var20_20.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize11, (int)testMatchEntities$1_result3.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap3 = var20_20.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$7(entity));
        int n2 = 2;
        ClientQuotaFilter testMatchEntities$1_filter4 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result4 = this.describeClientQuotas(testMatchEntities$1_filter4);
        Tuple2 tuple24 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition10, arg_0));
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches4 = (List)tuple24._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize10, (int)var27_27.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize10, (int)testMatchEntities$1_result4.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap4 = var27_27.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect5 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$8(entity));
        boolean bl2 = true;
        ClientQuotaFilter testMatchEntities$1_filter5 = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-2"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result5 = this.describeClientQuotas(testMatchEntities$1_filter5);
        Tuple2 tuple25 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition9, arg_0));
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches5 = (List)tuple25._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize9, (int)var34_34.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize9, (int)testMatchEntities$1_result5.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap5 = var34_34.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect6 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$9(entity));
        boolean bl3 = false;
        ClientQuotaFilter testMatchEntities$1_filter6 = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-1"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result6 = this.describeClientQuotas(testMatchEntities$1_filter6);
        Tuple2 tuple26 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition8, arg_0));
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches6 = (List)tuple26._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize8, (int)var41_41.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize8, (int)testMatchEntities$1_result6.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap6 = var41_41.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect7 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$10(entity));
        int n3 = 4;
        ClientQuotaFilter testMatchEntities$1_filter7 = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result7 = this.describeClientQuotas(testMatchEntities$1_filter7);
        Tuple2 tuple27 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition7, arg_0));
        if (tuple27 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches7 = (List)tuple27._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize7, (int)var48_48.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize7, (int)testMatchEntities$1_result7.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap7 = var48_48.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect8 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$11(entity));
        int n4 = 10;
        ClientQuotaFilter testMatchEntities$1_filter8 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result8 = this.describeClientQuotas(testMatchEntities$1_filter8);
        Tuple2 tuple28 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition6, arg_0));
        if (tuple28 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches8 = (List)tuple28._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize6, (int)var55_55.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize6, (int)testMatchEntities$1_result8.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap8 = var55_55.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect9 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$12(entity));
        boolean bl4 = true;
        ClientQuotaFilter testMatchEntities$1_filter9 = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result9 = this.describeClientQuotas(testMatchEntities$1_filter9);
        Tuple2 tuple29 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition5, arg_0));
        if (tuple29 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches9 = (List)tuple29._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize5, (int)var62_62.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize5, (int)testMatchEntities$1_result9.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap9 = var62_62.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect10 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$13(entity));
        int n5 = 7;
        ClientQuotaFilter testMatchEntities$1_filter10 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result10 = this.describeClientQuotas(testMatchEntities$1_filter10);
        Tuple2 tuple210 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition4, arg_0));
        if (tuple210 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches10 = (List)tuple210._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize4, (int)var69_69.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize4, (int)testMatchEntities$1_result10.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap10 = var69_69.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect11 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$14(entity));
        int n6 = 2;
        ClientQuotaFilter testMatchEntities$1_filter11 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"ip"), (List)Nil$.MODULE$)).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result11 = this.describeClientQuotas(testMatchEntities$1_filter11);
        Tuple2 tuple211 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition3, arg_0));
        if (tuple211 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches11 = (List)tuple211._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize3, (int)var76_76.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize3, (int)testMatchEntities$1_result11.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap11 = var76_76.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect12 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$15(entity));
        int n7 = 13;
        ClientQuotaFilter testMatchEntities$1_filter12 = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result12 = this.describeClientQuotas(testMatchEntities$1_filter12);
        Tuple2 tuple212 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition2, arg_0));
        if (tuple212 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches12 = (List)tuple212._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize2, (int)var83_83.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize2, (int)testMatchEntities$1_result12.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap12 = var83_83.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable intersect13 = (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$16(entity));
        boolean bl5 = false;
        ClientQuotaFilter testMatchEntities$1_filter13 = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> testMatchEntities$1_result13 = this.describeClientQuotas(testMatchEntities$1_filter13);
        Tuple2 tuple213 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition(arg_0 -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1$adapted((Function1)testMatchEntities$1_partition, arg_0));
        if (tuple213 == null) {
            throw new MatchError(null);
        }
        List testMatchEntities$1_expectedMatches13 = (List)tuple213._1();
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize, (int)var90_90.size());
        Assertions.assertEquals((int)testMatchEntities$1_expectedMatchSize, (int)testMatchEntities$1_result13.size());
        scala.collection.immutable.Map testMatchEntities$1_expectedMatchesMap13 = var90_90.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest
    public void testClientQuotasUnsupportedEntityTypes() {
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"name")}))).asJava());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty()));
    }

    @ClusterTest
    public void testClientQuotasSanitized() {
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user with spaces")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testClientQuotasWithDefaultName() {
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)ConfigEntityName$.MODULE$.Default())}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"client-id"), (List)Nil$.MODULE$)).asJava())));
        Predef$.MODULE$.assert(result.isEmpty());
    }

    private void verifyDescribeEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Object> quotas) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String entityType = (String)x0$1._1();
            String entityName = (String)x0$1._2();
            ClientQuotaFilterComponent clientQuotaFilterComponent = (ClientQuotaFilterComponent)Option$.MODULE$.apply((Object)entityName).map((Function1 & Serializable & scala.Serializable)name -> ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClientQuotaFilterComponent.ofDefaultEntity((String)entityType));
            return clientQuotaFilterComponent;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describe = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)components.toList()).asJava())));
        if (quotas.isEmpty()) {
            Assertions.assertEquals((int)0, (int)describe.size());
            return;
        }
        Assertions.assertEquals((int)1, (int)describe.size());
        java.util.Map<String, Double> configs = describe.get(entity);
        Assertions.assertNotNull(configs);
        Assertions.assertEquals((int)quotas.size(), (int)configs.size());
        quotas.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$4(configs, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private ClientQuotaEntity toClientEntity(Option<String> user, Option<String> clientId) {
        return new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)Option$.MODULE$.option2Iterable(user.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), x$3))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(clientId.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), x$4))), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private ClientQuotaEntity toIpEntity(Option<String> ip) {
        return new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(ip.map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), x$5))).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describeClientQuotas(ClientQuotaFilter filter) {
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendDescribeClientQuotasRequest(filter).complete(result);
        try {
            return (java.util.Map)result.get();
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private DescribeClientQuotasResponse sendDescribeClientQuotasRequest(ClientQuotaFilter filter) {
        DescribeClientQuotasRequest request = (DescribeClientQuotasRequest)new DescribeClientQuotasRequest.Builder(filter).build();
        return (DescribeClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyControllerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(DescribeClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Void alterEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Option<Object>> alter, boolean validateOnly) {
        try {
            return (Void)((KafkaFutureImpl)this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), alter)}))), validateOnly).get((Object)entity).get()).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> alterClientQuotas(scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>> request, boolean validateOnly) {
        scala.collection.immutable.Iterable entries = (scala.collection.immutable.Iterable)request.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            scala.collection.immutable.Map alter = (scala.collection.immutable.Map)x0$1._2();
            Collection ops = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)alter.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$2._1();
                Option value = (Option)x0$2._2();
                ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable & scala.Serializable)x -> ClientQuotasRequestTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
                return op;
            }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
            ClientQuotaAlteration clientQuotaAlteration = new ClientQuotaAlteration(entity, ops);
            return clientQuotaAlteration;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Map response = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)request.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)new KafkaFutureImpl()), Map$.MODULE$.canBuildFrom())).asJava();
        this.sendAlterClientQuotasRequest((Iterable<ClientQuotaAlteration>)entries, validateOnly).complete(response);
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response).asScala();
        Assertions.assertEquals((int)request.size(), (int)result.size());
        request.foreach((Function1 & Serializable & scala.Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$alterClientQuotas$6(result, e);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private AlterClientQuotasResponse sendAlterClientQuotasRequest(Iterable<ClientQuotaAlteration> entries, boolean validateOnly) {
        AlterClientQuotasRequest request = (AlterClientQuotasRequest)new AlterClientQuotasRequest.Builder(CollectionConverters$.MODULE$.asJavaCollectionConverter(entries).asJavaCollection(), validateOnly).build();
        return (AlterClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyControllerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(AlterClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterIpQuotasRequest$2(ClientQuotasRequestTest $this, IntRef currentServerQuota$1, InetAddress entityIp$1, scala.collection.immutable.Map expectedMatches$1, ClientQuotaEntity entity$1) {
        currentServerQuota$1.elem = ((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.cluster.brokerSocketServers()).asScala()).head()).connectionQuotas().connectionRateForIp(entityIp$1);
        return Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity$1)) - (double)currentServerQuota$1.elem) < 0.01;
    }

    public static final /* synthetic */ String $anonfun$testAlterIpQuotasRequest$3(ClientQuotaEntity entity$1, scala.collection.immutable.Map expectedMatches$1, IntRef currentServerQuota$1) {
        return new StringBuilder(33).append("Connection quota of ").append(entity$1).append(" is not ").append(expectedMatches$1.apply((Object)entity$1)).append(" but ").append(currentServerQuota$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$1(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.IpConnectionRateProp()})), (Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(props).asScala()).keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)), (Double)((Double)props.get($this.IpConnectionRateProp())));
            String entityName = (String)entity.entries().get("ip");
            InetAddress entityIp = entityName == null ? InetAddress.getByName(unknownHost$1) : InetAddress.getByName(entityName);
            IntRef currentServerQuota = IntRef.create((int)0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$2($this, currentServerQuota, entityIp, expectedMatches$1, entity)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$3(entity, expectedMatches$1, currentServerQuota));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void verifyIpQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches, String unknownHost$1) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)entityFilter, (List)Nil$.MODULE$)).asJava())));
        Assertions.assertEquals((Object)expectedMatches.keySet(), (Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).keySet());
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$1(this, expectedMatches, unknownHost$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final java.util.Map matchEntity$1(ClientQuotaEntity entity) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotaFilterComponent clientQuotaFilterComponent;
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                clientQuotaFilterComponent = entityName == null ? ClientQuotaFilterComponent.ofDefaultEntity((String)entityType) : ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
            } else {
                throw new MatchError(null);
            }
            return clientQuotaFilterComponent;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        return this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)components.toList()).asJava())));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$2(ClientQuotasRequestTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            java.util.Map result = $this.matchEntity$1(e);
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertTrue((result.get(e) != null ? 1 : 0) != 0);
            Double value = (Double)((java.util.Map)result.get(e)).get($this.RequestPercentageProp());
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)Predef$.MODULE$.Double2double(value), (double)v, (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$6(ClientQuotasRequestTest $this, ClientQuotaEntity e) {
        java.util.Map result = $this.matchEntity$1(e);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$1(Function1 partition$1, Tuple2 e) {
        return BoxesRunTime.unboxToBoolean((Object)partition$1.apply(e._1()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            double expectedValue = x0$1._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.RequestPercentageProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$3(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$2._1();
            double expectedValue = x0$2._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.IpConnectionRateProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void testMatchEntities$1(ClientQuotaFilter filter, int expectedMatchSize, Function1 partition) {
        void var6_6;
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(filter);
        Tuple2 tuple2 = ((TraversableLike)this.matchUserClientEntities().$plus$plus(this.matchIpEntities(), List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)partition.apply(e._1()))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)expectedMatchSize, (int)var6_6.size());
        Assertions.assertEquals((int)expectedMatchSize, (int)result.size());
        scala.collection.immutable.Map expectedMatchesMap = var6_6.toMap(Predef$.MODULE$.$conforms());
        this.matchUserClientEntities().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$1);
            return BoxedUnit.UNIT;
        });
        this.matchIpEntities().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, testMatchEntities$1_expectedMatchesMap, testMatchEntities$1_result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$4(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-1";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$5(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$6(ClientQuotaEntity entity) {
        Object v = entity.entries().get("client-id");
        String string = "client-id-2";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$7(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && entity.entries().get("user") == null;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$8(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-2";
        return v != null && v.equals(string) && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$9(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$10(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$11(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$12(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id") && !entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$13(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$14(ClientQuotaEntity entity) {
        return entity.entries().containsKey("ip");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$15(ClientQuotaEntity entity) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$16(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$4(java.util.Map configs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Double value = (Double)configs$1.get(k);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)v, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$6(scala.collection.mutable.Map result$3, Tuple2 e) {
        Assertions.assertTrue((boolean)result$3.get(e._1()).isDefined());
    }

    public ClientQuotasRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.ConsumerByteRateProp = "consumer_byte_rate";
        this.ProducerByteRateProp = "producer_byte_rate";
        this.RequestPercentageProp = "request_percentage";
        this.IpConnectionRateProp = "connection_creation_rate";
        this.matchUserClientEntities = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple3((Object)new Some((Object)"user-2"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple3((Object)new Some(null), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple3((Object)new Some((Object)"user-1"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple3((Object)new Some((Object)"user-2"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple3((Object)new Some((Object)"user-3"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple3((Object)new Some(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6))})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Option u = (Option)x0$1._1();
            Option c = (Option)x0$1._2();
            double v = BoxesRunTime.unboxToDouble((Object)x0$1._3());
            Tuple2 tuple2 = new Tuple2((Object)this.toClientEntity((Option<String>)u, (Option<String>)c), (Object)BoxesRunTime.boxToDouble((double)v));
            return tuple2;
        }, List$.MODULE$.canBuildFrom());
        this.matchIpEntities = (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"1.2.3.4"), (Object)BoxesRunTime.boxToDouble((double)10.0)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"2.3.4.5"), (Object)BoxesRunTime.boxToDouble((double)20.0)), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Some ip = (Some)x0$2._1();
            double quota = x0$2._2$mcD$sp();
            Tuple2 tuple2 = new Tuple2((Object)this.toIpEntity((Option<String>)ip), (Object)BoxesRunTime.boxToDouble((double)quota));
            return tuple2;
        }, List$.MODULE$.canBuildFrom());
    }
}

