/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0006\r\u0001EAQ\u0001\u0007\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002uAQA\f\u0001\u0005\u0002uAQ\u0001\r\u0001\u0005\u0002uAQA\r\u0001\u0005\u0002uAQ\u0001\u000e\u0001\u0005\nUBQA\u0012\u0001\u0005\u0002\u001dCQ\u0001\u0018\u0001\u0005\nuCQa\u001b\u0001\u0005\n1Daa\u001b\u0001\u0005\n\u0005\u001d!A\u0005*fcV,7\u000f^\"iC:tW\r\u001c+fgRT!!\u0004\b\u0002\u000f9,Go^8sW*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0019\u0005\tB/Z:u\u00032$XM\u001d*fcV,7\u000f^:\u0015\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"\u0001B+oSRD#A\u0001\u0012\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005\u00152\u0013aA1qS*\u0011q\u0005K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI#&A\u0003kk:LGOC\u0001,\u0003\ry'oZ\u0005\u0003[\u0011\u0012A\u0001V3ti\u0006aB/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u0014V-];fgR\u001c\bFA\u0002#\u0003\t\"Xm\u001d;O_:\fE\u000e^3s%\u0016\fX/Z:ug:{G\u000f\u0016:b]N4wN]7fI\"\u0012AAI\u0001\u0011i\u0016\u001cHOS:p]J+\u0017/^3tiND#!\u0002\u0012\u0002\u0017%\u001ch+\u00197jI*\u001bxN\u001c\u000b\u0003me\u0002\"aE\u001c\n\u0005a\"\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006u\u0019\u0001\raO\u0001\u0004gR\u0014\bC\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?)5\tqH\u0003\u0002A!\u00051AH]8pizJ!A\u0011\u000b\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005R\tqA]3rk\u0016\u001cH\u000f\u0006\u0002I\u001fB\u0011\u0011\n\u0014\b\u00037)K!a\u0013\u0007\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011QJ\u0014\u0002\b%\u0016\fX/Z:u\u0015\tYE\u0002C\u0003Q\u000f\u0001\u0007\u0011+A\u0002sKF\u0004\"A\u0015.\u000e\u0003MS!\u0001V+\u0002\u0011I,\u0017/^3tiNT!AV,\u0002\r\r|W.\\8o\u0015\ty\u0001L\u0003\u0002ZU\u00051\u0011\r]1dQ\u0016L!aW*\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\f\u0011C\\3x%\u0016\fX/Z:u\u0007>tG/\u001a=u)\tq\u0016\r\u0005\u0002S?&\u0011\u0001m\u0015\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u0015\u0011\u0007\u00021\u0001d\u0003\u0019\u0011WO\u001a4feB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0004]&|'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014!BQ=uK\n+hMZ3s\u0003\u0015!x.T1q)\ti\u0007\u000f\u0005\u0003=]nZ\u0014BA8F\u0005\ri\u0015\r\u001d\u0005\u0006c&\u0001\rA]\u0001\u0007G>tg-[4\u0011\u0007M\f\tA\u0004\u0002u}:\u0011Q/ \b\u0003mrt!a^>\u000f\u0005aThB\u0001 z\u0013\u0005Y\u0013BA-+\u0013\ty\u0001,\u0003\u0002W/&\u0011A+V\u0005\u0003\u007fN\u000b1#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgRLA!a\u0001\u0002\u0006\t11i\u001c8gS\u001eT!a`*\u0015\u00075\fI\u0001\u0003\u0004r\u0015\u0001\u0007\u00111\u0002\t\u0005\u0003\u001b\tIB\u0004\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\"V\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t9\"!\u0005\u0002E%s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\tY\"!\b\u00033\u0005cG/\u001a:bE2,7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0005\u0003/\t\t\u0002")
public class RequestChannelTest {
    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = RequestTestUtils.serializeRequestWithHeader((RequestHeader)new RequestHeader(req.apiKey(), req.version(), "client-id", 1), (AbstractRequest)req);
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)EasyMock.createNiceMock(MemoryPool.class), buffer, (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)config).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String name = (String)x0$1._1();
        String value = (String)x0$1._2();
        boolean bl = alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        return bl;
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }
}

